/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.CustomConversionDescriptor;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.EmulatedDispatchMethodDescriptor;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.EmulatedInterfaceDescriptor;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public class MachineRewritingFlags {
    private final Map<DexType, DexType> rewriteType;
    private final Map<DexType, DexType> rewriteDerivedTypeOnly;
    private final Map<DexMethod, DexMethod> staticRetarget;
    private final Map<DexMethod, DexMethod> nonEmulatedVirtualRetarget;
    private final Map<DexMethod, EmulatedDispatchMethodDescriptor> emulatedVirtualRetarget;
    private final Map<DexMethod, DexMethod> emulatedVirtualRetargetThroughEmulatedInterface;
    private final Map<DexType, EmulatedInterfaceDescriptor> emulatedInterfaces;
    private final Map<DexType, List<DexMethod>> wrappers;
    private final Map<DexType, DexType> legacyBackport;
    private final Set<DexType> dontRetarget;
    private final Map<DexType, CustomConversionDescriptor> customConversions;
    private final Map<DexMethod, MethodAccessFlags> amendLibraryMethod;

    public static Builder builder() {
        return new Builder();
    }

    MachineRewritingFlags(Map<DexType, DexType> rewriteType, Map<DexType, DexType> rewriteDerivedTypeOnly, Map<DexMethod, DexMethod> staticRetarget, Map<DexMethod, DexMethod> nonEmulatedVirtualRetarget, Map<DexMethod, EmulatedDispatchMethodDescriptor> emulatedVirtualRetarget, Map<DexMethod, DexMethod> emulatedVirtualRetargetThroughEmulatedInterface, Map<DexType, EmulatedInterfaceDescriptor> emulatedInterfaces, Map<DexType, List<DexMethod>> wrappers, Map<DexType, DexType> legacyBackport, Set<DexType> dontRetarget, Map<DexType, CustomConversionDescriptor> customConversions, Map<DexMethod, MethodAccessFlags> amendLibraryMethods) {
        this.rewriteType = rewriteType;
        this.rewriteDerivedTypeOnly = rewriteDerivedTypeOnly;
        this.staticRetarget = staticRetarget;
        this.nonEmulatedVirtualRetarget = nonEmulatedVirtualRetarget;
        this.emulatedVirtualRetarget = emulatedVirtualRetarget;
        this.emulatedVirtualRetargetThroughEmulatedInterface = emulatedVirtualRetargetThroughEmulatedInterface;
        this.emulatedInterfaces = emulatedInterfaces;
        this.wrappers = wrappers;
        this.legacyBackport = legacyBackport;
        this.dontRetarget = dontRetarget;
        this.customConversions = customConversions;
        this.amendLibraryMethod = amendLibraryMethods;
    }

    public Map<DexType, DexType> getRewriteType() {
        return this.rewriteType;
    }

    public Map<DexType, DexType> getRewriteDerivedTypeOnly() {
        return this.rewriteDerivedTypeOnly;
    }

    public Map<DexMethod, DexMethod> getStaticRetarget() {
        return this.staticRetarget;
    }

    public Map<DexMethod, DexMethod> getNonEmulatedVirtualRetarget() {
        return this.nonEmulatedVirtualRetarget;
    }

    public Map<DexMethod, EmulatedDispatchMethodDescriptor> getEmulatedVirtualRetarget() {
        return this.emulatedVirtualRetarget;
    }

    public Map<DexMethod, DexMethod> getEmulatedVirtualRetargetThroughEmulatedInterface() {
        return this.emulatedVirtualRetargetThroughEmulatedInterface;
    }

    public void forEachRetargetMethod(Consumer<DexMethod> consumer) {
        this.staticRetarget.keySet().forEach(consumer);
        this.nonEmulatedVirtualRetarget.keySet().forEach(consumer);
        this.emulatedVirtualRetarget.keySet().forEach(consumer);
    }

    public Map<DexType, EmulatedInterfaceDescriptor> getEmulatedInterfaces() {
        return this.emulatedInterfaces;
    }

    public Map<DexType, List<DexMethod>> getWrappers() {
        return this.wrappers;
    }

    public Map<DexType, DexType> getLegacyBackport() {
        return this.legacyBackport;
    }

    public Set<DexType> getDontRetarget() {
        return this.dontRetarget;
    }

    public boolean isCustomConversionRewrittenType(DexType type) {
        return Iterables.any(this.customConversions.values(), descriptor -> descriptor.getFrom().getHolderType() == type || descriptor.getTo().getHolderType() == type);
    }

    public Map<DexType, CustomConversionDescriptor> getCustomConversions() {
        return this.customConversions;
    }

    public Map<DexMethod, MethodAccessFlags> getAmendLibraryMethod() {
        return this.amendLibraryMethod;
    }

    public boolean hasRetargeting() {
        return !this.staticRetarget.isEmpty() || !this.nonEmulatedVirtualRetarget.isEmpty() || !this.emulatedVirtualRetarget.isEmpty();
    }

    public boolean isEmulatedInterfaceRewrittenType(DexType type) {
        return Iterables.any(this.emulatedInterfaces.values(), descriptor -> descriptor.getRewrittenType() == type);
    }

    public boolean hasEmulatedInterfaces() {
        return !this.emulatedInterfaces.isEmpty();
    }

    EmulatedDispatchMethodDescriptor getEmulatedInterfaceEmulatedDispatchMethodDescriptor(DexMethod method) {
        if (!this.emulatedInterfaces.containsKey(method.getHolderType())) {
            return null;
        }
        return this.emulatedInterfaces.get(method.getHolderType()).getEmulatedMethods().get(method);
    }

    public static class Builder {
        private final Map<DexType, DexType> rewriteType = new IdentityHashMap<DexType, DexType>();
        private final Map<DexType, DexType> rewriteDerivedTypeOnly = new IdentityHashMap<DexType, DexType>();
        private final ImmutableMap.Builder<DexMethod, DexMethod> staticRetarget = ImmutableMap.builder();
        private final ImmutableMap.Builder<DexMethod, DexMethod> nonEmulatedVirtualRetarget = ImmutableMap.builder();
        private final ImmutableMap.Builder<DexMethod, EmulatedDispatchMethodDescriptor> emulatedVirtualRetarget = ImmutableMap.builder();
        private final ImmutableMap.Builder<DexMethod, DexMethod> emulatedVirtualRetargetThroughEmulatedInterface = ImmutableMap.builder();
        private final ImmutableMap.Builder<DexType, EmulatedInterfaceDescriptor> emulatedInterfaces = ImmutableMap.builder();
        private final ImmutableMap.Builder<DexType, List<DexMethod>> wrappers = ImmutableMap.builder();
        private final ImmutableMap.Builder<DexType, DexType> legacyBackport = ImmutableMap.builder();
        private final ImmutableSet.Builder<DexType> dontRetarget = ImmutableSet.builder();
        private final ImmutableMap.Builder<DexType, CustomConversionDescriptor> customConversions = ImmutableMap.builder();
        private final ImmutableMap.Builder<DexMethod, MethodAccessFlags> amendLibraryMethod = ImmutableMap.builder();

        Builder() {
        }

        public void rewriteType(DexType src, DexType target) {
            assert (src != null);
            assert (target != null);
            assert (src != target);
            assert (!this.rewriteType.containsKey(src) || this.rewriteType.get(src) == target);
            this.rewriteType.put(src, target);
        }

        public void rewriteDerivedTypeOnly(DexType src, DexType target) {
            this.rewriteDerivedTypeOnly.put(src, target);
        }

        public void putStaticRetarget(DexMethod src, DexMethod dest) {
            this.staticRetarget.put(src, dest);
        }

        public void putNonEmulatedVirtualRetarget(DexMethod src, DexMethod dest) {
            this.nonEmulatedVirtualRetarget.put(src, dest);
        }

        public void putEmulatedInterface(DexType src, EmulatedInterfaceDescriptor descriptor) {
            this.emulatedInterfaces.put(src, descriptor);
        }

        public void putEmulatedVirtualRetarget(DexMethod src, EmulatedDispatchMethodDescriptor dest) {
            this.emulatedVirtualRetarget.put(src, dest);
        }

        public void putEmulatedVirtualRetargetThroughEmulatedInterface(DexMethod src, DexMethod dest) {
            this.emulatedVirtualRetargetThroughEmulatedInterface.put(src, dest);
        }

        public void addWrapper(DexType wrapperConversion, List<DexMethod> methods) {
            this.wrappers.put(wrapperConversion, ImmutableList.copyOf(methods));
        }

        public void putLegacyBackport(DexType src, DexType target) {
            this.legacyBackport.put(src, target);
        }

        public void addDontRetarget(DexType type) {
            this.dontRetarget.add((Object)type);
        }

        public void putCustomConversion(DexType src, CustomConversionDescriptor descriptor) {
            this.customConversions.put(src, descriptor);
        }

        public void amendLibraryMethod(DexMethod missingReference, MethodAccessFlags flags) {
            this.amendLibraryMethod.put(missingReference, flags);
        }

        public DexType getRewrittenType(DexType type) {
            return this.rewriteType.get(type);
        }

        public MachineRewritingFlags build() {
            return new MachineRewritingFlags(this.rewriteType, this.rewriteDerivedTypeOnly, this.staticRetarget.build(), this.nonEmulatedVirtualRetarget.build(), this.emulatedVirtualRetarget.build(), this.emulatedVirtualRetargetThroughEmulatedInterface.build(), this.emulatedInterfaces.build(), this.wrappers.build(), this.legacyBackport.build(), (Set<DexType>)((Object)this.dontRetarget.build()), this.customConversions.build(), this.amendLibraryMethod.build());
        }
    }
}

