/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.retargeter;

import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.ir.desugar.CfClassSynthesizerDesugaring;
import com.android.tools.r8.ir.desugar.CfClassSynthesizerDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.EmulatedDispatchMethodDescriptor;
import com.android.tools.r8.ir.desugar.desugaredlibrary.retargeter.DesugaredLibraryRetargeterSyntheticHelper;
import java.util.Map;

public class DesugaredLibraryRetargeterL8Synthesizer
implements CfClassSynthesizerDesugaring {
    private final AppView<?> appView;
    private final DesugaredLibraryRetargeterSyntheticHelper syntheticHelper;

    public static DesugaredLibraryRetargeterL8Synthesizer create(AppView<?> appView) {
        assert (appView.options().isDesugaredLibraryCompilation());
        if (appView.options().machineDesugaredLibrarySpecification.getEmulatedVirtualRetarget().isEmpty()) {
            return null;
        }
        return new DesugaredLibraryRetargeterL8Synthesizer(appView);
    }

    public DesugaredLibraryRetargeterL8Synthesizer(AppView<?> appView) {
        this.appView = appView;
        this.syntheticHelper = new DesugaredLibraryRetargeterSyntheticHelper(appView);
    }

    @Override
    public String uniqueIdentifier() {
        return "$retargeter$";
    }

    @Override
    public void synthesizeClasses(CompilationContext.ClassSynthesisDesugaringContext processingContext, CfClassSynthesizerDesugaringEventConsumer eventConsumer) {
        Map<DexMethod, EmulatedDispatchMethodDescriptor> emulatedVirtualRetarget = this.appView.options().machineDesugaredLibrarySpecification.getEmulatedVirtualRetarget();
        for (EmulatedDispatchMethodDescriptor emulatedDispatchMethod : emulatedVirtualRetarget.values()) {
            this.syntheticHelper.ensureProgramEmulatedHolderDispatchMethod(emulatedDispatchMethod, eventConsumer);
        }
    }
}

