/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.specificationconversion;

import com.android.tools.r8.dex.ApplicationReader;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.LazyLoadedDexApplication;
import com.android.tools.r8.utils.AndroidApp;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ExecutorService;

public class AppForSpecConversion {
    public static DexApplication readAppForTesting(Path desugaredJDKLib, Path androidLib, InternalOptions options, boolean libraryCompilation, Timing timing) throws IOException {
        timing.begin("Read App for testing");
        assert (!libraryCompilation || desugaredJDKLib != null);
        AndroidApp.Builder builder = AndroidApp.builder();
        if (libraryCompilation) {
            builder.addProgramFile(desugaredJDKLib);
        }
        AndroidApp inputApp = builder.addLibraryFile(androidLib).build();
        DexApplication app = AppForSpecConversion.internalReadApp(inputApp, options, timing);
        timing.end();
        return app;
    }

    private static DexApplication internalReadApp(AndroidApp inputApp, InternalOptions options, Timing timing) throws IOException {
        timing.begin("Internal Read App");
        ApplicationReader applicationReader = new ApplicationReader(inputApp, options, timing);
        ExecutorService executorService = ThreadUtils.getExecutorService(options);
        assert (!options.ignoreJavaLibraryOverride);
        options.ignoreJavaLibraryOverride = true;
        LazyLoadedDexApplication app = applicationReader.read(executorService);
        options.ignoreJavaLibraryOverride = false;
        timing.end();
        return app;
    }
}

