/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.specificationconversion;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.HumanRewritingFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.DerivedMethod;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.EmulatedDispatchMethodDescriptor;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.EmulatedInterfaceDescriptor;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.MachineRewritingFlags;
import com.android.tools.r8.synthesis.SyntheticNaming;
import com.android.tools.r8.utils.WorkList;
import com.android.tools.r8.utils.structural.StructuralItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public class HumanToMachineEmulatedInterfaceConverter {
    private final AppInfoWithClassHierarchy appInfo;
    private final Map<DexType, List<DexType>> emulatedInterfaceHierarchy = new IdentityHashMap<DexType, List<DexType>>();
    private final Set<DexType> missingEmulatedInterface = Sets.newIdentityHashSet();

    public HumanToMachineEmulatedInterfaceConverter(AppInfoWithClassHierarchy appInfo) {
        this.appInfo = appInfo;
    }

    private EmulatedDispatchMethodDescriptor computeEmulatedDispatchDescriptor(DexMethod method, HumanRewritingFlags rewritingFlags, AppInfoWithClassHierarchy appInfo) {
        SyntheticNaming syntheticNaming = appInfo.getSyntheticItems().getNaming();
        DerivedMethod forwardingMethod = new DerivedMethod(method, syntheticNaming.COMPANION_CLASS);
        DexMethod itfDexMethod = appInfo.dexItemFactory().createMethod(rewritingFlags.getEmulatedInterfaces().get(method.getHolderType()), method.getProto(), method.getName());
        DerivedMethod interfaceMethod = new DerivedMethod(itfDexMethod);
        DerivedMethod dispatchMethod = new DerivedMethod(method, syntheticNaming.EMULATED_INTERFACE_CLASS);
        LinkedHashMap<DexType, DerivedMethod> dispatchCases = this.getDispatchCases(rewritingFlags, method);
        return new EmulatedDispatchMethodDescriptor(interfaceMethod, dispatchMethod, forwardingMethod, dispatchCases);
    }

    private LinkedHashMap<DexType, DerivedMethod> getDispatchCases(HumanRewritingFlags rewritingFlags, DexMethod method) {
        List<DexType> subInterfaces = this.emulatedInterfaceHierarchy.get(method.getHolderType());
        LinkedHashMap<DexType, DerivedMethod> extraDispatchCases = new LinkedHashMap<DexType, DerivedMethod>();
        Map<DexMethod, DexType> retargetCoreLibMember = rewritingFlags.getRetargetMethodEmulatedDispatch();
        for (DexMethod retarget : retargetCoreLibMember.keySet()) {
            DexClass inClass;
            if (!retarget.match(method) || (inClass = this.appInfo.definitionFor(retarget.getHolderType())) == null || !this.implementsInterface(inClass, method.getHolderType())) continue;
            DexProto newProto = this.appInfo.dexItemFactory().prependHolderToProto(retarget);
            DexMethod forwardingDexMethod = this.appInfo.dexItemFactory().createMethod(retargetCoreLibMember.get(retarget), newProto, retarget.getName());
            extraDispatchCases.put(retarget.getHolderType(), new DerivedMethod(forwardingDexMethod));
        }
        if (subInterfaces != null) {
            SyntheticNaming syntheticNaming = this.appInfo.getSyntheticItems().getNaming();
            for (int i = subInterfaces.size() - 1; i >= 0; --i) {
                DexClass subInterfaceClass = this.appInfo.definitionFor(subInterfaces.get(i));
                assert (subInterfaceClass != null);
                DexEncodedMethod result = subInterfaceClass.lookupVirtualMethod(method);
                if (result == null || result.isAbstract()) continue;
                assert (result.isDefaultMethod());
                DexMethod reference = (DexMethod)result.getReference();
                extraDispatchCases.put(subInterfaceClass.type, new DerivedMethod(reference, syntheticNaming.COMPANION_CLASS));
            }
        } else assert (extraDispatchCases.size() <= 1);
        return extraDispatchCases;
    }

    private boolean implementsInterface(DexClass clazz, DexType interfaceType) {
        WorkList<DexType> workList = WorkList.newIdentityWorkList(Arrays.asList(clazz.interfaces.values));
        while (!workList.isEmpty()) {
            DexType next = workList.next();
            if (interfaceType == next) {
                return true;
            }
            DexClass nextClass = this.appInfo.definitionFor(next);
            if (nextClass == null) continue;
            workList.addIfNotSeen((DexType[])nextClass.interfaces.values);
        }
        return false;
    }

    private void processEmulatedInterfaceHierarchy(AppInfoWithClassHierarchy appInfo, Map<DexType, DexType> emulateInterfaces) {
        Set<DexType> processed = Sets.newIdentityHashSet();
        ArrayList<DexType> emulatedInterfacesSorted = new ArrayList<DexType>(emulateInterfaces.keySet());
        emulatedInterfacesSorted.sort(StructuralItem::compareTo);
        for (DexType interfaceType : emulatedInterfacesSorted) {
            this.processEmulatedInterfaceHierarchy(appInfo, emulateInterfaces, interfaceType, processed);
        }
    }

    private void processEmulatedInterfaceHierarchy(AppInfoWithClassHierarchy appInfo, Map<DexType, DexType> emulateInterfaces, DexType interfaceType, Set<DexType> processed) {
        if (processed.contains(interfaceType)) {
            return;
        }
        this.emulatedInterfaceHierarchy.put(interfaceType, new ArrayList());
        processed.add(interfaceType);
        DexClass theInterface = appInfo.definitionFor(interfaceType);
        if (theInterface == null) {
            return;
        }
        WorkList<DexType> workList = WorkList.newIdentityWorkList(Arrays.asList(theInterface.interfaces.values));
        while (!workList.isEmpty()) {
            DexType next = workList.next();
            if (!emulateInterfaces.containsKey(next)) continue;
            this.processEmulatedInterfaceHierarchy(appInfo, emulateInterfaces, next, processed);
            this.emulatedInterfaceHierarchy.get(next).add(interfaceType);
            DexClass nextClass = appInfo.definitionFor(next);
            if (nextClass == null) continue;
            workList.addIfNotSeen((DexType[])nextClass.interfaces.values);
        }
    }

    public void convertEmulatedInterfaces(HumanRewritingFlags rewritingFlags, AppInfoWithClassHierarchy appInfo, MachineRewritingFlags.Builder builder, BiConsumer<String, Set<? extends DexReference>> warnConsumer) {
        Map<DexType, DexType> emulateInterfaces = rewritingFlags.getEmulatedInterfaces();
        Set<DexMethod> dontRewriteInvocation = rewritingFlags.getDontRewriteInvocation();
        this.processEmulatedInterfaceHierarchy(appInfo, emulateInterfaces);
        for (DexType itf : emulateInterfaces.keySet()) {
            DexClass itfClass = appInfo.contextIndependentDefinitionFor(itf);
            if (itfClass == null) {
                this.missingEmulatedInterface.add(itf);
                continue;
            }
            IdentityHashMap<DexMethod, EmulatedDispatchMethodDescriptor> emulatedMethods = new IdentityHashMap<DexMethod, EmulatedDispatchMethodDescriptor>();
            itfClass.forEachClassMethodMatching(m3 -> m3.isDefaultMethod() && !dontRewriteInvocation.contains(m3.getReference()), method -> emulatedMethods.put((DexMethod)method.getReference(), this.computeEmulatedDispatchDescriptor((DexMethod)method.getReference(), rewritingFlags, appInfo)));
            builder.putEmulatedInterface(itf, new EmulatedInterfaceDescriptor(emulateInterfaces.get(itf), emulatedMethods));
        }
        warnConsumer.accept("Missing emulated interfaces: ", this.missingEmulatedInterface);
    }
}

