/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.specificationconversion;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.HumanDesugaredLibrarySpecification;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.HumanRewritingFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.MachineRewritingFlags;
import com.android.tools.r8.utils.DescriptorUtils;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public class HumanToMachinePrefixConverter {
    private final AppInfoWithClassHierarchy appInfo;
    private final MachineRewritingFlags.Builder builder;
    private final String synthesizedPrefix;
    private final boolean libraryCompilation;
    private final Map<DexString, DexString> descriptorPrefix;
    private final Map<DexString, Map<DexString, DexString>> descriptorDifferentPrefix;
    private final Set<DexString> usedPrefix = Sets.newIdentityHashSet();

    public HumanToMachinePrefixConverter(AppInfoWithClassHierarchy appInfo, MachineRewritingFlags.Builder builder, HumanDesugaredLibrarySpecification humanSpec, HumanRewritingFlags rewritingFlags) {
        this.appInfo = appInfo;
        this.builder = builder;
        this.synthesizedPrefix = humanSpec.getSynthesizedLibraryClassesPackagePrefix();
        this.libraryCompilation = humanSpec.isLibraryCompilation();
        this.descriptorPrefix = this.convertRewritePrefix(rewritingFlags.getRewritePrefix());
        this.descriptorDifferentPrefix = this.convertRewriteDifferentPrefix(rewritingFlags.getRewriteDerivedPrefix());
    }

    private void warnIfUnusedPrefix(BiConsumer<String, Set<DexString>> warnConsumer) {
        Set<DexString> prefixes = Sets.newIdentityHashSet();
        prefixes.addAll(this.descriptorPrefix.keySet());
        prefixes.addAll(this.descriptorDifferentPrefix.keySet());
        prefixes.removeAll(this.usedPrefix);
        warnConsumer.accept("The following prefixes do not match any type: ", prefixes);
    }

    private void rewriteRetargetKeys(Map<DexMethod, DexType> retarget) {
        for (DexMethod dexMethod : retarget.keySet()) {
            DexType type = this.convertJavaNameToDesugaredLibrary(dexMethod.holder);
            this.builder.rewriteDerivedTypeOnly(dexMethod.holder, type);
        }
    }

    private void rewriteEmulatedInterface(Map<DexType, DexType> emulateLibraryInterface) {
        emulateLibraryInterface.forEach(this.builder::rewriteDerivedTypeOnly);
    }

    private void rewriteValues(Map<?, DexType> flags) {
        for (DexType type : flags.values()) {
            this.registerType(type);
        }
    }

    private void rewriteClasses() {
        this.appInfo.app().forEachLibraryType(this::registerClassType);
        if (this.libraryCompilation) {
            this.appInfo.app().forEachProgramType(this::registerClassType);
        }
    }

    private void registerClassType(DexType type) {
        this.registerType(type);
        this.registerDifferentType(type);
    }

    private void registerType(DexType type) {
        DexType rewrittenType = this.rewrittenType(type);
        if (rewrittenType != null) {
            this.builder.rewriteType(type, rewrittenType);
        }
    }

    private void registerDifferentType(DexType type) {
        DexString prefix = this.prefixMatching(type, this.descriptorDifferentPrefix.keySet());
        if (prefix == null) {
            return;
        }
        this.descriptorDifferentPrefix.get(prefix).forEach((k, v) -> {
            DexString typeDescriptor = type.descriptor.withNewPrefix(prefix, (DexString)k, this.appInfo.dexItemFactory());
            DexString rewrittenTypeDescriptor = type.descriptor.withNewPrefix(prefix, (DexString)v, this.appInfo.dexItemFactory());
            this.builder.rewriteType(this.appInfo.dexItemFactory().createType(typeDescriptor), this.appInfo.dexItemFactory().createType(rewrittenTypeDescriptor));
        });
        this.usedPrefix.add(prefix);
    }

    private DexString prefixMatching(DexType type, Set<DexString> prefixes) {
        DexString prefixToMatch = type.descriptor.withoutArray(this.appInfo.dexItemFactory());
        for (DexString prefix : prefixes) {
            if (!prefixToMatch.startsWith(prefix)) continue;
            return prefix;
        }
        return null;
    }

    private DexType rewrittenType(DexType type) {
        DexString prefix = this.prefixMatching(type, this.descriptorPrefix.keySet());
        if (prefix == null) {
            return null;
        }
        DexString rewrittenTypeDescriptor = type.descriptor.withNewPrefix(prefix, this.descriptorPrefix.get(prefix), this.appInfo.dexItemFactory());
        this.usedPrefix.add(prefix);
        return this.appInfo.dexItemFactory().createType(rewrittenTypeDescriptor);
    }

    private ImmutableMap<DexString, Map<DexString, DexString>> convertRewriteDifferentPrefix(Map<String, Map<String, String>> rewriteDerivedPrefix) {
        ImmutableMap.Builder<DexString, ImmutableMap<DexString, DexString>> mapBuilder = ImmutableMap.builder();
        for (String key : rewriteDerivedPrefix.keySet()) {
            mapBuilder.put(this.toDescriptorPrefix(key), this.convertRewritePrefix(rewriteDerivedPrefix.get(key)));
        }
        return mapBuilder.build();
    }

    private ImmutableMap<DexString, DexString> convertRewritePrefix(Map<String, String> rewritePrefix) {
        ImmutableMap.Builder<DexString, DexString> mapBuilder = ImmutableMap.builder();
        for (String key : rewritePrefix.keySet()) {
            mapBuilder.put(this.toDescriptorPrefix(key), this.toDescriptorPrefix(rewritePrefix.get(key)));
        }
        return mapBuilder.build();
    }

    private DexString toDescriptorPrefix(String prefix) {
        return this.appInfo.dexItemFactory().createString("L" + DescriptorUtils.getBinaryNameFromJavaType(prefix));
    }

    public void convertPrefixFlags(HumanRewritingFlags rewritingFlags, BiConsumer<String, Set<DexString>> warnConsumer) {
        this.rewriteClasses();
        this.rewriteValues(rewritingFlags.getRetargetMethod());
        this.rewriteValues(rewritingFlags.getRetargetMethodEmulatedDispatch());
        this.rewriteValues(rewritingFlags.getCustomConversions());
        this.rewriteEmulatedInterface(rewritingFlags.getEmulatedInterfaces());
        this.rewriteRetargetKeys(rewritingFlags.getRetargetMethodEmulatedDispatch());
        this.warnIfUnusedPrefix(warnConsumer);
    }

    public DexType convertJavaNameToDesugaredLibrary(DexType type) {
        String convertedPrefix = DescriptorUtils.getJavaTypeFromBinaryName(this.synthesizedPrefix);
        String interfaceType = type.toString();
        int firstPackage = interfaceType.indexOf(46);
        return this.appInfo.dexItemFactory().createType(DescriptorUtils.javaTypeToDescriptor(convertedPrefix + interfaceType.substring(firstPackage + 1)));
    }
}

