/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.specificationconversion;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.HumanRewritingFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.DerivedMethod;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.EmulatedDispatchMethodDescriptor;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.MachineRewritingFlags;
import com.android.tools.r8.synthesis.SyntheticNaming;
import com.android.tools.r8.utils.TraversalContinuation;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public class HumanToMachineRetargetConverter {
    private final AppInfoWithClassHierarchy appInfo;
    private final Set<DexMethod> missingMethods = Sets.newIdentityHashSet();

    public HumanToMachineRetargetConverter(AppInfoWithClassHierarchy appInfo) {
        this.appInfo = appInfo;
    }

    private void convertRetargetMethodEmulatedDispatch(MachineRewritingFlags.Builder builder, HumanRewritingFlags rewritingFlags, DexMethod method, DexType type) {
        DexClass holder = this.appInfo.definitionFor(method.holder);
        DexEncodedMethod foundMethod = holder.lookupMethod(method);
        if (foundMethod == null) {
            this.missingMethods.add(method);
            return;
        }
        if (foundMethod.isStatic()) {
            this.appInfo.app().options.reporter.error("Cannot generate emulated dispatch for static method " + foundMethod);
            return;
        }
        if (!this.seemsToNeedEmulatedDispatch(holder, foundMethod)) {
            this.appInfo.app().options.reporter.warning("Generating (seemingly unnecessary) emulated dispatch for final method " + foundMethod);
        }
        this.convertEmulatedVirtualRetarget(builder, rewritingFlags, foundMethod, type);
    }

    private void convertRetargetMethod(MachineRewritingFlags.Builder builder, DexMethod method, DexType type) {
        DexClass holder = this.appInfo.definitionFor(method.holder);
        DexEncodedMethod foundMethod = holder.lookupMethod(method);
        if (foundMethod == null) {
            this.missingMethods.add(method);
            return;
        }
        if (foundMethod.isStatic()) {
            this.convertStaticRetarget(builder, foundMethod, type);
            return;
        }
        if (this.seemsToNeedEmulatedDispatch(holder, foundMethod)) {
            this.appInfo.app().options.reporter.warning("Retargeting non final method " + foundMethod + " which could lead to invalid runtime execution in overrides.");
        }
        this.convertNonEmulatedVirtualRetarget(builder, foundMethod, type);
    }

    private boolean seemsToNeedEmulatedDispatch(DexClass holder, DexEncodedMethod method) {
        assert (!method.isStatic());
        return !holder.isFinal() && !method.isFinal();
    }

    private void convertEmulatedVirtualRetarget(MachineRewritingFlags.Builder builder, HumanRewritingFlags rewritingFlags, DexEncodedMethod src, DexType type) {
        DexProto newProto = this.appInfo.dexItemFactory().prependHolderToProto((DexMethod)src.getReference());
        DexMethod forwardingDexMethod = this.appInfo.dexItemFactory().createMethod(type, newProto, src.getName());
        if (this.isEmulatedInterfaceDispatch(src, this.appInfo, rewritingFlags)) {
            builder.putEmulatedVirtualRetargetThroughEmulatedInterface((DexMethod)src.getReference(), forwardingDexMethod);
            return;
        }
        SyntheticNaming syntheticNaming = this.appInfo.getSyntheticItems().getNaming();
        DerivedMethod forwardingMethod = new DerivedMethod(forwardingDexMethod);
        DerivedMethod interfaceMethod = new DerivedMethod((DexMethod)src.getReference(), syntheticNaming.RETARGET_INTERFACE);
        DerivedMethod dispatchMethod = new DerivedMethod((DexMethod)src.getReference(), syntheticNaming.RETARGET_CLASS);
        LinkedHashMap<DexType, DerivedMethod> dispatchCases = new LinkedHashMap<DexType, DerivedMethod>();
        builder.putEmulatedVirtualRetarget((DexMethod)src.getReference(), new EmulatedDispatchMethodDescriptor(interfaceMethod, dispatchMethod, forwardingMethod, dispatchCases));
    }

    private boolean isEmulatedInterfaceDispatch(DexEncodedMethod method, AppInfoWithClassHierarchy appInfo, HumanRewritingFlags humanRewritingFlags) {
        Map<DexType, DexType> emulateLibraryInterface = humanRewritingFlags.getEmulatedInterfaces();
        if (emulateLibraryInterface.isEmpty()) {
            return false;
        }
        DexMethod methodToFind = (DexMethod)method.getReference();
        DexClass dexClass = appInfo.definitionFor(method.getHolderType());
        assert (!emulateLibraryInterface.containsKey(dexClass.getType()));
        return appInfo.traverseSuperTypes(dexClass, (supertype, subclass, isSupertypeAnInterface) -> TraversalContinuation.breakIf(subclass.isInterface() && emulateLibraryInterface.containsKey(subclass.getType()) && subclass.lookupMethod(methodToFind) != null)).shouldBreak();
    }

    private void convertNonEmulatedRetarget(DexEncodedMethod foundMethod, DexType type, AppInfoWithClassHierarchy appInfo, BiConsumer<DexMethod, DexMethod> consumer) {
        DexMethod src = (DexMethod)foundMethod.getReference();
        DexMethod dest = src.withHolder(type, appInfo.dexItemFactory());
        consumer.accept(src, dest);
    }

    private void convertNonEmulatedVirtualRetarget(MachineRewritingFlags.Builder builder, DexEncodedMethod foundMethod, DexType type) {
        this.convertNonEmulatedRetarget(foundMethod, type, this.appInfo, (src, dest) -> builder.putNonEmulatedVirtualRetarget((DexMethod)src, dest.withExtraArgumentPrepended(foundMethod.getHolderType(), this.appInfo.dexItemFactory())));
    }

    private void convertStaticRetarget(MachineRewritingFlags.Builder builder, DexEncodedMethod foundMethod, DexType type) {
        this.convertNonEmulatedRetarget(foundMethod, type, this.appInfo, builder::putStaticRetarget);
    }

    public void convertRetargetFlags(HumanRewritingFlags rewritingFlags, MachineRewritingFlags.Builder builder, BiConsumer<String, Set<? extends DexReference>> warnConsumer) {
        rewritingFlags.getRetargetMethod().forEach((method, type) -> this.convertRetargetMethod(builder, (DexMethod)method, (DexType)type));
        rewritingFlags.getRetargetMethodEmulatedDispatch().forEach((method, type) -> this.convertRetargetMethodEmulatedDispatch(builder, rewritingFlags, (DexMethod)method, (DexType)type));
        warnConsumer.accept("Cannot retarget missing methods: ", this.missingMethods);
    }
}

