/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.specificationconversion;

import com.android.tools.r8.androidapi.ComputedApiLevel;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.desugar.desugaredlibrary.DesugaredLibraryAmender;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.HumanDesugaredLibrarySpecification;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.HumanRewritingFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.HumanTopLevelFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.CustomConversionDescriptor;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.MachineDesugaredLibrarySpecification;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.MachineRewritingFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.MachineTopLevelFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.specificationconversion.AppForSpecConversion;
import com.android.tools.r8.ir.desugar.desugaredlibrary.specificationconversion.HumanToMachineEmulatedInterfaceConverter;
import com.android.tools.r8.ir.desugar.desugaredlibrary.specificationconversion.HumanToMachinePrefixConverter;
import com.android.tools.r8.ir.desugar.desugaredlibrary.specificationconversion.HumanToMachineRetargetConverter;
import com.android.tools.r8.ir.desugar.desugaredlibrary.specificationconversion.HumanToMachineWrapperConverter;
import com.android.tools.r8.ir.desugar.desugaredlibrary.specificationconversion.LibraryValidator;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.Timing;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class HumanToMachineSpecificationConverter {
    private AppInfoWithClassHierarchy appInfo;
    private Reporter reporter;
    private final Set<DexType> missingCustomConversions = Sets.newIdentityHashSet();
    private final Timing timing;

    public HumanToMachineSpecificationConverter(Timing timing) {
        this.timing = timing;
    }

    private MachineTopLevelFlags convertTopLevelFlags(HumanTopLevelFlags topLevelFlags) {
        return new MachineTopLevelFlags(topLevelFlags.getRequiredCompilationAPILevel(), topLevelFlags.getSynthesizedLibraryClassesPackagePrefix(), topLevelFlags.getIdentifier(), topLevelFlags.getJsonSource(), topLevelFlags.supportAllCallbacksFromLibrary(), topLevelFlags.getExtraKeepRules());
    }

    private MachineRewritingFlags convertRewritingFlags(HumanDesugaredLibrarySpecification humanSpec) {
        this.timing.begin("convert rewriting flags");
        HumanRewritingFlags rewritingFlags = humanSpec.getRewritingFlags();
        MachineRewritingFlags.Builder builder = MachineRewritingFlags.builder();
        DesugaredLibraryAmender.run(rewritingFlags.getAmendLibraryMethod(), this.appInfo, this.reporter, ComputedApiLevel.unknown());
        rewritingFlags.getAmendLibraryMethod().forEach(builder::amendLibraryMethod);
        new HumanToMachineRetargetConverter(this.appInfo).convertRetargetFlags(rewritingFlags, builder, this::warnMissingReferences);
        new HumanToMachineEmulatedInterfaceConverter(this.appInfo).convertEmulatedInterfaces(rewritingFlags, this.appInfo, builder, this::warnMissingReferences);
        new HumanToMachinePrefixConverter(this.appInfo, builder, humanSpec, rewritingFlags).convertPrefixFlags(rewritingFlags, this::warnMissingDexString);
        new HumanToMachineWrapperConverter(this.appInfo).convertWrappers(rewritingFlags, builder, this::warnMissingReferences);
        rewritingFlags.getCustomConversions().forEach((type, conversionType) -> this.convertCustomConversion(this.appInfo, builder, (DexType)type, (DexType)conversionType));
        this.warnMissingReferences("Cannot register custom conversion due to missing type: ", this.missingCustomConversions);
        rewritingFlags.getDontRetarget().forEach(builder::addDontRetarget);
        rewritingFlags.getLegacyBackport().forEach(builder::putLegacyBackport);
        MachineRewritingFlags machineFlags = builder.build();
        this.timing.end();
        return machineFlags;
    }

    private void convertCustomConversion(AppInfoWithClassHierarchy appInfo, MachineRewritingFlags.Builder builder, DexType type, DexType conversionType) {
        DexType rewrittenType = builder.getRewrittenType(type);
        if (rewrittenType == null) {
            this.missingCustomConversions.add(type);
            return;
        }
        DexProto fromProto = appInfo.dexItemFactory().createProto(rewrittenType, type);
        DexMethod fromMethod = appInfo.dexItemFactory().createMethod(conversionType, fromProto, appInfo.dexItemFactory().convertMethodName);
        DexProto toProto = appInfo.dexItemFactory().createProto(type, rewrittenType);
        DexMethod toMethod = appInfo.dexItemFactory().createMethod(conversionType, toProto, appInfo.dexItemFactory().convertMethodName);
        builder.putCustomConversion(type, new CustomConversionDescriptor(toMethod, fromMethod));
    }

    private void warn(String message, List<?> memberList) {
        if (memberList.isEmpty()) {
            return;
        }
        this.reporter.warning("Specification conversion: " + message + memberList);
    }

    public MachineDesugaredLibrarySpecification convertForTesting(HumanDesugaredLibrarySpecification humanSpec, Path desugaredJDKLib, Path androidLib, InternalOptions options) throws IOException {
        DexApplication app = AppForSpecConversion.readAppForTesting(desugaredJDKLib, androidLib, options, humanSpec.isLibraryCompilation(), this.timing);
        return this.convert(humanSpec, app);
    }

    public MachineDesugaredLibrarySpecification convert(HumanDesugaredLibrarySpecification humanSpec, DexApplication app) {
        this.timing.begin("Human to machine convert");
        this.reporter = app.options.reporter;
        this.appInfo = AppInfoWithClassHierarchy.createForDesugaring(AppInfo.createInitialAppInfo(app));
        LibraryValidator.validate(app, humanSpec.isLibraryCompilation(), humanSpec.getTopLevelFlags().getRequiredCompilationAPILevel());
        MachineRewritingFlags machineRewritingFlags = this.convertRewritingFlags(humanSpec);
        MachineTopLevelFlags topLevelFlags = this.convertTopLevelFlags(humanSpec.getTopLevelFlags());
        this.timing.end();
        return new MachineDesugaredLibrarySpecification(humanSpec.isLibraryCompilation(), topLevelFlags, machineRewritingFlags);
    }

    void warnMissingReferences(String message, Set<? extends DexReference> missingReferences) {
        ArrayList<? extends DexReference> memberList = new ArrayList<DexReference>(missingReferences);
        memberList.sort(DexReference::compareTo);
        this.warn(message, memberList);
    }

    void warnMissingDexString(String message, Set<DexString> missingDexString) {
        ArrayList<DexString> memberList = new ArrayList<DexString>(missingDexString);
        memberList.sort(DexString::compareTo);
        this.warn(message, memberList);
    }
}

