/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.desugaredlibrary.specificationconversion;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.desugar.desugaredlibrary.humanspecification.HumanRewritingFlags;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.MachineRewritingFlags;
import com.android.tools.r8.utils.structural.StructuralItem;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;

public class HumanToMachineWrapperConverter {
    private final AppInfoWithClassHierarchy appInfo;
    private final Set<DexType> missingClasses = Sets.newIdentityHashSet();

    public HumanToMachineWrapperConverter(AppInfoWithClassHierarchy appInfo) {
        this.appInfo = appInfo;
    }

    private List<DexMethod> allImplementedMethods(DexClass wrapperClass, Set<DexMethod> excludedMethods) {
        LinkedList<DexClass> workList = new LinkedList<DexClass>();
        ArrayList<DexMethod> implementedMethods = new ArrayList<DexMethod>();
        workList.add(wrapperClass);
        while (!workList.isEmpty()) {
            DexClass dexClass = (DexClass)workList.removeFirst();
            for (DexEncodedMethod virtualMethod : dexClass.virtualMethods()) {
                if (virtualMethod.isPrivateMethod()) continue;
                assert (virtualMethod.isProtectedMethod() || virtualMethod.isPublicMethod());
                boolean alreadyAdded = excludedMethods.contains(virtualMethod.getReference());
                if (!alreadyAdded) {
                    for (DexMethod alreadyImplementedMethod : implementedMethods) {
                        if (!alreadyImplementedMethod.match((DexMethod)virtualMethod.getReference())) continue;
                        alreadyAdded = true;
                        break;
                    }
                }
                if (alreadyAdded) continue;
                assert (!virtualMethod.isFinal()) : "Cannot wrap final method " + virtualMethod + " while wrapping " + wrapperClass;
                implementedMethods.add((DexMethod)virtualMethod.getReference());
            }
            for (DexType itf : dexClass.interfaces.values) {
                DexClass itfClass = this.appInfo.definitionFor(itf);
                if (itfClass == null) continue;
                workList.add(itfClass);
            }
            if (dexClass.superType == this.appInfo.dexItemFactory().objectType) continue;
            DexClass superClass = this.appInfo.definitionFor(dexClass.superType);
            assert (superClass != null) : "Missing supertype " + dexClass.superType + " while wrapping " + wrapperClass;
            workList.add(superClass);
        }
        return implementedMethods;
    }

    public void convertWrappers(HumanRewritingFlags rewritingFlags, MachineRewritingFlags.Builder builder, BiConsumer<String, Set<? extends DexReference>> warnConsumer) {
        rewritingFlags.getWrapperConversions().forEach((wrapperType, excludedMethods) -> {
            ImmutableList<DexMethod> methods;
            DexClass wrapperClass = this.appInfo.definitionFor((DexType)wrapperType);
            if (wrapperClass == null) {
                this.missingClasses.add((DexType)wrapperType);
                return;
            }
            if (wrapperClass.isEnum()) {
                methods = ImmutableList.of();
            } else {
                methods = this.allImplementedMethods(wrapperClass, (Set<DexMethod>)excludedMethods);
                methods.sort(StructuralItem::compareTo);
            }
            builder.addWrapper((DexType)wrapperType, (List<DexMethod>)methods);
        });
        warnConsumer.accept("The following types to wrap are missing: ", this.missingClasses);
    }
}

