/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.itf;

import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.cf.code.CfNew;
import com.android.tools.r8.cf.code.CfStackInstruction;
import com.android.tools.r8.cf.code.CfThrow;
import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMember;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexLibraryClass;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GenericSignature;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.DerivedMethod;
import com.android.tools.r8.ir.desugar.itf.InterfaceDesugaringSyntheticHelper;
import com.android.tools.r8.ir.desugar.itf.InterfaceProcessingDesugaringEventConsumer;
import com.android.tools.r8.position.MethodPosition;
import com.android.tools.r8.utils.BooleanBox;
import com.android.tools.r8.utils.BooleanUtils;
import com.android.tools.r8.utils.IterableUtils;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import com.android.tools.r8.utils.OptionalBool;
import com.android.tools.r8.utils.WorkList;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

final class ClassProcessor {
    private final AppView<?> appView;
    private final DexItemFactory dexItemFactory;
    private final InterfaceDesugaringSyntheticHelper helper;
    private final MethodSignatureEquivalence equivalence = MethodSignatureEquivalence.get();
    private final boolean needsLibraryInfo;
    private final Predicate<ProgramMethod> isLiveMethod;
    private final Map<DexClass, ClassInfo> classInfo = new ConcurrentHashMap<DexClass, ClassInfo>();
    private final Map<DexLibraryClass, SignaturesInfo> libraryClassInfo = new ConcurrentHashMap<DexLibraryClass, SignaturesInfo>();
    private final Map<DexClass, SignaturesInfo> interfaceInfo = new ConcurrentHashMap<DexClass, SignaturesInfo>();
    private final Map<DexProgramClass, ProgramMethodSet> newSyntheticMethods = new ConcurrentHashMap<DexProgramClass, ProgramMethodSet>();
    private final Map<DexProgramClass, List<GenericSignature.ClassTypeSignature>> newExtraInterfaceSignatures = new ConcurrentHashMap<DexProgramClass, List<GenericSignature.ClassTypeSignature>>();

    ClassProcessor(AppView<?> appView, Predicate<ProgramMethod> isLiveMethod) {
        this.appView = appView;
        this.dexItemFactory = appView.dexItemFactory();
        this.helper = new InterfaceDesugaringSyntheticHelper(appView);
        this.needsLibraryInfo = appView.options().machineDesugaredLibrarySpecification.hasEmulatedInterfaces();
        this.isLiveMethod = isLiveMethod;
    }

    private boolean isLiveMethod(DexClassAndMethod method) {
        if (method.isProgramMethod()) {
            return this.isLiveMethod.test(method.asProgramMethod());
        }
        return true;
    }

    private boolean needsLibraryInfo() {
        return this.needsLibraryInfo;
    }

    private boolean ignoreLibraryInfo() {
        return !this.needsLibraryInfo;
    }

    private SignaturesInfo computeInterfaceInfo(DexClass iface, SignaturesInfo interfaceInfo) {
        assert (iface.isInterface());
        assert (iface.superType == this.dexItemFactory.objectType);
        assert (!this.helper.isEmulatedInterface(iface.type));
        if (!iface.isLibraryClass() || this.needsLibraryInfo() && this.helper.isInDesugaredLibrary(iface)) {
            MethodSignatures signatures = this.getDefaultMethods(iface);
            interfaceInfo = interfaceInfo.withSignatures(signatures);
        }
        return interfaceInfo;
    }

    private SignaturesInfo computeEmulatedInterfaceInfo(DexClass iface, SignaturesInfo interfaceInfo) {
        assert (iface.isInterface());
        assert (iface.superType == this.dexItemFactory.objectType);
        assert (this.helper.isEmulatedInterface(iface.type));
        assert (this.needsLibraryInfo());
        MethodSignatures signatures = this.getDefaultMethods(iface);
        EmulatedInterfaceInfo emulatedInterfaceInfo = new EmulatedInterfaceInfo(signatures, new EmulatedInterfaces(iface.type));
        return interfaceInfo.withEmulatedInterfaceInfo(emulatedInterfaceInfo);
    }

    private MethodSignatures getDefaultMethods(DexClass iface) {
        assert (iface.isInterface());
        HashSet<Equivalence.Wrapper<DexMethod>> defaultMethods = new HashSet<Equivalence.Wrapper<DexMethod>>(iface.getMethodCollection().numberOfVirtualMethods());
        for (DexEncodedMethod method : iface.virtualMethods(DexEncodedMethod::isDefaultMethod)) {
            defaultMethods.add(this.equivalence.wrap((DexMethod)method.getReference()));
        }
        return MethodSignatures.create(defaultMethods);
    }

    private SignaturesInfo computeLibraryClassInfo(DexLibraryClass clazz, SignaturesInfo signatures) {
        return signatures;
    }

    private ClassInfo computeClassInfo(DexClass clazz, ClassInfo superInfo, SignaturesInfo signatureInfo) {
        ImmutableList.Builder<DexClassAndMethod> additionalForwards = ImmutableList.builder();
        this.resolveForwardingMethods(clazz, superInfo, signatureInfo.signatures, additionalForwards);
        if (this.shouldResolveForwardingMethodsForEmulatedInterfaces(clazz, signatureInfo.emulatedInterfaceInfo)) {
            this.resolveForwardingMethods(clazz, superInfo, signatureInfo.emulatedInterfaceSignaturesToForward(), additionalForwards);
            this.duplicateEmulatedInterfaces(clazz, signatureInfo.emulatedInterfaceInfo.emulatedInterfaces);
            return ClassInfo.create(superInfo, (ImmutableList<DexClassAndMethod>)additionalForwards.build(), EmulatedInterfaceInfo.EMPTY);
        }
        return ClassInfo.create(superInfo, (ImmutableList<DexClassAndMethod>)additionalForwards.build(), signatureInfo.emulatedInterfaceInfo);
    }

    private void duplicateEmulatedInterfaces(DexClass clazz, EmulatedInterfaces emulatedInterfaces) {
        if (clazz.isNotProgramClass()) {
            return;
        }
        HashSet<DexType> filtered = new HashSet<DexType>(emulatedInterfaces.getEmulatedInterfaces());
        WorkList<DexType> workList = WorkList.newIdentityWorkList();
        for (DexType emulatedInterface : emulatedInterfaces.getEmulatedInterfaces()) {
            DexClass iface2 = this.appView.definitionFor(emulatedInterface);
            if (iface2 == null) continue;
            assert (iface2.isLibraryClass() || this.appView.options().machineDesugaredLibrarySpecification.isLibraryCompilation());
            workList.addIfNotSeen(iface2.getInterfaces());
        }
        while (workList.hasNext()) {
            DexType type = (DexType)workList.next();
            filtered.remove(type);
            DexClass iface3 = this.appView.definitionFor(type);
            if (iface3 == null) continue;
            workList.addIfNotSeen(iface3.getInterfaces());
        }
        for (DexType emulatedInterface : emulatedInterfaces.getEmulatedInterfaces()) {
            DexClass s2 = this.appView.definitionFor(emulatedInterface);
            if (s2 != null) {
                s2 = this.appView.definitionFor(s2.superType);
            }
            while (s2 != null && s2.getType() != this.appView.dexItemFactory().objectType) {
                filtered.remove(s2.getType());
                s2 = this.appView.definitionFor(s2.getSuperType());
            }
        }
        IdentityHashMap<DexType, GenericSignature.ClassTypeSignature> signatures = new IdentityHashMap<DexType, GenericSignature.ClassTypeSignature>();
        this.collectEmulatedInterfaces(clazz, filtered, signatures);
        ArrayList<DexType> sortedEmulatedInterfaces = new ArrayList<DexType>(filtered);
        Collections.sort(sortedEmulatedInterfaces);
        ArrayList<GenericSignature.ClassTypeSignature> extraInterfaceSignatures = new ArrayList<GenericSignature.ClassTypeSignature>();
        for (DexType extraInterface : sortedEmulatedInterfaces) {
            GenericSignature.ClassTypeSignature signature = (GenericSignature.ClassTypeSignature)signatures.get(extraInterface);
            assert (signature != null);
            extraInterfaceSignatures.add(signature);
        }
        clazz.getInterfaces().forEach((Consumer<? super DexType>)((Consumer<DexType>)iface -> {
            for (int i = 0; i < extraInterfaceSignatures.size(); ++i) {
                if (((GenericSignature.ClassTypeSignature)extraInterfaceSignatures.get(i)).type() != iface) continue;
                if (!this.appView.options().desugarSpecificOptions().allowAllDesugaredInput) {
                    throw new CompilationError("Code has already been library desugared. Interface " + iface.getDescriptor() + " is already implemented by " + clazz.getType().getDescriptor());
                }
                extraInterfaceSignatures.remove(i);
                break;
            }
        }));
        this.newExtraInterfaceSignatures.put(clazz.asProgramClass(), extraInterfaceSignatures);
    }

    private void collectEmulatedInterfaces(DexClass clazz, Set<DexType> emulatesInterfaces, Map<DexType, GenericSignature.ClassTypeSignature> extraInterfaceSignatures) {
        if (this.appView.options().cfToCfDesugar && clazz.validInterfaceSignatures()) {
            clazz.forEachImmediateSupertypeWithSignature((type, signature) -> {
                if (emulatesInterfaces.contains(type)) {
                    extraInterfaceSignatures.put((DexType)type, new GenericSignature.ClassTypeSignature(this.helper.getEmulatedInterface((DexType)type), signature.typeArguments()));
                }
                this.collectEmulatedInterfacesWithPropagatedTypeArguments((DexType)type, signature.typeArguments(), emulatesInterfaces, extraInterfaceSignatures);
            });
        } else {
            clazz.forEachImmediateSupertype(type -> {
                if (emulatesInterfaces.contains(type)) {
                    extraInterfaceSignatures.put((DexType)type, new GenericSignature.ClassTypeSignature(this.helper.getEmulatedInterface((DexType)type)));
                }
                this.collectEmulatedInterfacesWithPropagatedTypeArguments((DexType)type, null, emulatesInterfaces, extraInterfaceSignatures);
            });
        }
    }

    private void collectEmulatedInterfacesWithPropagatedTypeArguments(DexType type, List<GenericSignature.FieldTypeSignature> typeArguments, Set<DexType> emulatesInterfaces, Map<DexType, GenericSignature.ClassTypeSignature> extraInterfaceSignatures) {
        DexClass clazz = this.appView.definitionFor(type);
        if (clazz == null) {
            return;
        }
        if (this.appView.options().cfToCfDesugar && clazz.validInterfaceSignatures()) {
            assert (typeArguments != null);
            clazz.forEachImmediateSupertypeWithAppliedTypeArguments(typeArguments, (iface, signature) -> {
                if (emulatesInterfaces.contains(iface)) {
                    extraInterfaceSignatures.put((DexType)iface, new GenericSignature.ClassTypeSignature(this.helper.getEmulatedInterface((DexType)iface), (List<GenericSignature.FieldTypeSignature>)signature));
                }
                this.collectEmulatedInterfacesWithPropagatedTypeArguments((DexType)iface, (List<GenericSignature.FieldTypeSignature>)signature, emulatesInterfaces, extraInterfaceSignatures);
            });
        } else {
            assert (typeArguments == null);
            clazz.forEachImmediateSupertype(iface -> {
                if (emulatesInterfaces.contains(iface)) {
                    extraInterfaceSignatures.put((DexType)iface, new GenericSignature.ClassTypeSignature(this.helper.getEmulatedInterface((DexType)iface)));
                }
                this.collectEmulatedInterfacesWithPropagatedTypeArguments((DexType)iface, null, emulatesInterfaces, extraInterfaceSignatures);
            });
        }
    }

    private boolean shouldResolveForwardingMethodsForEmulatedInterfaces(DexClass clazz, EmulatedInterfaceInfo emulatedInterfaceInfo) {
        AppInfoWithClassHierarchy appInfo = this.appView.appInfoForDesugaring();
        for (Equivalence.Wrapper<DexMethod> signature : emulatedInterfaceInfo.signatures.signatures) {
            MethodResolutionResult resolutionResult = appInfo.resolveMethodOnClass(signature.get(), clazz);
            if (resolutionResult.isFailedResolution()) {
                return true;
            }
            DexClass resolvedHolder = resolutionResult.asSingleResolution().getResolvedHolder();
            if (resolvedHolder.isLibraryClass() || emulatedInterfaceInfo.contains(resolvedHolder.type)) continue;
            return true;
        }
        return false;
    }

    private void resolveForwardingMethods(DexClass clazz, ClassInfo superInfo, MethodSignatures signatures, ImmutableList.Builder<DexClassAndMethod> additionalForwards) {
        if (clazz.isProgramClass() && this.appView.isAlreadyLibraryDesugared(clazz.asProgramClass())) {
            return;
        }
        for (Equivalence.Wrapper<DexMethod> wrapper : signatures.signatures) {
            this.resolveForwardForSignature(clazz, wrapper.get(), (target, forward) -> {
                if (this.isLiveMethod((DexClassAndMethod)target) && !superInfo.isTargetedByForwards((DexClassAndMethod)target)) {
                    additionalForwards.add(target);
                    this.addForwardingMethod((DexClassAndMethod)target, (DexMethod)forward, clazz);
                }
            });
        }
    }

    private void resolveForwardForSignature(DexClass clazz, DexMethod method, BiConsumer<DexClassAndMethod, DexMethod> addForward) {
        AppInfoWithClassHierarchy appInfo = this.appView.appInfoForDesugaring();
        MethodResolutionResult resolutionResult = appInfo.resolveMethodOn(clazz, method);
        if (resolutionResult.isFailedResolution() || resolutionResult.asSuccessfulMemberResolutionResult().getResolvedMember().isStatic()) {
            BooleanBox staticTarget = new BooleanBox(true);
            if (resolutionResult.isFailedResolution()) {
                resolutionResult.asFailedResolution().forEachFailureDependency(target -> staticTarget.and(target.isStatic()));
            } else if (resolutionResult.isSuccessfulMemberResolutionResult()) {
                staticTarget.set(resolutionResult.asSuccessfulMemberResolutionResult().getResolvedMember().isStatic());
            }
            if (staticTarget.isAssigned() && staticTarget.isTrue()) {
                resolutionResult = appInfo.resolveMethodOnInterface(method.holder, method);
            }
            if (resolutionResult.isFailedResolution()) {
                if (resolutionResult.isIncompatibleClassChangeErrorResult()) {
                    this.addICCEThrowingMethod(method, clazz);
                    return;
                }
                if (resolutionResult.isNoSuchMethodErrorResult(clazz, appInfo)) {
                    this.addNoSuchMethodErrorThrowingMethod(method, clazz);
                    return;
                }
                assert (resolutionResult.isIllegalAccessErrorResult(clazz, appInfo));
                this.addIllegalAccessErrorThrowingMethod(method, clazz);
                return;
            }
        }
        assert (resolutionResult.isSuccessfulMemberResolutionResult());
        DexClassAndMethod virtualDispatchTarget = resolutionResult.lookupVirtualDispatchTarget(clazz, appInfo);
        assert (virtualDispatchTarget != null);
        if (virtualDispatchTarget.isDefaultMethod()) {
            addForward.accept(virtualDispatchTarget, (DexMethod)this.helper.ensureDefaultAsMethodOfCompanionClassStub(virtualDispatchTarget).getReference());
            return;
        }
        DerivedMethod forwardingMethod = this.helper.computeEmulatedInterfaceForwardingMethod(virtualDispatchTarget.getHolder(), virtualDispatchTarget);
        if (forwardingMethod != null) {
            DexMethod concreteForwardingMethod = this.helper.ensureEmulatedInterfaceForwardingMethod(forwardingMethod);
            addForward.accept(virtualDispatchTarget, concreteForwardingMethod);
        }
    }

    private void addSyntheticMethod(DexProgramClass clazz, DexEncodedMethod method) {
        this.newSyntheticMethods.computeIfAbsent(clazz, key -> ProgramMethodSet.create()).createAndAdd(clazz, method);
    }

    private void addICCEThrowingMethod(DexMethod method, DexClass clazz) {
        this.addThrowingMethod(method, clazz, this.dexItemFactory.icceType);
    }

    private void addIllegalAccessErrorThrowingMethod(DexMethod method, DexClass clazz) {
        this.addThrowingMethod(method, clazz, this.dexItemFactory.illegalAccessErrorType);
    }

    private void addNoSuchMethodErrorThrowingMethod(DexMethod method, DexClass clazz) {
        this.addThrowingMethod(method, clazz, this.dexItemFactory.noSuchMethodErrorType);
    }

    private void addThrowingMethod(DexMethod method, DexClass clazz, DexType errorType) {
        if (!clazz.isProgramClass()) {
            return;
        }
        MethodAccessFlags accessFlags = (MethodAccessFlags)((MethodAccessFlags.Builder)MethodAccessFlags.builder().setPublic()).build();
        DexMethod newMethod = method.withHolder(clazz.getType(), this.dexItemFactory);
        DexEncodedMethod newEncodedMethod = DexEncodedMethod.syntheticBuilder().setMethod(newMethod).setAccessFlags(accessFlags).setCode(ClassProcessor.createExceptionThrowingCfCode(newMethod, accessFlags, errorType, this.dexItemFactory)).disableAndroidApiLevelCheck().build();
        this.addSyntheticMethod(clazz.asProgramClass(), newEncodedMethod);
    }

    private static CfCode createExceptionThrowingCfCode(DexMethod method, MethodAccessFlags accessFlags, DexType exceptionType, DexItemFactory dexItemFactory) {
        DexMethod instanceInitializer = dexItemFactory.createMethod(exceptionType, dexItemFactory.createProto(dexItemFactory.voidType, new DexType[0]), dexItemFactory.constructorMethodName);
        int maxStack = 2;
        int maxLocals = method.getParameters().size() + BooleanUtils.intValue(!accessFlags.isStatic());
        return new CfCode(method.getHolderType(), maxStack, maxLocals, ImmutableList.of(new CfNew(exceptionType), new CfStackInstruction(CfStackInstruction.Opcode.Dup), new CfInvoke(183, instanceInitializer, false), new CfThrow()));
    }

    private void addForwardingMethod(DexClassAndMethod target, DexMethod forwardMethod, DexClass clazz) {
        if (!clazz.isProgramClass()) {
            return;
        }
        DexEncodedMethod methodOnSelf = clazz.lookupMethod((DexMethod)target.getReference());
        if (methodOnSelf != null) {
            throw new CompilationError("Attempt to add forwarding method that conflicts with existing method.", null, clazz.getOrigin(), new MethodPosition(((DexMethod)methodOnSelf.getReference()).asMethodReference()));
        }
        DexEncodedMethod desugaringForwardingMethod = DexEncodedMethod.createDesugaringForwardingMethod((DexEncodedMethod)target.getDefinition(), clazz, forwardMethod, this.dexItemFactory);
        if (!target.isProgramDefinition() || ((DexEncodedMethod)target.getDefinition()).isLibraryMethodOverride().isTrue()) {
            desugaringForwardingMethod.setLibraryMethodOverride(OptionalBool.TRUE);
        }
        this.addSyntheticMethod(clazz.asProgramClass(), desugaringForwardingMethod);
    }

    private DexClass definitionOrNull(DexType type, ReportingContext context) {
        if (type == null || type == this.dexItemFactory.objectType) {
            return null;
        }
        DexClass clazz = context.definitionFor(type, this.appView);
        if (clazz == null) {
            context.reportMissingType(type);
            return null;
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <C extends DexClass, I> I reentrantComputeIfAbsent(Map<C, I> infoMap, C clazz, Function<C, I> supplier) {
        I computedInfo = infoMap.get(clazz);
        if (computedInfo != null) {
            return computedInfo;
        }
        C c = clazz;
        synchronized (c) {
            computedInfo = infoMap.get(clazz);
            if (computedInfo != null) {
                return computedInfo;
            }
            computedInfo = supplier.apply(clazz);
            infoMap.put(clazz, computedInfo);
            return computedInfo;
        }
    }

    private ClassInfo visitClassInfo(DexType type, ReportingContext context) {
        DexClass clazz = this.definitionOrNull(type, context);
        return clazz == null ? ClassInfo.EMPTY : this.visitClassInfo(clazz, context);
    }

    private ClassInfo visitClassInfo(DexClass clazz, ReportingContext context) {
        assert (!clazz.isInterface());
        if (clazz.isLibraryClass()) {
            return ClassInfo.EMPTY;
        }
        return this.reentrantComputeIfAbsent(this.classInfo, clazz, key -> this.visitClassInfoRaw((DexClass)key, context));
    }

    private ClassInfo visitClassInfoRaw(DexClass clazz, ReportingContext context) {
        ReportingContext thisContext = context.forClass(clazz);
        ClassInfo superInfo = this.visitClassInfo(clazz.superType, thisContext);
        SignaturesInfo signatures = this.visitLibraryClassInfo(clazz.superType);
        assert (superInfo.isEmpty() || signatures.isEmpty());
        signatures = signatures.withEmulatedInterfaceInfo(superInfo.emulatedInterfaceInfo);
        for (DexType iface : clazz.interfaces.values) {
            signatures = signatures.merge(this.visitInterfaceInfo(iface, thisContext));
        }
        return this.computeClassInfo(clazz, superInfo, signatures);
    }

    private SignaturesInfo visitLibraryClassInfo(DexType type) {
        if (this.ignoreLibraryInfo()) {
            return SignaturesInfo.EMPTY;
        }
        DexClass clazz = this.definitionOrNull(type, LibraryReportingContext.LIBRARY_CONTEXT);
        return clazz == null ? SignaturesInfo.EMPTY : this.visitLibraryClassInfo(clazz);
    }

    private SignaturesInfo visitLibraryClassInfo(DexClass clazz) {
        assert (!clazz.isInterface());
        return clazz.isLibraryClass() ? this.reentrantComputeIfAbsent(this.libraryClassInfo, clazz.asLibraryClass(), this::visitLibraryClassInfoRaw) : SignaturesInfo.EMPTY;
    }

    private SignaturesInfo visitLibraryClassInfoRaw(DexLibraryClass clazz) {
        SignaturesInfo signatures = this.visitLibraryClassInfo(clazz.superType);
        for (DexType iface : clazz.interfaces.values) {
            signatures = signatures.merge(this.visitInterfaceInfo(iface, (ReportingContext)LibraryReportingContext.LIBRARY_CONTEXT));
        }
        return this.computeLibraryClassInfo(clazz, signatures);
    }

    private SignaturesInfo visitInterfaceInfo(DexType iface, ReportingContext context) {
        DexClass definition = this.definitionOrNull(iface, context);
        return definition == null ? SignaturesInfo.EMPTY : this.visitInterfaceInfo(definition, context);
    }

    private SignaturesInfo visitInterfaceInfo(DexClass iface, ReportingContext context) {
        if (iface.isLibraryClass() && this.ignoreLibraryInfo()) {
            return SignaturesInfo.EMPTY;
        }
        return this.reentrantComputeIfAbsent(this.interfaceInfo, iface, key -> this.visitInterfaceInfoRaw((DexClass)key, context));
    }

    private SignaturesInfo visitInterfaceInfoRaw(DexClass iface, ReportingContext context) {
        ReportingContext thisContext = context.forClass(iface);
        SignaturesInfo interfaceInfo = SignaturesInfo.EMPTY;
        for (DexType superiface : iface.interfaces.values) {
            interfaceInfo = interfaceInfo.merge(this.visitInterfaceInfo(superiface, thisContext));
        }
        return this.helper.isEmulatedInterface(iface.type) ? this.computeEmulatedInterfaceInfo(iface, interfaceInfo) : this.computeInterfaceInfo(iface, interfaceInfo);
    }

    public void process(DexProgramClass clazz, InterfaceProcessingDesugaringEventConsumer eventConsumer) {
        if (!clazz.isInterface()) {
            this.visitClassInfo(clazz, new ReportingContext(clazz, clazz, (context, missing) -> eventConsumer.warnMissingInterface((DexProgramClass)context, (DexType)missing, this.helper)));
        }
    }

    public void finalizeProcessing(InterfaceProcessingDesugaringEventConsumer eventConsumer) {
        this.newSyntheticMethods.forEach((clazz, newForwardingMethods) -> {
            ArrayList sorted2 = new ArrayList(newForwardingMethods.toCollection());
            sorted2.sort(Comparator.comparing(DexClassAndMember::getReference));
            for (ProgramMethod method : sorted2) {
                clazz.addVirtualMethod((DexEncodedMethod)method.getDefinition());
                eventConsumer.acceptForwardingMethod(method);
            }
        });
        this.newExtraInterfaceSignatures.forEach((clazz, extraInterfaceSignatures) -> {
            if (!extraInterfaceSignatures.isEmpty()) {
                for (GenericSignature.ClassTypeSignature signature : extraInterfaceSignatures) {
                    eventConsumer.acceptEmulatedInterfaceMarkerInterface((DexProgramClass)clazz, this.helper.ensureEmulatedInterfaceMarkerInterface(signature.type()));
                }
                clazz.addExtraInterfaces((List<GenericSignature.ClassTypeSignature>)extraInterfaceSignatures);
            }
        });
    }

    private static class LibraryReportingContext
    extends ReportingContext {
        static final LibraryReportingContext LIBRARY_CONTEXT = new LibraryReportingContext();

        LibraryReportingContext() {
            super(null, null, null);
        }

        @Override
        ReportingContext forClass(DexClass directSubClass) {
            return this;
        }

        @Override
        public DexClass definitionFor(DexType type, AppView<?> appView) {
            return appView.definitionFor(type);
        }

        @Override
        public void reportMissingType(DexType missingType) {
        }
    }

    private static class ReportingContext {
        final DexClass directSubClass;
        final DexProgramClass closestProgramSubClass;
        final BiConsumer<DexProgramClass, DexType> reportMissingTypeCallback;

        public ReportingContext(DexClass directSubClass, DexProgramClass closestProgramSubClass, BiConsumer<DexProgramClass, DexType> reportMissingTypeCallback) {
            this.directSubClass = directSubClass;
            this.closestProgramSubClass = closestProgramSubClass;
            this.reportMissingTypeCallback = reportMissingTypeCallback;
        }

        ReportingContext forClass(DexClass directSubClass) {
            return new ReportingContext(directSubClass, directSubClass.isProgramClass() ? directSubClass.asProgramClass() : this.closestProgramSubClass, this.reportMissingTypeCallback);
        }

        public DexClass definitionFor(DexType type, AppView<?> appView) {
            return ((AppInfo)appView.appInfo()).definitionForDesugarDependency(this.directSubClass, type);
        }

        public void reportMissingType(DexType missingType) {
            this.reportMissingTypeCallback.accept(this.closestProgramSubClass, missingType);
        }
    }

    private static class EmulatedInterfaceInfo {
        static final EmulatedInterfaceInfo EMPTY = new EmulatedInterfaceInfo(MethodSignatures.EMPTY, EmulatedInterfaces.EMPTY);
        final MethodSignatures signatures;
        final EmulatedInterfaces emulatedInterfaces;

        private EmulatedInterfaceInfo(MethodSignatures methodsToForward, EmulatedInterfaces emulatedInterfaces) {
            this.signatures = methodsToForward;
            this.emulatedInterfaces = emulatedInterfaces;
        }

        public EmulatedInterfaceInfo merge(EmulatedInterfaceInfo other) {
            if (this.isEmpty()) {
                return other;
            }
            if (other.isEmpty()) {
                return this;
            }
            return new EmulatedInterfaceInfo(this.signatures.merge(other.signatures), this.emulatedInterfaces.merge(other.emulatedInterfaces));
        }

        public boolean isEmpty() {
            assert (!this.emulatedInterfaces.isEmpty() || this.signatures.isEmpty());
            return this.emulatedInterfaces.isEmpty();
        }

        boolean contains(DexType type) {
            return this.emulatedInterfaces.contains(type);
        }
    }

    static class EmulatedInterfaces {
        static EmulatedInterfaces EMPTY = new EmulatedInterfaces(ImmutableSet.of());
        final Set<DexType> emulatedInterfaces;

        EmulatedInterfaces(DexType emulatedInterface) {
            this.emulatedInterfaces = ImmutableSet.of(emulatedInterface);
        }

        private EmulatedInterfaces(Set<DexType> emulatedInterfaces) {
            this.emulatedInterfaces = emulatedInterfaces;
        }

        boolean isEmpty() {
            return this.emulatedInterfaces.isEmpty();
        }

        boolean contains(DexType type) {
            return this.emulatedInterfaces.contains(type);
        }

        Set<DexType> getEmulatedInterfaces() {
            return this.emulatedInterfaces;
        }

        EmulatedInterfaces merge(EmulatedInterfaces other) {
            ImmutableSet.Builder newEmulatedInterfaces = ImmutableSet.builder();
            newEmulatedInterfaces.addAll(this.emulatedInterfaces);
            newEmulatedInterfaces.addAll(other.emulatedInterfaces);
            return new EmulatedInterfaces((Set<DexType>)((Object)newEmulatedInterfaces.build()));
        }
    }

    private static class SignaturesInfo {
        static final SignaturesInfo EMPTY = new SignaturesInfo(MethodSignatures.EMPTY, EmulatedInterfaceInfo.EMPTY);
        final MethodSignatures signatures;
        final EmulatedInterfaceInfo emulatedInterfaceInfo;

        private SignaturesInfo(MethodSignatures methodsToForward, EmulatedInterfaceInfo emulatedInterfaceInfo) {
            this.signatures = methodsToForward;
            this.emulatedInterfaceInfo = emulatedInterfaceInfo;
        }

        public static SignaturesInfo create(MethodSignatures signatures) {
            if (signatures.isEmpty()) {
                return EMPTY;
            }
            return new SignaturesInfo(signatures, EmulatedInterfaceInfo.EMPTY);
        }

        public SignaturesInfo merge(SignaturesInfo other) {
            if (this.isEmpty()) {
                return other;
            }
            if (other.isEmpty()) {
                return this;
            }
            return new SignaturesInfo(this.signatures.merge(other.signatures), this.emulatedInterfaceInfo.merge(other.emulatedInterfaceInfo));
        }

        public MethodSignatures emulatedInterfaceSignaturesToForward() {
            return this.emulatedInterfaceInfo.signatures.withoutAll(this.signatures);
        }

        boolean isEmpty() {
            return this.signatures.isEmpty() && this.emulatedInterfaceInfo.isEmpty();
        }

        public SignaturesInfo withSignatures(MethodSignatures additions) {
            if (additions.isEmpty()) {
                return this;
            }
            MethodSignatures newSignatures = this.signatures.merge(additions);
            return new SignaturesInfo(newSignatures, this.emulatedInterfaceInfo);
        }

        public SignaturesInfo withEmulatedInterfaceInfo(EmulatedInterfaceInfo additionalEmulatedInterfaceInfo) {
            if (additionalEmulatedInterfaceInfo.isEmpty()) {
                return this;
            }
            return new SignaturesInfo(this.signatures, this.emulatedInterfaceInfo.merge(additionalEmulatedInterfaceInfo));
        }
    }

    private static class ClassInfo {
        static final ClassInfo EMPTY = new ClassInfo(null, ImmutableList.of(), EmulatedInterfaceInfo.EMPTY);
        final ClassInfo parent;
        final ImmutableList<DexClassAndMethod> forwardedMethodTargets;
        final EmulatedInterfaceInfo emulatedInterfaceInfo;

        ClassInfo(ClassInfo parent, ImmutableList<DexClassAndMethod> forwardedMethodTargets, EmulatedInterfaceInfo emulatedInterfaceInfo) {
            this.parent = parent;
            this.forwardedMethodTargets = forwardedMethodTargets;
            this.emulatedInterfaceInfo = emulatedInterfaceInfo;
        }

        static ClassInfo create(ClassInfo parent, ImmutableList<DexClassAndMethod> forwardedMethodTargets, EmulatedInterfaceInfo emulatedInterfaceInfo) {
            return forwardedMethodTargets.isEmpty() && emulatedInterfaceInfo.isEmpty() ? parent : new ClassInfo(parent, forwardedMethodTargets, emulatedInterfaceInfo);
        }

        public boolean isEmpty() {
            return this == EMPTY;
        }

        boolean isTargetedByForwards(DexClassAndMethod method) {
            return IterableUtils.any(this.forwardedMethodTargets, DexClassAndMember::getDefinition, definition -> definition == method.getDefinition()) || this.parent != null && this.parent.isTargetedByForwards(method);
        }
    }

    private static class MethodSignatures {
        static final MethodSignatures EMPTY = new MethodSignatures(Collections.emptySet());
        final Set<Equivalence.Wrapper<DexMethod>> signatures;

        static MethodSignatures create(Set<Equivalence.Wrapper<DexMethod>> signatures) {
            return signatures.isEmpty() ? EMPTY : new MethodSignatures(signatures);
        }

        MethodSignatures(Set<Equivalence.Wrapper<DexMethod>> signatures) {
            this.signatures = Collections.unmodifiableSet(signatures);
        }

        MethodSignatures merge(MethodSignatures other) {
            if (this.isEmpty()) {
                return other;
            }
            if (other.isEmpty()) {
                return this;
            }
            HashSet<Equivalence.Wrapper<DexMethod>> merged = new HashSet<Equivalence.Wrapper<DexMethod>>(this.signatures);
            merged.addAll(other.signatures);
            return this.signatures.size() == merged.size() ? this : new MethodSignatures(merged);
        }

        boolean isEmpty() {
            return this.signatures.isEmpty();
        }

        public MethodSignatures withoutAll(MethodSignatures other) {
            HashSet<Equivalence.Wrapper<DexMethod>> merged = new HashSet<Equivalence.Wrapper<DexMethod>>(this.signatures);
            merged.removeAll(other.signatures);
            return this.signatures.size() == merged.size() ? this : new MethodSignatures(merged);
        }
    }
}

