/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.itf;

import com.android.tools.r8.com.google.common.collect.Lists;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

final class DefaultMethodsHelper {
    private final Set<DexEncodedMethod> candidates = Sets.newIdentityHashSet();
    private final Set<DexEncodedMethod> hidden = Sets.newIdentityHashSet();

    DefaultMethodsHelper() {
    }

    final void merge(Collection collection) {
        this.candidates.addAll(collection.live);
        this.hidden.addAll(collection.hidden);
    }

    final void hideMatches(DexMethod method) {
        Iterator<DexEncodedMethod> it = this.candidates.iterator();
        while (it.hasNext()) {
            DexEncodedMethod candidate = it.next();
            if (!method.match(candidate)) continue;
            this.hidden.add(candidate);
            it.remove();
        }
    }

    final void addDefaultMethod(DexEncodedMethod encoded) {
        this.candidates.add(encoded);
    }

    final Collection wrapInCollection() {
        this.candidates.removeAll(this.hidden);
        return this.candidates.isEmpty() && this.hidden.isEmpty() ? Collection.EMPTY : new Collection(Lists.newArrayList(this.candidates), Lists.newArrayList(this.hidden));
    }

    static final class Collection {
        static final Collection EMPTY = new Collection(Collections.emptyList(), Collections.emptyList());
        private final List<DexEncodedMethod> live;
        private final List<DexEncodedMethod> hidden;

        private Collection(List<DexEncodedMethod> live, List<DexEncodedMethod> hidden) {
            this.live = live;
            this.hidden = hidden;
        }

        DexMethod getSingleCandidate(DexMethod method) {
            DexMethod candidate = null;
            for (DexEncodedMethod encodedMethod : this.live) {
                DexMethod current = (DexMethod)encodedMethod.getReference();
                if (current.proto != method.proto || current.name != method.name) continue;
                if (candidate != null) {
                    return null;
                }
                candidate = current;
            }
            return candidate;
        }
    }
}

