/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.itf;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.GenericSignature;
import com.android.tools.r8.graph.MethodCollection;
import com.android.tools.r8.utils.IterableUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

public final class EmulatedInterfaceApplicationRewriter {
    private final AppView<?> appView;
    private final Map<DexType, DexType> emulatedInterfaces;

    public EmulatedInterfaceApplicationRewriter(AppView<?> appView) {
        this.appView = appView;
        this.emulatedInterfaces = new IdentityHashMap<DexType, DexType>();
        appView.options().machineDesugaredLibrarySpecification.getEmulatedInterfaces().forEach((ei, descriptor) -> this.emulatedInterfaces.put((DexType)ei, descriptor.getRewrittenType()));
    }

    private DexProgramClass rewriteEmulatedInterface(DexProgramClass emulatedInterface) {
        if (this.appView.isAlreadyLibraryDesugared(emulatedInterface)) {
            return emulatedInterface;
        }
        DexType newType = this.emulatedInterfaces.get(emulatedInterface.type);
        assert (newType != null);
        DexEncodedMethod[] newVirtualMethods = this.renameHolder(emulatedInterface.virtualMethods(), newType);
        DexEncodedMethod[] newDirectMethods = this.renameHolder(emulatedInterface.directMethods(), newType);
        assert (emulatedInterface.getSuperType() == this.appView.dexItemFactory().objectType);
        assert (!emulatedInterface.hasFields());
        assert (emulatedInterface.getNestHost() == null);
        assert (!emulatedInterface.hasNestMemberAttributes());
        assert (!emulatedInterface.hasFields());
        DexProgramClass newEmulatedInterface = new DexProgramClass(newType, emulatedInterface.getOriginKind(), emulatedInterface.getOrigin(), emulatedInterface.getAccessFlags(), this.appView.dexItemFactory().objectType, DexTypeList.empty(), emulatedInterface.getSourceFile(), null, Collections.emptyList(), null, Collections.emptyList(), emulatedInterface.getClassSignature(), emulatedInterface.annotations(), DexEncodedField.EMPTY_ARRAY, DexEncodedField.EMPTY_ARRAY, MethodCollection.MethodCollectionFactory.fromMethods(newDirectMethods, newVirtualMethods), false, emulatedInterface.getChecksumSupplier());
        newEmulatedInterface.addExtraInterfaces(this.getRewrittenInterfacesOfEmulatedInterface(emulatedInterface));
        return newEmulatedInterface;
    }

    private List<GenericSignature.ClassTypeSignature> getRewrittenInterfacesOfEmulatedInterface(DexProgramClass emulatedInterface) {
        ArrayList<GenericSignature.ClassTypeSignature> newInterfaces = new ArrayList<GenericSignature.ClassTypeSignature>();
        GenericSignature.ClassSignature classSignature = emulatedInterface.getClassSignature();
        for (int i = 0; i < emulatedInterface.interfaces.size(); ++i) {
            List<GenericSignature.FieldTypeSignature> typeArguments;
            DexType itf = emulatedInterface.interfaces.values[i];
            if (!this.emulatedInterfaces.containsKey(itf)) continue;
            if (classSignature == null) {
                typeArguments = Collections.emptyList();
            } else {
                GenericSignature.ClassTypeSignature classTypeSignature = classSignature.superInterfaceSignatures().get(i);
                assert (itf == classTypeSignature.type());
                typeArguments = classTypeSignature.typeArguments();
            }
            newInterfaces.add(new GenericSignature.ClassTypeSignature(this.emulatedInterfaces.get(itf), typeArguments));
        }
        return newInterfaces;
    }

    private DexEncodedMethod[] renameHolder(Iterable<DexEncodedMethod> methods, DexType newName) {
        List<DexEncodedMethod> methodArray = IterableUtils.toNewArrayList(methods);
        DexEncodedMethod[] newMethods = new DexEncodedMethod[methodArray.size()];
        for (int i = 0; i < newMethods.length; ++i) {
            newMethods[i] = methodArray.get(i).toRenamedHolderMethod(newName, this.appView.dexItemFactory());
        }
        return newMethods;
    }

    public void rewriteApplication(DexApplication.Builder<?> builder) {
        assert (this.appView.options().isDesugaredLibraryCompilation());
        ArrayList<DexProgramClass> newProgramClasses = new ArrayList<DexProgramClass>();
        for (DexProgramClass clazz : builder.getProgramClasses()) {
            if (this.emulatedInterfaces.containsKey(clazz.type)) {
                newProgramClasses.add(this.rewriteEmulatedInterface(clazz));
                continue;
            }
            newProgramClasses.add(clazz);
        }
        builder.replaceProgramClasses(newProgramClasses);
    }
}

