/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.itf;

import com.android.tools.r8.cf.CfVersion;
import com.android.tools.r8.cf.code.CfInitClass;
import com.android.tools.r8.cf.code.CfReturnVoid;
import com.android.tools.r8.cf.code.CfStackInstruction;
import com.android.tools.r8.cf.code.CfStaticFieldRead;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.ClasspathOrLibraryClass;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexClasspathClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.FieldAccessFlags;
import com.android.tools.r8.graph.GenericSignature;
import com.android.tools.r8.graph.InvalidCode;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.ThrowNullCode;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.DerivedMethod;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.EmulatedDispatchMethodDescriptor;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.EmulatedInterfaceDescriptor;
import com.android.tools.r8.ir.desugar.itf.EmulatedInterfaceSynthesizerEventConsumer;
import com.android.tools.r8.ir.desugar.itf.InterfaceMethodDesugaringBaseEventConsumer;
import com.android.tools.r8.ir.desugar.itf.InterfaceProcessor;
import com.android.tools.r8.synthesis.SyntheticClassBuilder;
import com.android.tools.r8.synthesis.SyntheticItems;
import com.android.tools.r8.synthesis.SyntheticMethodBuilder;
import com.android.tools.r8.synthesis.SyntheticNaming;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.structural.Ordered;
import java.util.Iterator;
import java.util.function.Predicate;

public class InterfaceDesugaringSyntheticHelper {
    public static final CfVersion MAX_INTERFACE_DESUGARED_CF_VERSION = CfVersion.V1_7;
    static final String COMPANION_CLASS_NAME_SUFFIX = "$-CC";
    static final String DEFAULT_METHOD_PREFIX = "$default$";
    static final String PRIVATE_METHOD_PREFIX = "$private$";
    private final AppView<?> appView;
    private final Predicate<DexType> shouldIgnoreFromReportsPredicate;

    public static CfVersion getInterfaceDesugaredCfVersion(CfVersion existing) {
        return Ordered.min(existing, MAX_INTERFACE_DESUGARED_CF_VERSION);
    }

    public InterfaceDesugaringSyntheticHelper(AppView<?> appView) {
        this.appView = appView;
        this.shouldIgnoreFromReportsPredicate = this.getShouldIgnoreFromReportsPredicate(appView);
    }

    public static String getCompanionClassDescriptor(String descriptor) {
        return descriptor.substring(0, descriptor.length() - 1) + COMPANION_CLASS_NAME_SUFFIX + ";";
    }

    public static DexType getCompanionClassType(DexType type, DexItemFactory factory) {
        assert (type.isClassType());
        String descriptor = type.descriptor.toString();
        String ccTypeDescriptor = InterfaceDesugaringSyntheticHelper.getCompanionClassDescriptor(descriptor);
        return factory.createSynthesizedType(ccTypeDescriptor);
    }

    public static boolean isCompanionClassType(DexType type) {
        return type.descriptor.toString().endsWith("$-CC;");
    }

    public static DexType getInterfaceClassType(DexType type, DexItemFactory factory) {
        assert (InterfaceDesugaringSyntheticHelper.isCompanionClassType(type));
        String descriptor = type.descriptor.toString();
        String interfaceTypeDescriptor = descriptor.substring(0, descriptor.length() - 1 - COMPANION_CLASS_NAME_SUFFIX.length()) + ";";
        return factory.createType(interfaceTypeDescriptor);
    }

    private boolean requiresEmulatedDispatch(DexClassAndMethod method) {
        return method.isLibraryMethod() || this.isEmulatedInterface(method.getHolderType()) || this.appView.options().machineDesugaredLibrarySpecification.getEmulatedVirtualRetargetThroughEmulatedInterface().containsKey(method.getReference());
    }

    private DexMethod staticAsMethodOfCompanionClass(DexClassAndMethod method) {
        DexItemFactory dexItemFactory = this.appView.dexItemFactory();
        DexType companionClassType = InterfaceDesugaringSyntheticHelper.getCompanionClassType(method.getHolderType(), dexItemFactory);
        DexMethod rewritten = ((DexMethod)method.getReference()).withHolder(companionClassType, dexItemFactory);
        return rewritten;
    }

    private static DexMethod instanceAsMethodOfCompanionClass(DexMethod method, String prefix, DexItemFactory factory) {
        DexType[] params = method.proto.parameters.values;
        DexType[] newParams = new DexType[params.length + 1];
        newParams[0] = method.holder;
        System.arraycopy(params, 0, newParams, 1, params.length);
        return factory.createMethod(InterfaceDesugaringSyntheticHelper.getCompanionClassType(method.holder, factory), factory.createProto(method.proto.returnType, newParams), factory.createString(prefix + method.name.toString()));
    }

    public static DexMethod defaultAsMethodOfCompanionClass(DexMethod method, DexItemFactory factory) {
        return InterfaceDesugaringSyntheticHelper.instanceAsMethodOfCompanionClass(method, DEFAULT_METHOD_PREFIX, factory);
    }

    static DexMethod privateAsMethodOfCompanionClass(DexMethod method, DexItemFactory factory) {
        return InterfaceDesugaringSyntheticHelper.instanceAsMethodOfCompanionClass(method, PRIVATE_METHOD_PREFIX, factory);
    }

    private static DexClassAndMethod ensureMethodOfClasspathCompanionClassStub(DexMethod companionMethodReference, ClasspathOrLibraryClass context, AppView<?> appView) {
        return appView.getSyntheticItems().ensureFixedClasspathClassMethod(companionMethodReference.getName(), companionMethodReference.getProto(), kinds -> kinds.COMPANION_CLASS, context, appView, classBuilder -> {}, ignored -> {}, methodBuilder -> methodBuilder.setAccessFlags(MethodAccessFlags.createPublicStaticSynthetic()).setCode(ignore -> ThrowNullCode.get()));
    }

    private void ensureCompanionClassInitializesInterface(DexProgramClass iface, InterfaceMethodDesugaringBaseEventConsumer eventConsumer) {
        assert (this.hasStaticMethodThatTriggersNonTrivialClassInitializer(iface));
        InterfaceProcessor.ensureCompanionMethod(iface, this.appView.dexItemFactory().classConstructorMethodName, this.appView.dexItemFactory().createProto(this.appView.dexItemFactory().voidType, new DexType[0]), this.appView, methodBuilder -> this.createCompanionClassInitializer(iface, (SyntheticMethodBuilder)methodBuilder), eventConsumer::acceptCompanionClassClinit);
    }

    private DexEncodedField ensureStaticClinitFieldToTriggerInterfaceInitialization(DexProgramClass iface) {
        DexEncodedField clinitField = this.findExistingStaticClinitFieldToTriggerInterfaceInitialization(iface);
        if (clinitField == null) {
            clinitField = this.createStaticClinitFieldToTriggerInterfaceInitialization(iface);
            iface.appendStaticField(clinitField);
        }
        return clinitField;
    }

    private boolean hasStaticMethodThatTriggersNonTrivialClassInitializer(DexProgramClass iface) {
        return iface.hasClassInitializer() && iface.getMethodCollection().hasDirectMethods(method -> method.isStatic() && !method.isClassInitializer());
    }

    private DexEncodedField findExistingStaticClinitFieldToTriggerInterfaceInitialization(DexProgramClass iface) {
        Iterator<DexEncodedField> iterator2 = iface.staticFields(field -> !field.isPrivate() && !field.getOptimizationInfo().isDead()).iterator();
        if (iterator2.hasNext()) {
            DexEncodedField field2 = iterator2.next();
            return field2;
        }
        return null;
    }

    private DexEncodedField createStaticClinitFieldToTriggerInterfaceInitialization(DexProgramClass iface) {
        DexItemFactory dexItemFactory = this.appView.dexItemFactory();
        DexField clinitFieldReference = dexItemFactory.createFreshFieldNameWithoutHolder(iface.getType(), dexItemFactory.intType, "$desugar$clinit", candidate -> iface.lookupField((DexField)candidate) == null);
        return DexEncodedField.syntheticBuilder().setField(clinitFieldReference).setAccessFlags((FieldAccessFlags)((FieldAccessFlags.Builder)((FieldAccessFlags.Builder)((FieldAccessFlags.Builder)FieldAccessFlags.builder().setPackagePrivate()).setStatic()).setSynthetic()).build()).setStaticValue(DexValue.DexValueInt.DEFAULT).disableAndroidApiLevelCheck().build();
    }

    private void createCompanionClassInitializer(DexProgramClass iface, SyntheticMethodBuilder methodBuilder) {
        methodBuilder.setAccessFlags((MethodAccessFlags)((MethodAccessFlags.Builder)((MethodAccessFlags.Builder)MethodAccessFlags.builder().setConstructor().setPackagePrivate()).setStatic()).build()).setClassFileVersion(InterfaceDesugaringSyntheticHelper.getInterfaceDesugaredCfVersion(iface.getInitialClassFileVersion())).setCode(method -> {
            if (this.appView.canUseInitClass()) {
                return new CfCode(method.holder, 1, 0, ImmutableList.of(new CfInitClass(iface.getType()), new CfStackInstruction(CfStackInstruction.Opcode.Pop), new CfReturnVoid()));
            }
            DexEncodedField clinitField = this.ensureStaticClinitFieldToTriggerInterfaceInitialization(iface);
            boolean isWide = clinitField.getType().isWideType();
            return new CfCode(method.holder, isWide ? 2 : 1, 0, ImmutableList.of(new CfStaticFieldRead((DexField)clinitField.getReference(), (DexField)clinitField.getReference()), isWide ? new CfStackInstruction(CfStackInstruction.Opcode.Pop2) : new CfStackInstruction(CfStackInstruction.Opcode.Pop), new CfReturnVoid()));
        });
    }

    private Predicate<DexType> getShouldIgnoreFromReportsPredicate(AppView<?> appView) {
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        InternalOptions options = appView.options();
        DexString companionClassNameDescriptorSuffix = dexItemFactory.createString("$-CC;");
        return type -> {
            DexString descriptor = type.getDescriptor();
            return appView.typeRewriter.hasRewrittenType((DexType)type, appView) || descriptor.endsWith(companionClassNameDescriptorSuffix) || this.isRewrittenEmulatedInterface((DexType)type) || options.machineDesugaredLibrarySpecification.isCustomConversionRewrittenType((DexType)type) || appView.getDontWarnConfiguration().matches((DexType)type);
        };
    }

    boolean isEmulatedInterface(DexType itf) {
        return this.appView.options().machineDesugaredLibrarySpecification.getEmulatedInterfaces().containsKey(itf);
    }

    boolean isRewrittenEmulatedInterface(DexType itf) {
        return this.appView.options().machineDesugaredLibrarySpecification.isEmulatedInterfaceRewrittenType(itf);
    }

    DexType getEmulatedInterface(DexType type) {
        EmulatedInterfaceDescriptor interfaceDescriptor = this.appView.options().machineDesugaredLibrarySpecification.getEmulatedInterfaces().get(type);
        return interfaceDescriptor == null ? null : interfaceDescriptor.getRewrittenType();
    }

    boolean isInDesugaredLibrary(DexClass clazz) {
        assert (clazz.isLibraryClass() || this.appView.options().isDesugaredLibraryCompilation());
        if (this.isEmulatedInterface(clazz.type)) {
            return true;
        }
        return this.appView.typeRewriter.hasRewrittenType(clazz.type, this.appView);
    }

    final boolean isCompatibleDefaultMethod(DexEncodedMethod method) {
        assert (!method.accessFlags.isConstructor());
        assert (!method.accessFlags.isStatic());
        if (method.accessFlags.isAbstract()) {
            return false;
        }
        if (method.accessFlags.isNative()) {
            throw new Unimplemented("Native default interface methods are not yet supported.");
        }
        if (!method.accessFlags.isPublic()) {
            throw new Unimplemented("Non public default interface methods are not yet supported.");
        }
        return true;
    }

    public boolean verifyKind(DerivedMethod method, SyntheticItems.SyntheticKindSelector kindSelector) {
        SyntheticNaming.SyntheticKind kind = kindSelector.select(this.appView.getSyntheticItems().getNaming());
        assert (method.getHolderKind().equals(kind));
        return true;
    }

    DexMethod emulatedInterfaceDispatchMethod(DerivedMethod method, DexType holder) {
        assert (this.verifyKind(method, kinds -> kinds.EMULATED_INTERFACE_CLASS));
        DexProto newProto = this.appView.dexItemFactory().prependHolderToProto(method.getMethod());
        return this.appView.dexItemFactory().createMethod(holder, newProto, method.getName());
    }

    DexMethod emulatedInterfaceInterfaceMethod(DerivedMethod method) {
        assert (method.getHolderKind() == null);
        return method.getMethod();
    }

    DexType getInterfaceClassType(DexType type) {
        return InterfaceDesugaringSyntheticHelper.getInterfaceClassType(type, this.appView.dexItemFactory());
    }

    DexClasspathClass ensureEmulatedInterfaceMarkerInterface(DexType type) {
        return this.appView.getSyntheticItems().ensureFixedClasspathClassFromType(kinds -> kinds.EMULATED_INTERFACE_MARKER_CLASS, type, this.appView, SyntheticClassBuilder::setInterface, ignored -> {});
    }

    DexClassAndMethod lookupMaximallySpecificIncludingSelf(DexClass initialResolutionHolder, DexClassAndMethod method) {
        assert (method.getHolderType().isClassType());
        if (method.getHolder().isInterface()) {
            return method;
        }
        return this.appView.appInfoForDesugaring().lookupMaximallySpecificMethod(initialResolutionHolder, (DexMethod)method.getReference());
    }

    EmulatedDispatchMethodDescriptor getEmulatedDispatchDescriptor(DexClass initialResolutionHolder, DexClassAndMethod method) {
        if (method == null) {
            return null;
        }
        assert (initialResolutionHolder != null);
        if (!this.requiresEmulatedDispatch(method)) {
            return null;
        }
        DexClassAndMethod maximallySpecificMethod = this.lookupMaximallySpecificIncludingSelf(initialResolutionHolder, method);
        if (maximallySpecificMethod == null) {
            return null;
        }
        return this.appView.options().machineDesugaredLibrarySpecification.getEmulatedInterfaceEmulatedDispatchMethodDescriptor((DexMethod)maximallySpecificMethod.getReference());
    }

    DerivedMethod computeEmulatedInterfaceDispatchMethod(MethodResolutionResult resolutionResult) {
        EmulatedDispatchMethodDescriptor descriptor = this.getEmulatedDispatchDescriptor(resolutionResult.getInitialResolutionHolder(), resolutionResult.getResolutionPair());
        return descriptor == null ? null : descriptor.getEmulatedDispatchMethod();
    }

    DerivedMethod computeEmulatedInterfaceForwardingMethod(DexClass initialResolutionHolder, DexClassAndMethod method) {
        if (method == null) {
            return null;
        }
        DexMethod retarget = this.appView.options().machineDesugaredLibrarySpecification.getEmulatedVirtualRetargetThroughEmulatedInterface().get(method.getReference());
        if (retarget != null) {
            return new DerivedMethod(retarget);
        }
        EmulatedDispatchMethodDescriptor descriptor = this.getEmulatedDispatchDescriptor(initialResolutionHolder, method);
        return descriptor == null ? null : descriptor.getForwardingMethod();
    }

    DexMethod ensureEmulatedInterfaceForwardingMethod(DerivedMethod method) {
        if (method.getHolderKind() == null) {
            return method.getMethod();
        }
        assert (this.verifyKind(method, kinds -> kinds.COMPANION_CLASS));
        DexClassAndMethod resolvedMethod = this.appView.appInfoForDesugaring().resolveMethod(method.getMethod(), true).getResolutionPair();
        return (DexMethod)this.ensureDefaultAsMethodOfCompanionClassStub(resolvedMethod).getReference();
    }

    DexClassAndMethod ensureEmulatedInterfaceDispatchMethod(DerivedMethod emulatedDispatchMethod, EmulatedInterfaceSynthesizerEventConsumer.ClasspathEmulatedInterfaceSynthesizerEventConsumer eventConsumer) {
        assert (this.verifyKind(emulatedDispatchMethod, kinds -> kinds.EMULATED_INTERFACE_CLASS));
        DexClassAndMethod method = this.appView.appInfoForDesugaring().resolveMethod(emulatedDispatchMethod.getMethod(), true).getResolutionPair();
        assert (this.verifyKind(emulatedDispatchMethod, kinds -> kinds.EMULATED_INTERFACE_CLASS));
        if (method.isProgramMethod()) {
            assert (this.appView.options().isDesugaredLibraryCompilation());
            DexProgramClass emulatedInterface = this.appView.getSyntheticItems().getExistingFixedClass(kinds -> kinds.EMULATED_INTERFACE_CLASS, method.asProgramMethod().getHolder(), this.appView);
            DexMethod emulatedInterfaceMethod = this.emulatedInterfaceDispatchMethod(emulatedDispatchMethod, emulatedInterface.type);
            assert (emulatedInterface.lookupProgramMethod(emulatedInterfaceMethod) != null);
            return emulatedInterface.lookupProgramMethod(emulatedInterfaceMethod);
        }
        DexMethod emulatedInterfaceMethod = this.emulatedInterfaceDispatchMethod(emulatedDispatchMethod, this.appView.dexItemFactory().objectType);
        return this.appView.getSyntheticItems().ensureFixedClasspathClassMethod(emulatedInterfaceMethod.getName(), emulatedInterfaceMethod.getProto(), kinds -> kinds.EMULATED_INTERFACE_CLASS, method.getHolder().asClasspathOrLibraryClass(), this.appView, classBuilder -> {}, eventConsumer::acceptClasspathEmulatedInterface, methodBuilder -> methodBuilder.setAccessFlags(MethodAccessFlags.createPublicStaticSynthetic()).setCode(ignore -> ThrowNullCode.get()));
    }

    DexClassAndMethod ensureDefaultAsMethodOfCompanionClassStub(DexClassAndMethod method) {
        if (method.isProgramMethod()) {
            return this.ensureDefaultAsMethodOfProgramCompanionClassStub(method.asProgramMethod());
        }
        ClasspathOrLibraryClass context = method.getHolder().asClasspathOrLibraryClass();
        DexMethod companionMethodReference = InterfaceDesugaringSyntheticHelper.defaultAsMethodOfCompanionClass((DexMethod)method.getReference(), this.appView.dexItemFactory());
        return InterfaceDesugaringSyntheticHelper.ensureMethodOfClasspathCompanionClassStub(companionMethodReference, context, this.appView);
    }

    DexClassAndMethod ensureStaticAsMethodOfCompanionClassStub(DexClassAndMethod method, CfInstructionDesugaringEventConsumer eventConsumer) {
        if (method.isProgramMethod()) {
            return this.ensureStaticAsMethodOfProgramCompanionClassStub(method.asProgramMethod(), eventConsumer);
        }
        ClasspathOrLibraryClass context = method.getHolder().asClasspathOrLibraryClass();
        DexMethod companionMethodReference = this.staticAsMethodOfCompanionClass(method);
        return InterfaceDesugaringSyntheticHelper.ensureMethodOfClasspathCompanionClassStub(companionMethodReference, context, this.appView);
    }

    ProgramMethod ensureDefaultAsMethodOfProgramCompanionClassStub(ProgramMethod method) {
        DexEncodedMethod virtual = (DexEncodedMethod)method.getDefinition();
        DexMethod companionMethod = InterfaceDesugaringSyntheticHelper.defaultAsMethodOfCompanionClass((DexMethod)method.getReference(), this.appView.dexItemFactory());
        return InterfaceProcessor.ensureCompanionMethod(method.getHolder(), companionMethod.getName(), companionMethod.getProto(), this.appView, methodBuilder -> {
            MethodAccessFlags newFlags = method.getAccessFlags().copy();
            newFlags.promoteToStatic();
            methodBuilder.setAccessFlags(newFlags).setGenericSignature(GenericSignature.MethodTypeSignature.noSignature()).disableAndroidApiLevelCheck().setAnnotations(virtual.annotations().methodParametersWithFakeThisArguments(this.appView.dexItemFactory())).setParameterAnnotationsList(virtual.getParameterAnnotations().withFakeThisParameter()).setCode(ignored -> InvalidCode.getInstance());
        }, ignored -> {});
    }

    ProgramMethod ensurePrivateAsMethodOfProgramCompanionClassStub(ProgramMethod method) {
        DexMethod companionMethod = InterfaceDesugaringSyntheticHelper.privateAsMethodOfCompanionClass((DexMethod)method.getReference(), this.appView.dexItemFactory());
        DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
        return InterfaceProcessor.ensureCompanionMethod(method.getHolder(), companionMethod.getName(), companionMethod.getProto(), this.appView, methodBuilder -> {
            MethodAccessFlags newFlags = definition.getAccessFlags().copy();
            assert (newFlags.isPrivate());
            newFlags.promoteToPublic();
            newFlags.promoteToStatic();
            methodBuilder.setAccessFlags(newFlags).setGenericSignature(definition.getGenericSignature()).setAnnotations(definition.annotations()).disableAndroidApiLevelCheck().setParameterAnnotationsList(definition.getParameterAnnotations()).setCode(ignored -> InvalidCode.getInstance());
        }, ignored -> {});
    }

    DexMethod privateAsMethodOfCompanionClass(DexClassAndMethod method) {
        return InterfaceDesugaringSyntheticHelper.privateAsMethodOfCompanionClass((DexMethod)method.getReference(), this.appView.dexItemFactory());
    }

    ProgramMethod ensureStaticAsMethodOfProgramCompanionClassStub(ProgramMethod method, InterfaceMethodDesugaringBaseEventConsumer eventConsumer) {
        assert (!((DexEncodedMethod)method.getDefinition()).isClassInitializer());
        if (method.getHolder().hasClassInitializer()) {
            this.ensureCompanionClassInitializesInterface(method.getHolder(), eventConsumer);
        }
        DexMethod companionMethodReference = this.staticAsMethodOfCompanionClass(method);
        DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
        return InterfaceProcessor.ensureCompanionMethod(method.getHolder(), companionMethodReference.getName(), companionMethodReference.getProto(), this.appView, methodBuilder -> {
            MethodAccessFlags newFlags = definition.getAccessFlags().copy();
            newFlags.promoteToPublic();
            methodBuilder.setAccessFlags(newFlags).setGenericSignature(definition.getGenericSignature()).setAnnotations(definition.annotations()).setParameterAnnotationsList(definition.getParameterAnnotations()).disableAndroidApiLevelCheck().setCode(ignored -> InvalidCode.getInstance());
        }, companion -> eventConsumer.acceptCompanionMethod(method, (ProgramMethod)companion));
    }

    public ProgramMethod ensureMethodOfProgramCompanionClassStub(ProgramMethod method, InterfaceMethodDesugaringBaseEventConsumer eventConsumer) {
        DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
        assert (method.getHolder().isInterface());
        assert (definition.isNonAbstractNonNativeMethod());
        assert (definition.getCode() != null);
        assert (!InvalidCode.isInvalidCode(definition.getCode()));
        if (definition.isStatic()) {
            return this.ensureStaticAsMethodOfProgramCompanionClassStub(method, eventConsumer);
        }
        if (definition.isPrivate()) {
            return this.ensurePrivateAsMethodOfProgramCompanionClassStub(method);
        }
        return this.ensureDefaultAsMethodOfProgramCompanionClassStub(method);
    }

    boolean shouldIgnoreFromReports(DexType missing) {
        return this.shouldIgnoreFromReportsPredicate.test(missing);
    }

    public void warnMissingInterface(DexClass classToDesugar, DexClass implementing, DexType missing) {
        if (this.shouldIgnoreFromReports(missing)) {
            return;
        }
        this.appView.options().warningMissingInterfaceForDesugar(classToDesugar, implementing, missing);
    }
}

