/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.itf;

import com.android.tools.r8.DesugarGraphConsumer;
import com.android.tools.r8.cf.CfVersion;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unimplemented;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaring;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringCollection;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.DesugarDescription;
import com.android.tools.r8.ir.desugar.FreshLocalProvider;
import com.android.tools.r8.ir.desugar.LocalStackAllocator;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.DerivedMethod;
import com.android.tools.r8.ir.desugar.desugaredlibrary.machinespecification.MachineDesugaredLibrarySpecification;
import com.android.tools.r8.ir.desugar.icce.AlwaysThrowingInstructionDesugaring;
import com.android.tools.r8.ir.desugar.itf.DefaultMethodsHelper;
import com.android.tools.r8.ir.desugar.itf.InterfaceDesugaringSyntheticHelper;
import com.android.tools.r8.ir.desugar.itf.InterfaceMethodDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.itf.InterfaceMethodProcessorFacade;
import com.android.tools.r8.ir.desugar.itf.InterfaceProcessor;
import com.android.tools.r8.ir.desugar.lambda.LambdaInstructionDesugaring;
import com.android.tools.r8.ir.desugar.stringconcat.StringConcatInstructionDesugaring;
import com.android.tools.r8.ir.synthetic.ForwardMethodBuilder;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.position.MethodPosition;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import com.android.tools.r8.utils.structural.Ordered;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;

public final class InterfaceMethodRewriter
implements CfInstructionDesugaring {
    private final AppView<?> appView;
    private final InternalOptions options;
    final DexItemFactory factory;
    private final InterfaceDesugaringSyntheticHelper helper;
    private final Set<DexString> emulatedMethods = Sets.newIdentityHashSet();
    private final ProgramMethodSet synthesizedMethods = ProgramMethodSet.createConcurrent();
    private final Map<DexType, DefaultMethodsHelper.Collection> cache = new ConcurrentHashMap<DexType, DefaultMethodsHelper.Collection>();
    private final Set<CfInstructionDesugaring> precedingDesugarings;

    public InterfaceMethodRewriter(AppView<?> appView, Set<CfInstructionDesugaring> precedingDesugarings) {
        this.appView = appView;
        this.precedingDesugarings = precedingDesugarings;
        this.options = appView.options();
        this.factory = appView.dexItemFactory();
        this.helper = new InterfaceDesugaringSyntheticHelper(appView);
        this.initializeEmulatedInterfaceVariables();
    }

    public static void checkForAssumedLibraryTypes(AppInfo appInfo, InternalOptions options) {
        MachineDesugaredLibrarySpecification machineDesugaredLibrarySpecification = options.machineDesugaredLibrarySpecification;
        machineDesugaredLibrarySpecification.getEmulatedInterfaces().forEach((ei, descriptor) -> {
            InterfaceMethodRewriter.registerType(appInfo, ei);
            InterfaceMethodRewriter.registerType(appInfo, descriptor.getRewrittenType());
        });
        machineDesugaredLibrarySpecification.getCustomConversions().forEach((type, descriptor) -> {
            InterfaceMethodRewriter.registerType(appInfo, type);
            InterfaceMethodRewriter.registerType(appInfo, descriptor.getTo().getHolderType());
            InterfaceMethodRewriter.registerType(appInfo, descriptor.getFrom().getHolderType());
        });
    }

    private static void registerType(AppInfo appInfo, DexType type) {
        appInfo.dexItemFactory().registerTypeNeededForDesugaring(type);
        DexClass clazz = appInfo.definitionFor(type);
        if (clazz != null && clazz.isLibraryClass() && clazz.isInterface()) {
            clazz.forEachMethod(m3 -> {
                if (m3.isDefaultMethod()) {
                    appInfo.dexItemFactory().registerTypeNeededForDesugaring(((DexMethod)m3.getReference()).proto.returnType);
                    for (DexType param : ((DexMethod)m3.getReference()).proto.parameters.values) {
                        appInfo.dexItemFactory().registerTypeNeededForDesugaring(param);
                    }
                }
            });
        }
    }

    private void initializeEmulatedInterfaceVariables() {
        Set<DexType> emulateLibraryInterface = this.options.machineDesugaredLibrarySpecification.getEmulatedInterfaces().keySet();
        for (DexType interfaceType : emulateLibraryInterface) {
            DexClass emulatedInterfaceClass = this.appView.definitionFor(interfaceType);
            if (emulatedInterfaceClass == null) continue;
            for (DexEncodedMethod encodedMethod : emulatedInterfaceClass.methods(DexEncodedMethod::isDefaultMethod)) {
                this.emulatedMethods.add(((DexMethod)encodedMethod.getReference()).name);
            }
        }
    }

    private boolean isAlreadyDesugared(CfInvoke invoke, ProgramMethod context) {
        return Iterables.any(this.precedingDesugarings, desugaring -> desugaring.needsDesugaring(invoke, context));
    }

    private DesugarDescription computeDescription(CfInstruction instruction, ProgramMethod context) {
        CfInvoke invoke = instruction.asInvoke();
        if (invoke == null) {
            return DesugarDescription.nothing();
        }
        if (this.isAlreadyDesugared(invoke, context)) {
            return DesugarDescription.nothing();
        }
        if (invoke.isInvokeSpecial() && invoke.isInvokeConstructor(this.factory)) {
            return DesugarDescription.nothing();
        }
        if (!invoke.isInterface()) {
            return this.computeNonInterfaceInvoke(invoke, context);
        }
        DexClass holder = this.appView.definitionForHolder(invoke.getMethod(), context);
        if (holder == null) {
            if (invoke.isInvokeVirtual() || invoke.isInvokeInterface()) {
                return DesugarDescription.nothing();
            }
            return DesugarDescription.builder().addScanEffect(() -> {
                if (invoke.isInvokeStatic()) {
                    this.leavingStaticInvokeToInterface(context);
                }
                this.warnMissingType(context, invoke.getMethod().getHolderType());
            }).build();
        }
        if (invoke.isInvokeStatic()) {
            return this.computeInvokeStatic(holder, invoke, context);
        }
        if (invoke.isInvokeSpecial()) {
            return this.computeInvokeSpecial(holder, invoke, context);
        }
        if (invoke.isInvokeVirtual() || invoke.isInvokeInterface()) {
            return this.computeInvokeVirtualDispatch(holder, invoke, context);
        }
        return DesugarDescription.nothing();
    }

    private DesugarDescription computeNonInterfaceInvoke(CfInvoke invoke, ProgramMethod context) {
        assert (!invoke.isInterface());
        if (invoke.isInvokeSpecial()) {
            DexClass clazz = this.appView.definitionForHolder(invoke.getMethod(), context);
            if (clazz == null) {
                return DesugarDescription.nothing();
            }
            return this.computeEmulatedInterfaceInvokeSpecial(clazz, invoke.getMethod(), context);
        }
        if (!invoke.isInvokeVirtual() && !invoke.isInvokeInterface()) {
            return DesugarDescription.nothing();
        }
        DesugarDescription description = this.computeEmulatedInterfaceVirtualDispatchOrNull(invoke);
        if (description != null) {
            return description;
        }
        AppInfoWithClassHierarchy appInfo = this.appView.appInfoForDesugaring();
        MethodResolutionResult resolution = appInfo.resolveMethod(invoke.getMethod(), invoke.isInterface());
        if (!resolution.isSingleResolution() || !resolution.asSingleResolution().getResolvedMethod().isStatic()) {
            return DesugarDescription.nothing();
        }
        DexClass holder = appInfo.definitionFor(invoke.getMethod().getHolderType(), context);
        DexClassAndMethod target = appInfo.lookupMaximallySpecificMethod(holder, invoke.getMethod());
        if (target != null && target.isDefaultMethod()) {
            return this.computeInvokeAsThrowRewrite(invoke, resolution.asSingleResolution(), context);
        }
        return DesugarDescription.nothing();
    }

    private DesugarDescription computeInvokeSpecial(DexClass holder, CfInvoke invoke, ProgramMethod context) {
        if (invoke.isInvokeSuper(context.getHolderType())) {
            return this.rewriteInvokeSuper(invoke, context);
        }
        return this.computeInvokeDirect(holder, invoke, context);
    }

    private DesugarDescription computeInvokeStatic(DexClass holder, CfInvoke invoke, ProgramMethod context) {
        if (!holder.isInterface()) {
            return DesugarDescription.builder().addScanEffect(() -> this.leavingStaticInvokeToInterface(context)).build();
        }
        if (this.appView.getSyntheticItems().isPendingSynthetic(invoke.getMethod().getHolderType())) {
            return DesugarDescription.nothing();
        }
        if (this.isNonDesugaredLibraryClass(holder)) {
            if (this.options.canLeaveStaticInterfaceMethodInvokes()) {
                return DesugarDescription.builder().addScanEffect(() -> this.leavingStaticInvokeToInterface(context)).build();
            }
            if (this.synthesizedMethods.contains(context)) {
                return DesugarDescription.nothing();
            }
            return DesugarDescription.builder().setDesugarRewrite((freshLocalProvider, localStackAllocator, eventConsumer, context1, methodProcessingContext, dexItemFactory) -> {
                ProgramMethod newProgramMethod = this.appView.getSyntheticItems().createMethod(kind -> kind.STATIC_INTERFACE_CALL, methodProcessingContext.createUniqueContext(), this.appView, syntheticMethodBuilder -> syntheticMethodBuilder.setProto(invoke.getMethod().getProto()).setAccessFlags(MethodAccessFlags.createPublicStaticSynthetic()).setCode(m3 -> ForwardMethodBuilder.builder(this.factory).setStaticTarget(invoke.getMethod(), true).setStaticSource(m3).build()));
                this.synthesizedMethods.add(newProgramMethod);
                eventConsumer.acceptInvokeStaticInterfaceOutliningMethod(newProgramMethod, context1);
                this.leavingStaticInvokeToInterface(newProgramMethod);
                return this.getInvokeStaticInstructions((DexMethod)newProgramMethod.getReference());
            }).build();
        }
        MethodResolutionResult.SingleResolutionResult resolutionResult = this.appView.appInfoForDesugaring().resolveMethodOnInterface(holder, invoke.getMethod()).asSingleResolution();
        if (holder.isInterface() && this.shouldRewriteToInvokeToThrow(resolutionResult, true)) {
            return this.computeInvokeAsThrowRewrite(invoke, resolutionResult, context);
        }
        assert (resolutionResult != null);
        assert (resolutionResult.getResolvedMethod().isStatic());
        DexClassAndMethod method = resolutionResult.getResolutionPair();
        return DesugarDescription.builder().setDesugarRewrite((freshLocalProvider, localStackAllocator, eventConsumer, context12, methodProcessingContext, dexItemFactory) -> {
            DexClassAndMethod companionMethod = this.helper.ensureStaticAsMethodOfCompanionClassStub(method, eventConsumer);
            return this.getInvokeStaticInstructions((DexMethod)companionMethod.getReference());
        }).build();
    }

    private DesugarDescription computeInvokeVirtualDispatch(DexClass holder, CfInvoke invoke, ProgramMethod context) {
        AppInfoWithClassHierarchy appInfoForDesugaring = this.appView.appInfoForDesugaring();
        MethodResolutionResult.SingleResolutionResult resolution = appInfoForDesugaring.resolveMethod(invoke.getMethod(), invoke.isInterface()).asSingleResolution();
        if (resolution != null && resolution.getResolvedMethod().isPrivate() && resolution.isAccessibleFrom((ProgramDefinition)context, appInfoForDesugaring).isTrue()) {
            return this.computeInvokeDirect(holder, invoke, context);
        }
        if (resolution != null && resolution.getResolvedMethod().isStatic()) {
            return this.computeInvokeAsThrowRewrite(invoke, resolution, context);
        }
        DesugarDescription description = this.computeEmulatedInterfaceVirtualDispatchOrNull(invoke);
        return description != null ? description : DesugarDescription.nothing();
    }

    private DesugarDescription computeEmulatedInterfaceVirtualDispatchOrNull(CfInvoke invoke) {
        MethodResolutionResult resolutionResult = this.appView.appInfoForDesugaring().resolveMethod(invoke.getMethod(), invoke.isInterface());
        DerivedMethod emulatedDispatchMethod = this.helper.computeEmulatedInterfaceDispatchMethod(resolutionResult);
        if (emulatedDispatchMethod == null) {
            return null;
        }
        return DesugarDescription.builder().setDesugarRewrite((freshLocalProvider, localStackAllocator, eventConsumer, context1, methodProcessingContext, dexItemFactory) -> this.getInvokeStaticInstructions((DexMethod)this.helper.ensureEmulatedInterfaceDispatchMethod(emulatedDispatchMethod, eventConsumer).getReference())).build();
    }

    private DesugarDescription computeInvokeDirect(DexClass clazz, CfInvoke invoke, ProgramMethod context) {
        DexMethod invokedMethod = invoke.getMethod();
        if (!clazz.isInterface()) {
            return DesugarDescription.nothing();
        }
        if (clazz.isLibraryClass()) {
            throw new CompilationError("Unexpected call to a private method defined in library class " + clazz.toSourceString(), this.getMethodOrigin((DexMethod)context.getReference()));
        }
        MethodResolutionResult resolution = this.appView.appInfoForDesugaring().resolveMethod(invokedMethod, invoke.isInterface());
        if (resolution.isFailedResolution()) {
            return this.computeInvokeAsThrowRewrite(invoke, null, context);
        }
        MethodResolutionResult.SingleResolutionResult singleResolution = resolution.asSingleResolution();
        if (singleResolution == null) {
            return DesugarDescription.nothing();
        }
        DexClassAndMethod directTarget = clazz.lookupClassMethod(invokedMethod);
        if (directTarget != null) {
            assert (directTarget.getDefinition() == singleResolution.getResolutionPair().getDefinition());
            return DesugarDescription.builder().setDesugarRewrite((freshLocalProvider, localStackAllocator, eventConsumer, context1, methodProcessingContext, dexItemFactory) -> {
                DexMethod companionMethod;
                DexClassAndMethod companionMethodDefinition = null;
                if (((DexEncodedMethod)directTarget.getDefinition()).isPrivateMethod()) {
                    if (directTarget.isProgramMethod()) {
                        companionMethodDefinition = this.helper.ensurePrivateAsMethodOfProgramCompanionClassStub(directTarget.asProgramMethod());
                        companionMethod = (DexMethod)companionMethodDefinition.getReference();
                    } else {
                        companionMethod = this.helper.privateAsMethodOfCompanionClass(directTarget);
                    }
                } else {
                    companionMethodDefinition = this.helper.ensureDefaultAsMethodOfCompanionClassStub(directTarget);
                    companionMethod = (DexMethod)companionMethodDefinition.getReference();
                }
                if (companionMethodDefinition != null) {
                    this.acceptCompanionMethod(directTarget, companionMethodDefinition, eventConsumer);
                }
                return this.getInvokeStaticInstructions(companionMethod);
            }).build();
        }
        DexClassAndMethod virtualTarget = this.appView.appInfoForDesugaring().lookupMaximallySpecificMethod(clazz, invokedMethod);
        if (virtualTarget != null) {
            assert (virtualTarget.getDefinition() == singleResolution.getResolutionPair().getDefinition());
            return DesugarDescription.builder().setDesugarRewrite((freshLocalProvider, localStackAllocator, eventConsumer, context12, methodProcessingContext, dexItemFactory) -> {
                DexClassAndMethod companionMethod = this.helper.ensureDefaultAsMethodOfCompanionClassStub(virtualTarget);
                this.acceptCompanionMethod(virtualTarget, companionMethod, eventConsumer);
                return this.getInvokeStaticInstructions((DexMethod)companionMethod.getReference());
            }).build();
        }
        assert (false);
        return DesugarDescription.nothing();
    }

    private DesugarDescription computeInvokeAsThrowRewrite(CfInvoke invoke, MethodResolutionResult.SingleResolutionResult resolution, ProgramMethod context) {
        assert (!this.isAlreadyDesugared(invoke, context));
        return AlwaysThrowingInstructionDesugaring.computeInvokeAsThrowRewrite(this.appView, invoke, resolution);
    }

    private Collection<CfInstruction> getInvokeStaticInstructions(DexMethod newTarget) {
        return Collections.singletonList(new CfInvoke(184, newTarget, false));
    }

    private void leavingStaticInvokeToInterface(ProgramMethod method) {
        if (method.getHolder().hasClassFileVersion()) {
            ((DexEncodedMethod)method.getDefinition()).upgradeClassFileVersion(Ordered.min(CfVersion.V1_8, method.getHolder().getInitialClassFileVersion()));
        } else {
            ((DexEncodedMethod)method.getDefinition()).upgradeClassFileVersion(CfVersion.V1_8);
        }
    }

    private boolean isSyntheticMethodThatShouldNotBeDoubleProcessed(ProgramMethod method) {
        return this.appView.getSyntheticItems().isSyntheticMethodThatShouldNotBeDoubleProcessed(method);
    }

    private void reportInterfaceMethodHandleCallSite(DexCallSite callSite, ProgramMethod context) {
        this.reportStaticInterfaceMethodHandle(context, callSite.bootstrapMethod);
        for (DexValue arg : callSite.bootstrapArgs) {
            if (!arg.isDexValueMethodHandle()) continue;
            this.reportStaticInterfaceMethodHandle(context, (DexMethodHandle)arg.asDexValueMethodHandle().value);
        }
    }

    private void acceptCompanionMethod(DexClassAndMethod method, DexClassAndMethod companion, InterfaceMethodDesugaringEventConsumer eventConsumer) {
        assert (method.isProgramMethod() == companion.isProgramMethod());
        if (method.isProgramMethod()) {
            eventConsumer.acceptCompanionMethod(method.asProgramMethod(), companion.asProgramMethod());
        }
    }

    private DesugarDescription rewriteInvokeSuper(CfInvoke invoke, ProgramMethod context) {
        DexMethod invokedMethod = invoke.getMethod();
        DexClass clazz = this.appView.definitionFor(invokedMethod.holder, context);
        if (clazz == null) {
            return DesugarDescription.builder().addScanEffect(() -> this.warnMissingType(context, invokedMethod.holder)).build();
        }
        MethodResolutionResult.SingleResolutionResult resolutionResult = this.appView.appInfoForDesugaring().resolveMethodOn(clazz, invokedMethod).asSingleResolution();
        if (clazz.isInterface() && this.shouldRewriteToInvokeToThrow(resolutionResult, false)) {
            return this.computeInvokeAsThrowRewrite(invoke, resolutionResult, context);
        }
        if (clazz.isInterface() && !clazz.isLibraryClass()) {
            if (resolutionResult.getResolvedMethod().isPrivateMethod()) {
                if (resolutionResult.isAccessibleFrom((ProgramDefinition)context, this.appView.appInfoForDesugaring()).isFalse()) {
                    return this.computeInvokeAsThrowRewrite(invoke, null, context);
                }
                return DesugarDescription.builder().setDesugarRewrite((freshLocalProvider, localStackAllocator, eventConsumer, context1, methodProcessingContext, dexItemFactory) -> {
                    DexMethod companionMethod;
                    DexClassAndMethod method = resolutionResult.getResolutionPair();
                    if (method.isProgramMethod()) {
                        ProgramMethod companionMethodDefinition = this.helper.ensurePrivateAsMethodOfProgramCompanionClassStub(method.asProgramMethod());
                        companionMethod = (DexMethod)companionMethodDefinition.getReference();
                        eventConsumer.acceptCompanionMethod(method.asProgramMethod(), companionMethodDefinition);
                    } else {
                        companionMethod = this.helper.privateAsMethodOfCompanionClass(method);
                    }
                    return this.getInvokeStaticInstructions(companionMethod);
                }).build();
            }
            return DesugarDescription.builder().setDesugarRewrite((freshLocalProvider, localStackAllocator, eventConsumer, context12, methodProcessingContext, dexItemFactory) -> {
                DexClassAndMethod method = resolutionResult.getResolutionPair();
                DexMethod amendedMethod = this.amendDefaultMethod(context12.getHolder(), invokedMethod);
                assert (method.getReference() == amendedMethod);
                DexClassAndMethod companionMethod = this.helper.ensureDefaultAsMethodOfCompanionClassStub(method);
                this.acceptCompanionMethod(method, companionMethod, eventConsumer);
                return this.getInvokeStaticInstructions((DexMethod)companionMethod.getReference());
            }).build();
        }
        return this.computeEmulatedInterfaceInvokeSpecial(clazz, invokedMethod, context);
    }

    private DesugarDescription computeEmulatedInterfaceInvokeSpecial(DexClass clazz, DexMethod invokedMethod, ProgramMethod context) {
        DexClass holder;
        DexClassAndMethod superTarget = this.appView.appInfoForDesugaring().lookupSuperTarget(invokedMethod, context);
        if (clazz.isInterface() && this.appView.typeRewriter.hasRewrittenType(clazz.type, this.appView) && superTarget != null && ((DexEncodedMethod)superTarget.getDefinition()).isDefaultMethod() && (holder = superTarget.getHolder()).isLibraryClass() && holder.isInterface()) {
            return DesugarDescription.builder().setDesugarRewrite((freshLocalProvider, localStackAllocator, eventConsumer, context13, methodProcessingContext, dexItemFactory) -> {
                DexClassAndMethod companionTarget = this.helper.ensureDefaultAsMethodOfCompanionClassStub(superTarget);
                this.acceptCompanionMethod(superTarget, companionTarget, eventConsumer);
                return this.getInvokeStaticInstructions((DexMethod)companionTarget.getReference());
            }).build();
        }
        DerivedMethod forwardingMethod = this.helper.computeEmulatedInterfaceForwardingMethod(clazz, superTarget);
        if (forwardingMethod == null) {
            return DesugarDescription.nothing();
        }
        return DesugarDescription.builder().setDesugarRewrite((freshLocalProvider, localStackAllocator, eventConsumer, context14, methodProcessingContext, dexItemFactory) -> this.getInvokeStaticInstructions(this.helper.ensureEmulatedInterfaceForwardingMethod(forwardingMethod))).build();
    }

    private boolean shouldRewriteToInvokeToThrow(MethodResolutionResult.SingleResolutionResult resolutionResult, boolean isInvokeStatic) {
        return resolutionResult == null || resolutionResult.getResolvedMethod().isStatic() != isInvokeStatic;
    }

    private boolean isNonDesugaredLibraryClass(DexClass clazz) {
        return clazz.isLibraryClass() && !this.helper.isInDesugaredLibrary(clazz);
    }

    private void reportStaticInterfaceMethodHandle(ProgramMethod context, DexMethodHandle handle) {
        if (handle.type.isInvokeStatic()) {
            DexClass holderClass = this.appView.definitionFor(handle.asMethod().holder);
            if (holderClass == null) {
                this.warnMissingType(context, handle.asMethod().holder);
            } else if (holderClass.isInterface()) {
                throw new Unimplemented("Desugaring of static interface method handle in `" + context.toSourceString() + "` is not yet supported.");
            }
        }
    }

    private DexMethod amendDefaultMethod(DexClass classToDesugar, DexMethod method) {
        DexMethod singleCandidate = this.getOrCreateInterfaceInfo(classToDesugar, classToDesugar, method.holder).getSingleCandidate(method);
        return singleCandidate != null ? singleCandidate : method;
    }

    private Origin getMethodOrigin(DexMethod method) {
        DexClass clazz;
        DexType holder = method.holder;
        if (InterfaceDesugaringSyntheticHelper.isCompanionClassType(holder)) {
            holder = this.helper.getInterfaceClassType(holder);
        }
        return (clazz = this.appView.definitionFor(holder)) == null ? Origin.unknown() : clazz.getOrigin();
    }

    private DefaultMethodsHelper.Collection createInterfaceInfo(DexClass classToDesugar, DexClass implementing, DexType iface) {
        DefaultMethodsHelper helper = new DefaultMethodsHelper();
        DexClass definedInterface = this.appView.definitionFor(iface);
        if (definedInterface == null) {
            this.helper.warnMissingInterface(classToDesugar, implementing, iface);
            return helper.wrapInCollection();
        }
        if (!definedInterface.isInterface()) {
            throw new CompilationError("Type " + iface.toSourceString() + " is referenced as an interface from `" + implementing.toString() + "`.");
        }
        if (this.isNonDesugaredLibraryClass(definedInterface)) {
            return helper.wrapInCollection();
        }
        if (implementing.isProgramClass() && !definedInterface.isLibraryClass()) {
            InterfaceMethodRewriter.reportDependencyEdge(implementing.asProgramClass(), definedInterface, this.appView.appInfo());
        }
        for (DexType superinterface : definedInterface.interfaces.values) {
            helper.merge(this.getOrCreateInterfaceInfo(classToDesugar, definedInterface, superinterface));
        }
        for (DexEncodedMethod virtual : definedInterface.virtualMethods()) {
            helper.hideMatches((DexMethod)virtual.getReference());
        }
        for (DexEncodedMethod encoded : definedInterface.virtualMethods()) {
            if (!this.helper.isCompatibleDefaultMethod(encoded)) continue;
            helper.addDefaultMethod(encoded);
        }
        return helper.wrapInCollection();
    }

    private void warnMissingType(ProgramMethod context, DexType missing) {
        if (this.helper.shouldIgnoreFromReports(missing)) {
            return;
        }
        DexMethod method = this.appView.graphLens().getOriginalMethodSignature((DexMethod)context.getReference());
        Origin origin = this.getMethodOrigin(method);
        MethodPosition position = new MethodPosition(method.asMethodReference());
        this.options.warningMissingTypeForDesugar(origin, position, missing, method);
    }

    public static void reportDependencyEdge(DexClass dependent, DexClass dependency, AppInfo appInfo) {
        assert (!dependent.isLibraryClass());
        assert (!dependency.isLibraryClass());
        DesugarGraphConsumer consumer = appInfo.app().options.desugarGraphConsumer;
        if (consumer != null) {
            Origin dependencyOrigin = dependency.getOrigin();
            Collection<DexType> dependents = appInfo.getSyntheticItems().getSynthesizingContextTypes(dependent.getType());
            if (dependents.isEmpty()) {
                InterfaceMethodRewriter.reportDependencyEdge(consumer, dependencyOrigin, dependent);
            } else {
                for (DexType type : dependents) {
                    InterfaceMethodRewriter.reportDependencyEdge(consumer, dependencyOrigin, appInfo.definitionFor(type));
                }
            }
        }
    }

    private static void reportDependencyEdge(DesugarGraphConsumer consumer, Origin dependencyOrigin, DexClass clazz) {
        Origin dependentOrigin = clazz.getOrigin();
        if (dependentOrigin != dependencyOrigin) {
            consumer.accept(dependentOrigin, dependencyOrigin);
        }
    }

    public Set<DexString> getEmulatedMethods() {
        return this.emulatedMethods;
    }

    @Override
    public boolean hasPreciseNeedsDesugaring() {
        return false;
    }

    @Override
    public void scan(ProgramMethod context, CfInstructionDesugaringEventConsumer eventConsumer) {
        if (this.isSyntheticMethodThatShouldNotBeDoubleProcessed(context)) {
            this.leavingStaticInvokeToInterface(context);
            return;
        }
        CfCode code = ((DexEncodedMethod)context.getDefinition()).getCode().asCfCode();
        for (CfInstruction instruction : code.getInstructions()) {
            if (instruction.isInvokeDynamic() && !LambdaInstructionDesugaring.isLambdaInvoke(instruction, context, this.appView) && !StringConcatInstructionDesugaring.isStringConcatInvoke(instruction, this.appView.dexItemFactory())) {
                this.reportInterfaceMethodHandleCallSite(instruction.asInvokeDynamic().getCallSite(), context);
            }
            this.computeDescription(instruction, context).scan();
        }
    }

    @Override
    public boolean needsDesugaring(CfInstruction instruction, ProgramMethod context) {
        if (this.isSyntheticMethodThatShouldNotBeDoubleProcessed(context)) {
            return false;
        }
        return this.computeDescription(instruction, context).needsDesugaring();
    }

    @Override
    public Collection<CfInstruction> desugarInstruction(CfInstruction instruction, FreshLocalProvider freshLocalProvider, LocalStackAllocator localStackAllocator, CfInstructionDesugaringEventConsumer eventConsumer, ProgramMethod context, CompilationContext.MethodProcessingContext methodProcessingContext, CfInstructionDesugaringCollection desugaringCollection, DexItemFactory dexItemFactory) {
        assert (!this.isSyntheticMethodThatShouldNotBeDoubleProcessed(context));
        return this.computeDescription(instruction, context).desugarInstruction(freshLocalProvider, localStackAllocator, eventConsumer, context, methodProcessingContext, dexItemFactory);
    }

    public InterfaceMethodProcessorFacade getPostProcessingDesugaringD8(Flavor flavour, InterfaceProcessor interfaceProcessor) {
        return new InterfaceMethodProcessorFacade(this.appView, flavour, m3 -> true, interfaceProcessor);
    }

    public InterfaceMethodProcessorFacade getPostProcessingDesugaringR8(Flavor flavour, Predicate<ProgramMethod> isLiveMethod, InterfaceProcessor interfaceProcessor) {
        return new InterfaceMethodProcessorFacade(this.appView, flavour, isLiveMethod, interfaceProcessor);
    }

    final DefaultMethodsHelper.Collection getOrCreateInterfaceInfo(DexClass classToDesugar, DexClass implementing, DexType iface) {
        DefaultMethodsHelper.Collection collection = this.cache.get(iface);
        if (collection != null) {
            return collection;
        }
        collection = this.createInterfaceInfo(classToDesugar, implementing, iface);
        DefaultMethodsHelper.Collection existing = this.cache.putIfAbsent(iface, collection);
        return existing != null ? existing : collection;
    }

    public static enum Flavor {
        IncludeAllResources,
        ExcludeDexResources;

    }
}

