/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.itf;

import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.ir.desugar.itf.InterfaceProcessor;

class InterfaceMethodRewriterFixup {
    private final AppView<?> appView;
    private final InterfaceProcessor.InterfaceProcessorNestedGraphLens graphLens;

    InterfaceMethodRewriterFixup(AppView<?> appView, InterfaceProcessor.InterfaceProcessorNestedGraphLens graphLens) {
        this.appView = appView;
        this.graphLens = graphLens;
    }

    private EnclosingMethodAttribute fixupEnclosingMethodAttribute(EnclosingMethodAttribute enclosingMethodAttribute) {
        DexMethod enclosingMethod = enclosingMethodAttribute.getEnclosingMethod();
        DexMethod mappedEnclosingMethod = this.fixupDexMethodForEnclosingMethod(enclosingMethod);
        return mappedEnclosingMethod != enclosingMethod ? new EnclosingMethodAttribute(mappedEnclosingMethod) : enclosingMethodAttribute;
    }

    private DexMethod fixupDexMethodForEnclosingMethod(DexMethod method) {
        if (method == null) {
            return null;
        }
        DexMethod mappedMethod = this.graphLens.getExtraNewMethodSignatures().getRepresentativeValue(method);
        if (mappedMethod != null) {
            return mappedMethod;
        }
        return this.graphLens.getRenamedMethodSignature(method);
    }

    void run() {
        for (DexProgramClass clazz : ((AppInfo)this.appView.appInfo()).classes()) {
            InnerClassAttribute innerClassAttributeForThisClass;
            if (clazz.getEnclosingMethodAttribute() == null || clazz.getEnclosingMethodAttribute().getEnclosingMethod() == null || (innerClassAttributeForThisClass = clazz.getInnerClassAttributeForThisClass()) == null || innerClassAttributeForThisClass.getOuter() != null) continue;
            clazz.setEnclosingMethodAttribute(this.fixupEnclosingMethodAttribute(clazz.getEnclosingMethodAttribute()));
        }
    }
}

