/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.lambda;

import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.cf.code.CfInvokeDynamic;
import com.android.tools.r8.cf.code.CfLoad;
import com.android.tools.r8.cf.code.CfNew;
import com.android.tools.r8.cf.code.CfStackInstruction;
import com.android.tools.r8.cf.code.CfStaticFieldRead;
import com.android.tools.r8.cf.code.CfStore;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaring;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringCollection;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.FreshLocalProvider;
import com.android.tools.r8.ir.desugar.LambdaClass;
import com.android.tools.r8.ir.desugar.LambdaDescriptor;
import com.android.tools.r8.ir.desugar.LocalStackAllocator;
import com.android.tools.r8.ir.desugar.lambda.LambdaDesugaringEventConsumer;
import com.android.tools.r8.synthesis.SyntheticProgramClassBuilder;
import com.android.tools.r8.utils.Box;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;

public class LambdaInstructionDesugaring
implements CfInstructionDesugaring {
    private final AppView<?> appView;
    private final Set<DexMethod> directTargetedLambdaImplementationMethods = Sets.newIdentityHashSet();

    public LambdaInstructionDesugaring(AppView<?> appView) {
        this.appView = appView;
    }

    private Collection<CfInstruction> desugarInvokeDynamicInstruction(CfInvokeDynamic invoke, FreshLocalProvider freshLocalProvider, LocalStackAllocator localStackAllocator, LambdaDesugaringEventConsumer eventConsumer, ProgramMethod context, CompilationContext.MethodProcessingContext methodProcessingContext, DesugarInvoke desugarInvoke) {
        LambdaClass lambdaClass = this.createLambdaClass(invoke, context, methodProcessingContext, desugarInvoke);
        if (lambdaClass == null) {
            return null;
        }
        eventConsumer.acceptLambdaClass(lambdaClass, context);
        if (lambdaClass.isStatelessSingleton()) {
            return ImmutableList.of(new CfStaticFieldRead(lambdaClass.lambdaField, lambdaClass.lambdaField));
        }
        DexTypeList captureTypes = lambdaClass.descriptor.captures;
        ArrayDeque<CfInstruction> replacement = new ArrayDeque<CfInstruction>(3 + captureTypes.size() * 2);
        replacement.add(new CfNew(lambdaClass.getType()));
        replacement.add(new CfStackInstruction(CfStackInstruction.Opcode.Dup));
        captureTypes.forEach((Consumer<? super DexType>)((Consumer<DexType>)captureType -> {
            ValueType valueType = ValueType.fromDexType(captureType);
            int freshLocal = freshLocalProvider.getFreshLocal(valueType.requiredRegisters());
            replacement.addFirst(new CfStore(valueType, freshLocal));
            replacement.addLast(new CfLoad(valueType, freshLocal));
        }));
        replacement.add(new CfInvoke(183, lambdaClass.constructor, false));
        localStackAllocator.allocateLocalStack(2);
        return replacement;
    }

    private LambdaClass createLambdaClass(CfInvokeDynamic invoke, ProgramMethod context, CompilationContext.MethodProcessingContext methodProcessingContext, DesugarInvoke desugarInvoke) {
        LambdaDescriptor descriptor = LambdaDescriptor.tryInfer(invoke.getCallSite(), this.appView.appInfoForDesugaring(), context);
        if (descriptor == null) {
            return null;
        }
        Box box = new Box();
        DexProgramClass clazz = this.appView.getSyntheticItems().createClass(kinds -> kinds.LAMBDA, methodProcessingContext.createUniqueContext(), this.appView, builder -> box.set(new LambdaClass((SyntheticProgramClassBuilder)builder, this.appView, this, context, descriptor, desugarInvoke)));
        LambdaClass lambdaClass = (LambdaClass)box.get();
        lambdaClass.setClass(clazz);
        return lambdaClass;
    }

    public static boolean isLambdaInvoke(CfInstruction instruction, ProgramMethod context, AppView<?> appView) {
        return instruction.isInvokeDynamic() && LambdaDescriptor.tryInfer(instruction.asInvokeDynamic().getCallSite(), appView.appInfoForDesugaring(), context) != null;
    }

    public boolean isDirectTargetedLambdaImplementationMethod(DexMethodHandle implMethod) {
        return implMethod.type.isInvokeDirect() && this.directTargetedLambdaImplementationMethods.contains(implMethod.asMethod());
    }

    @Override
    public void scan(ProgramMethod method, CfInstructionDesugaringEventConsumer eventConsumer) {
        CfCode code = ((DexEncodedMethod)method.getDefinition()).getCode().asCfCode();
        for (CfInstruction instruction : code.getInstructions()) {
            DexMethod target;
            if (!instruction.isInvokeSpecial() || !(target = instruction.asInvoke().getMethod()).getName().startsWith(this.appView.dexItemFactory().javacLambdaMethodPrefix)) continue;
            this.directTargetedLambdaImplementationMethods.add(target);
        }
    }

    @Override
    public Collection<CfInstruction> desugarInstruction(CfInstruction instruction, FreshLocalProvider freshLocalProvider, LocalStackAllocator localStackAllocator, CfInstructionDesugaringEventConsumer eventConsumer, ProgramMethod context, CompilationContext.MethodProcessingContext methodProcessingContext, CfInstructionDesugaringCollection desugaringCollection, DexItemFactory dexItemFactory) {
        if (instruction.isInvokeDynamic()) {
            return this.desugarInvokeDynamicInstruction(instruction.asInvokeDynamic(), freshLocalProvider, localStackAllocator, eventConsumer, context, methodProcessingContext, (invoke, localProvider, stackAllocator) -> desugaringCollection.desugarInstruction(invoke, localProvider, stackAllocator, eventConsumer, context, methodProcessingContext));
        }
        return null;
    }

    @Override
    public boolean needsDesugaring(CfInstruction instruction, ProgramMethod context) {
        return LambdaInstructionDesugaring.isLambdaInvoke(instruction, context, this.appView);
    }

    public static interface DesugarInvoke {
        public Collection<CfInstruction> desugarInvoke(CfInvoke var1, FreshLocalProvider var2, LocalStackAllocator var3);
    }
}

