/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.nest;

import com.android.tools.r8.com.google.common.collect.Iterables;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClasspathClass;
import com.android.tools.r8.graph.DexType;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class Nest {
    private final DexClass hostClass;
    private final List<DexClass> members;
    private final List<DexType> missingMembers;

    private Nest(DexClass hostClass, List<DexClass> members, List<DexType> missingMembers) {
        this.hostClass = hostClass;
        this.members = members;
        this.missingMembers = missingMembers;
    }

    public static Nest create(AppView<?> appView, DexClass clazz) {
        return Nest.create(appView, clazz, null);
    }

    public static Nest create(AppView<?> appView, DexClass clazz, Consumer<DexClass> missingHostConsumer) {
        DexClass hostClass;
        assert (clazz.isInANest());
        DexClass dexClass = hostClass = clazz.isNestHost() ? clazz : appView.definitionFor(clazz.getNestHost());
        if (hostClass == null) {
            if (missingHostConsumer != null) {
                missingHostConsumer.accept(clazz);
            }
            return null;
        }
        ArrayList<DexClass> members = new ArrayList<DexClass>(hostClass.getNestMembersClassAttributes().size());
        ArrayList<DexType> missingMembers = new ArrayList<DexType>();
        hostClass.forEachNestMember(memberType -> {
            DexClass memberClass = appView.definitionFor((DexType)memberType);
            if (memberClass != null) {
                members.add(memberClass);
            } else {
                missingMembers.add((DexType)memberType);
            }
        });
        return new Nest(hostClass, members, missingMembers);
    }

    public Iterable<DexClasspathClass> getClasspathMembers() {
        return Iterables.transform(Iterables.filter(this.members, DexClass::isClasspathClass), DexClass::asClasspathClass);
    }

    public DexClass getHostClass() {
        return this.hostClass;
    }

    public List<DexClass> getMembers() {
        return this.members;
    }

    public List<DexType> getMissingMembers() {
        return this.missingMembers;
    }

    public boolean hasLibraryMember() {
        return Iterables.any(this.members, DexClass::isLibraryClass);
    }

    public boolean hasMissingMembers() {
        return !this.missingMembers.isEmpty();
    }
}

