/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.records;

import com.android.tools.r8.cf.code.CfConstClass;
import com.android.tools.r8.cf.code.CfConstString;
import com.android.tools.r8.cf.code.CfDexItemBasedConstString;
import com.android.tools.r8.cf.code.CfFieldInstruction;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.cf.code.CfInvokeDynamic;
import com.android.tools.r8.cf.code.CfStackInstruction;
import com.android.tools.r8.cf.code.CfTypeInstruction;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.desugar.CfClassSynthesizerDesugaring;
import com.android.tools.r8.ir.desugar.CfClassSynthesizerDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaring;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringCollection;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.CfPostProcessingDesugaring;
import com.android.tools.r8.ir.desugar.CfPostProcessingDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.FreshLocalProvider;
import com.android.tools.r8.ir.desugar.LocalStackAllocator;
import com.android.tools.r8.ir.desugar.ProgramAdditions;
import com.android.tools.r8.ir.desugar.records.RecordCfMethods;
import com.android.tools.r8.ir.desugar.records.RecordDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.records.RecordRewriterHelper;
import com.android.tools.r8.ir.synthetic.CallObjectInitCfCodeProvider;
import com.android.tools.r8.ir.synthetic.RecordCfCodeProvider;
import com.android.tools.r8.ir.synthetic.SyntheticCfCodeProvider;
import com.android.tools.r8.synthesis.SyntheticProgramClassBuilder;
import com.android.tools.r8.utils.InternalOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.BiFunction;

public class RecordDesugaring
implements CfInstructionDesugaring,
CfClassSynthesizerDesugaring,
CfPostProcessingDesugaring {
    public static final String GET_FIELDS_AS_OBJECTS_METHOD_NAME = "$record$getFieldsAsObjects";
    public static final String EQUALS_RECORD_METHOD_NAME = "$record$equals";
    private final AppView<?> appView;
    private final DexItemFactory factory;
    private final DexProto recordToStringHelperProto;
    private final DexProto recordHashCodeHelperProto;

    public static RecordDesugaring create(AppView<?> appView) {
        return appView.options().shouldDesugarRecords() ? new RecordDesugaring(appView) : null;
    }

    public static void registerSynthesizedCodeReferences(DexItemFactory factory) {
        RecordCfMethods.registerSynthesizedCodeReferences(factory);
        RecordCfCodeProvider.RecordGetFieldsAsObjectsCfCodeProvider.registerSynthesizedCodeReferences(factory);
        RecordCfCodeProvider.RecordEqualsCfCodeProvider.registerSynthesizedCodeReferences(factory);
    }

    private RecordDesugaring(AppView<?> appView) {
        this.appView = appView;
        this.factory = appView.dexItemFactory();
        this.recordToStringHelperProto = this.factory.createProto(this.factory.stringType, this.factory.objectArrayType, this.factory.classType, this.factory.stringType);
        this.recordHashCodeHelperProto = this.factory.createProto(this.factory.intType, this.factory.classType, this.factory.objectArrayType);
    }

    private void prepareInvokeDynamicOnRecord(CfInvokeDynamic invokeDynamic, ProgramAdditions programAdditions, ProgramMethod context) {
        RecordRewriterHelper.RecordInvokeDynamic recordInvokeDynamic = RecordRewriterHelper.parseInvokeDynamicOnRecord(invokeDynamic, this.appView, context);
        if (recordInvokeDynamic.getMethodName() == this.factory.toStringMethodName || recordInvokeDynamic.getMethodName() == this.factory.hashCodeMethodName) {
            this.ensureGetFieldsAsObjects(recordInvokeDynamic, programAdditions);
            return;
        }
        if (recordInvokeDynamic.getMethodName() == this.factory.equalsMethodName) {
            this.ensureEqualsRecord(recordInvokeDynamic, programAdditions);
            return;
        }
        throw new Unreachable("Invoke dynamic needs record desugaring but could not be desugared.");
    }

    private void scanInstruction(CfInstruction instruction, CfInstructionDesugaringEventConsumer eventConsumer) {
        assert (!instruction.isInitClass());
        if (instruction.isInvoke()) {
            CfInvoke cfInvoke = instruction.asInvoke();
            if (RecordDesugaring.refersToRecord(cfInvoke.getMethod(), this.factory)) {
                this.ensureRecordClass(eventConsumer);
            }
            return;
        }
        if (instruction.isFieldInstruction()) {
            CfFieldInstruction fieldInstruction = instruction.asFieldInstruction();
            if (RecordDesugaring.refersToRecord(fieldInstruction.getField(), this.factory)) {
                this.ensureRecordClass(eventConsumer);
            }
            return;
        }
        if (instruction.isTypeInstruction()) {
            CfTypeInstruction typeInstruction = instruction.asTypeInstruction();
            if (RecordDesugaring.refersToRecord(typeInstruction.getType(), this.factory)) {
                this.ensureRecordClass(eventConsumer);
            }
            return;
        }
    }

    private List<CfInstruction> desugarInvokeDynamicOnRecord(CfInvokeDynamic invokeDynamic, LocalStackAllocator localStackAllocator, CfInstructionDesugaringEventConsumer eventConsumer, ProgramMethod context, CompilationContext.MethodProcessingContext methodProcessingContext) {
        RecordRewriterHelper.RecordInvokeDynamic recordInvokeDynamic = RecordRewriterHelper.parseInvokeDynamicOnRecord(invokeDynamic, this.appView, context);
        if (recordInvokeDynamic.getMethodName() == this.factory.toStringMethodName) {
            return this.desugarInvokeRecordToString(recordInvokeDynamic, localStackAllocator, eventConsumer, methodProcessingContext);
        }
        if (recordInvokeDynamic.getMethodName() == this.factory.hashCodeMethodName) {
            return this.desugarInvokeRecordHashCode(recordInvokeDynamic, localStackAllocator, eventConsumer, methodProcessingContext);
        }
        if (recordInvokeDynamic.getMethodName() == this.factory.equalsMethodName) {
            return this.desugarInvokeRecordEquals(recordInvokeDynamic);
        }
        throw new Unreachable("Invoke dynamic needs record desugaring but could not be desugared.");
    }

    private ProgramMethod synthesizeEqualsRecordMethod(DexProgramClass clazz, DexMethod getFieldsAsObjects, DexMethod method) {
        return this.synthesizeMethod(clazz, new RecordCfCodeProvider.RecordEqualsCfCodeProvider(this.appView, clazz.type, getFieldsAsObjects), method);
    }

    private ProgramMethod synthesizeGetFieldsAsObjectsMethod(DexProgramClass clazz, DexField[] fields, DexMethod method) {
        return this.synthesizeMethod(clazz, new RecordCfCodeProvider.RecordGetFieldsAsObjectsCfCodeProvider(this.appView, this.factory.recordTagType, fields), method);
    }

    private ProgramMethod synthesizeMethod(DexProgramClass clazz, SyntheticCfCodeProvider provider, DexMethod method) {
        MethodAccessFlags methodAccessFlags = MethodAccessFlags.fromSharedAccessFlags(4098, false);
        DexEncodedMethod encodedMethod = DexEncodedMethod.syntheticBuilder().setMethod(method).setAccessFlags(methodAccessFlags).setCode(null).disableAndroidApiLevelCheck().build();
        ProgramMethod result = new ProgramMethod(clazz, encodedMethod);
        result.setCode(provider.generateCfCode(), this.appView);
        return result;
    }

    private DexMethod ensureEqualsRecord(RecordRewriterHelper.RecordInvokeDynamic recordInvokeDynamic, ProgramAdditions programAdditions) {
        DexMethod getFieldsAsObjects = this.ensureGetFieldsAsObjects(recordInvokeDynamic, programAdditions);
        DexProgramClass clazz = recordInvokeDynamic.getRecordClass();
        DexMethod method = this.equalsRecordMethod(clazz.type);
        assert (clazz.lookupProgramMethod(method) == null);
        programAdditions.accept(method, () -> this.synthesizeEqualsRecordMethod(clazz, getFieldsAsObjects, method));
        return method;
    }

    private DexMethod ensureGetFieldsAsObjects(RecordRewriterHelper.RecordInvokeDynamic recordInvokeDynamic, ProgramAdditions programAdditions) {
        DexProgramClass clazz = recordInvokeDynamic.getRecordClass();
        DexMethod method = this.getFieldsAsObjectsMethod(clazz.type);
        assert (clazz.lookupProgramMethod(method) == null);
        programAdditions.accept(method, () -> this.synthesizeGetFieldsAsObjectsMethod(clazz, recordInvokeDynamic.getFields(), method));
        return method;
    }

    private DexMethod getFieldsAsObjectsMethod(DexType holder) {
        return this.factory.createMethod(holder, this.factory.createProto(this.factory.objectArrayType, new DexType[0]), GET_FIELDS_AS_OBJECTS_METHOD_NAME);
    }

    private DexMethod equalsRecordMethod(DexType holder) {
        return this.factory.createMethod(holder, this.factory.createProto(this.factory.booleanType, this.factory.objectType), EQUALS_RECORD_METHOD_NAME);
    }

    private ProgramMethod synthesizeRecordHelper(DexProto helperProto, BiFunction<InternalOptions, DexMethod, CfCode> codeGenerator, CompilationContext.MethodProcessingContext methodProcessingContext) {
        return this.appView.getSyntheticItems().createMethod(kinds -> kinds.RECORD_HELPER, methodProcessingContext.createUniqueContext(), this.appView, builder -> builder.setProto(helperProto).setAccessFlags(MethodAccessFlags.createPublicStaticSynthetic()).setCode(methodSig -> (CfCode)codeGenerator.apply(this.appView.options(), methodSig)).disableAndroidApiLevelCheck());
    }

    private List<CfInstruction> desugarInvokeRecordHashCode(RecordRewriterHelper.RecordInvokeDynamic recordInvokeDynamic, LocalStackAllocator localStackAllocator, RecordDesugaringEventConsumer.RecordInstructionDesugaringEventConsumer eventConsumer, CompilationContext.MethodProcessingContext methodProcessingContext) {
        localStackAllocator.allocateLocalStack(1);
        DexMethod getFieldsAsObjects = this.getFieldsAsObjectsMethod(recordInvokeDynamic.getRecordType());
        assert (recordInvokeDynamic.getRecordClass().lookupProgramMethod(getFieldsAsObjects) != null);
        ArrayList<CfInstruction> instructions = new ArrayList<CfInstruction>();
        instructions.add(new CfStackInstruction(CfStackInstruction.Opcode.Dup));
        instructions.add(new CfInvoke(182, this.factory.objectMembers.getClass, false));
        instructions.add(new CfStackInstruction(CfStackInstruction.Opcode.Swap));
        instructions.add(new CfInvoke(183, getFieldsAsObjects, false));
        ProgramMethod programMethod = this.synthesizeRecordHelper(this.recordHashCodeHelperProto, RecordCfMethods::RecordMethods_hashCode, methodProcessingContext);
        eventConsumer.acceptRecordMethod(programMethod);
        instructions.add(new CfInvoke(184, (DexMethod)programMethod.getReference(), false));
        return instructions;
    }

    private List<CfInstruction> desugarInvokeRecordEquals(RecordRewriterHelper.RecordInvokeDynamic recordInvokeDynamic) {
        DexMethod equalsRecord = this.equalsRecordMethod(recordInvokeDynamic.getRecordType());
        assert (recordInvokeDynamic.getRecordClass().lookupProgramMethod(equalsRecord) != null);
        return Collections.singletonList(new CfInvoke(183, equalsRecord, false));
    }

    private List<CfInstruction> desugarInvokeRecordToString(RecordRewriterHelper.RecordInvokeDynamic recordInvokeDynamic, LocalStackAllocator localStackAllocator, RecordDesugaringEventConsumer.RecordInstructionDesugaringEventConsumer eventConsumer, CompilationContext.MethodProcessingContext methodProcessingContext) {
        localStackAllocator.allocateLocalStack(2);
        DexMethod getFieldsAsObjects = this.getFieldsAsObjectsMethod(recordInvokeDynamic.getRecordType());
        assert (recordInvokeDynamic.getRecordClass().lookupProgramMethod(getFieldsAsObjects) != null);
        ArrayList<CfInstruction> instructions = new ArrayList<CfInstruction>();
        instructions.add(new CfInvoke(183, getFieldsAsObjects, false));
        instructions.add(new CfConstClass(recordInvokeDynamic.getRecordType(), true));
        if (this.appView.options().testing.enableRecordModeling && this.appView.enableWholeProgramOptimizations()) {
            instructions.add(new CfDexItemBasedConstString(recordInvokeDynamic.getRecordType(), recordInvokeDynamic.computeRecordFieldNamesComputationInfo()));
        } else {
            instructions.add(new CfConstString(recordInvokeDynamic.getFieldNames()));
        }
        ProgramMethod programMethod = this.synthesizeRecordHelper(this.recordToStringHelperProto, RecordCfMethods::RecordMethods_toString, methodProcessingContext);
        eventConsumer.acceptRecordMethod(programMethod);
        instructions.add(new CfInvoke(184, (DexMethod)programMethod.getReference(), false));
        return instructions;
    }

    private void ensureRecordClass(RecordDesugaringEventConsumer eventConsumer) {
        DexItemFactory factory = this.appView.dexItemFactory();
        this.checkRecordTagNotPresent(factory);
        this.appView.getSyntheticItems().ensureFixedClassFromType(kinds -> kinds.RECORD_TAG, factory.recordType, this.appView, builder -> {
            DexEncodedMethod init = this.synthesizeRecordInitMethod();
            ((SyntheticProgramClassBuilder)builder.setAbstract()).setDirectMethods(ImmutableList.of(init));
        }, eventConsumer::acceptRecordClass);
    }

    private void checkRecordTagNotPresent(DexItemFactory factory) {
        DexClass r8RecordClass = ((AppInfo)this.appView.appInfo()).definitionForWithoutExistenceAssert(factory.recordTagType);
        if (r8RecordClass != null && r8RecordClass.isProgramClass()) {
            this.appView.options().reporter.error("D8/R8 is compiling a mix of desugared and non desugared input using java.lang.Record, but the application reader did not import correctly " + factory.recordTagType);
        }
    }

    public static boolean refersToRecord(DexField field, DexItemFactory factory) {
        assert (!RecordDesugaring.refersToRecord(field.holder, factory)) : "The java.lang.Record class has no fields.";
        return RecordDesugaring.refersToRecord(field.type, factory);
    }

    public static boolean refersToRecord(DexMethod method, DexItemFactory factory) {
        if (RecordDesugaring.refersToRecord(method.holder, factory)) {
            return true;
        }
        return RecordDesugaring.refersToRecord(method.proto, factory);
    }

    private static boolean refersToRecord(DexProto proto, DexItemFactory factory) {
        if (RecordDesugaring.refersToRecord(proto.returnType, factory)) {
            return true;
        }
        return RecordDesugaring.refersToRecord(proto.parameters.values, factory);
    }

    private static boolean refersToRecord(DexType[] types, DexItemFactory factory) {
        for (DexType type : types) {
            if (!RecordDesugaring.refersToRecord(type, factory)) continue;
            return true;
        }
        return false;
    }

    private static boolean refersToRecord(DexType type, DexItemFactory factory) {
        return type == factory.recordType;
    }

    private boolean needsDesugaring(DexMethod method, boolean isSuper) {
        return this.rewriteMethod(method, isSuper) != method;
    }

    private boolean needsDesugaring(CfInvokeDynamic invokeDynamic, ProgramMethod context) {
        return RecordRewriterHelper.isInvokeDynamicOnRecord(invokeDynamic, this.appView, context);
    }

    private DexMethod rewriteMethod(DexMethod method, boolean isSuper) {
        if (method != this.factory.recordMembers.equals && method != this.factory.recordMembers.hashCode && method != this.factory.recordMembers.toString) {
            return method;
        }
        if (isSuper) {
            throw new CompilationError("Rewrite invoke-super to abstract method error.");
        }
        if (method == this.factory.recordMembers.equals) {
            return this.factory.objectMembers.equals;
        }
        if (method == this.factory.recordMembers.toString) {
            return this.factory.objectMembers.toString;
        }
        assert (method == this.factory.recordMembers.hashCode);
        return this.factory.objectMembers.toString;
    }

    private DexEncodedMethod synthesizeRecordInitMethod() {
        MethodAccessFlags methodAccessFlags = MethodAccessFlags.fromSharedAccessFlags(4100, true);
        return DexEncodedMethod.syntheticBuilder().setMethod(this.factory.recordMembers.constructor).setAccessFlags(methodAccessFlags).setCode(new CallObjectInitCfCodeProvider(this.appView, this.factory.recordTagType).generateCfCode()).disableAndroidApiLevelCheck().build();
    }

    @Override
    public void prepare(ProgramMethod method, ProgramAdditions programAdditions) {
        CfCode cfCode = ((DexEncodedMethod)method.getDefinition()).getCode().asCfCode();
        for (CfInstruction instruction : cfCode.getInstructions()) {
            if (!instruction.isInvokeDynamic() || !this.needsDesugaring(instruction, method)) continue;
            this.prepareInvokeDynamicOnRecord(instruction.asInvokeDynamic(), programAdditions, method);
        }
    }

    @Override
    public void scan(ProgramMethod programMethod, CfInstructionDesugaringEventConsumer eventConsumer) {
        CfCode cfCode = ((DexEncodedMethod)programMethod.getDefinition()).getCode().asCfCode();
        for (CfInstruction instruction : cfCode.getInstructions()) {
            this.scanInstruction(instruction, eventConsumer);
        }
    }

    @Override
    public Collection<CfInstruction> desugarInstruction(CfInstruction instruction, FreshLocalProvider freshLocalProvider, LocalStackAllocator localStackAllocator, CfInstructionDesugaringEventConsumer eventConsumer, ProgramMethod context, CompilationContext.MethodProcessingContext methodProcessingContext, CfInstructionDesugaringCollection desugaringCollection, DexItemFactory dexItemFactory) {
        assert (!instruction.isInitClass());
        if (!this.needsDesugaring(instruction, context)) {
            return null;
        }
        if (instruction.isInvokeDynamic()) {
            return this.desugarInvokeDynamicOnRecord(instruction.asInvokeDynamic(), localStackAllocator, eventConsumer, context, methodProcessingContext);
        }
        assert (instruction.isInvoke());
        CfInvoke cfInvoke = instruction.asInvoke();
        DexMethod newMethod = this.rewriteMethod(cfInvoke.getMethod(), cfInvoke.isInvokeSuper(context.getHolderType()));
        assert (newMethod != cfInvoke.getMethod());
        return Collections.singletonList(new CfInvoke(cfInvoke.getOpcode(), newMethod, cfInvoke.isInterface()));
    }

    @Override
    public boolean needsDesugaring(CfInstruction instruction, ProgramMethod context) {
        if (instruction.isInvokeDynamic()) {
            return this.needsDesugaring(instruction.asInvokeDynamic(), context);
        }
        if (instruction.isInvoke()) {
            CfInvoke cfInvoke = instruction.asInvoke();
            return this.needsDesugaring(cfInvoke.getMethod(), cfInvoke.isInvokeSuper(context.getHolderType()));
        }
        return false;
    }

    @Override
    public String uniqueIdentifier() {
        return "$record$";
    }

    @Override
    public void synthesizeClasses(CompilationContext.ClassSynthesisDesugaringContext processingContext, CfClassSynthesizerDesugaringEventConsumer eventConsumer) {
        if (((AppInfo)this.appView.appInfo()).app().getFlags().hasReadRecordReferenceFromProgramClass()) {
            this.ensureRecordClass(eventConsumer);
        }
    }

    @Override
    public void postProcessingDesugaring(Collection<DexProgramClass> programClasses, CfPostProcessingDesugaringEventConsumer eventConsumer, ExecutorService executorService) throws ExecutionException {
        for (DexProgramClass clazz : programClasses) {
            if (!clazz.isRecord()) continue;
            assert (clazz.superType == this.factory.recordType);
            clazz.accessFlags.unsetRecord();
        }
    }
}

