/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.records;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.FieldResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.ArrayPut;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.NewArrayEmpty;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.RecordFieldValues;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackIgnore;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class RecordFieldValuesRewriter {
    private final AppView<AppInfoWithLiveness> appView;
    private final IRConverter irConverter;

    public static RecordFieldValuesRewriter create(AppView<AppInfoWithLiveness> appView) {
        if (appView.enableWholeProgramOptimizations() && appView.options().isGeneratingDex() && appView.options().testing.enableRecordModeling) {
            return new RecordFieldValuesRewriter(appView);
        }
        return null;
    }

    private RecordFieldValuesRewriter(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
        this.irConverter = new IRConverter(appView, Timing.empty());
    }

    private void splitIfCatchHandlers(IRCode code, BasicBlock blockWithIncorrectThrowingInstructions, ListIterator<BasicBlock> blockIterator) {
        InstructionListIterator instructionsIterator = blockWithIncorrectThrowingInstructions.listIterator(code);
        BasicBlock currentBlock = blockWithIncorrectThrowingInstructions;
        while (currentBlock != null && instructionsIterator.hasNext()) {
            Instruction throwingInstruction = (Instruction)instructionsIterator.nextUntil(Instruction::instructionTypeCanThrow);
            if (throwingInstruction != null) {
                BasicBlock nextBlock = instructionsIterator.split(code, blockIterator);
                blockIterator.previous();
                nextBlock.copyCatchHandlers(code, blockIterator, currentBlock, this.appView.options());
                BasicBlock b = blockIterator.next();
                assert (b == nextBlock);
                instructionsIterator = nextBlock.listIterator(code);
                currentBlock = nextBlock;
                continue;
            }
            assert (!instructionsIterator.hasNext());
            instructionsIterator = null;
            currentBlock = null;
        }
    }

    private List<Value> computePresentFields(RecordFieldValues recordFieldValues, ProgramMethod context) {
        List<Value> inValues = recordFieldValues.inValues();
        DexField[] fields = recordFieldValues.getFields();
        assert (inValues.size() == fields.length);
        ArrayList<Value> newInValues = new ArrayList<Value>();
        for (int index = 0; index < fields.length; ++index) {
            FieldResolutionResult resolution = this.appView.appInfo().resolveField(this.appView.graphLens().getRenamedFieldSignature(fields[index]), context);
            if (!resolution.isSingleFieldResolutionResult()) continue;
            newInValues.add(inValues.get(index));
        }
        return newInValues;
    }

    public void rewriteRecordFieldValues() {
        for (DexMethod recordFieldValuesReference : this.appView.appInfo().recordFieldValuesReferences) {
            DexClass dexClass = this.appView.contextIndependentDefinitionFor(recordFieldValuesReference.getHolderType());
            assert (dexClass.isProgramClass());
            ProgramMethod programMethod = dexClass.asProgramClass().lookupProgramMethod(recordFieldValuesReference);
            assert (programMethod != null);
            this.rewriteRecordFieldValues(programMethod);
        }
    }

    public void rewriteRecordFieldValues(ProgramMethod programMethod) {
        IRCode irCode = ((DexEncodedMethod)programMethod.getDefinition()).getCode().buildIR(programMethod, this.appView, programMethod.getOrigin());
        boolean done = false;
        BasicBlockIterator blockIterator = irCode.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock block = (BasicBlock)blockIterator.next();
            InstructionListIterator iterator2 = block.listIterator(irCode);
            while (iterator2.hasNext()) {
                Instruction instruction = (Instruction)iterator2.next();
                if (!instruction.isRecordFieldValues()) continue;
                this.rewriteRecordFieldArray(instruction.asRecordFieldValues(), irCode, blockIterator, iterator2);
                done = true;
            }
        }
        assert (done);
        this.irConverter.removeDeadCodeAndFinalizeIR(irCode, OptimizationFeedbackIgnore.getInstance(), Timing.empty());
    }

    public void rewriteRecordFieldArray(RecordFieldValues recordFieldArray, IRCode code, ListIterator<BasicBlock> blockIterator, InstructionListIterator iterator2) {
        List<Value> newInValues = this.computePresentFields(recordFieldArray, code.context());
        ConstNumber arrayLengthIntConstant = code.createIntConstant(newInValues.size());
        Position constantPosition = this.appView.options().debug ? Position.none() : recordFieldArray.getPosition();
        arrayLengthIntConstant.setPosition(constantPosition);
        iterator2.previous();
        iterator2.add(arrayLengthIntConstant);
        iterator2.next();
        NewArrayEmpty newArrayEmpty = new NewArrayEmpty(recordFieldArray.outValue(), arrayLengthIntConstant.outValue(), this.appView.dexItemFactory().objectArrayType);
        newArrayEmpty.setPosition(recordFieldArray.getPosition());
        iterator2.replaceCurrentInstruction(newArrayEmpty);
        for (int i = 0; i < newInValues.size(); ++i) {
            ConstNumber intConstantI = code.createIntConstant(i);
            intConstantI.setPosition(constantPosition);
            iterator2.add(intConstantI);
            ArrayPut arrayPut = new ArrayPut(MemberType.OBJECT, newArrayEmpty.outValue(), intConstantI.outValue(), newInValues.get(i));
            iterator2.add(arrayPut);
            arrayPut.setPosition(recordFieldArray.getPosition());
        }
        if (newArrayEmpty.getBlock().hasCatchHandlers()) {
            this.splitIfCatchHandlers(code, newArrayEmpty.getBlock(), blockIterator);
        }
    }
}

