/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.desugar.stringconcat;

import com.android.tools.r8.cf.code.CfConstString;
import com.android.tools.r8.cf.code.CfInstruction;
import com.android.tools.r8.cf.code.CfInvoke;
import com.android.tools.r8.cf.code.CfInvokeDynamic;
import com.android.tools.r8.cf.code.CfLoad;
import com.android.tools.r8.cf.code.CfNew;
import com.android.tools.r8.cf.code.CfStackInstruction;
import com.android.tools.r8.cf.code.CfStore;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexCallSite;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaring;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringCollection;
import com.android.tools.r8.ir.desugar.CfInstructionDesugaringEventConsumer;
import com.android.tools.r8.ir.desugar.FreshLocalProvider;
import com.android.tools.r8.ir.desugar.LocalStackAllocator;
import com.android.tools.r8.utils.BooleanUtils;
import com.android.tools.r8.utils.IteratorUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StringConcatInstructionDesugaring
implements CfInstructionDesugaring {
    private final DexItemFactory factory;
    private final DexItemFactory.StringBuildingMethods stringBuilderMethods;
    private final Map<DexType, DexMethod> paramTypeToAppendMethod = new IdentityHashMap<DexType, DexMethod>();

    public StringConcatInstructionDesugaring(AppView<?> appView) {
        this.factory = appView.dexItemFactory();
        this.stringBuilderMethods = this.factory.stringBuilderMethods;
        this.paramTypeToAppendMethod.put(this.factory.booleanType, this.stringBuilderMethods.appendBoolean);
        this.paramTypeToAppendMethod.put(this.factory.charType, this.stringBuilderMethods.appendChar);
        this.paramTypeToAppendMethod.put(this.factory.byteType, this.stringBuilderMethods.appendInt);
        this.paramTypeToAppendMethod.put(this.factory.shortType, this.stringBuilderMethods.appendInt);
        this.paramTypeToAppendMethod.put(this.factory.intType, this.stringBuilderMethods.appendInt);
        this.paramTypeToAppendMethod.put(this.factory.longType, this.stringBuilderMethods.appendLong);
        this.paramTypeToAppendMethod.put(this.factory.floatType, this.stringBuilderMethods.appendFloat);
        this.paramTypeToAppendMethod.put(this.factory.doubleType, this.stringBuilderMethods.appendDouble);
        this.paramTypeToAppendMethod.put(this.factory.stringType, this.stringBuilderMethods.appendString);
    }

    private Collection<CfInstruction> desugarMakeConcat(CfInvokeDynamic invoke, FreshLocalProvider freshLocalProvider, LocalStackAllocator localStackAllocator) {
        DexProto proto = invoke.getCallSite().methodProto;
        DexType[] parameters = proto.parameters.values;
        ConcatBuilder builder = new ConcatBuilder();
        for (DexType parameter : parameters) {
            ValueType valueType = ValueType.fromDexType(parameter);
            builder.addChunk(new ArgumentChunk(this.paramTypeToAppendMethod.getOrDefault(parameter, this.stringBuilderMethods.appendObject), freshLocalProvider.getFreshLocal(valueType.requiredRegisters())));
        }
        return builder.desugar(localStackAllocator);
    }

    private Collection<CfInstruction> desugarMakeConcatWithConstants(CfInvokeDynamic invoke, FreshLocalProvider freshLocalProvider, LocalStackAllocator localStackAllocator, ProgramMethod context) {
        DexCallSite callSite = invoke.getCallSite();
        DexProto proto = callSite.methodProto;
        DexTypeList parameters = proto.getParameters();
        List<DexValue> bootstrapArgs = callSite.bootstrapArgs;
        if (bootstrapArgs.isEmpty()) {
            throw StringConcatInstructionDesugaring.error(context, "bootstrap method misses `recipe` argument");
        }
        DexValue.DexValueString recipeValue = bootstrapArgs.get(0).asDexValueString();
        if (recipeValue == null) {
            throw StringConcatInstructionDesugaring.error(context, "bootstrap method argument `recipe` must be a string");
        }
        String recipe = ((DexString)recipeValue.getValue()).toString();
        ArrayList<DexValue> constantArguments = new ArrayList<DexValue>();
        for (int i = 1; i < bootstrapArgs.size(); ++i) {
            constantArguments.add(bootstrapArgs.get(i));
        }
        ConcatBuilder builder = new ConcatBuilder();
        StringBuilder acc = new StringBuilder();
        int length = recipe.length();
        Iterator constantArgumentsIterator = constantArguments.iterator();
        Iterator<DexType> parameterIterator = parameters.iterator();
        for (int i = 0; i < length; ++i) {
            char c = recipe.charAt(i);
            if (c == '\u0001') {
                if (acc.length() > 0) {
                    DexString stringConstant = this.factory.createString(acc.toString());
                    builder.addChunk(new ConstantChunk(this.paramTypeToAppendMethod.get(this.factory.stringType), stringConstant));
                    acc.setLength(0);
                }
                if (!parameterIterator.hasNext()) {
                    throw StringConcatInstructionDesugaring.error(context, "too many argument references in `recipe`");
                }
                DexType parameter = parameterIterator.next();
                ValueType valueType = ValueType.fromDexType(parameter);
                builder.addChunk(new ArgumentChunk(this.paramTypeToAppendMethod.getOrDefault(parameter, this.stringBuilderMethods.appendObject), freshLocalProvider.getFreshLocal(valueType.requiredRegisters())));
                continue;
            }
            if (c == '\u0002') {
                if (!constantArgumentsIterator.hasNext()) {
                    throw StringConcatInstructionDesugaring.error(context, "too many constant references in `recipe`");
                }
                acc.append(StringConcatInstructionDesugaring.convertToString((DexValue)constantArgumentsIterator.next(), context));
                continue;
            }
            acc.append(c);
        }
        if (parameterIterator.hasNext()) {
            throw StringConcatInstructionDesugaring.error(context, "too few argument references in `recipe`, expected " + parameters.size() + ", referenced: " + (parameters.size() - IteratorUtils.countRemaining(parameterIterator)));
        }
        if (constantArgumentsIterator.hasNext()) {
            throw StringConcatInstructionDesugaring.error(context, "too few constant references in `recipe`, expected " + constantArguments.size() + ", referenced: " + (constantArguments.size() - IteratorUtils.countRemaining(constantArgumentsIterator)));
        }
        if (acc.length() > 0) {
            DexString stringConstant = this.factory.createString(acc.toString());
            builder.addChunk(new ConstantChunk(this.paramTypeToAppendMethod.get(this.factory.stringType), stringConstant));
        }
        return builder.desugar(localStackAllocator);
    }

    public static boolean isStringConcatInvoke(CfInstruction instruction, DexItemFactory factory) {
        CfInvokeDynamic invoke = instruction.asInvokeDynamic();
        if (invoke == null) {
            return false;
        }
        DexCallSite callSite = invoke.getCallSite();
        if (callSite.bootstrapMethod.type.isInvokeStatic()) {
            DexMethod bootstrapMethod = callSite.bootstrapMethod.asMethod();
            return bootstrapMethod == factory.stringConcatFactoryMembers.makeConcat || bootstrapMethod == factory.stringConcatFactoryMembers.makeConcatWithConstants;
        }
        return false;
    }

    private static String convertToString(DexValue value, ProgramMethod context) {
        if (value.isDexValueString()) {
            return ((DexString)value.asDexValueString().getValue()).toString();
        }
        throw StringConcatInstructionDesugaring.error(context, "const arg referenced from `recipe` is not supported: " + value.getClass().getName());
    }

    private static CompilationError error(ProgramMethod context, String message) {
        return new CompilationError("String concatenation desugaring error (method: " + context.toSourceString() + "): " + message);
    }

    @Override
    public Collection<CfInstruction> desugarInstruction(CfInstruction instruction, FreshLocalProvider freshLocalProvider, LocalStackAllocator localStackAllocator, CfInstructionDesugaringEventConsumer eventConsumer, ProgramMethod context, CompilationContext.MethodProcessingContext methodProcessingContext, CfInstructionDesugaringCollection desugaringCollection, DexItemFactory dexItemFactory) {
        if (instruction.isInvokeDynamic()) {
            CfInvokeDynamic invoke = instruction.asInvokeDynamic();
            DexCallSite callSite = invoke.getCallSite();
            if (callSite.bootstrapMethod.type.isInvokeStatic()) {
                DexMethod bootstrapMethod = callSite.bootstrapMethod.asMethod();
                if (bootstrapMethod == this.factory.stringConcatFactoryMembers.makeConcat) {
                    return this.desugarMakeConcat(invoke, freshLocalProvider, localStackAllocator);
                }
                if (bootstrapMethod == this.factory.stringConcatFactoryMembers.makeConcatWithConstants) {
                    return this.desugarMakeConcatWithConstants(invoke, freshLocalProvider, localStackAllocator, context);
                }
            }
        }
        return null;
    }

    @Override
    public boolean needsDesugaring(CfInstruction instruction, ProgramMethod context) {
        return StringConcatInstructionDesugaring.isStringConcatInvoke(instruction, this.factory);
    }

    private static final class ConstantChunk
    extends Chunk {
        private final DexString stringConstant;

        ConstantChunk(DexMethod method, DexString stringConstant) {
            super(method);
            this.stringConstant = stringConstant;
        }

        public DexString getStringConstant() {
            return this.stringConstant;
        }

        @Override
        public boolean isConstantChunk() {
            return true;
        }

        @Override
        public ConstantChunk asConstantChunk() {
            return this;
        }
    }

    private static final class ArgumentChunk
    extends Chunk {
        private final int variableIndex;

        ArgumentChunk(DexMethod method, int variableIndex) {
            super(method);
            this.variableIndex = variableIndex;
        }

        public int getVariableIndex() {
            return this.variableIndex;
        }

        @Override
        public boolean isArgumentChunk() {
            return true;
        }

        @Override
        public ArgumentChunk asArgumentChunk() {
            return this;
        }
    }

    private static abstract class Chunk {
        private final DexMethod method;

        Chunk(DexMethod method) {
            this.method = method;
        }

        public DexMethod getMethod() {
            return this.method;
        }

        public ValueType getValueType() {
            assert (this.method.getProto().getArity() == 1);
            return ValueType.fromDexType(this.method.getParameter(0));
        }

        public boolean isArgumentChunk() {
            return false;
        }

        public ArgumentChunk asArgumentChunk() {
            return null;
        }

        public boolean isConstantChunk() {
            return false;
        }

        public ConstantChunk asConstantChunk() {
            return null;
        }
    }

    private final class ConcatBuilder {
        private final List<Chunk> chunks = new ArrayList<Chunk>();
        private ArgumentChunk biggestArgumentChunk = null;
        private ConstantChunk firstConstantChunk = null;
        private int argumentChunksStackSize = 0;

        ConcatBuilder() {
        }

        void addChunk(ArgumentChunk chunk) {
            this.chunks.add(chunk);
            this.argumentChunksStackSize += chunk.getValueType().requiredRegisters();
            if (this.biggestArgumentChunk == null || chunk.getValueType().requiredRegisters() > this.biggestArgumentChunk.getValueType().requiredRegisters()) {
                this.biggestArgumentChunk = chunk;
            }
        }

        void addChunk(ConstantChunk chunk) {
            this.chunks.add(chunk);
            if (this.firstConstantChunk == null) {
                this.firstConstantChunk = chunk;
            }
        }

        final Collection<CfInstruction> desugar(LocalStackAllocator localStackAllocator) {
            ArgumentChunk argumentChunk;
            ArrayDeque<CfInstruction> replacement = new ArrayDeque<CfInstruction>();
            for (Chunk chunk : this.chunks) {
                if (!chunk.isArgumentChunk()) continue;
                argumentChunk = chunk.asArgumentChunk();
                replacement.addFirst(new CfStore(argumentChunk.getValueType(), argumentChunk.getVariableIndex()));
            }
            replacement.add(new CfNew(((StringConcatInstructionDesugaring)StringConcatInstructionDesugaring.this).factory.stringBuilderType));
            replacement.add(new CfStackInstruction(CfStackInstruction.Opcode.Dup));
            replacement.add(new CfInvoke(183, ((StringConcatInstructionDesugaring)StringConcatInstructionDesugaring.this).stringBuilderMethods.defaultConstructor, false));
            for (Chunk chunk : this.chunks) {
                if (chunk.isArgumentChunk()) {
                    argumentChunk = chunk.asArgumentChunk();
                    replacement.add(new CfLoad(argumentChunk.getValueType(), argumentChunk.getVariableIndex()));
                } else {
                    assert (chunk.isConstantChunk());
                    replacement.add(new CfConstString(chunk.asConstantChunk().getStringConstant()));
                }
                replacement.add(new CfInvoke(182, chunk.method, false));
            }
            replacement.add(new CfInvoke(182, ((StringConcatInstructionDesugaring)StringConcatInstructionDesugaring.this).stringBuilderMethods.toString, false));
            int maxLocalStackSizeAfterStores = 2 + BooleanUtils.intValue(this.biggestArgumentChunk != null && this.biggestArgumentChunk.getValueType().requiredRegisters() == 2);
            if (maxLocalStackSizeAfterStores > this.argumentChunksStackSize) {
                localStackAllocator.allocateLocalStack(maxLocalStackSizeAfterStores - this.argumentChunksStackSize);
            }
            return replacement;
        }
    }
}

