/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClassAndField;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.FieldResolutionResult;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.analysis.type.DynamicTypeWithUpperBound;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.Assume;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.LazyDominatorTree;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.info.FieldOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.MethodOptimizationInfo;
import com.android.tools.r8.ir.optimize.membervaluepropagation.assume.AssumeInfo;
import com.android.tools.r8.ir.optimize.membervaluepropagation.assume.AssumeInfoLookup;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArrayList;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntList;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntListIterator;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.TriConsumer;
import com.android.tools.r8.utils.TriFunction;
import com.android.tools.r8.utils.TriPredicate;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class AssumeInserter {
    private final AppView<AppInfoWithLiveness> appView;

    public AssumeInserter(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
    }

    private void internalInsertAssumeInstructionsInBlocks(IRCode code, BasicBlockIterator blockIterator, Predicate<BasicBlock> blockTester, Timing timing) {
        timing.begin("Part 1: Compute assumed values");
        AssumedValues assumedValues = this.computeAssumedValues(code, blockIterator, blockTester);
        timing.end();
        if (assumedValues.isEmpty()) {
            return;
        }
        timing.begin("Part 2: Remove redundant assume instructions");
        this.removeRedundantAssumeInstructions(assumedValues);
        timing.end();
        timing.begin("Part 3: Compute dominated users");
        Map<Instruction, Map<Value, AssumedValueInfo>> redundantAssumedValues = this.computeDominanceForAssumedValues(code, assumedValues);
        timing.end();
        if (assumedValues.isEmpty()) {
            return;
        }
        timing.begin("Part 4: Remove redundant dominated assume instructions");
        this.removeRedundantDominatedAssumeInstructions(assumedValues, redundantAssumedValues);
        timing.end();
        if (assumedValues.isEmpty()) {
            return;
        }
        timing.begin("Part 5: Materialize assume instructions");
        this.materializeAssumeInstructions(code, assumedValues);
        timing.end();
    }

    private AssumedValues computeAssumedValues(IRCode code, BasicBlockIterator blockIterator, Predicate<BasicBlock> blockTester) {
        AssumedValues.Builder assumedValuesBuilder = new AssumedValues.Builder();
        while (blockIterator.hasNext()) {
            BasicBlock block = blockIterator.next();
            if (!blockTester.test(block)) continue;
            this.computeAssumedValuesInBlock(code, blockIterator, block, assumedValuesBuilder);
        }
        return assumedValuesBuilder.build();
    }

    private void computeAssumedValuesInBlock(IRCode code, BasicBlockIterator blockIterator, BasicBlock block, AssumedValues.Builder assumedValuesBuilder) {
        Value lhs;
        If ifInstruction;
        InstructionListIterator instructionIterator = block.listIterator(code);
        while (instructionIterator.hasNext()) {
            Value inValue;
            Instruction current = (Instruction)instructionIterator.next();
            boolean needsAssumeInstruction = false;
            if (current.throwsOnNullInput() && assumedValuesBuilder.isMaybeNull(inValue = current.getNonNullInput()) && AssumeInserter.isNullableReferenceTypeWithOtherNonDebugUsers(inValue, current)) {
                assumedValuesBuilder.addNonNullValueWithUnknownDominance(current, inValue);
                needsAssumeInstruction = true;
            }
            if (current.isInvokeMethod()) {
                needsAssumeInstruction |= this.computeAssumedValuesForInvokeMethod(code, current.asInvokeMethod(), assumedValuesBuilder);
            } else if (current.isFieldGet()) {
                needsAssumeInstruction |= this.computeAssumedValuesForFieldGet(current.asFieldInstruction(), assumedValuesBuilder);
            }
            if (!block.hasCatchHandlers()) continue;
            if (needsAssumeInstruction) {
                BasicBlock insertionBlock = instructionIterator.split(code, blockIterator);
                assert (!instructionIterator.hasNext());
                assert (instructionIterator.peekPrevious().isGoto());
                assert (blockIterator.peekPrevious() == insertionBlock);
                this.computeAssumedValuesInBlock(code, blockIterator, insertionBlock, assumedValuesBuilder);
                return;
            }
            if (!current.instructionTypeCanThrow()) continue;
            break;
        }
        if ((ifInstruction = block.exit().asIf()) != null && ifInstruction.isNonTrivialNullTest() && assumedValuesBuilder.isMaybeNull(lhs = ifInstruction.lhs()) && AssumeInserter.isNullableReferenceTypeWithOtherNonDebugUsers(lhs, ifInstruction) && ifInstruction.targetFromNonNullObject().getPredecessors().size() == 1) {
            assumedValuesBuilder.addNonNullValueWithUnknownDominance(ifInstruction, lhs);
        }
    }

    private boolean computeAssumedValuesForInvokeMethod(IRCode code, InvokeMethod invoke, AssumedValues.Builder assumedValuesBuilder) {
        if (!invoke.hasOutValue() && invoke.getInvokedMethod().proto.parameters.isEmpty()) {
            return false;
        }
        DexMethod invokedMethod = invoke.getInvokedMethod();
        if (invokedMethod.holder.isArrayType() && invokedMethod.match(this.appView.dexItemFactory().objectMembers.clone)) {
            return this.computeAssumedValuesFromArrayClone(invoke, assumedValuesBuilder);
        }
        return this.computeAssumedValuesFromSingleTarget(code, invoke, assumedValuesBuilder);
    }

    private boolean computeAssumedValuesFromArrayClone(InvokeMethod invoke, AssumedValues.Builder assumedValuesBuilder) {
        Value outValue = invoke.outValue();
        if (outValue == null || !outValue.hasNonDebugUsers()) {
            return false;
        }
        DynamicTypeWithUpperBound dynamicType = invoke.getInvokedMethod().getHolderType().toDynamicType(this.appView, Nullability.definitelyNotNull());
        assumedValuesBuilder.addAssumedValueKnownToDominateAllUsers(invoke, outValue, dynamicType);
        return true;
    }

    private boolean computeAssumedValuesFromSingleTarget(IRCode code, InvokeMethod invoke, AssumedValues.Builder assumedValuesBuilder) {
        BitSet nonNullParamOnNormalExits;
        AssumeInfo assumeInfo;
        MethodResolutionResult.SingleResolutionResult resolutionResult = this.appView.appInfo().unsafeResolveMethodDueToDexFormat(invoke.getInvokedMethod()).asSingleResolution();
        if (resolutionResult == null) {
            return false;
        }
        DexClassAndMethod singleTarget = invoke.lookupSingleTarget(this.appView, code.context());
        if (invoke.hasUsedOutValue() && invoke.getOutType().isReferenceType() && (assumeInfo = AssumeInfoLookup.lookupAssumeInfo(this.appView, resolutionResult, singleTarget)) != null && assumeInfo.hasReturnInfo() && assumeInfo.getReturnInfo().isNonNull()) {
            assumedValuesBuilder.addNonNullValueKnownToDominateAllUsers(invoke, invoke.outValue());
        }
        if (singleTarget == null) {
            return false;
        }
        boolean needsAssumeInstruction = false;
        MethodOptimizationInfo optimizationInfo = ((DexEncodedMethod)singleTarget.getDefinition()).getOptimizationInfo();
        if (invoke.hasUsedOutValue()) {
            needsAssumeInstruction = this.computeAssumedValuesForOutValue(invoke, optimizationInfo.getDynamicType(), assumedValuesBuilder);
        }
        if ((nonNullParamOnNormalExits = optimizationInfo.getNonNullParamOnNormalExits()) != null) {
            int start;
            for (int i = start = invoke.isInvokeMethodWithReceiver() ? 1 : 0; i < invoke.arguments().size(); ++i) {
                Value argument;
                if (!nonNullParamOnNormalExits.get(i) || !assumedValuesBuilder.isMaybeNull(argument = invoke.getArgument(i)) || !AssumeInserter.isNullableReferenceTypeWithOtherNonDebugUsers(argument, invoke)) continue;
                assumedValuesBuilder.addNonNullValueWithUnknownDominance(invoke, argument);
                needsAssumeInstruction = true;
            }
        }
        return needsAssumeInstruction;
    }

    private boolean computeAssumedValuesForFieldGet(FieldInstruction fieldGet, AssumedValues.Builder assumedValuesBuilder) {
        AssumeInfo assumeInfo;
        if (fieldGet.hasUnusedOutValue()) {
            return false;
        }
        FieldResolutionResult.SingleFieldResolutionResult<?> resolutionResult = this.appView.appInfo().resolveField(fieldGet.getField()).asSingleFieldResolutionResult();
        if (resolutionResult == null) {
            return false;
        }
        DexClassAndField field = resolutionResult.getResolutionPair();
        if (field.getType().isReferenceType() && (assumeInfo = AssumeInfoLookup.lookupAssumeInfo(this.appView, field)) != null && assumeInfo.hasReturnInfo() && assumeInfo.getReturnInfo().isNonNull()) {
            assumedValuesBuilder.addNonNullValueKnownToDominateAllUsers(fieldGet, fieldGet.outValue());
        }
        FieldOptimizationInfo optimizationInfo = ((DexEncodedField)field.getDefinition()).getOptimizationInfo();
        return this.computeAssumedValuesForOutValue(fieldGet, optimizationInfo.getDynamicType(), assumedValuesBuilder);
    }

    private boolean computeAssumedValuesForOutValue(Instruction instruction, DynamicType dynamicType, AssumedValues.Builder assumedValuesBuilder) {
        DynamicTypeWithUpperBound staticType;
        Value outValue = instruction.outValue();
        if (dynamicType.isUnknown()) {
            return false;
        }
        if (dynamicType.isNotNullType()) {
            assumedValuesBuilder.addNonNullValueKnownToDominateAllUsers(instruction, outValue);
            return true;
        }
        DynamicTypeWithUpperBound dynamicTypeWithUpperBound = dynamicType.asDynamicTypeWithUpperBound();
        if (!dynamicTypeWithUpperBound.strictlyLessThan(staticType = DynamicType.create(this.appView, outValue.getType()), this.appView)) {
            return false;
        }
        if (!dynamicTypeWithUpperBound.getNullability().isMaybeNull() && dynamicTypeWithUpperBound.withNullability(Nullability.maybeNull()).equals(staticType)) {
            assert (dynamicTypeWithUpperBound.getNullability().isDefinitelyNotNull());
            assumedValuesBuilder.addNonNullValueKnownToDominateAllUsers(instruction, outValue);
        } else {
            assumedValuesBuilder.addAssumedValueKnownToDominateAllUsers(instruction, outValue, dynamicTypeWithUpperBound);
        }
        return true;
    }

    private void removeRedundantAssumeInstructions(AssumedValues assumedValues) {
        assumedValues.removeIf((instruction, assumedValue, assumedValueInfo) -> {
            if (assumedValueInfo.hasDynamicTypeInfo()) {
                return false;
            }
            assert (assumedValueInfo.isNonNull());
            if (assumedValue.isPhi()) {
                return false;
            }
            Instruction definition = assumedValue.definition;
            if (definition == instruction) {
                return false;
            }
            AssumedValueInfo otherAssumedValueInfo = assumedValues.getAssumedValueInfo(definition, (Value)assumedValue);
            if (otherAssumedValueInfo == null) {
                return false;
            }
            if (!otherAssumedValueInfo.isNonNull()) {
                assumedValueInfo.setDynamicTypeAssumption(otherAssumedValueInfo.getDynamicTypeAssumption());
                return false;
            }
            return true;
        });
    }

    private Map<Instruction, Map<Value, AssumedValueInfo>> computeDominanceForAssumedValues(IRCode code, AssumedValues assumedValues) {
        IdentityHashMap<Instruction, Map<Value, AssumedValueInfo>> redundantAssumedValues = new IdentityHashMap<Instruction, Map<Value, AssumedValueInfo>>();
        LazyDominatorTree lazyDominatorTree = new LazyDominatorTree(code);
        IdentityHashMap dominatedBlocksCache = new IdentityHashMap();
        assumedValues.computeDominance((instruction, assumedValue, assumedValueInfo) -> {
            AssumedValueInfo alreadyAssumedValueInfo;
            Map alreadyAssumedValues = (Map)redundantAssumedValues.get(instruction);
            if (alreadyAssumedValues != null && (alreadyAssumedValueInfo = (AssumedValueInfo)alreadyAssumedValues.get(assumedValue)) != null) {
                if (assumedValueInfo.isSubsumedBy(alreadyAssumedValueInfo)) {
                    return AssumedDominance.redundant();
                }
                assumedValueInfo.strengthenWith(alreadyAssumedValueInfo);
            }
            if (assumedValue == instruction.outValue()) {
                return AssumedDominance.everything();
            }
            BasicBlock block = instruction.getBlock();
            if (assumedValue.getBlock() == block && block.exit().isGoto() && !instruction.getBlock().hasCatchHandlers()) {
                Instruction current;
                InstructionIterator iterator2 = instruction.getBlock().iterator();
                if (!assumedValue.isPhi()) {
                    iterator2.nextUntil(x -> x != assumedValue.definition);
                    iterator2.previous();
                }
                boolean isUsedBeforeInstruction = false;
                while (iterator2.hasNext() && (current = (Instruction)iterator2.next()) != instruction) {
                    if (!current.inValues().contains(assumedValue) && !current.getDebugValues().contains(assumedValue)) continue;
                    isUsedBeforeInstruction = true;
                    break;
                }
                if (!isUsedBeforeInstruction) {
                    return AssumedDominance.everythingElse();
                }
            }
            BasicBlock insertionBlock = this.getInsertionBlock((Instruction)instruction);
            assert (assumedValue.hasPhiUsers() || assumedValue.uniqueUsers().stream().anyMatch(user -> user != instruction) || assumedValue.isArgument());
            DominatorTree dominatorTree = lazyDominatorTree.get();
            Set dominatedBlocks = dominatedBlocksCache.computeIfAbsent(insertionBlock, x -> dominatorTree.dominatedBlocks((BasicBlock)x, Sets.newIdentityHashSet()));
            AssumedDominance.Builder dominance = AssumedDominance.builder(assumedValue);
            for (Instruction instruction2 : assumedValue.uniqueUsers()) {
                if (instruction2 == instruction || !dominatedBlocks.contains(instruction2.getBlock())) continue;
                if (instruction2.getBlock() == insertionBlock && insertionBlock == block) {
                    Instruction first = (Instruction)block.iterator().nextUntil(x -> x == instruction || x == instruction2);
                    assert (first != null);
                    if (first == instruction2) continue;
                }
                dominance.addDominatedUser(instruction2);
                redundantAssumedValues.computeIfAbsent(instruction2, ignore -> new IdentityHashMap()).put(assumedValue, assumedValueInfo);
            }
            for (Phi phi : assumedValue.uniquePhiUsers()) {
                IntList dominatedPredecessorIndices = this.findDominatedPredecessorIndexesInPhi(phi, (Value)assumedValue, dominatedBlocks);
                if (dominatedPredecessorIndices.isEmpty()) continue;
                dominance.addDominatedPhiUser(phi, dominatedPredecessorIndices);
            }
            return dominance.build();
        });
        return redundantAssumedValues;
    }

    private void removeRedundantDominatedAssumeInstructions(AssumedValues assumedValues, Map<Instruction, Map<Value, AssumedValueInfo>> redundantAssumedValues) {
        assumedValues.removeAll(redundantAssumedValues);
    }

    private void materializeAssumeInstructions(IRCode code, AssumedValues assumedValues) {
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        IdentityHashMap<BasicBlock, Map<Instruction, List<Instruction>>> pendingInsertions = new IdentityHashMap<BasicBlock, Map<Instruction, List<Instruction>>>();
        this.materializeSelectedAssumeInstructions(code, assumedValues, affectedValues, pendingInsertions, assumedValueInfo -> !assumedValueInfo.dominance.isEverything());
        this.materializeSelectedAssumeInstructions(code, assumedValues, affectedValues, pendingInsertions, assumedValueInfo -> assumedValueInfo.dominance.isEverything());
        pendingInsertions.forEach((block, pendingInsertionsPerInstruction) -> {
            InstructionListIterator instructionIterator = block.listIterator(code);
            while (instructionIterator.hasNext() && !pendingInsertionsPerInstruction.isEmpty()) {
                Instruction instruction = (Instruction)instructionIterator.next();
                List pendingAssumeInstructions = (List)pendingInsertionsPerInstruction.remove(instruction);
                if (pendingAssumeInstructions == null) continue;
                pendingAssumeInstructions.forEach(instructionIterator::add);
            }
        });
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appView).narrowing(affectedValues);
        }
    }

    private void materializeSelectedAssumeInstructions(IRCode code, AssumedValues assumedValues, Set<Value> affectedValues, Map<BasicBlock, Map<Instruction, List<Instruction>>> pendingInsertions, Predicate<AssumedValueInfo> predicate) {
        assumedValues.removeIf((instruction, assumedValue, assumedValueInfo) -> {
            Value newValue;
            if (!predicate.test((AssumedValueInfo)assumedValueInfo)) {
                return false;
            }
            BasicBlock block = instruction.getBlock();
            BasicBlock insertionBlock = this.getInsertionBlock((Instruction)instruction);
            AssumedDominance dominance = assumedValueInfo.getDominance();
            Value value = assumedValueInfo.isNull() ? code.createValue(TypeElement.getNull()) : (newValue = code.createValue(assumedValueInfo.isNonNull() ? assumedValue.getType().asReferenceType().asMeetWithNotNull() : assumedValue.getType(), assumedValue.getLocalInfo()));
            if (dominance.isEverything()) {
                assumedValue.replaceUsers(newValue);
            } else if (dominance.isEverythingElse()) {
                assumedValue.replaceSelectiveInstructionUsers(newValue, user -> user != instruction);
                assumedValue.replacePhiUsers(newValue);
            } else if (dominance.isSomething()) {
                SomethingAssumedDominance somethingDominance = dominance.asSomething();
                somethingDominance.getDominatedPhiUsers().forEach((user, indices) -> {
                    IntListIterator iterator2 = indices.iterator();
                    while (iterator2.hasNext()) {
                        Value operand = user.getOperand(iterator2.nextInt());
                        if (operand == assumedValue) continue;
                        assert (operand.isDefinedByInstructionSatisfying(Instruction::isAssume));
                        iterator2.remove();
                    }
                });
                assumedValue.replaceSelectiveUsers(newValue, somethingDominance.getDominatedUsers(), somethingDominance.getDominatedPhiUsers());
            }
            affectedValues.addAll(newValue.affectedValues());
            Instruction assumeInstruction = assumedValueInfo.isNull() ? new ConstNumber(newValue, 0L) : new Assume(assumedValueInfo.dynamicTypeAssumption, assumedValueInfo.nonNullAssumption, newValue, (Value)assumedValue, (Instruction)instruction, this.appView);
            assumeInstruction.setPosition(instruction.getPosition());
            if (insertionBlock != block) {
                insertionBlock.listIterator(code).add(assumeInstruction);
            } else {
                pendingInsertions.computeIfAbsent(block, ignore -> new IdentityHashMap()).computeIfAbsent(instruction, ignore -> new ArrayList()).add(assumeInstruction);
            }
            return true;
        });
    }

    private BasicBlock getInsertionBlock(Instruction instruction) {
        if (instruction.isIf()) {
            return instruction.asIf().targetFromNonNullObject();
        }
        BasicBlock block = instruction.getBlock();
        if (block.hasCatchHandlers()) {
            return block.exit().asGoto().getTarget();
        }
        return block;
    }

    private IntList findDominatedPredecessorIndexesInPhi(Phi user, Value assumedValue, Set<BasicBlock> dominatedBlocks) {
        assert (user.getOperands().contains(assumedValue));
        List<Value> operands = user.getOperands();
        List<BasicBlock> predecessors = user.getBlock().getPredecessors();
        assert (operands.size() == predecessors.size());
        IntArrayList predecessorIndexes = new IntArrayList();
        int index = 0;
        Iterator<Value> operandIterator = operands.iterator();
        Iterator<BasicBlock> predecessorIterator = predecessors.iterator();
        while (operandIterator.hasNext() && predecessorIterator.hasNext()) {
            Value operand = operandIterator.next();
            BasicBlock predecessor = predecessorIterator.next();
            if (operand == assumedValue && dominatedBlocks.contains(predecessor)) {
                predecessorIndexes.add(index);
            }
            ++index;
        }
        return predecessorIndexes;
    }

    private static boolean isNullableReferenceType(Value value) {
        TypeElement type = value.getType();
        return type.isReferenceType() && type.asReferenceType().isNullable();
    }

    private static boolean isNullableReferenceTypeWithOtherNonDebugUsers(Value value, Instruction ignore) {
        if (AssumeInserter.isNullableReferenceType(value)) {
            if (value.hasPhiUsers()) {
                return true;
            }
            for (Instruction user : value.uniqueUsers()) {
                if (user == ignore) continue;
                return true;
            }
        }
        return false;
    }

    public void insertAssumeInstructions(IRCode code, Timing timing) {
        this.insertAssumeInstructionsInBlocks(code, code.listIterator(), Predicates.alwaysTrue(), timing);
    }

    public void insertAssumeInstructionsInBlocks(IRCode code, BasicBlockIterator blockIterator, Predicate<BasicBlock> blockTester, Timing timing) {
        timing.begin("Insert assume instructions");
        this.internalInsertAssumeInstructionsInBlocks(code, blockIterator, blockTester, timing);
        timing.end();
    }

    static class UnknownAssumedDominance
    extends AssumedDominance {
        private static final UnknownAssumedDominance INSTANCE = new UnknownAssumedDominance();

        private UnknownAssumedDominance() {
        }

        public static UnknownAssumedDominance getInstance() {
            return INSTANCE;
        }

        @Override
        boolean isUnknown() {
            return true;
        }
    }

    static class SomethingAssumedDominance
    extends AssumedDominance {
        private final Set<Instruction> dominatedUsers;
        private final Map<Phi, IntList> dominatedPhiUsers;

        SomethingAssumedDominance(Set<Instruction> dominatedUsers, Map<Phi, IntList> dominatedPhiUsers) {
            this.dominatedUsers = dominatedUsers;
            this.dominatedPhiUsers = dominatedPhiUsers;
        }

        public Set<Instruction> getDominatedUsers() {
            return this.dominatedUsers;
        }

        public Map<Phi, IntList> getDominatedPhiUsers() {
            return this.dominatedPhiUsers;
        }

        @Override
        boolean isSomething() {
            return true;
        }

        @Override
        SomethingAssumedDominance asSomething() {
            return this;
        }
    }

    static class NothingAssumedDominance
    extends AssumedDominance {
        private static final NothingAssumedDominance INSTANCE = new NothingAssumedDominance();

        private NothingAssumedDominance() {
        }

        public static NothingAssumedDominance getInstance() {
            return INSTANCE;
        }

        @Override
        boolean isNothing() {
            return true;
        }
    }

    static class EverythingElseAssumedDominance
    extends AssumedDominance {
        private static final EverythingElseAssumedDominance INSTANCE = new EverythingElseAssumedDominance();

        private EverythingElseAssumedDominance() {
        }

        public static EverythingElseAssumedDominance getInstance() {
            return INSTANCE;
        }

        @Override
        boolean isEverythingElse() {
            return true;
        }
    }

    static class EverythingAssumedDominance
    extends AssumedDominance {
        private static final EverythingAssumedDominance INSTANCE = new EverythingAssumedDominance();

        private EverythingAssumedDominance() {
        }

        public static EverythingAssumedDominance getInstance() {
            return INSTANCE;
        }

        @Override
        boolean isEverything() {
            return true;
        }
    }

    static abstract class AssumedDominance {
        AssumedDominance() {
        }

        public static Builder builder(Value assumedValue) {
            return new Builder(assumedValue);
        }

        public static EverythingAssumedDominance everything() {
            return EverythingAssumedDominance.getInstance();
        }

        public static EverythingElseAssumedDominance everythingElse() {
            return EverythingElseAssumedDominance.getInstance();
        }

        public static NothingAssumedDominance nothing() {
            return NothingAssumedDominance.getInstance();
        }

        public static UnknownAssumedDominance redundant() {
            return AssumedDominance.unknown();
        }

        public static SomethingAssumedDominance something(Set<Instruction> dominatedUsers, Map<Phi, IntList> dominatedPhiUsers) {
            return new SomethingAssumedDominance(dominatedUsers, dominatedPhiUsers);
        }

        public static UnknownAssumedDominance unknown() {
            return UnknownAssumedDominance.getInstance();
        }

        boolean isEverything() {
            return false;
        }

        boolean isEverythingElse() {
            return false;
        }

        boolean isNothing() {
            return false;
        }

        boolean isSomething() {
            return false;
        }

        SomethingAssumedDominance asSomething() {
            return null;
        }

        boolean isUnknown() {
            return false;
        }

        static class Builder {
            private final Value assumedValue;
            private final Set<Instruction> dominatedUsers = Sets.newIdentityHashSet();
            private final Map<Phi, IntList> dominatedPhiUsers = new IdentityHashMap<Phi, IntList>();

            private Builder(Value assumedValue) {
                this.assumedValue = assumedValue;
            }

            void addDominatedUser(Instruction user) {
                assert (this.assumedValue.uniqueUsers().contains(user));
                assert (!this.dominatedUsers.contains(user));
                this.dominatedUsers.add(user);
            }

            void addDominatedPhiUser(Phi user, IntList dominatedPredecessorIndices) {
                assert (this.assumedValue.uniquePhiUsers().contains(user));
                assert (!this.dominatedPhiUsers.containsKey(user));
                this.dominatedPhiUsers.put(user, dominatedPredecessorIndices);
            }

            AssumedDominance build() {
                if (this.dominatedUsers.isEmpty() && this.dominatedPhiUsers.isEmpty()) {
                    return AssumedDominance.nothing();
                }
                assert (this.dominatedUsers.size() < this.assumedValue.uniqueUsers().size() || this.dominatedPhiUsers.size() < this.assumedValue.uniquePhiUsers().size());
                return AssumedDominance.something(this.dominatedUsers, this.dominatedPhiUsers);
            }
        }
    }

    static class AssumedValues {
        Map<Instruction, Map<Value, AssumedValueInfo>> assumedValues;

        public AssumedValues(Map<Instruction, Map<Value, AssumedValueInfo>> assumedValues) {
            this.assumedValues = assumedValues;
        }

        public static Builder builder() {
            return new Builder();
        }

        void computeDominance(TriFunction<Instruction, Value, AssumedValueInfo, AssumedDominance> function) {
            Iterator<Map.Entry<Instruction, Map<Value, AssumedValueInfo>>> outerIterator = this.assumedValues.entrySet().iterator();
            while (outerIterator.hasNext()) {
                Map.Entry<Instruction, Map<Value, AssumedValueInfo>> outerEntry = outerIterator.next();
                Instruction instruction = outerEntry.getKey();
                Map<Value, AssumedValueInfo> dominancePerValue = outerEntry.getValue();
                Iterator<Map.Entry<Value, AssumedValueInfo>> innerIterator = dominancePerValue.entrySet().iterator();
                while (innerIterator.hasNext()) {
                    Map.Entry<Value, AssumedValueInfo> innerEntry = innerIterator.next();
                    Value assumedValue = innerEntry.getKey();
                    AssumedValueInfo assumedValueInfo = innerEntry.getValue();
                    AssumedDominance dominance = assumedValueInfo.dominance;
                    if (dominance.isEverything()) {
                        assert (assumedValue.isDefinedByInstructionSatisfying(definition -> definition.outValue() == assumedValue));
                        continue;
                    }
                    assert (dominance.isUnknown());
                    dominance = function.apply(instruction, assumedValue, assumedValueInfo);
                    if (dominance.isNothing() && !assumedValue.isArgument() || dominance.isUnknown()) {
                        innerIterator.remove();
                        continue;
                    }
                    assumedValueInfo.setDominance(dominance);
                }
                if (!dominancePerValue.isEmpty()) continue;
                outerIterator.remove();
            }
        }

        AssumedValueInfo getAssumedValueInfo(Instruction instruction, Value assumedValue) {
            Map<Value, AssumedValueInfo> dominancePerValue = this.assumedValues.get(instruction);
            return dominancePerValue != null ? dominancePerValue.get(assumedValue) : null;
        }

        boolean isEmpty() {
            return this.assumedValues.isEmpty();
        }

        void forEach(TriConsumer<Instruction, Value, AssumedValueInfo> consumer) {
            this.assumedValues.forEach((? super K instruction, ? super V dominancePerValue) -> dominancePerValue.forEach((? super K assumedValue, ? super V assumedValueInfo) -> consumer.accept((Instruction)instruction, (Value)assumedValue, (AssumedValueInfo)assumedValueInfo)));
        }

        void removeAll(Map<Instruction, Map<Value, AssumedValueInfo>> keys2) {
            keys2.forEach((? super K instruction, ? super V redundantAssumedValues) -> {
                Map<Value, AssumedValueInfo> dominancePerValue = this.assumedValues.get(instruction);
                if (dominancePerValue != null) {
                    redundantAssumedValues.keySet().forEach(dominancePerValue::remove);
                    if (dominancePerValue.isEmpty()) {
                        this.assumedValues.remove(instruction);
                    }
                }
            });
        }

        void removeIf(TriPredicate<Instruction, Value, AssumedValueInfo> predicate) {
            Iterator<Map.Entry<Instruction, Map<Value, AssumedValueInfo>>> outerIterator = this.assumedValues.entrySet().iterator();
            while (outerIterator.hasNext()) {
                Map.Entry<Instruction, Map<Value, AssumedValueInfo>> outerEntry = outerIterator.next();
                Instruction instruction = outerEntry.getKey();
                Map<Value, AssumedValueInfo> dominancePerValue = outerEntry.getValue();
                Iterator<Map.Entry<Value, AssumedValueInfo>> innerIterator = dominancePerValue.entrySet().iterator();
                while (innerIterator.hasNext()) {
                    AssumedValueInfo assumedValueInfo;
                    Map.Entry<Value, AssumedValueInfo> innerEntry = innerIterator.next();
                    Value assumedValue = innerEntry.getKey();
                    if (!predicate.test(instruction, assumedValue, assumedValueInfo = innerEntry.getValue())) continue;
                    innerIterator.remove();
                }
                if (!dominancePerValue.isEmpty()) continue;
                outerIterator.remove();
            }
        }

        static class Builder {
            private final Map<Instruction, Map<Value, AssumedValueInfo>> assumedValues = new LinkedHashMap<Instruction, Map<Value, AssumedValueInfo>>();
            private final Set<Value> nonNullValuesKnownToDominateAllUsers = Sets.newIdentityHashSet();

            Builder() {
            }

            private void updateAssumedValueInfo(Instruction instruction, Value assumedValue, AssumedDominance dominance, Consumer<AssumedValueInfo> consumer) {
                AssumedValueInfo assumedValueInfo = this.assumedValues.computeIfAbsent(instruction, ignore -> new LinkedHashMap()).computeIfAbsent(assumedValue, ignore -> new AssumedValueInfo(dominance));
                consumer.accept(assumedValueInfo);
                if (dominance.isEverything() && assumedValueInfo.isNonNull()) {
                    this.nonNullValuesKnownToDominateAllUsers.add(assumedValue);
                }
            }

            void addAssumedValueKnownToDominateAllUsers(Instruction instruction, Value assumedValue, DynamicTypeWithUpperBound dynamicType) {
                this.updateAssumedValueInfo(instruction, assumedValue, AssumedDominance.everything(), assumedValueInfo -> assumedValueInfo.setDynamicTypeAssumption(dynamicType));
            }

            void addNonNullValueKnownToDominateAllUsers(Instruction instruction, Value nonNullValue) {
                this.updateAssumedValueInfo(instruction, nonNullValue, AssumedDominance.everything(), AssumedValueInfo::setNotNull);
            }

            void addNonNullValueWithUnknownDominance(Instruction instruction, Value nonNullValue) {
                this.updateAssumedValueInfo(instruction, nonNullValue, AssumedDominance.unknown(), AssumedValueInfo::setNotNull);
            }

            public boolean isMaybeNull(Value value) {
                return !this.nonNullValuesKnownToDominateAllUsers.contains(value);
            }

            public AssumedValues build() {
                return new AssumedValues(this.assumedValues);
            }
        }
    }

    static class AssumedValueInfo {
        AssumedDominance dominance;
        Assume.DynamicTypeAssumption dynamicTypeAssumption;
        Assume.NonNullAssumption nonNullAssumption;

        AssumedValueInfo(AssumedDominance dominance) {
            this.dominance = dominance;
        }

        AssumedDominance getDominance() {
            return this.dominance;
        }

        void setDominance(AssumedDominance dominance) {
            this.dominance = dominance;
        }

        boolean hasDynamicTypeInfo() {
            return this.dynamicTypeAssumption != null;
        }

        Assume.DynamicTypeAssumption getDynamicTypeAssumption() {
            return this.dynamicTypeAssumption;
        }

        void setDynamicTypeAssumption(Assume.DynamicTypeAssumption dynamicTypeAssumption) {
            this.dynamicTypeAssumption = dynamicTypeAssumption;
        }

        void setDynamicTypeAssumption(DynamicTypeWithUpperBound dynamicType) {
            assert (dynamicType != null);
            this.dynamicTypeAssumption = new Assume.DynamicTypeAssumption(dynamicType);
            if (dynamicType.getDynamicUpperBoundType().isDefinitelyNotNull()) {
                this.setNotNull();
            }
        }

        boolean isNull() {
            return this.dynamicTypeAssumption != null && this.dynamicTypeAssumption.getDynamicType().getNullability().isDefinitelyNull();
        }

        boolean isNonNull() {
            return this.nonNullAssumption != null;
        }

        void setNotNull() {
            this.nonNullAssumption = Assume.NonNullAssumption.get();
        }

        boolean isSubsumedBy(AssumedValueInfo other) {
            return !this.hasDynamicTypeInfo() && other.isNonNull();
        }

        void strengthenWith(AssumedValueInfo info) {
            if (info.isNonNull()) {
                this.setNotNull();
            }
            if (!this.hasDynamicTypeInfo() && info.hasDynamicTypeInfo()) {
                this.setDynamicTypeAssumption(info.getDynamicTypeAssumption());
            }
        }
    }
}

