/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.collect.Maps;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.FieldResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.ArrayPut;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.ConstNumber;
import com.android.tools.r8.ir.code.ConstString;
import com.android.tools.r8.ir.code.DexItemBasedConstString;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.StaticGet;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import com.android.tools.r8.naming.dexitembasedstring.ClassNameComputationInfo;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.Action;
import com.android.tools.r8.utils.IteratorUtils;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class ClassInitializerDefaultsOptimization {
    private final AppView<?> appView;
    private final IRConverter converter;
    private final DexItemFactory dexItemFactory;
    private WaveDoneAction waveDoneAction = null;

    public ClassInitializerDefaultsOptimization(AppView<?> appView, IRConverter converter) {
        this.appView = appView;
        this.converter = converter;
        this.dexItemFactory = appView.dexItemFactory();
    }

    private DexValue getDexStringValue(Value inValue, DexType holder) {
        if (inValue.isPhi()) {
            return null;
        }
        if (inValue.isConstant()) {
            if (inValue.isConstNumber()) {
                assert (inValue.isZero());
                return DexValue.DexValueNull.NULL;
            }
            if (inValue.isConstString()) {
                ConstString cnst = inValue.getConstInstruction().asConstString();
                return new DexValue.DexValueString(cnst.getValue());
            }
            if (inValue.isDexItemBasedConstString()) {
                DexItemBasedConstString cnst = inValue.getConstInstruction().asDexItemBasedConstString();
                assert (!cnst.getNameComputationInfo().needsToComputeName());
                return new DexValue.DexItemBasedValueString(cnst.getItem(), cnst.getNameComputationInfo());
            }
            assert (false);
            return null;
        }
        InvokeVirtual invoke = inValue.getAliasedValue().definition.asInvokeVirtual();
        return this.getDexStringValueForInvoke(invoke.getInvokedMethod(), holder);
    }

    private DexValue getDexStringValueForInvoke(DexMethod invokedMethod, DexType holder) {
        DexClass clazz = this.appView.definitionFor(holder);
        if (clazz == null) {
            assert (false);
            return null;
        }
        if (this.appView.enableWholeProgramOptimizations() && this.appView.withLiveness().appInfo().isMinificationAllowed(holder)) {
            if (invokedMethod == this.dexItemFactory.classMethods.getName) {
                return new DexValue.DexItemBasedValueString(holder, ClassNameComputationInfo.getInstance(ClassNameComputationInfo.ClassNameMapping.NAME));
            }
            if (invokedMethod == this.dexItemFactory.classMethods.getCanonicalName) {
                return new DexValue.DexItemBasedValueString(holder, ClassNameComputationInfo.getInstance(ClassNameComputationInfo.ClassNameMapping.CANONICAL_NAME));
            }
            if (invokedMethod == this.dexItemFactory.classMethods.getSimpleName) {
                return new DexValue.DexItemBasedValueString(holder, ClassNameComputationInfo.getInstance(ClassNameComputationInfo.ClassNameMapping.SIMPLE_NAME));
            }
            if (invokedMethod == this.dexItemFactory.classMethods.getTypeName) {
                // empty if block
            }
            assert (false);
            return null;
        }
        ClassNameComputationInfo.ClassNameMapping mapping = null;
        if (invokedMethod == this.dexItemFactory.classMethods.getName) {
            mapping = ClassNameComputationInfo.ClassNameMapping.NAME;
        } else if (invokedMethod == this.dexItemFactory.classMethods.getCanonicalName) {
            mapping = ClassNameComputationInfo.ClassNameMapping.CANONICAL_NAME;
        } else if (invokedMethod == this.dexItemFactory.classMethods.getSimpleName) {
            mapping = ClassNameComputationInfo.ClassNameMapping.SIMPLE_NAME;
        } else if (invokedMethod == this.dexItemFactory.classMethods.getTypeName) {
            // empty if block
        }
        if (mapping != null) {
            return new DexValue.DexValueString(mapping.map(holder.toDescriptorString(), clazz, this.dexItemFactory));
        }
        assert (false);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<DexEncodedField, StaticPut> findFinalFieldPutsWhileCollectingUnnecessaryStaticPuts(IRCode code, ProgramMethod context, Set<StaticPut> unnecessaryStaticPuts) {
        IdentityHashMap<DexEncodedField, StaticPut> finalFieldPuts = Maps.newIdentityHashMap();
        IdentityHashMap<DexField, Set<StaticPut>> isWrittenBefore = Maps.newIdentityHashMap();
        Set<DexEncodedField> isReadBefore = Sets.newIdentityHashSet();
        int color = code.reserveMarkingColor();
        try {
            BasicBlock block = code.entryBlock();
            while (!block.isMarked(color) && block.getPredecessors().size() <= 1) {
                block.mark(color);
                for (Instruction instruction : block.getInstructions()) {
                    Value outValue;
                    Object put;
                    Object field;
                    Map<DexEncodedField, StaticPut> map;
                    if (instruction.isArrayPut()) {
                        ArrayPut arrayPut = instruction.asArrayPut();
                        if (!arrayPut.instructionInstanceCanThrow(this.appView, context)) continue;
                        map = this.validateFinalFieldPuts(finalFieldPuts, isWrittenBefore);
                        return map;
                    }
                    if (instruction.isStaticGet()) {
                        StaticGet get = instruction.asStaticGet();
                        field = context.getHolder().lookupField(get.getField());
                        if (field == null) {
                            Map<DexEncodedField, StaticPut> map2 = this.validateFinalFieldPuts(finalFieldPuts, isWrittenBefore);
                            return map2;
                        }
                        isReadBefore.add((DexEncodedField)field);
                        continue;
                    }
                    if (instruction.isStaticPut()) {
                        put = instruction.asStaticPut();
                        if (((FieldInstruction)put).getField().holder != context.getHolderType()) {
                            field = this.validateFinalFieldPuts(finalFieldPuts, isWrittenBefore);
                            return field;
                        }
                        DexField fieldReference = ((FieldInstruction)put).getField();
                        DexEncodedField field2 = context.getHolder().lookupField(fieldReference);
                        Value value = ((StaticPut)put).value().getAliasedValue();
                        TypeElement valueType = value.getType();
                        if (field2 != null) {
                            if (isReadBefore.contains(field2) || value.isDexItemBasedConstStringThatNeedsToComputeClassName()) continue;
                            if (value.isConstant()) {
                                if (fieldReference.type.isReferenceType() && value.isZero()) {
                                    finalFieldPuts.put(field2, (StaticPut)put);
                                    unnecessaryStaticPuts.add((StaticPut)put);
                                    if (!isWrittenBefore.containsKey(fieldReference)) continue;
                                    unnecessaryStaticPuts.addAll((Collection)isWrittenBefore.get(fieldReference));
                                    isWrittenBefore.remove(fieldReference);
                                    continue;
                                }
                                if (fieldReference.type.isPrimitiveType() || fieldReference.type == this.dexItemFactory.stringType) {
                                    finalFieldPuts.put(field2, (StaticPut)put);
                                    unnecessaryStaticPuts.add((StaticPut)put);
                                    if (!isWrittenBefore.containsKey(fieldReference)) continue;
                                    unnecessaryStaticPuts.addAll((Collection)isWrittenBefore.get(fieldReference));
                                    isWrittenBefore.remove(fieldReference);
                                    continue;
                                }
                            } else {
                                if (this.isClassNameConstantOf((DexClass)context.getHolder(), (StaticPut)put)) {
                                    finalFieldPuts.put(field2, (StaticPut)put);
                                    unnecessaryStaticPuts.add((StaticPut)put);
                                    if (!isWrittenBefore.containsKey(fieldReference)) continue;
                                    unnecessaryStaticPuts.addAll((Collection)isWrittenBefore.get(fieldReference));
                                    isWrittenBefore.remove(fieldReference);
                                    continue;
                                }
                                if (valueType.isReferenceType() && valueType.isDefinitelyNotNull()) {
                                    finalFieldPuts.put(field2, (StaticPut)put);
                                    continue;
                                }
                            }
                        } else {
                            Map<DexEncodedField, StaticPut> map3 = this.validateFinalFieldPuts(finalFieldPuts, isWrittenBefore);
                            return map3;
                        }
                        isWrittenBefore.computeIfAbsent(fieldReference, ignore -> Sets.newIdentityHashSet()).add(put);
                        continue;
                    }
                    if (instruction.instructionMayHaveSideEffects(this.appView, context)) {
                        put = this.validateFinalFieldPuts(finalFieldPuts, isWrittenBefore);
                        return put;
                    }
                    if (this.isClassNameConstantOf((DexClass)context.getHolder(), instruction)) continue;
                    if (!instruction.isInvoke() || !instruction.hasOutValue() || !(outValue = instruction.outValue()).hasNonDebugUsers()) continue;
                    map = this.validateFinalFieldPuts(finalFieldPuts, isWrittenBefore);
                    return map;
                }
                if (!block.exit().isGoto()) continue;
                block = block.exit().asGoto().getTarget();
            }
        }
        finally {
            code.returnMarkingColor(color);
        }
        return this.validateFinalFieldPuts(finalFieldPuts, isWrittenBefore);
    }

    private Map<DexEncodedField, StaticPut> validateFinalFieldPuts(Map<DexEncodedField, StaticPut> finalFieldPuts, Map<DexField, Set<StaticPut>> isWrittenBefore) {
        isWrittenBefore.keySet().forEach(finalFieldPuts::remove);
        return finalFieldPuts;
    }

    private boolean isClassNameConstantOf(DexClass clazz, StaticPut put) {
        if (put.getField().type != this.dexItemFactory.stringType) {
            return false;
        }
        Value value = put.value().getAliasedValue();
        if (value.isPhi()) {
            return false;
        }
        return this.isClassNameConstantOf(clazz, value.definition);
    }

    private boolean isClassNameConstantOf(DexClass clazz, Instruction instruction) {
        if (instruction.isInvokeVirtual()) {
            InvokeVirtual invoke = instruction.asInvokeVirtual();
            if (!this.dexItemFactory.classMethods.isReflectiveNameLookup(invoke.getInvokedMethod())) {
                return false;
            }
            Value inValue = invoke.inValues().get(0);
            return !inValue.isPhi() && inValue.definition.isConstClass() && inValue.definition.asConstClass().getValue() == clazz.type;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassInitializerDefaultsResult optimize(IRCode code, OptimizationFeedback feedback) {
        if (this.appView.options().debug) {
            return ClassInitializerDefaultsResult.empty();
        }
        ProgramMethod context = code.context();
        if (context.getOrComputeReachabilitySensitive(this.appView)) {
            return ClassInitializerDefaultsResult.empty();
        }
        if (!((DexEncodedMethod)context.getDefinition()).isClassInitializer()) {
            return ClassInitializerDefaultsResult.empty();
        }
        Set<StaticPut> unnecessaryStaticPuts = Sets.newIdentityHashSet();
        Map<DexEncodedField, StaticPut> finalFieldPuts = this.findFinalFieldPutsWhileCollectingUnnecessaryStaticPuts(code, context, unnecessaryStaticPuts);
        if (finalFieldPuts.isEmpty()) {
            assert (unnecessaryStaticPuts.isEmpty());
            return ClassInitializerDefaultsResult.empty();
        }
        IdentityHashMap<DexEncodedField, DexValue> fieldsWithStaticValues = new IdentityHashMap<DexEncodedField, DexValue>();
        finalFieldPuts.forEach((field, put) -> {
            DexType fieldType = ((DexField)field.getReference()).type;
            Value value = put.value().getAliasedValue();
            if (!unnecessaryStaticPuts.contains(put)) return;
            if (fieldType == this.dexItemFactory.stringType) {
                fieldsWithStaticValues.put((DexEncodedField)field, this.getDexStringValue(value, context.getHolderType()));
                return;
            } else if (fieldType.isClassType() || fieldType.isArrayType()) {
                if (!value.isZero()) throw new Unreachable("Unexpected default value for field type " + fieldType + ".");
                fieldsWithStaticValues.put((DexEncodedField)field, DexValue.DexValueNull.NULL);
                return;
            } else {
                ConstNumber cnst = value.getConstInstruction().asConstNumber();
                if (fieldType == this.dexItemFactory.booleanType) {
                    fieldsWithStaticValues.put((DexEncodedField)field, DexValue.DexValueBoolean.create(cnst.getBooleanValue()));
                    return;
                } else if (fieldType == this.dexItemFactory.byteType) {
                    fieldsWithStaticValues.put((DexEncodedField)field, DexValue.DexValueByte.create((byte)cnst.getIntValue()));
                    return;
                } else if (fieldType == this.dexItemFactory.shortType) {
                    fieldsWithStaticValues.put((DexEncodedField)field, DexValue.DexValueShort.create((short)cnst.getIntValue()));
                    return;
                } else if (fieldType == this.dexItemFactory.intType) {
                    fieldsWithStaticValues.put((DexEncodedField)field, DexValue.DexValueInt.create(cnst.getIntValue()));
                    return;
                } else if (fieldType == this.dexItemFactory.longType) {
                    fieldsWithStaticValues.put((DexEncodedField)field, DexValue.DexValueLong.create(cnst.getLongValue()));
                    return;
                } else if (fieldType == this.dexItemFactory.floatType) {
                    fieldsWithStaticValues.put((DexEncodedField)field, DexValue.DexValueFloat.create(cnst.getFloatValue()));
                    return;
                } else if (fieldType == this.dexItemFactory.doubleType) {
                    fieldsWithStaticValues.put((DexEncodedField)field, DexValue.DexValueDouble.create(cnst.getDoubleValue()));
                    return;
                } else {
                    if (fieldType != this.dexItemFactory.charType) throw new Unreachable("Unexpected field type " + fieldType + ".");
                    fieldsWithStaticValues.put((DexEncodedField)field, DexValue.DexValueChar.create((char)cnst.getIntValue()));
                }
            }
        });
        if (!unnecessaryStaticPuts.isEmpty()) {
            Set<Instruction> unnecessaryInstructions = Sets.newIdentityHashSet();
            InstructionListIterator instructionIterator = code.instructionListIterator();
            while (instructionIterator.hasNext()) {
                Instruction instruction = (Instruction)instructionIterator.next();
                if (!instruction.isStaticPut() || !unnecessaryStaticPuts.contains(instruction.asStaticPut())) continue;
                Value inValue = instruction.asStaticPut().value();
                instructionIterator.removeOrReplaceByDebugLocalRead();
                if (inValue.numberOfAllUsers() > 0) continue;
                if (inValue.isConstString()) {
                    unnecessaryInstructions.add(inValue.definition);
                    continue;
                }
                if (inValue.isPhi() || !inValue.definition.isInvokeVirtual()) continue;
                unnecessaryInstructions.add(inValue.definition);
            }
            if (unnecessaryInstructions.size() > 0) {
                IteratorUtils.removeIf(code.instructionListIterator(), unnecessaryInstructions::contains);
            }
        }
        if (this.appView.enableWholeProgramOptimizations() && this.converter.isInWave()) {
            if (((AppInfo)this.appView.appInfo()).hasLiveness()) {
                AppView<AppInfoWithLiveness> appViewWithLiveness = this.appView.withLiveness();
                AppInfoWithLiveness appInfoWithLiveness = appViewWithLiveness.appInfo();
                Set candidates = finalFieldPuts.values().stream().filter(unnecessaryStaticPuts::contains).map(FieldInstruction::getField).map(appInfoWithLiveness::resolveField).map(FieldResolutionResult::getResolvedField).filter(appInfoWithLiveness::isStaticFieldWrittenOnlyInEnclosingStaticInitializer).map(field -> (DexField)field.getReference()).collect(Collectors.toSet());
                for (Instruction instruction : code.instructions()) {
                    StaticPut staticPutInstruction;
                    DexField field2;
                    DexEncodedField encodedField;
                    if (!instruction.isStaticPut() || (encodedField = appInfoWithLiveness.resolveField(field2 = (staticPutInstruction = instruction.asStaticPut()).getField()).getResolvedField()) == null) continue;
                    candidates.remove(encodedField.getReference());
                }
                feedback.modifyAppInfoWithLiveness(modifier -> candidates.forEach(modifier::removeWrittenField));
                ClassInitializerDefaultsOptimization classInitializerDefaultsOptimization = this;
                synchronized (classInitializerDefaultsOptimization) {
                    if (this.waveDoneAction == null) {
                        this.waveDoneAction = new WaveDoneAction(fieldsWithStaticValues);
                        this.converter.addWaveDoneAction(() -> {
                            this.waveDoneAction.execute();
                            this.waveDoneAction = null;
                        });
                    } else {
                        this.waveDoneAction.join(fieldsWithStaticValues);
                    }
                }
            } else assert (false);
        } else {
            fieldsWithStaticValues.forEach(DexEncodedField::setStaticValue);
        }
        return new ClassInitializerDefaultsResult(fieldsWithStaticValues);
    }

    private static class WaveDoneAction
    implements Action {
        private final Map<DexEncodedField, DexValue> fieldsWithStaticValues = new IdentityHashMap<DexEncodedField, DexValue>();

        WaveDoneAction(Map<DexEncodedField, DexValue> fieldsWithStaticValues) {
            this.fieldsWithStaticValues.putAll(fieldsWithStaticValues);
        }

        public synchronized void join(Map<DexEncodedField, DexValue> fieldsWithStaticValues) {
            this.fieldsWithStaticValues.putAll(fieldsWithStaticValues);
        }

        @Override
        public void execute() {
            this.fieldsWithStaticValues.forEach(DexEncodedField::setStaticValue);
        }
    }

    public static class ClassInitializerDefaultsResult {
        private static final ClassInitializerDefaultsResult EMPTY = new ClassInitializerDefaultsResult(null);
        private final Map<DexEncodedField, DexValue> fieldsWithStaticValues;

        ClassInitializerDefaultsResult(Map<DexEncodedField, DexValue> fieldsWithStaticValues) {
            this.fieldsWithStaticValues = fieldsWithStaticValues;
        }

        public static ClassInitializerDefaultsResult empty() {
            return EMPTY;
        }

        public void forEachOptimizedField(BiConsumer<DexEncodedField, DexValue> consumer) {
            if (this.fieldsWithStaticValues != null) {
                this.fieldsWithStaticValues.forEach(consumer);
            }
        }

        public boolean hasStaticValue(DexEncodedField field) {
            if (field.isStatic()) {
                return this.fieldsWithStaticValues != null && this.fieldsWithStaticValues.containsKey(field) || field.getStaticValue() != null;
            }
            return false;
        }

        public DexValue getStaticValue(DexEncodedField field) {
            assert (this.hasStaticValue(field));
            assert (field.isStatic());
            if (this.fieldsWithStaticValues != null && this.fieldsWithStaticValues.containsKey(field)) {
                return this.fieldsWithStaticValues.get(field);
            }
            return field.getStaticValue();
        }
    }
}

