/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Iterators;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.CheckCast;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.CodeRewriter;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.Box;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;

public class DeadCodeRemover {
    private final AppView<?> appView;
    private final CodeRewriter codeRewriter;

    public DeadCodeRemover(AppView<?> appView, CodeRewriter codeRewriter) {
        this.appView = appView;
        this.codeRewriter = codeRewriter;
    }

    private static void updateWorklist(Queue<BasicBlock> worklist, Value value) {
        BasicBlock block = null;
        if (value.isPhi()) {
            block = value.asPhi().getBlock();
        } else if (value.definition.hasBlock()) {
            block = value.definition.getBlock();
        }
        if (block != null) {
            worklist.add(block);
        }
    }

    private static void updateWorklist(Queue<BasicBlock> worklist, Instruction instruction) {
        for (Value inValue : instruction.inValues()) {
            DeadCodeRemover.updateWorklist(worklist, inValue);
        }
        for (Value debugValue : instruction.getDebugValues()) {
            DeadCodeRemover.updateWorklist(worklist, debugValue);
        }
    }

    private void removeDeadPhis(Queue<BasicBlock> worklist, IRCode code, BasicBlock block) {
        Iterator<Phi> phiIt = block.getPhis().iterator();
        while (phiIt.hasNext()) {
            Phi phi = phiIt.next();
            if (!phi.isDead(this.appView, code)) continue;
            phiIt.remove();
            for (Value operand : phi.getOperands()) {
                operand.removePhiUser(phi);
                DeadCodeRemover.updateWorklist(worklist, operand);
            }
        }
    }

    private void removeDeadInstructions(Queue<BasicBlock> worklist, IRCode code, BasicBlock block) {
        InstructionListIterator iterator2 = block.listIterator(code, block.getInstructions().size());
        while (iterator2.hasPrevious()) {
            Value outValue;
            DeadInstructionResult deadInstructionResult;
            Instruction current = (Instruction)iterator2.previous();
            if (current.hasOutValue()) {
                CheckCast checkCast;
                if (current.isCheckCast() && !(checkCast = current.asCheckCast()).isRefiningStaticType(this.appView.options()) && checkCast.outValue().getLocalInfo() == checkCast.object().getLocalInfo()) {
                    checkCast.outValue().replaceUsers(checkCast.object());
                    checkCast.object().uniquePhiUsers().forEach(Phi::removeTrivialPhi);
                }
                if (current.isInvoke() && !current.outValue().isUsed()) {
                    current.setOutValue(null);
                }
                if (current.isStaticGet() && !current.outValue().isUsed() && this.appView.hasLiveness()) {
                    Box initClass = new Box();
                    if (iterator2.removeOrReplaceCurrentInstructionByInitClassIfPossible(this.appView.withLiveness(), code, current.asStaticGet().getField().getHolderType(), initClass::set)) {
                        if (!initClass.isSet()) continue;
                        current = (Instruction)iterator2.previous();
                        assert (current == initClass.get());
                    }
                }
            }
            if ((deadInstructionResult = current.canBeDeadCode(this.appView, code)).isNotDead()) continue;
            if (deadInstructionResult.isMaybeDead()) {
                boolean satisfied = true;
                for (Value valueRequiredToBeDead : deadInstructionResult.getValuesRequiredToBeDead()) {
                    if (valueRequiredToBeDead.isDead(this.appView, code)) continue;
                    satisfied = false;
                    break;
                }
                if (!satisfied) continue;
            }
            if ((outValue = current.outValue()) != null && !outValue.isDead(this.appView, code)) continue;
            DeadCodeRemover.updateWorklist(worklist, current);
            if (outValue != null) {
                outValue.clearUsers();
            }
            iterator2.removeOrReplaceByDebugLocalRead();
        }
    }

    private boolean removeUnneededCatchHandlers(IRCode code) {
        boolean mayHaveIntroducedUnreachableBlocks = false;
        for (BasicBlock block : code.blocks) {
            if (!block.hasCatchHandlers()) continue;
            if (block.canThrow()) {
                Collection<CatchHandlers.CatchHandler<BasicBlock>> deadCatchHandlers;
                if (!this.appView.enableWholeProgramOptimizations() || (deadCatchHandlers = this.getDeadCatchHandlers(block)).isEmpty()) continue;
                for (CatchHandlers.CatchHandler catchHandler : deadCatchHandlers) {
                    ((BasicBlock)catchHandler.target).unlinkCatchHandlerForGuard(catchHandler.guard);
                }
                mayHaveIntroducedUnreachableBlocks = true;
                continue;
            }
            CatchHandlers<BasicBlock> handlers = block.getCatchHandlers();
            for (BasicBlock basicBlock : handlers.getUniqueTargets()) {
                basicBlock.unlinkCatchHandler();
                mayHaveIntroducedUnreachableBlocks = true;
            }
        }
        if (mayHaveIntroducedUnreachableBlocks) {
            code.removeUnreachableBlocks();
        }
        assert (code.isConsistentGraph(this.appView));
        return mayHaveIntroducedUnreachableBlocks;
    }

    private Collection<CatchHandlers.CatchHandler<BasicBlock>> getDeadCatchHandlers(BasicBlock block) {
        AppInfoWithLiveness appInfoWithLiveness = ((AppInfo)this.appView.appInfo()).withLiveness();
        ImmutableList.Builder builder = ImmutableList.builder();
        CatchHandlers<BasicBlock> catchHandlers = block.getCatchHandlers();
        for (int i = 0; i < catchHandlers.size(); ++i) {
            DexProgramClass clazz;
            DexType guard = catchHandlers.getGuards().get(i);
            BasicBlock target = catchHandlers.getAllTargets().get(i);
            boolean isSubsumedByPreviousGuard = false;
            for (int j = 0; j < i; ++j) {
                DexType previousGuard = catchHandlers.getGuards().get(j);
                if (!this.appView.isSubtype(guard, previousGuard).isTrue()) continue;
                isSubsumedByPreviousGuard = true;
                break;
            }
            if (isSubsumedByPreviousGuard) {
                builder.add(new CatchHandlers.CatchHandler<BasicBlock>(guard, target));
                continue;
            }
            if (appInfoWithLiveness == null || (clazz = DexProgramClass.asProgramClassOrNull(this.appView.definitionFor(guard))) == null || appInfoWithLiveness.isInstantiatedDirectlyOrIndirectly(clazz)) continue;
            builder.add(new CatchHandlers.CatchHandler<BasicBlock>(guard, target));
        }
        return builder.build();
    }

    public void run(IRCode code, Timing timing) {
        timing.begin("Remove dead code");
        this.codeRewriter.rewriteMoveResult(code);
        ArrayDeque<BasicBlock> worklist = new ArrayDeque<BasicBlock>();
        do {
            worklist.addAll(code.topologicallySortedBlocks());
            while (!worklist.isEmpty()) {
                BasicBlock block = (BasicBlock)worklist.removeLast();
                this.removeDeadInstructions(worklist, code, block);
                this.removeDeadPhis(worklist, code, block);
            }
        } while (this.codeRewriter.simplifyIf(code).anySimplifications() || this.removeUnneededCatchHandlers(code));
        assert (code.isConsistentSSA(this.appView));
        timing.end();
    }

    public boolean verifyNoDeadCode(IRCode code) {
        assert (!this.codeRewriter.rewriteMoveResult(code));
        assert (!this.removeUnneededCatchHandlers(code));
        for (BasicBlock block : code.blocks) {
            assert (!block.hasDeadPhi(this.appView, code));
            for (Instruction instruction : block.getInstructions()) {
                assert (!instruction.isInvoke() || !instruction.hasOutValue() || instruction.outValue().hasAnyUsers());
                assert (!instruction.canBeDeadCode(this.appView, code).isDeadIfOutValueIsDead() || instruction.hasOutValue() && !instruction.outValue().isDead(this.appView, code));
            }
        }
        return true;
    }

    public static abstract class DeadInstructionResult {
        private static final DeadInstructionResult DEFINITELY_DEAD_INSTANCE = new DeadInstructionResult(){

            @Override
            public boolean isDeadIfOutValueIsDead() {
                return true;
            }
        };
        private static final DeadInstructionResult DEFINITELY_NOT_DEAD_INSTANCE = new DeadInstructionResult(){

            @Override
            public boolean isNotDead() {
                return true;
            }
        };

        public static DeadInstructionResult deadIfOutValueIsDead() {
            return DEFINITELY_DEAD_INSTANCE;
        }

        public static DeadInstructionResult notDead() {
            return DEFINITELY_NOT_DEAD_INSTANCE;
        }

        public static DeadInstructionResult deadIfInValueIsDead(final Value inValueRequiredToBeDead) {
            return new DeadInstructionResult(){

                @Override
                public boolean isMaybeDead() {
                    return true;
                }

                @Override
                public boolean isDeadIfInValueIsDead() {
                    return true;
                }

                @Override
                public Iterable<Value> getValuesRequiredToBeDead() {
                    return () -> Iterators.singletonIterator(inValueRequiredToBeDead);
                }
            };
        }

        public boolean isDeadIfInValueIsDead() {
            return false;
        }

        public boolean isDeadIfOutValueIsDead() {
            return false;
        }

        public boolean isNotDead() {
            return false;
        }

        public boolean isMaybeDead() {
            return false;
        }

        public Iterable<Value> getValuesRequiredToBeDead() {
            throw new Unreachable();
        }
    }
}

