/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.features.ClassToFeatureSplitMap;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.Code;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import com.android.tools.r8.ir.analysis.inlining.SimpleInliningConstraint;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.Monitor;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.MethodProcessor;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningOracle;
import com.android.tools.r8.ir.optimize.InliningStrategy;
import com.android.tools.r8.ir.optimize.inliner.InlinerUtils;
import com.android.tools.r8.ir.optimize.inliner.InliningIRProvider;
import com.android.tools.r8.ir.optimize.inliner.InliningReasonStrategy;
import com.android.tools.r8.ir.optimize.inliner.WhyAreYouNotInliningReporter;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.MainDexInfo;
import com.android.tools.r8.synthesis.SyntheticItems;
import com.android.tools.r8.utils.AndroidApiLevelUtils;
import com.android.tools.r8.utils.BooleanUtils;
import com.android.tools.r8.utils.InternalOptions;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Set;

public final class DefaultInliningOracle
implements InliningOracle,
InliningStrategy {
    private final AppView<AppInfoWithLiveness> appView;
    private final InternalOptions.InlinerOptions inlinerOptions;
    private final MainDexInfo mainDexInfo;
    private final ProgramMethod method;
    private final MethodProcessor methodProcessor;
    private final InliningReasonStrategy reasonStrategy;
    private int instructionAllowance;

    DefaultInliningOracle(AppView<AppInfoWithLiveness> appView, InliningReasonStrategy inliningReasonStrategy, ProgramMethod method, MethodProcessor methodProcessor, int inliningInstructionAllowance) {
        this.appView = appView;
        this.inlinerOptions = appView.options().inlinerOptions();
        this.reasonStrategy = inliningReasonStrategy;
        this.mainDexInfo = appView.appInfo().getMainDexInfo();
        this.method = method;
        this.methodProcessor = methodProcessor;
        this.instructionAllowance = inliningInstructionAllowance;
    }

    private boolean isSingleTargetInvalid(InvokeMethod invoke, ProgramMethod singleTarget, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        int arity;
        if (singleTarget == null) {
            throw new Unreachable("Unexpected attempt to inline invoke that does not have a single target");
        }
        if (((DexEncodedMethod)singleTarget.getDefinition()).isClassInitializer()) {
            throw new Unreachable("Unexpected attempt to invoke a class initializer (`" + singleTarget.toSourceString() + "`)");
        }
        if (!((DexEncodedMethod)singleTarget.getDefinition()).hasCode()) {
            whyAreYouNotInliningReporter.reportInlineeDoesNotHaveCode();
            return true;
        }
        int numberOfArguments = invoke.arguments().size() - BooleanUtils.intValue(invoke.isInvokeMethodWithReceiver());
        if (numberOfArguments != (arity = ((DexMethod)singleTarget.getReference()).getArity())) {
            whyAreYouNotInliningReporter.reportIncorrectArity(numberOfArguments, arity);
            return true;
        }
        return false;
    }

    private int getInliningInstructionLimitIncrement(InvokeMethod invoke, ProgramMethod candidate) {
        int instructionLimit = 0;
        BitSet hints = ((DexEncodedMethod)candidate.getDefinition()).getOptimizationInfo().getNonNullParamOrThrow();
        if (hints != null) {
            List<Value> arguments = invoke.arguments();
            for (int index = invoke.getFirstNonReceiverArgumentIndex(); index < arguments.size(); ++index) {
                Value argument = arguments.get(index);
                if (!argument.isArgument() && (!argument.getType().isReferenceType() || !argument.isNeverNull()) || !hints.get(index)) continue;
                instructionLimit += 4;
            }
        }
        if (this.appView.options().isGeneratingDex() && invoke.hasOutValue() && invoke.outValue().hasNonDebugUsers()) {
            ++instructionLimit;
        }
        return instructionLimit;
    }

    private boolean neverInline(InvokeMethod invoke, MethodResolutionResult.SingleResolutionResult resolutionResult, ProgramMethod singleTarget, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        AppInfoWithLiveness appInfo = this.appView.appInfo();
        DexMethod singleTargetReference = (DexMethod)singleTarget.getReference();
        if (!this.appView.getKeepInfo(singleTarget).isInliningAllowed(this.appView.options())) {
            whyAreYouNotInliningReporter.reportPinned();
            return true;
        }
        if (appInfo.noSideEffects.containsKey(invoke.getInvokedMethod()) || appInfo.noSideEffects.containsKey(resolutionResult.getResolvedMethod().getReference()) || appInfo.noSideEffects.containsKey(singleTargetReference)) {
            return !((DexEncodedMethod)singleTarget.getDefinition()).getOptimizationInfo().forceInline();
        }
        return !this.appView.testing().allowInliningOfSynthetics && this.appView.getSyntheticItems().isSyntheticClass(singleTarget.getHolder());
    }

    private boolean isTargetClassInitialized(InvokeStatic invoke, ProgramMethod context, ProgramMethod target, ClassInitializationAnalysis classInitializationAnalysis) {
        boolean targetIsGuaranteedToBeInitialized;
        if (this.appView.appInfo().isSubtype(context.getHolderType(), target.getHolderType())) {
            return true;
        }
        if (!((DexEncodedMethod)context.getDefinition()).isStatic() && (targetIsGuaranteedToBeInitialized = this.appView.withInitializedClassesInInstanceMethods(analysis -> analysis.isClassDefinitelyLoadedInInstanceMethod(target.getHolder(), context), false).booleanValue())) {
            return true;
        }
        if (classInitializationAnalysis.isClassDefinitelyLoadedBeforeInstruction(target.getHolderType(), invoke)) {
            return true;
        }
        if (!target.getHolder().classInitializationMayHaveSideEffectsInContext(this.appView, context)) {
            return true;
        }
        return this.appView.rootSet().bypassClinitForInlining.contains(target.getReference());
    }

    private boolean willExceedInstructionBudget(Inliner.InlineeWithReason inlinee, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        int numberOfInstructions = Inliner.numberOfInstructions(inlinee.code);
        if (this.instructionAllowance < Inliner.numberOfInstructions(inlinee.code)) {
            whyAreYouNotInliningReporter.reportWillExceedInstructionBudget(numberOfInstructions, this.instructionAllowance);
            return true;
        }
        return false;
    }

    private boolean willExceedMonitorEnterValuesBudget(IRCode code, InvokeMethod invoke, Inliner.InlineeWithReason inlinee, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        int threshold;
        if (!code.metadata().mayHaveMonitorInstruction()) {
            return false;
        }
        if (!inlinee.code.metadata().mayHaveMonitorInstruction()) {
            return false;
        }
        Set<DexType> constantMonitorEnterValues = Sets.newIdentityHashSet();
        Set<Value> nonConstantMonitorEnterValues = Sets.newIdentityHashSet();
        InlinerUtils.collectAllMonitorEnterValues(code, constantMonitorEnterValues, nonConstantMonitorEnterValues);
        if (constantMonitorEnterValues.isEmpty() && nonConstantMonitorEnterValues.isEmpty()) {
            return false;
        }
        for (Monitor monitor : inlinee.code.instructions(Instruction::isMonitorEnter)) {
            Value monitorEnterValue = monitor.object().getAliasedValue();
            if (monitorEnterValue.isDefinedByInstructionSatisfying(Instruction::isArgument)) {
                monitorEnterValue = invoke.arguments().get(monitorEnterValue.definition.asArgument().getIndex()).getAliasedValue();
            }
            InlinerUtils.addMonitorEnterValue(monitorEnterValue, constantMonitorEnterValues, nonConstantMonitorEnterValues);
        }
        int numberOfMonitorEnterValuesAfterInlining = constantMonitorEnterValues.size() + nonConstantMonitorEnterValues.size();
        if (numberOfMonitorEnterValuesAfterInlining > (threshold = this.inlinerOptions.inliningMonitorEnterValuesAllowance)) {
            whyAreYouNotInliningReporter.reportWillExceedMonitorEnterValuesBudget(numberOfMonitorEnterValuesAfterInlining, threshold);
            return true;
        }
        return false;
    }

    private boolean willExceedControlFlowResolutionBlocksBudget(Inliner.InlineeWithReason inlinee, BasicBlock block, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        int threshold;
        if (!block.hasCatchHandlers()) {
            return false;
        }
        int numberOfThrowingInstructionsInInlinee = 0;
        for (BasicBlock inlineeBlock : inlinee.code.blocks) {
            numberOfThrowingInstructionsInInlinee += inlineeBlock.numberOfThrowingInstructions();
        }
        int estimatedNumberOfControlFlowResolutionBlocks = numberOfThrowingInstructionsInInlinee * block.numberOfCatchHandlers();
        if (estimatedNumberOfControlFlowResolutionBlocks >= (threshold = this.inlinerOptions.inliningControlFlowResolutionBlocksThreshold)) {
            whyAreYouNotInliningReporter.reportPotentialExplosionInExceptionalControlFlowResolutionBlocks(estimatedNumberOfControlFlowResolutionBlocks, threshold);
            return true;
        }
        return false;
    }

    @Override
    public AppView<AppInfoWithLiveness> appView() {
        return this.appView;
    }

    @Override
    public boolean isForcedInliningOracle() {
        return false;
    }

    @Override
    public boolean passesInliningConstraints(InvokeMethod invoke, MethodResolutionResult.SingleResolutionResult resolutionResult, ProgramMethod singleTarget, Inliner.Reason reason, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        if (reason != Inliner.Reason.FORCE && !AndroidApiLevelUtils.isApiSafeForInlining(this.method, singleTarget, this.appView.options(), whyAreYouNotInliningReporter)) {
            return false;
        }
        if (((DexEncodedMethod)this.method.getDefinition()).isInstanceInitializer() && this.appView.options().isGeneratingClassFiles() && reason != Inliner.Reason.FORCE) {
            whyAreYouNotInliningReporter.reportNoInliningIntoConstructorsWhenGeneratingClassFiles();
            return false;
        }
        if (this.method.isStructurallyEqualTo(singleTarget)) {
            assert (!singleTarget.getOptimizationInfo().forceInline());
            whyAreYouNotInliningReporter.reportRecursiveMethod();
            return false;
        }
        if (reason != Inliner.Reason.FORCE && this.methodProcessor.isProcessedConcurrently(singleTarget)) {
            whyAreYouNotInliningReporter.reportProcessedConcurrently();
            return false;
        }
        SyntheticItems syntheticItems = this.appView.getSyntheticItems();
        ClassToFeatureSplitMap classToFeatureSplitMap = this.appView.appInfo().getClassToFeatureSplitMap();
        if (!classToFeatureSplitMap.isInSameFeatureOrBothInSameBase(singleTarget, this.method, syntheticItems) && !classToFeatureSplitMap.isInBase(singleTarget.getHolder(), syntheticItems)) {
            whyAreYouNotInliningReporter.reportInliningAcrossFeatureSplit();
            return false;
        }
        Set<Inliner.Reason> validInliningReasons = this.appView.testing().validInliningReasons;
        if (validInliningReasons != null && !validInliningReasons.contains((Object)reason)) {
            whyAreYouNotInliningReporter.reportInvalidInliningReason(reason, validInliningReasons);
            return false;
        }
        if (resolutionResult.isAccessibleFrom((ProgramDefinition)this.method, this.appView.appInfo()).isPossiblyFalse()) {
            whyAreYouNotInliningReporter.reportInaccessible();
            return false;
        }
        if (reason == Inliner.Reason.SIMPLE && !this.satisfiesRequirementsForSimpleInlining(invoke, singleTarget)) {
            whyAreYouNotInliningReporter.reportInlineeNotSimple();
            return false;
        }
        if (reason != Inliner.Reason.FORCE && this.mainDexInfo.disallowInliningIntoContext(this.appView, this.method, singleTarget, this.appView.getSyntheticItems())) {
            whyAreYouNotInliningReporter.reportInlineeRefersToClassesNotInMainDex();
            return false;
        }
        assert (reason != Inliner.Reason.FORCE || !this.mainDexInfo.disallowInliningIntoContext(this.appView, this.method, singleTarget, this.appView.getSyntheticItems()));
        return true;
    }

    public boolean satisfiesRequirementsForSimpleInlining(InvokeMethod invoke, ProgramMethod target) {
        int instructionLimit;
        Code code;
        boolean deterministic;
        boolean bl = deterministic = !this.methodProcessor.isProcessedConcurrently(target);
        if (deterministic && (code = ((DexEncodedMethod)target.getDefinition()).getCode()).estimatedSizeForInliningAtMost(instructionLimit = this.inlinerOptions.getSimpleInliningInstructionLimit() + this.getInliningInstructionLimitIncrement(invoke, target))) {
            return true;
        }
        SimpleInliningConstraint simpleInliningConstraint = ((DexEncodedMethod)target.getDefinition()).getOptimizationInfo().getSimpleInliningConstraint();
        return simpleInliningConstraint.isSatisfied(invoke);
    }

    @Override
    public ProgramMethod lookupSingleTarget(InvokeMethod invoke, ProgramMethod context) {
        return invoke.lookupSingleProgramTarget(this.appView, context);
    }

    @Override
    public Inliner.InlineResult computeInlining(IRCode code, InvokeMethod invoke, MethodResolutionResult.SingleResolutionResult resolutionResult, ProgramMethod singleTarget, ProgramMethod context, ClassInitializationAnalysis classInitializationAnalysis, InliningIRProvider inliningIRProvider, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        if (this.isSingleTargetInvalid(invoke, singleTarget, whyAreYouNotInliningReporter)) {
            return null;
        }
        if (this.neverInline(invoke, resolutionResult, singleTarget, whyAreYouNotInliningReporter)) {
            if (((DexEncodedMethod)singleTarget.getDefinition()).getOptimizationInfo().forceInline()) {
                throw new Unreachable("Unexpected attempt to force inline method `" + singleTarget.toSourceString() + "` in `" + context.toSourceString() + "`.");
            }
            return null;
        }
        Inliner.Reason reason = this.reasonStrategy.computeInliningReason(invoke, singleTarget, context, this, this.methodProcessor);
        if (reason == Inliner.Reason.NEVER) {
            return null;
        }
        if (reason == Inliner.Reason.SIMPLE && !((DexEncodedMethod)singleTarget.getDefinition()).isProcessed() && this.methodProcessor.isPrimaryMethodProcessor()) {
            return new Inliner.RetryAction();
        }
        if (!((DexEncodedMethod)singleTarget.getDefinition()).isInliningCandidate(this.method, reason, (AppInfoWithClassHierarchy)this.appView.appInfo(), whyAreYouNotInliningReporter)) {
            return null;
        }
        if (!this.passesInliningConstraints(invoke, resolutionResult, singleTarget, reason, whyAreYouNotInliningReporter)) {
            return null;
        }
        Inliner.InlineAction action = invoke.computeInlining(singleTarget, reason, this, classInitializationAnalysis, whyAreYouNotInliningReporter);
        if (action == null) {
            return null;
        }
        if (!this.setDowncastTypeIfNeeded(this.appView, action, invoke, singleTarget, context)) {
            return null;
        }
        if (((DexEncodedMethod)singleTarget.getDefinition()).isInstanceInitializer() && !this.canInlineInstanceInitializer(code, invoke.asInvokeDirect(), singleTarget, inliningIRProvider, whyAreYouNotInliningReporter)) {
            return null;
        }
        return action;
    }

    public Inliner.InlineAction computeForInvokeWithReceiver(InvokeMethodWithReceiver invoke, ProgramMethod singleTarget, Inliner.Reason reason, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        Value receiver = invoke.getReceiver();
        if (receiver.getType().isDefinitelyNull()) {
            whyAreYouNotInliningReporter.reportReceiverDefinitelyNull();
            return null;
        }
        Inliner.InlineAction action = new Inliner.InlineAction(singleTarget, invoke, reason);
        if (receiver.getType().isNullable()) {
            assert (!receiver.getType().isDefinitelyNull());
            if (!this.inlinerOptions.enableInliningOfInvokesWithNullableReceivers) {
                whyAreYouNotInliningReporter.reportReceiverMaybeNull();
                return null;
            }
        }
        return action;
    }

    public Inliner.InlineAction computeForInvokeStatic(InvokeStatic invoke, ProgramMethod singleTarget, Inliner.Reason reason, ClassInitializationAnalysis classInitializationAnalysis, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        Inliner.InlineAction action = new Inliner.InlineAction(singleTarget, invoke, reason);
        if (this.isTargetClassInitialized(invoke, this.method, singleTarget, classInitializationAnalysis)) {
            return action;
        }
        if (this.appView.canUseInitClass() && this.inlinerOptions.enableInliningOfInvokesWithClassInitializationSideEffects) {
            action.setShouldEnsureStaticInitialization();
            return action;
        }
        whyAreYouNotInliningReporter.reportMustTriggerClassInitialization();
        return null;
    }

    @Override
    public boolean allowInliningOfInvokeInInlinee(Inliner.InlineAction action, int inliningDepth, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        assert (inliningDepth > 0);
        if (action.reason.mustBeInlined()) {
            return true;
        }
        int threshold = this.inlinerOptions.applyInliningToInlineeMaxDepth;
        if (inliningDepth <= threshold) {
            return true;
        }
        whyAreYouNotInliningReporter.reportWillExceedMaxInliningDepth(inliningDepth, threshold);
        return false;
    }

    @Override
    public boolean canInlineInstanceInitializer(IRCode code, InvokeDirect invoke, ProgramMethod singleTarget, InliningIRProvider inliningIRProvider, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        IRCode inlinee = inliningIRProvider.getInliningIR(invoke, singleTarget);
        DexType callerMethodHolder = this.method.getHolderType();
        DexType calleeMethodHolder = singleTarget.getHolderType();
        if (((DexEncodedMethod)this.method.getDefinition()).isInstanceInitializer() && callerMethodHolder == calleeMethodHolder && invoke.getReceiver() == code.getThis()) {
            inliningIRProvider.cacheInliningIR(invoke, inlinee);
            return true;
        }
        Value thisValue = inlinee.entryBlock().entry().asArgument().outValue();
        ArrayList<InvokeDirect> initCallsOnThis = new ArrayList<InvokeDirect>();
        for (Instruction instruction : inlinee.instructions()) {
            if (instruction.isInvokeDirect()) {
                Value receiver;
                InvokeDirect initCall = instruction.asInvokeDirect();
                DexMethod invokedMethod = initCall.getInvokedMethod();
                if (!this.appView.dexItemFactory().isConstructor(invokedMethod) || (receiver = initCall.getReceiver().getAliasedValue()) != thisValue) continue;
                if (calleeMethodHolder != invokedMethod.holder) {
                    whyAreYouNotInliningReporter.reportUnsafeConstructorInliningDueToIndirectConstructorCall(initCall);
                    return false;
                }
                initCallsOnThis.add(initCall);
                continue;
            }
            if (!instruction.isInstancePut()) continue;
            InstancePut instancePut = instruction.asInstancePut();
            DexField field = instancePut.getField();
            DexEncodedField target = this.appView.appInfo().lookupInstanceTarget(field);
            if (target != null && !target.accessFlags.isFinal()) continue;
            whyAreYouNotInliningReporter.reportUnsafeConstructorInliningDueToFinalFieldAssignment(instancePut);
            return false;
        }
        int markingColor = inlinee.reserveMarkingColor();
        for (InvokeDirect initCallOnThis : initCallsOnThis) {
            BasicBlock block = initCallOnThis.getBlock();
            for (Instruction instruction : block.instructionsBefore(initCallOnThis)) {
                for (Value inValue : instruction.inValues()) {
                    Value root = inValue.getAliasedValue();
                    if (root != thisValue) continue;
                    inlinee.returnMarkingColor(markingColor);
                    whyAreYouNotInliningReporter.reportUnsafeConstructorInliningDueToUninitializedObjectUse(instruction);
                    return false;
                }
            }
            for (BasicBlock predecessor : block.getPredecessors()) {
                inlinee.markTransitivePredecessors(predecessor, markingColor);
            }
        }
        for (BasicBlock block : inlinee.blocks) {
            if (!block.isMarked(markingColor)) continue;
            for (Instruction instruction : block.getInstructions()) {
                for (Value inValue : instruction.inValues()) {
                    Value root = inValue.getAliasedValue();
                    if (root != thisValue) continue;
                    inlinee.returnMarkingColor(markingColor);
                    whyAreYouNotInliningReporter.reportUnsafeConstructorInliningDueToUninitializedObjectUse(instruction);
                    return false;
                }
            }
        }
        inlinee.returnMarkingColor(markingColor);
        inliningIRProvider.cacheInliningIR(invoke, inlinee);
        return true;
    }

    @Override
    public boolean stillHasBudget(Inliner.InlineAction action, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        boolean stillHasBudget;
        if (action.reason.mustBeInlined()) {
            return true;
        }
        boolean bl = stillHasBudget = this.instructionAllowance > 0;
        if (!stillHasBudget) {
            whyAreYouNotInliningReporter.reportInstructionBudgetIsExceeded();
        }
        return stillHasBudget;
    }

    @Override
    public boolean willExceedBudget(IRCode code, InvokeMethod invoke, Inliner.InlineeWithReason inlinee, BasicBlock block, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        if (inlinee.reason.mustBeInlined()) {
            return false;
        }
        return this.willExceedInstructionBudget(inlinee, whyAreYouNotInliningReporter) || this.willExceedMonitorEnterValuesBudget(code, invoke, inlinee, whyAreYouNotInliningReporter) || this.willExceedControlFlowResolutionBlocksBudget(inlinee, block, whyAreYouNotInliningReporter);
    }

    @Override
    public void markInlined(Inliner.InlineeWithReason inlinee) {
        this.instructionAllowance -= Inliner.numberOfInstructions(inlinee.code);
    }

    @Override
    public ClassTypeElement getReceiverTypeOrDefault(InvokeMethod invoke, ClassTypeElement defaultValue) {
        return defaultValue;
    }
}

