/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.JumpInstruction;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.ArrayList;

public class DynamicTypeOptimization {
    private final AppView<AppInfoWithLiveness> appView;

    public DynamicTypeOptimization(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
    }

    public DynamicType computeDynamicReturnType(ProgramMethod method, IRCode code) {
        assert (method.getReturnType().isReferenceType());
        ArrayList<DynamicType> returnedTypes = new ArrayList<DynamicType>();
        for (BasicBlock block : code.getBlocks()) {
            JumpInstruction exitInstruction = block.exit();
            if (!exitInstruction.isReturn()) continue;
            Value returnValue = exitInstruction.asReturn().returnValue();
            returnedTypes.add(returnValue.getDynamicType(this.appView));
        }
        return DynamicType.join(this.appView, returnedTypes);
    }
}

