/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningOracle;
import com.android.tools.r8.ir.optimize.InliningStrategy;
import com.android.tools.r8.ir.optimize.inliner.InliningIRProvider;
import com.android.tools.r8.ir.optimize.inliner.WhyAreYouNotInliningReporter;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Map;

final class ForcedInliningOracle
implements InliningOracle,
InliningStrategy {
    private final AppView<AppInfoWithLiveness> appView;
    private final ProgramMethod method;
    private final Map<? extends InvokeMethod, Inliner.InliningInfo> invokesToInline;

    ForcedInliningOracle(AppView<AppInfoWithLiveness> appView, ProgramMethod method, Map<? extends InvokeMethod, Inliner.InliningInfo> invokesToInline) {
        this.appView = appView;
        this.method = method;
        this.invokesToInline = invokesToInline;
    }

    private Inliner.InlineAction computeForInvoke(InvokeMethod invoke, MethodResolutionResult.SingleResolutionResult resolutionResult, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        Inliner.InliningInfo info = this.invokesToInline.get(invoke);
        if (info == null) {
            return null;
        }
        assert (this.method.getDefinition() != info.target.getDefinition());
        assert (this.passesInliningConstraints(invoke, resolutionResult, info.target, Inliner.Reason.FORCE, whyAreYouNotInliningReporter));
        return new Inliner.InlineAction(info.target, invoke, Inliner.Reason.FORCE);
    }

    @Override
    public AppView<AppInfoWithLiveness> appView() {
        return this.appView;
    }

    @Override
    public boolean isForcedInliningOracle() {
        return true;
    }

    @Override
    public boolean passesInliningConstraints(InvokeMethod invoke, MethodResolutionResult.SingleResolutionResult resolutionResult, ProgramMethod candidate, Inliner.Reason reason, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        return true;
    }

    @Override
    public ProgramMethod lookupSingleTarget(InvokeMethod invoke, ProgramMethod context) {
        Inliner.InliningInfo info = this.invokesToInline.get(invoke);
        if (info != null) {
            return info.target;
        }
        return invoke.lookupSingleProgramTarget(this.appView, context);
    }

    @Override
    public Inliner.InlineResult computeInlining(IRCode code, InvokeMethod invoke, MethodResolutionResult.SingleResolutionResult resolutionResult, ProgramMethod singleTarget, ProgramMethod context, ClassInitializationAnalysis classInitializationAnalysis, InliningIRProvider inliningIRProvider, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        Inliner.InlineAction action = this.computeForInvoke(invoke, resolutionResult, whyAreYouNotInliningReporter);
        if (action == null) {
            return null;
        }
        if (!this.setDowncastTypeIfNeeded(this.appView, action, invoke, singleTarget, context)) {
            return null;
        }
        return action;
    }

    @Override
    public boolean allowInliningOfInvokeInInlinee(Inliner.InlineAction action, int inliningDepth, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        return false;
    }

    @Override
    public boolean canInlineInstanceInitializer(IRCode code, InvokeDirect invoke, ProgramMethod singleTarget, InliningIRProvider inliningIRProvider, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        return true;
    }

    @Override
    public boolean stillHasBudget(Inliner.InlineAction action, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        return true;
    }

    @Override
    public boolean willExceedBudget(IRCode code, InvokeMethod invoke, Inliner.InlineeWithReason inlinee, BasicBlock block, WhyAreYouNotInliningReporter whyAreYouNotInliningReporter) {
        return false;
    }

    @Override
    public void markInlined(Inliner.InlineeWithReason inlinee) {
    }

    @Override
    public ClassTypeElement getReceiverTypeOrDefault(InvokeMethod invoke, ClassTypeElement defaultValue) {
        assert (invoke.isInvokeMethodWithReceiver());
        Inliner.InliningInfo info = this.invokesToInline.get(invoke.asInvokeMethodWithReceiver());
        assert (info != null);
        if (info.receiverClass != null) {
            return info.receiverClass.getType().toTypeElement(this.appView).asClassType();
        }
        return defaultValue;
    }
}

