/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.androidapi.AvailableApiExceptions;
import com.android.tools.r8.com.google.common.base.Predicates;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AccessFlags;
import com.android.tools.r8.graph.AppInfo;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.NestMemberClassAttribute;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.ClassInitializationAnalysis;
import com.android.tools.r8.ir.analysis.proto.ProtoInliningReasonStrategy;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.ConstClass;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InitClass;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.Monitor;
import com.android.tools.r8.ir.code.MoveException;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Throw;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.conversion.LensCodeRewriter;
import com.android.tools.r8.ir.conversion.MethodProcessor;
import com.android.tools.r8.ir.conversion.PostMethodProcessor;
import com.android.tools.r8.ir.optimize.AssumeInserter;
import com.android.tools.r8.ir.optimize.AssumeRemover;
import com.android.tools.r8.ir.optimize.DefaultInliningOracle;
import com.android.tools.r8.ir.optimize.ForcedInliningOracle;
import com.android.tools.r8.ir.optimize.InliningConstraints;
import com.android.tools.r8.ir.optimize.InliningOracle;
import com.android.tools.r8.ir.optimize.InliningStrategy;
import com.android.tools.r8.ir.optimize.MemberValuePropagation;
import com.android.tools.r8.ir.optimize.MultiCallerInliner;
import com.android.tools.r8.ir.optimize.NestUtils;
import com.android.tools.r8.ir.optimize.SimpleDominatingEffectAnalysis;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackIgnore;
import com.android.tools.r8.ir.optimize.inliner.DefaultInliningReasonStrategy;
import com.android.tools.r8.ir.optimize.inliner.InliningIRProvider;
import com.android.tools.r8.ir.optimize.inliner.InliningReasonStrategy;
import com.android.tools.r8.ir.optimize.inliner.NopWhyAreYouNotInliningReporter;
import com.android.tools.r8.ir.optimize.inliner.WhyAreYouNotInliningReporter;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.MainDexInfo;
import com.android.tools.r8.utils.ConsumerUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.IteratorUtils;
import com.android.tools.r8.utils.ListUtils;
import com.android.tools.r8.utils.MapUtils;
import com.android.tools.r8.utils.SetUtils;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.collections.LongLivedProgramMethodSetBuilder;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public class Inliner {
    protected final AppView<AppInfoWithLiveness> appView;
    private final IRConverter converter;
    private final LensCodeRewriter lensCodeRewriter;
    final MainDexInfo mainDexInfo;
    private final LongLivedProgramMethodSetBuilder<ProgramMethodSet> singleInlineCallers;
    private final MultiCallerInliner multiCallerInliner;
    private final Map<DexProgramClass, ProgramMethodSet> singleCallerInlinedMethodsInWave = new ConcurrentHashMap<DexProgramClass, ProgramMethodSet>();
    private final Set<DexMethod> singleCallerInlinedPrunedMethodsForTesting = Sets.newIdentityHashSet();
    private final AvailableApiExceptions availableApiExceptions;

    public Inliner(AppView<AppInfoWithLiveness> appView, IRConverter converter, LensCodeRewriter lensCodeRewriter) {
        this.appView = appView;
        this.converter = converter;
        this.lensCodeRewriter = lensCodeRewriter;
        this.mainDexInfo = appView.appInfo().getMainDexInfo();
        this.multiCallerInliner = new MultiCallerInliner(appView);
        this.singleInlineCallers = LongLivedProgramMethodSetBuilder.createConcurrentForIdentitySet(appView.graphLens());
        this.availableApiExceptions = appView.options().canHaveDalvikCatchHandlerVerificationBug() ? new AvailableApiExceptions(appView.options()) : null;
    }

    private ConstraintWithTarget instructionAllowedForInlining(Instruction instruction, InliningConstraints inliningConstraints, ProgramMethod context) {
        ConstraintWithTarget result = instruction.inliningConstraint(inliningConstraints, context);
        if (result == ConstraintWithTarget.NEVER && instruction.isDebugInstruction()) {
            return ConstraintWithTarget.ALWAYS;
        }
        return result;
    }

    private boolean returnsIntAsBoolean(IRCode code, ProgramMethod method) {
        DexType returnType = ((DexEncodedMethod)method.getDefinition()).returnType();
        for (BasicBlock basicBlock : code.blocks) {
            InstructionIterator instructionIterator = basicBlock.iterator();
            while (instructionIterator.hasNext()) {
                Instruction instruction = (Instruction)instructionIterator.nextUntil(Instruction::isReturn);
                if (instruction == null || !returnType.isBooleanType() || instruction.inValues().get(0).knownToBeBoolean()) continue;
                return true;
            }
        }
        return false;
    }

    static int numberOfInstructions(IRCode code) {
        int numberOfInstructions = 0;
        for (BasicBlock block : code.blocks) {
            for (Instruction instruction : block.getInstructions()) {
                assert (!instruction.isDebugInstruction());
                if (instruction.isArgument() || instruction.isAssume() || instruction.isGoto() && instruction.asGoto().getTarget().getPredecessors().size() == 1 || instruction.isReturn()) continue;
                ++numberOfInstructions;
            }
        }
        return numberOfInstructions;
    }

    private void performInliningImpl(InliningStrategy strategy, InliningOracle oracle, ProgramMethod context, IRCode code, OptimizationFeedback feedback, InliningIRProvider inliningIRProvider, MethodProcessor methodProcessor, Timing timing) {
        AssumeRemover assumeRemover = new AssumeRemover(this.appView, code);
        Set<BasicBlock> blocksToRemove = Sets.newIdentityHashSet();
        BasicBlockIterator blockIterator = code.listIterator();
        ClassInitializationAnalysis classInitializationAnalysis = new ClassInitializationAnalysis(this.appView, code);
        ArrayDeque<BasicBlock> inlineeStack = new ArrayDeque<BasicBlock>();
        InternalOptions.InlinerOptions options = this.appView.options().inlinerOptions();
        while (blockIterator.hasNext()) {
            BasicBlock block = blockIterator.next();
            if (!inlineeStack.isEmpty() && inlineeStack.peekFirst() == block) {
                inlineeStack.pop();
            }
            if (blocksToRemove.contains(block)) continue;
            InstructionListIterator iterator2 = block.listIterator(code);
            while (iterator2.hasNext()) {
                Instruction current = (Instruction)iterator2.next();
                if (current.isInvokeMethod()) {
                    InvokeMethod invoke = current.asInvokeMethod();
                    MethodResolutionResult.SingleResolutionResult resolutionResult = this.appView.appInfo().resolveMethod(invoke.getInvokedMethod(), invoke.getInterfaceBit()).asSingleResolution();
                    if (resolutionResult == null || resolutionResult.isAccessibleFrom((ProgramDefinition)context, this.appView).isPossiblyFalse() || this.tryInlineMethodWithoutSideEffects(code, iterator2, invoke, resolutionResult.getResolutionPair(), assumeRemover)) continue;
                    ProgramMethod singleTarget = oracle.lookupSingleTarget(invoke, context);
                    if (singleTarget == null) {
                        WhyAreYouNotInliningReporter.handleInvokeWithUnknownTarget(invoke, this.appView, context);
                        continue;
                    }
                    DexEncodedMethod singleTargetMethod = (DexEncodedMethod)singleTarget.getDefinition();
                    WhyAreYouNotInliningReporter whyAreYouNotInliningReporter = oracle.isForcedInliningOracle() ? NopWhyAreYouNotInliningReporter.getInstance() : WhyAreYouNotInliningReporter.createFor(singleTarget, this.appView, context);
                    InlineResult inlineResult = oracle.computeInlining(code, invoke, resolutionResult, singleTarget, context, classInitializationAnalysis, inliningIRProvider, whyAreYouNotInliningReporter);
                    if (inlineResult == null) {
                        assert (((WhyAreYouNotInliningReporter)whyAreYouNotInliningReporter).unsetReasonHasBeenReportedFlag());
                        continue;
                    }
                    if (inlineResult.isRetryAction()) {
                        this.enqueueMethodForReprocessing(context);
                        continue;
                    }
                    InlineAction action = inlineResult.asInlineAction();
                    if (action.reason == Reason.MULTI_CALLER_CANDIDATE) {
                        assert (methodProcessor.isPrimaryMethodProcessor());
                        continue;
                    }
                    if (!inlineeStack.isEmpty() && !strategy.allowInliningOfInvokeInInlinee(action, inlineeStack.size(), whyAreYouNotInliningReporter)) {
                        assert (((WhyAreYouNotInliningReporter)whyAreYouNotInliningReporter).unsetReasonHasBeenReportedFlag());
                        continue;
                    }
                    if (!strategy.stillHasBudget(action, whyAreYouNotInliningReporter)) {
                        assert (((WhyAreYouNotInliningReporter)whyAreYouNotInliningReporter).unsetReasonHasBeenReportedFlag());
                        continue;
                    }
                    InlineeWithReason inlinee = action.buildInliningIR(this.appView, invoke, context, inliningIRProvider, this.lensCodeRewriter);
                    if (strategy.willExceedBudget(code, invoke, inlinee, block, whyAreYouNotInliningReporter)) {
                        assert (((WhyAreYouNotInliningReporter)whyAreYouNotInliningReporter).unsetReasonHasBeenReportedFlag());
                        continue;
                    }
                    assert (((DexEncodedMethod)singleTarget.getDefinition()).isProcessed());
                    Value outValue = invoke.outValue();
                    if (outValue != null) {
                        assumeRemover.markAssumeDynamicTypeUsersForRemoval(outValue);
                    }
                    boolean inlineeMayHaveInvokeMethod = inlinee.code.metadata().mayHaveInvokeMethod();
                    iterator2.previous();
                    strategy.markInlined(inlinee);
                    iterator2.inlineInvoke(this.appView, code, inlinee.code, blockIterator, blocksToRemove, action.getDowncastClass());
                    if (inlinee.reason == Reason.SINGLE_CALLER) {
                        assert (this.converter.isInWave());
                        feedback.markInlinedIntoSingleCallSite(singleTargetMethod);
                        if (this.singleCallerInlinedMethodsInWave.isEmpty()) {
                            this.converter.addWaveDoneAction(this::onWaveDone);
                        }
                        this.singleCallerInlinedMethodsInWave.computeIfAbsent(singleTarget.getHolder(), MapUtils.ignoreKey(ProgramMethodSet::createConcurrent)).add(singleTarget);
                    }
                    classInitializationAnalysis.notifyCodeHasChanged();
                    this.postProcessInlineeBlocks(code, blockIterator, block, blocksToRemove, timing);
                    if (((DexEncodedMethod)context.getDefinition()).isBridge() && !inlinee.code.method().isBridge()) {
                        ((DexEncodedMethod)context.getDefinition()).accessFlags.demoteFromBridge();
                    }
                    if (((DexEncodedMethod)context.getDefinition()).accessFlags.isSynthetic() && !inlinee.code.method().accessFlags.isSynthetic()) {
                        ((DexEncodedMethod)context.getDefinition()).accessFlags.demoteFromSynthetic();
                    }
                    ((DexEncodedMethod)context.getDefinition()).copyMetadata(this.appView, singleTargetMethod);
                    if (!inlineeMayHaveInvokeMethod || !options.applyInliningToInlinee || inlineeStack.size() + 1 > options.applyInliningToInlineeMaxDepth && this.appView.appInfo().hasNoAlwaysInlineMethods()) continue;
                    BasicBlock inlineeEnd = IteratorUtils.peekNext(blockIterator);
                    inlineeStack.push(inlineeEnd);
                    IteratorUtils.previousUntil(blockIterator, previous -> previous == block);
                    blockIterator.next();
                    continue;
                }
                if (!current.isAssume()) continue;
                assumeRemover.removeIfMarked(current.asAssume(), iterator2);
            }
        }
        assert (inlineeStack.isEmpty());
        assumeRemover.removeMarkedInstructions(blocksToRemove).finish();
        classInitializationAnalysis.finish();
        code.removeBlocks(blocksToRemove);
        code.removeAllDeadAndTrivialPhis();
        assert (code.isConsistentSSA(this.appView));
    }

    private boolean tryInlineMethodWithoutSideEffects(IRCode code, InstructionListIterator iterator2, InvokeMethod invoke, DexClassAndMethod resolvedMethod, AssumeRemover assumeRemover) {
        if (invoke.isInvokeMethodWithReceiver()) {
            if (!iterator2.replaceCurrentInstructionByNullCheckIfPossible(this.appView, code.context())) {
                return false;
            }
        } else if (invoke.isInvokeStatic()) {
            if (!iterator2.removeOrReplaceCurrentInstructionByInitClassIfPossible(this.appView, code, resolvedMethod.getHolderType())) {
                return false;
            }
        } else {
            return false;
        }
        assumeRemover.markUnusedAssumeValuesForRemoval(invoke.arguments());
        return true;
    }

    private boolean containsPotentialCatchHandlerVerificationError(IRCode code) {
        if (this.availableApiExceptions == null) {
            assert (!this.appView.options().canHaveDalvikCatchHandlerVerificationBug());
            return false;
        }
        for (BasicBlock block : code.blocks) {
            for (CatchHandlers.CatchHandler<BasicBlock> catchHandler : block.getCatchHandlers()) {
                DexClass clazz = this.appView.definitionFor(catchHandler.guard);
                if (clazz != null && !clazz.isLibraryClass() || !this.availableApiExceptions.canCauseVerificationError(catchHandler.guard)) continue;
                return true;
            }
        }
        return false;
    }

    private DexProgramClass getDowncastTypeIfNeeded(InliningStrategy strategy, InvokeMethod invoke, ProgramMethod target) {
        if (invoke.isInvokeMethodWithReceiver()) {
            ClassTypeElement targetType;
            Value receiver = invoke.asInvokeMethodWithReceiver().getReceiver();
            if (!receiver.getType().isClassType()) {
                return target.getHolder();
            }
            ClassTypeElement receiverType = strategy.getReceiverTypeOrDefault(invoke, receiver.getType().asClassType());
            if (!receiverType.lessThanOrEqualUpToNullability(targetType = target.getHolderType().toTypeElement(this.appView).asClassType(), this.appView)) {
                return target.getHolder();
            }
        }
        return null;
    }

    private void postProcessInlineeBlocks(IRCode code, BasicBlockIterator blockIterator, BasicBlock block, Set<BasicBlock> blocksToRemove, Timing timing) {
        BasicBlock state = IteratorUtils.peekNext(blockIterator);
        Set<BasicBlock> inlineeBlocks = Sets.newIdentityHashSet();
        this.rewindBlockIterator(blockIterator, block, inlineeBlock -> {
            if (!blocksToRemove.contains(inlineeBlock)) {
                inlineeBlocks.add((BasicBlock)inlineeBlock);
            }
        });
        this.applyMemberValuePropagationToInlinee(code, blockIterator, inlineeBlocks);
        this.rewindBlockIterator(blockIterator, block);
        this.insertAssumeInstructions(code, blockIterator, inlineeBlocks, timing);
        this.rewindBlockIterator(blockIterator, state);
    }

    private void insertAssumeInstructions(IRCode code, BasicBlockIterator blockIterator, Set<BasicBlock> inlineeBlocks, Timing timing) {
        new AssumeInserter(this.appView).insertAssumeInstructionsInBlocks(code, blockIterator, inlineeBlocks::contains, timing);
        assert (!blockIterator.hasNext());
    }

    private void applyMemberValuePropagationToInlinee(IRCode code, ListIterator<BasicBlock> blockIterator, Set<BasicBlock> inlineeBlocks) {
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        new MemberValuePropagation(this.appView).run(code, blockIterator, affectedValues, inlineeBlocks::contains);
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appView).narrowing(affectedValues);
        }
        assert (!blockIterator.hasNext());
    }

    private void rewindBlockIterator(ListIterator<BasicBlock> blockIterator, BasicBlock callerBlock) {
        this.rewindBlockIterator(blockIterator, callerBlock, ConsumerUtils.emptyConsumer());
    }

    private void rewindBlockIterator(ListIterator<BasicBlock> blockIterator, BasicBlock callerBlock, Consumer<BasicBlock> consumer) {
        BasicBlock previous;
        while (blockIterator.hasPrevious() && (previous = blockIterator.previous()) != callerBlock) {
            consumer.accept(previous);
        }
        assert (IteratorUtils.peekNext(blockIterator) == callerBlock);
    }

    private void onWaveDone() {
        this.singleCallerInlinedMethodsInWave.forEach((clazz, singleCallerInlinedMethodsForClass) -> {
            singleCallerInlinedMethodsForClass.removeIf(method -> {
                if (((DexEncodedMethod)method.getDefinition()).belongsToVirtualPool() || ((DexEncodedMethod)method.getDefinition()).getGenericSignature().hasSignature()) {
                    method.convertToAbstractOrThrowNullMethod(this.appView);
                    this.converter.onMethodCodePruned((ProgramMethod)method);
                    return true;
                }
                return false;
            });
            if (!singleCallerInlinedMethodsForClass.isEmpty()) {
                clazz.getMethodCollection().removeMethods(singleCallerInlinedMethodsForClass.toDefinitionSet(SetUtils::newIdentityHashSet));
                for (ProgramMethod method2 : singleCallerInlinedMethodsForClass) {
                    this.converter.onMethodPruned(method2);
                    this.singleCallerInlinedPrunedMethodsForTesting.add((DexMethod)method2.getReference());
                }
            }
        });
        this.singleCallerInlinedMethodsInWave.clear();
    }

    public static boolean verifyAllSingleCallerMethodsHaveBeenPruned(AppView<AppInfoWithLiveness> appView) {
        for (DexProgramClass clazz : appView.appInfo().classesWithDeterministicOrder()) {
            clazz.forEachProgramMethodMatching(method -> method.getOptimizationInfo().hasBeenInlinedIntoSingleCallSite(), method -> {
                assert (!((DexEncodedMethod)method.getDefinition()).hasCode() || !method.canBeConvertedToAbstractMethod(appView));
            });
        }
        return true;
    }

    public static boolean verifyAllMultiCallerInlinedMethodsHaveBeenPruned(AppView<?> appView) {
        for (DexProgramClass clazz : ((AppInfo)appView.appInfo()).classesWithDeterministicOrder()) {
            for (DexEncodedMethod method : clazz.methods()) {
                if (method.hasCode() && !method.getOptimizationInfo().isMultiCallerMethod()) continue;
            }
        }
        return true;
    }

    public ConstraintWithTarget computeInliningConstraint(IRCode code) {
        if (this.containsPotentialCatchHandlerVerificationError(code)) {
            return ConstraintWithTarget.NEVER;
        }
        ProgramMethod context = code.context();
        if (this.appView.options().canHaveDalvikIntUsedAsNonIntPrimitiveTypeBug() && this.returnsIntAsBoolean(code, context)) {
            return ConstraintWithTarget.NEVER;
        }
        ConstraintWithTarget result = ConstraintWithTarget.ALWAYS;
        InliningConstraints inliningConstraints = new InliningConstraints(this.appView, GraphLens.getIdentityLens());
        for (Instruction instruction : code.instructions()) {
            ConstraintWithTarget state = this.instructionAllowedForInlining(instruction, inliningConstraints, context);
            if (state == ConstraintWithTarget.NEVER) {
                result = state;
                break;
            }
            result = ConstraintWithTarget.meet(result, state, this.appView);
        }
        return result;
    }

    public void recordCallEdgesForMultiCallerInlining(ProgramMethod method, IRCode code, MethodProcessor methodProcessor, Timing timing) {
        this.multiCallerInliner.recordCallEdgesForMultiCallerInlining(method, code, methodProcessor, timing);
    }

    public void performForcedInlining(ProgramMethod method, IRCode code, Map<? extends InvokeMethod, InliningInfo> invokesToInline, InliningIRProvider inliningIRProvider, MethodProcessor methodProcessor, Timing timing) {
        ForcedInliningOracle oracle = new ForcedInliningOracle(this.appView, method, invokesToInline);
        this.performInliningImpl(oracle, oracle, method, code, OptimizationFeedbackIgnore.getInstance(), inliningIRProvider, methodProcessor, timing);
    }

    public void performInlining(ProgramMethod method, IRCode code, OptimizationFeedback feedback, MethodProcessor methodProcessor, Timing timing) {
        this.performInlining(method, code, feedback, methodProcessor, timing, this.createDefaultInliningReasonStrategy(methodProcessor));
    }

    public void performInlining(ProgramMethod method, IRCode code, OptimizationFeedback feedback, MethodProcessor methodProcessor, Timing timing, InliningReasonStrategy inliningReasonStrategy) {
        InternalOptions.InlinerOptions options = this.appView.options().inlinerOptions();
        DefaultInliningOracle oracle = this.createDefaultOracle(method, methodProcessor, options.inliningInstructionAllowance - Inliner.numberOfInstructions(code), inliningReasonStrategy);
        InliningIRProvider inliningIRProvider = new InliningIRProvider(this.appView, method, code, methodProcessor);
        assert (inliningIRProvider.verifyIRCacheIsEmpty());
        this.performInliningImpl(oracle, oracle, method, code, feedback, inliningIRProvider, methodProcessor, timing);
    }

    public InliningReasonStrategy createDefaultInliningReasonStrategy(MethodProcessor methodProcessor) {
        DefaultInliningReasonStrategy defaultInliningReasonStrategy = new DefaultInliningReasonStrategy(this.appView, methodProcessor.getCallSiteInformation());
        return this.appView.withGeneratedMessageLiteShrinker(ignore -> new ProtoInliningReasonStrategy(this.appView, defaultInliningReasonStrategy), defaultInliningReasonStrategy);
    }

    public DefaultInliningOracle createDefaultOracle(ProgramMethod method, MethodProcessor methodProcessor, int inliningInstructionAllowance) {
        return this.createDefaultOracle(method, methodProcessor, inliningInstructionAllowance, this.createDefaultInliningReasonStrategy(methodProcessor));
    }

    public DefaultInliningOracle createDefaultOracle(ProgramMethod method, MethodProcessor methodProcessor, int inliningInstructionAllowance, InliningReasonStrategy inliningReasonStrategy) {
        return new DefaultInliningOracle(this.appView, inliningReasonStrategy, method, methodProcessor, inliningInstructionAllowance);
    }

    public void enqueueMethodForReprocessing(ProgramMethod method) {
        this.singleInlineCallers.add(method, this.appView.graphLens());
    }

    public void onMethodPruned(ProgramMethod method) {
        this.onMethodCodePruned(method);
        this.multiCallerInliner.onMethodPruned(method);
    }

    public void onMethodCodePruned(ProgramMethod method) {
        this.singleInlineCallers.remove((DexMethod)method.getReference(), this.appView.graphLens());
    }

    public void onLastWaveDone(PostMethodProcessor.Builder postMethodProcessorBuilder, ExecutorService executorService, Timing timing) throws ExecutionException {
        postMethodProcessorBuilder.rewrittenWithLens(this.appView).merge(this.singleInlineCallers.rewrittenWithLens(this.appView).removeIf(this.appView, method -> method.getOptimizationInfo().hasBeenInlinedIntoSingleCallSite()));
        this.singleInlineCallers.clear();
        this.multiCallerInliner.onLastWaveDone(postMethodProcessorBuilder, executorService, timing);
    }

    public boolean verifyIsPrunedDueToSingleCallerInlining(DexMethod method) {
        assert (this.singleCallerInlinedPrunedMethodsForTesting.contains(method));
        return true;
    }

    public static class InliningInfo {
        public final ProgramMethod target;
        public final DexProgramClass receiverClass;

        public InliningInfo(ProgramMethod target, DexProgramClass receiverClass) {
            this.target = target;
            this.receiverClass = receiverClass;
        }
    }

    static class InlineeWithReason {
        final Reason reason;
        final IRCode code;

        InlineeWithReason(IRCode code, Reason reason) {
            this.code = code;
            this.reason = reason;
        }
    }

    public static class RetryAction
    extends InlineResult {
        @Override
        boolean isRetryAction() {
            return true;
        }
    }

    public static class InlineAction
    extends InlineResult {
        public final ProgramMethod target;
        public final Invoke invoke;
        final Reason reason;
        private boolean shouldEnsureStaticInitialization;
        private DexProgramClass downcastClass;

        InlineAction(ProgramMethod target, Invoke invoke, Reason reason) {
            this.target = target;
            this.invoke = invoke;
            this.reason = reason;
        }

        private void handleSimpleEffectAnalysisResult(SimpleDominatingEffectAnalysis.SimpleEffectAnalysisResult result, BasicBlock entryBlock, Consumer<Instruction> satisfyingInstructionConsumer, Consumer<BasicBlock> failingPathConsumer) {
            List<BasicBlock> topmostNotSatisfiedBlocks = result.getTopmostNotSatisfiedBlocks();
            if (result.isNotSatisfied() || result.isPartial() && topmostNotSatisfiedBlocks.size() > 1 || result.isPartial() && topmostNotSatisfiedBlocks.get(0).hasCatchHandlers()) {
                failingPathConsumer.accept(entryBlock);
            } else {
                result.forEachSatisfyingInstruction(satisfyingInstructionConsumer);
                topmostNotSatisfiedBlocks.forEach(failingPathConsumer);
            }
        }

        private void synthesizeInitClass(IRCode code, BasicBlock block) {
            assert (!block.hasCatchHandlers());
            BasicBlock initClassBlock = block.listIterator(code, block.isEntry() ? code.collectArguments().size() : 0).split(code, 0, null);
            assert (!initClassBlock.hasCatchHandlers());
            InstructionListIterator iterator2 = initClassBlock.listIterator(code);
            iterator2.setInsertionPosition(this.invoke.getPosition());
            iterator2.add(new InitClass(code.createValue(TypeElement.getInt()), this.target.getHolderType()));
        }

        private void synthesizeNullCheckForReceiver(AppView<?> appView, IRCode code, InvokeMethod invoke, BasicBlock block) {
            List<Value> arguments = code.collectArguments();
            if (!arguments.isEmpty()) {
                Value receiver = arguments.get(0);
                assert (receiver.isThis());
                BasicBlock throwBlock = block.listIterator(code, block.isEntry() ? arguments.size() : 0).split(code, 0, null);
                assert (!throwBlock.hasCatchHandlers());
                InstructionListIterator iterator2 = throwBlock.listIterator(code);
                iterator2.setInsertionPosition(invoke.getPosition());
                DexMethod getClassMethod = appView.dexItemFactory().objectMembers.getClass;
                iterator2.add(new InvokeVirtual(getClassMethod, null, ImmutableList.of(receiver)));
            } else assert (false) : "Unable to synthesize a null check for the receiver";
        }

        private void setRemoveInnerFramePositionForReceiverUse(Instruction instruction) {
            Position position = instruction.getPosition();
            if (position == null) {
                assert (false) : "Expected position for inlinee call to receiver";
                return;
            }
            Position outermostCaller = position.getOutermostCaller();
            Object removeInnerFrame = ((Position.PositionBuilder)outermostCaller.builderWithCopy().setRemoveInnerFramesIfThrowingNpe(true)).build();
            instruction.forceOverwritePosition(position.replacePosition(outermostCaller, (Position)removeInnerFrame));
        }

        @Override
        InlineAction asInlineAction() {
            return this;
        }

        DexProgramClass getDowncastClass() {
            return this.downcastClass;
        }

        void setDowncastClass(DexProgramClass downcastClass) {
            this.downcastClass = downcastClass;
        }

        void setShouldEnsureStaticInitialization() {
            this.shouldEnsureStaticInitialization = true;
        }

        InlineeWithReason buildInliningIR(AppView<AppInfoWithLiveness> appView, InvokeMethod invoke, ProgramMethod context, InliningIRProvider inliningIRProvider, LensCodeRewriter lensCodeRewriter) {
            boolean isSynthesizingNullCheckForReceiverUsingMonitorEnter;
            DexItemFactory dexItemFactory = appView.dexItemFactory();
            InternalOptions options = appView.options();
            IRCode code = inliningIRProvider.getInliningIR(invoke, this.target);
            if (this.shouldEnsureStaticInitialization) {
                this.handleSimpleEffectAnalysisResult(SimpleDominatingEffectAnalysis.triggersClassInitializationBeforeAnyStaticRead(appView, code, context), code.entryBlock(), ConsumerUtils.emptyConsumer(), failingBlock -> this.synthesizeInitClass(code, (BasicBlock)failingBlock));
            }
            boolean shouldSynthesizeMonitorEnterExit = ((DexEncodedMethod)this.target.getDefinition()).isSynchronized() && options.isGeneratingClassFiles();
            boolean bl = isSynthesizingNullCheckForReceiverUsingMonitorEnter = shouldSynthesizeMonitorEnterExit && !((DexEncodedMethod)this.target.getDefinition()).isStatic();
            if (invoke.isInvokeMethodWithReceiver() && invoke.asInvokeMethodWithReceiver().getReceiver().isMaybeNull() && !isSynthesizingNullCheckForReceiverUsingMonitorEnter) {
                this.handleSimpleEffectAnalysisResult(SimpleDominatingEffectAnalysis.canInlineWithoutSynthesizingNullCheckForReceiver(appView, code), code.entryBlock(), this::setRemoveInnerFramePositionForReceiverUse, failingBlock -> this.synthesizeNullCheckForReceiver(appView, code, invoke, (BasicBlock)failingBlock));
            }
            if (shouldSynthesizeMonitorEnterExit) {
                Value lockValue;
                TypeElement throwableType = TypeElement.fromDexType(dexItemFactory.throwableType, Nullability.definitelyNotNull(), appView);
                code.prepareBlocksForCatchHandlers();
                BasicBlock monitorExitBlock = new BasicBlock();
                monitorExitBlock.setNumber(code.getNextBlockNumber());
                ArrayList<BasicBlock> moveExceptionBlocks = new ArrayList<BasicBlock>();
                for (BasicBlock block2 : code.blocks) {
                    if (!block2.canThrow() || block2.hasCatchHandlers() && block2.getCatchHandlersWithSuccessorIndexes().hasCatchAll(dexItemFactory)) continue;
                    BasicBlock moveExceptionBlock = BasicBlock.createGotoBlock(code.getNextBlockNumber(), Position.none(), code.metadata(), monitorExitBlock);
                    InstructionListIterator moveExceptionBlockIterator = moveExceptionBlock.listIterator(code);
                    moveExceptionBlockIterator.setInsertionPosition(Position.syntheticNone());
                    moveExceptionBlockIterator.add(new MoveException(code.createValue(throwableType), dexItemFactory.throwableType, options));
                    block2.appendCatchHandler(moveExceptionBlock, dexItemFactory.throwableType);
                    moveExceptionBlocks.add(moveExceptionBlock);
                }
                InstructionListIterator monitorExitBlockIterator = null;
                if (!moveExceptionBlocks.isEmpty()) {
                    Value exceptionValue;
                    if (moveExceptionBlocks.size() == 1) {
                        exceptionValue = ((BasicBlock)ListUtils.first(moveExceptionBlocks)).getInstructions().getFirst().outValue();
                    } else {
                        Phi phi = code.createPhi(monitorExitBlock, throwableType);
                        List<Value> operands = ListUtils.map(moveExceptionBlocks, block -> block.getInstructions().getFirst().outValue());
                        phi.addOperands(operands);
                        exceptionValue = phi;
                    }
                    monitorExitBlockIterator = monitorExitBlock.listIterator(code);
                    monitorExitBlockIterator.setInsertionPosition(Position.syntheticNone());
                    monitorExitBlockIterator.add(new Throw(exceptionValue));
                    monitorExitBlock.getMutablePredecessors().addAll(moveExceptionBlocks);
                    code.blocks.addAll(moveExceptionBlocks);
                    code.blocks.add(monitorExitBlock);
                }
                BasicBlock entryBlock = code.entryBlock();
                InstructionListIterator entryBlockIterator = entryBlock.listIterator(code);
                entryBlockIterator.nextUntil(Predicates.not(Instruction::isArgument));
                entryBlockIterator.previous();
                BasicBlock monitorEnterBlock = entryBlockIterator.split(code, 0, null);
                assert (!monitorEnterBlock.hasCatchHandlers());
                InstructionListIterator monitorEnterBlockIterator = monitorEnterBlock.listIterator(code);
                monitorEnterBlockIterator.setInsertionPosition(invoke.getPosition());
                if (((DexEncodedMethod)this.target.getDefinition()).isStatic()) {
                    lockValue = code.createValue(TypeElement.fromDexType(dexItemFactory.objectType, Nullability.definitelyNotNull(), appView));
                    monitorEnterBlockIterator.add(new ConstClass(lockValue, this.target.getHolderType()));
                } else {
                    lockValue = entryBlock.getInstructions().getFirst().asArgument().outValue();
                }
                monitorEnterBlockIterator.add(new Monitor(Monitor.Type.ENTER, lockValue));
                if (monitorExitBlockIterator != null) {
                    monitorExitBlockIterator.previous();
                    monitorExitBlockIterator.add(new Monitor(Monitor.Type.EXIT, lockValue));
                    monitorExitBlock.close(null);
                }
                for (BasicBlock block3 : code.blocks) {
                    if (!block3.exit().isReturn()) continue;
                    assert (!block3.canThrow());
                    InstructionListIterator instructionIterator = block3.listIterator(code, block3.getInstructions().size() - 1);
                    instructionIterator.setInsertionPosition(Position.syntheticNone());
                    instructionIterator.add(new Monitor(Monitor.Type.EXIT, lockValue));
                }
            }
            if (inliningIRProvider.shouldApplyCodeRewritings(this.target)) {
                assert (lensCodeRewriter != null);
                lensCodeRewriter.rewrite(code, this.target, inliningIRProvider.getMethodProcessor());
            }
            if (options.testing.inlineeIrModifier != null) {
                options.testing.inlineeIrModifier.accept(code);
            }
            assert (code.isConsistentSSA(appView));
            return new InlineeWithReason(code, this.reason);
        }
    }

    public static abstract class InlineResult {
        InlineAction asInlineAction() {
            return null;
        }

        boolean isRetryAction() {
            return false;
        }
    }

    public static enum Reason {
        FORCE,
        ALWAYS,
        SINGLE_CALLER,
        MULTI_CALLER_CANDIDATE,
        SIMPLE,
        NEVER;


        public boolean mustBeInlined() {
            return this == FORCE || this == ALWAYS;
        }
    }

    public static class ConstraintWithTarget {
        public static final ConstraintWithTarget NEVER = new ConstraintWithTarget(Constraint.NEVER);
        public static final ConstraintWithTarget ALWAYS = new ConstraintWithTarget(Constraint.ALWAYS);
        public final Constraint constraint;
        final DexType targetHolder;

        private ConstraintWithTarget(Constraint constraint) {
            assert (constraint == Constraint.NEVER || constraint == Constraint.ALWAYS);
            this.constraint = constraint;
            this.targetHolder = null;
        }

        ConstraintWithTarget(Constraint constraint, DexType targetHolder) {
            assert (constraint != Constraint.NEVER && constraint != Constraint.ALWAYS);
            assert (targetHolder != null);
            this.constraint = constraint;
            this.targetHolder = targetHolder;
        }

        public static ConstraintWithTarget deriveConstraint(ProgramMethod context, DexType targetHolder, AccessFlags<?> flags, AppView<?> appView) {
            if (flags.isPublic()) {
                return ALWAYS;
            }
            if (flags.isPrivate()) {
                if (context.getHolder().isInANest()) {
                    return NestUtils.sameNest(context.getHolderType(), targetHolder, appView) ? new ConstraintWithTarget(Constraint.SAMENEST, targetHolder) : NEVER;
                }
                return targetHolder == context.getHolderType() ? new ConstraintWithTarget(Constraint.SAMECLASS, targetHolder) : NEVER;
            }
            if (flags.isProtected()) {
                if (targetHolder.isSamePackage(context.getHolderType())) {
                    return new ConstraintWithTarget(Constraint.PACKAGE, targetHolder);
                }
                if (appView.isSubtype(context.getHolderType(), targetHolder).isTrue()) {
                    return new ConstraintWithTarget(Constraint.SUBCLASS, targetHolder);
                }
                return NEVER;
            }
            return targetHolder.isSamePackage(context.getHolderType()) ? new ConstraintWithTarget(Constraint.PACKAGE, targetHolder) : NEVER;
        }

        public static ConstraintWithTarget classIsVisible(ProgramMethod context, DexType clazz, AppView<?> appView) {
            if (clazz.isArrayType()) {
                return ConstraintWithTarget.classIsVisible(context, clazz.toArrayElementType(appView.dexItemFactory()), appView);
            }
            if (clazz.isPrimitiveType()) {
                return ALWAYS;
            }
            DexClass definition = appView.definitionFor(clazz);
            return definition == null ? NEVER : ConstraintWithTarget.deriveConstraint(context, clazz, definition.accessFlags, appView);
        }

        public static ConstraintWithTarget meet(ConstraintWithTarget one, ConstraintWithTarget other, AppView<?> appView) {
            if (one.equals(other)) {
                return one;
            }
            if (other.constraint.ordinal() < one.constraint.ordinal()) {
                return ConstraintWithTarget.meet(other, one, appView);
            }
            if (one == NEVER) {
                return NEVER;
            }
            if (other == ALWAYS) {
                return one;
            }
            int constraint = one.constraint.value | other.constraint.value;
            assert (!Constraint.NEVER.isSet(constraint));
            assert (!Constraint.ALWAYS.isSet(constraint));
            if (Constraint.SAMECLASS.isSet(constraint)) {
                assert (one.constraint == Constraint.SAMECLASS);
                if (other.constraint == Constraint.SAMECLASS) {
                    assert (one.targetHolder != other.targetHolder);
                    return NEVER;
                }
                if (other.constraint == Constraint.SAMENEST) {
                    if (NestUtils.sameNest(one.targetHolder, other.targetHolder, appView)) {
                        return one;
                    }
                    return NEVER;
                }
                if (other.constraint == Constraint.PACKAGE) {
                    if (one.targetHolder.isSamePackage(other.targetHolder)) {
                        return one;
                    }
                    return NEVER;
                }
                assert (other.constraint == Constraint.SUBCLASS);
                if (appView.isSubtype(one.targetHolder, other.targetHolder).isTrue()) {
                    return one;
                }
                return NEVER;
            }
            if (Constraint.SAMENEST.isSet(constraint)) {
                assert (one.constraint == Constraint.SAMENEST);
                if (other.constraint == Constraint.SAMENEST) {
                    if (NestUtils.sameNest(one.targetHolder, other.targetHolder, appView)) {
                        return one;
                    }
                    return NEVER;
                }
                assert (ConstraintWithTarget.verifyAllNestInSamePackage(one.targetHolder, appView));
                if (other.constraint == Constraint.PACKAGE) {
                    if (one.targetHolder.isSamePackage(other.targetHolder)) {
                        return one;
                    }
                    return NEVER;
                }
                assert (other.constraint == Constraint.SUBCLASS);
                if (ConstraintWithTarget.allNestMembersSubtypeOf(one.targetHolder, other.targetHolder, appView)) {
                    return one;
                }
                return NEVER;
            }
            if (Constraint.PACKAGE.isSet(constraint)) {
                assert (one.constraint == Constraint.PACKAGE);
                if (other.constraint == Constraint.PACKAGE) {
                    assert (one.targetHolder != other.targetHolder);
                    if (one.targetHolder.isSamePackage(other.targetHolder)) {
                        return one;
                    }
                    return NEVER;
                }
                assert (other.constraint == Constraint.SUBCLASS);
                if (other.targetHolder.isSamePackage(one.targetHolder)) {
                    return one;
                }
                if (appView.isSubtype(one.targetHolder, other.targetHolder).isTrue()) {
                    return new ConstraintWithTarget(Constraint.SAMECLASS, one.targetHolder);
                }
                return NEVER;
            }
            assert (Constraint.SUBCLASS.isSet(constraint));
            assert (one.constraint == other.constraint);
            assert (one.targetHolder != other.targetHolder);
            if (appView.isSubtype(one.targetHolder, other.targetHolder).isTrue()) {
                return one;
            }
            if (appView.isSubtype(other.targetHolder, one.targetHolder).isTrue()) {
                return other;
            }
            return NEVER;
        }

        private static boolean allNestMembersSubtypeOf(DexType nestType, DexType superType, AppView<?> appView) {
            DexClass nestHost;
            DexClass dexClass = appView.definitionFor(nestType);
            if (dexClass == null) {
                assert (false);
                return false;
            }
            if (!dexClass.isInANest()) {
                return appView.isSubtype(dexClass.type, superType).isTrue();
            }
            DexClass dexClass2 = nestHost = dexClass.isNestHost() ? dexClass : appView.definitionFor(dexClass.getNestHost());
            if (nestHost == null) {
                assert (false);
                return false;
            }
            for (NestMemberClassAttribute member : nestHost.getNestMembersClassAttributes()) {
                if (appView.isSubtype(member.getNestMember(), superType).isTrue()) continue;
                return false;
            }
            return true;
        }

        private static boolean verifyAllNestInSamePackage(DexType type, AppView<?> appView) {
            DexClass nestHost;
            String descr = type.getPackageDescriptor();
            DexClass dexClass = appView.definitionFor(type);
            assert (dexClass != null);
            if (!dexClass.isInANest()) {
                return true;
            }
            DexClass dexClass2 = nestHost = dexClass.isNestHost() ? dexClass : appView.definitionFor(dexClass.getNestHost());
            assert (nestHost != null);
            for (NestMemberClassAttribute member : nestHost.getNestMembersClassAttributes()) {
                assert (member.getNestMember().getPackageDescriptor().equals(descr));
            }
            return true;
        }

        public int hashCode() {
            if (this.targetHolder == null) {
                return this.constraint.ordinal();
            }
            return this.constraint.ordinal() * this.targetHolder.computeHashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ConstraintWithTarget)) {
                return false;
            }
            ConstraintWithTarget o = (ConstraintWithTarget)other;
            return this.constraint.ordinal() == o.constraint.ordinal() && this.targetHolder == o.targetHolder;
        }
    }

    public static final class Constraint
    extends Enum<Constraint> {
        public static final /* enum */ Constraint NEVER = new Constraint(1);
        public static final /* enum */ Constraint SAMECLASS = new Constraint(2);
        public static final /* enum */ Constraint SAMENEST = new Constraint(4);
        public static final /* enum */ Constraint PACKAGE = new Constraint(8);
        public static final /* enum */ Constraint SUBCLASS = new Constraint(16);
        public static final /* enum */ Constraint ALWAYS = new Constraint(32);
        private static final /* synthetic */ Constraint[] $VALUES;
        int value;

        public static Constraint[] values() {
            return (Constraint[])$VALUES.clone();
        }

        public static Constraint valueOf(String name) {
            return Enum.valueOf(Constraint.class, name);
        }

        private Constraint(int value) {
            this.value = value;
        }

        static {
            $VALUES = new Constraint[]{NEVER, SAMECLASS, SAMENEST, PACKAGE, SUBCLASS, ALWAYS};
            assert (NEVER.ordinal() < SAMECLASS.ordinal());
            assert (SAMECLASS.ordinal() < SAMENEST.ordinal());
            assert (SAMENEST.ordinal() < PACKAGE.ordinal());
            assert (PACKAGE.ordinal() < SUBCLASS.ordinal());
            assert (SUBCLASS.ordinal() < ALWAYS.ordinal());
        }

        public Constraint meet(Constraint otherConstraint) {
            if (this.ordinal() < otherConstraint.ordinal()) {
                return this;
            }
            return otherConstraint;
        }

        boolean isSet(int value) {
            return (this.value & value) != 0;
        }
    }
}

