/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.AppInfoWithClassHierarchy;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMember;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexReference;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldResolutionResult;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.VerticalClassMerger;
import com.android.tools.r8.utils.TriFunction;

public class InliningConstraints {
    private AppView<AppInfoWithLiveness> appView;
    private boolean allowStaticInterfaceMethodCalls = true;
    private GraphLens graphLens;

    public InliningConstraints(AppView<AppInfoWithLiveness> appView, GraphLens graphLens) {
        this.appView = appView;
        this.graphLens = graphLens;
    }

    private boolean isVerticalClassMerging() {
        return this.graphLens instanceof VerticalClassMerger.SingleTypeMapperGraphLens;
    }

    private DexEncodedMethod singleTargetWhileVerticalClassMerging(MethodResolutionResult resolutionResult, ProgramMethod context, TriFunction<MethodResolutionResult, DexProgramClass, AppInfoWithClassHierarchy, DexEncodedMethod> lookup) {
        if (!resolutionResult.isSingleResolution()) {
            return null;
        }
        DexEncodedMethod dexEncodedMethod = lookup.apply(resolutionResult, context.getHolder(), this.appView.appInfo());
        if (!this.isVerticalClassMerging() || dexEncodedMethod != null) {
            return dexEncodedMethod;
        }
        assert (this.isVerticalClassMerging());
        assert (this.graphLens.lookupType(context.getHolder().superType) == context.getHolderType());
        DexProgramClass superContext = this.appView.programDefinitionFor(context.getHolder().superType, context);
        if (superContext == null) {
            return null;
        }
        DexEncodedMethod alternativeDexEncodedMethod = lookup.apply(resolutionResult, superContext, this.appView.appInfo());
        if (alternativeDexEncodedMethod != null && alternativeDexEncodedMethod.getHolderType() == superContext.type) {
            return alternativeDexEncodedMethod;
        }
        return null;
    }

    private Inliner.ConstraintWithTarget forFieldInstruction(DexField field, ProgramMethod context) {
        DexField lookup = this.graphLens.lookupField(field);
        FieldResolutionResult fieldResolutionResult = this.appView.appInfo().resolveField(lookup);
        return this.forResolvedMember(fieldResolutionResult.getInitialResolutionHolder(), context, fieldResolutionResult.getResolvedField());
    }

    private Inliner.ConstraintWithTarget forVirtualInvoke(DexMethod method, ProgramMethod context, boolean isInterface) {
        if (method.holder.isArrayType()) {
            return Inliner.ConstraintWithTarget.ALWAYS;
        }
        MethodResolutionResult resolutionResult = this.appView.appInfo().resolveMethod(method, isInterface);
        if (!resolutionResult.isVirtualTarget()) {
            return Inliner.ConstraintWithTarget.NEVER;
        }
        return this.forResolvedMember(resolutionResult.getInitialResolutionHolder(), context, resolutionResult.getSingleTarget());
    }

    private Inliner.ConstraintWithTarget forResolvedMember(DexClass initialResolutionHolder, ProgramMethod context, DexEncodedMember<?, ?> resolvedMember) {
        if (resolvedMember == null) {
            return Inliner.ConstraintWithTarget.NEVER;
        }
        if (!this.appView.appInfo().getClassToFeatureSplitMap().isInBaseOrSameFeatureAs(resolvedMember.getHolderType(), (ProgramDefinition)context.asProgramMethod(), this.appView.getSyntheticItems())) {
            return Inliner.ConstraintWithTarget.NEVER;
        }
        DexType resolvedHolder = this.graphLens.lookupType(resolvedMember.getHolderType());
        assert (initialResolutionHolder != null);
        Inliner.ConstraintWithTarget memberConstraintWithTarget = Inliner.ConstraintWithTarget.deriveConstraint(context, resolvedHolder, resolvedMember.getAccessFlags(), this.appView);
        Inliner.ConstraintWithTarget classConstraintWithTarget = Inliner.ConstraintWithTarget.deriveConstraint(context, initialResolutionHolder.type, initialResolutionHolder.accessFlags, this.appView);
        return Inliner.ConstraintWithTarget.meet(classConstraintWithTarget, memberConstraintWithTarget, this.appView);
    }

    public AppView<AppInfoWithLiveness> getAppView() {
        return this.appView;
    }

    public GraphLens getGraphLens() {
        return this.graphLens;
    }

    public void disallowStaticInterfaceMethodCalls() {
        this.allowStaticInterfaceMethodCalls = false;
    }

    public Inliner.ConstraintWithTarget forAlwaysMaterializingUser() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forArgument() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forArrayGet() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forArrayLength() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forArrayPut() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forBinop() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forDexItemBasedConstString(DexReference type, ProgramMethod context) {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forCheckCast(DexType type, ProgramMethod context) {
        return Inliner.ConstraintWithTarget.classIsVisible(context, type, this.appView);
    }

    public Inliner.ConstraintWithTarget forConstClass(DexType type, ProgramMethod context) {
        return Inliner.ConstraintWithTarget.classIsVisible(context, type, this.appView);
    }

    public Inliner.ConstraintWithTarget forConstInstruction() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forDebugLocalRead() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forDebugLocalsChange() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forDebugPosition() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forDup() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forDup2() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forInitClass(DexType clazz, ProgramMethod context) {
        return Inliner.ConstraintWithTarget.classIsVisible(context, clazz, this.appView);
    }

    public Inliner.ConstraintWithTarget forInstanceGet(DexField field, ProgramMethod context) {
        return this.forFieldInstruction(field, context);
    }

    public Inliner.ConstraintWithTarget forInstanceOf(DexType type, ProgramMethod context) {
        return Inliner.ConstraintWithTarget.classIsVisible(context, type, this.appView);
    }

    public Inliner.ConstraintWithTarget forInstancePut(DexField field, ProgramMethod context) {
        return this.forFieldInstruction(field, context);
    }

    public Inliner.ConstraintWithTarget forInvoke(DexMethod method, Invoke.Type type, ProgramMethod context) {
        switch (type) {
            case DIRECT: {
                return this.forInvokeDirect(method, context);
            }
            case INTERFACE: {
                return this.forInvokeInterface(method, context);
            }
            case STATIC: {
                return this.forInvokeStatic(method, context);
            }
            case SUPER: {
                return this.forInvokeSuper(method, context);
            }
            case VIRTUAL: {
                return this.forInvokeVirtual(method, context);
            }
            case CUSTOM: {
                return this.forInvokeCustom();
            }
            case POLYMORPHIC: {
                return this.forInvokePolymorphic(method, context);
            }
        }
        throw new Unreachable("Unexpected type: " + (Object)((Object)type));
    }

    public Inliner.ConstraintWithTarget forInvokeCustom() {
        return Inliner.ConstraintWithTarget.NEVER;
    }

    public Inliner.ConstraintWithTarget forInvokeDirect(DexMethod method, ProgramMethod context) {
        DexMethod lookup = (DexMethod)this.graphLens.lookupMethod(method, (DexMethod)context.getReference(), Invoke.Type.DIRECT).getReference();
        if (lookup.holder.isArrayType()) {
            return Inliner.ConstraintWithTarget.ALWAYS;
        }
        MethodResolutionResult resolutionResult = this.appView.appInfo().unsafeResolveMethodDueToDexFormat(lookup);
        DexEncodedMethod target = this.singleTargetWhileVerticalClassMerging(resolutionResult, context, MethodResolutionResult::lookupInvokeDirectTarget);
        return this.forResolvedMember(resolutionResult.getInitialResolutionHolder(), context, target);
    }

    public Inliner.ConstraintWithTarget forInvokeInterface(DexMethod method, ProgramMethod context) {
        DexMethod lookup = (DexMethod)this.graphLens.lookupMethod(method, (DexMethod)context.getReference(), Invoke.Type.INTERFACE).getReference();
        return this.forVirtualInvoke(lookup, context, true);
    }

    public Inliner.ConstraintWithTarget forInvokeMultiNewArray(DexType type, ProgramMethod context) {
        return Inliner.ConstraintWithTarget.classIsVisible(context, type, this.appView);
    }

    public Inliner.ConstraintWithTarget forInvokeNewArray(DexType type, ProgramMethod context) {
        return Inliner.ConstraintWithTarget.classIsVisible(context, type, this.appView);
    }

    public Inliner.ConstraintWithTarget forInvokePolymorphic(DexMethod method, ProgramMethod context) {
        return Inliner.ConstraintWithTarget.NEVER;
    }

    public Inliner.ConstraintWithTarget forInvokeStatic(DexMethod method, ProgramMethod context) {
        DexClass methodClass;
        DexMethod lookup = (DexMethod)this.graphLens.lookupMethod(method, (DexMethod)context.getReference(), Invoke.Type.STATIC).getReference();
        if (lookup.holder.isArrayType()) {
            return Inliner.ConstraintWithTarget.ALWAYS;
        }
        MethodResolutionResult resolutionResult = this.appView.appInfo().unsafeResolveMethodDueToDexFormat(lookup);
        DexEncodedMethod target = this.singleTargetWhileVerticalClassMerging(resolutionResult, context, MethodResolutionResult::lookupInvokeStaticTarget);
        if (!this.allowStaticInterfaceMethodCalls && target != null && (methodClass = this.appView.definitionFor(this.graphLens.lookupType(target.getHolderType()))) != null && methodClass.isInterface() && target.hasCode()) {
            return Inliner.ConstraintWithTarget.NEVER;
        }
        return this.forResolvedMember(resolutionResult.getInitialResolutionHolder(), context, target);
    }

    public Inliner.ConstraintWithTarget forInvokeSuper(DexMethod method, ProgramMethod context) {
        return new Inliner.ConstraintWithTarget(Inliner.Constraint.SAMECLASS, context.getHolderType());
    }

    public Inliner.ConstraintWithTarget forInvokeVirtual(DexMethod method, ProgramMethod context) {
        DexMethod lookup = (DexMethod)this.graphLens.lookupMethod(method, (DexMethod)context.getReference(), Invoke.Type.VIRTUAL).getReference();
        return this.forVirtualInvoke(lookup, context, false);
    }

    public Inliner.ConstraintWithTarget forJumpInstruction() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forLoad() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forMonitor() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forMove() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forMoveException() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forNewArrayEmpty(DexType type, ProgramMethod context) {
        return Inliner.ConstraintWithTarget.classIsVisible(context, type, this.appView);
    }

    public Inliner.ConstraintWithTarget forRecordFieldValues() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forNewArrayFilledData() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forNewInstance(DexType type, ProgramMethod context) {
        return Inliner.ConstraintWithTarget.classIsVisible(context, type, this.appView);
    }

    public Inliner.ConstraintWithTarget forNewUnboxedEnumInstance(DexType type, ProgramMethod context) {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forAssume() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forPop() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forReturn() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forStaticGet(DexField field, ProgramMethod context) {
        return this.forFieldInstruction(field, context);
    }

    public Inliner.ConstraintWithTarget forStaticPut(DexField field, ProgramMethod context) {
        return this.forFieldInstruction(field, context);
    }

    public Inliner.ConstraintWithTarget forStore() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forSwap() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forThrow() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forUnop() {
        return Inliner.ConstraintWithTarget.ALWAYS;
    }

    public Inliner.ConstraintWithTarget forConstMethodHandle() {
        return Inliner.ConstraintWithTarget.NEVER;
    }

    public Inliner.ConstraintWithTarget forConstMethodType() {
        return Inliner.ConstraintWithTarget.NEVER;
    }
}

