/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.Move;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.regalloc.RegisterAllocator;
import java.util.HashSet;
import java.util.Set;

class MoveEliminator {
    private final Set<Move> activeMoves = new HashSet<Move>();
    private final RegisterAllocator allocator;

    MoveEliminator(RegisterAllocator allocator) {
        this.allocator = allocator;
    }

    public boolean shouldBeEliminated(Instruction instruction) {
        if (instruction.isMove()) {
            int moveDstRegister;
            Move move = instruction.asMove();
            int moveSrcRegister = this.allocator.getArgumentOrAllocateRegisterForValue(move.src(), move.getNumber());
            if (moveSrcRegister == (moveDstRegister = this.allocator.getRegisterForValue(move.dest(), move.getNumber()))) {
                return true;
            }
            for (Move activeMove : this.activeMoves) {
                int activeMoveSrcRegister = this.allocator.getArgumentOrAllocateRegisterForValue(activeMove.src(), activeMove.getNumber());
                int activeMoveDstRegister = this.allocator.getRegisterForValue(activeMove.dest(), activeMove.getNumber());
                if (activeMoveSrcRegister == moveSrcRegister && activeMoveDstRegister == moveDstRegister) {
                    return true;
                }
                if (activeMoveDstRegister != moveSrcRegister || activeMoveSrcRegister != moveDstRegister) continue;
                if (!move.outType().isWide()) {
                    return true;
                }
                if (moveSrcRegister == moveDstRegister + 1 || moveSrcRegister + 1 == moveDstRegister) continue;
                return true;
            }
        }
        if (instruction.outValue() != null && instruction.outValue().needsRegister()) {
            Value defined = instruction.outValue();
            int definedRegister = this.allocator.getRegisterForValue(defined, instruction.getNumber());
            this.activeMoves.removeIf(m3 -> {
                int moveSrcRegister = this.allocator.getArgumentOrAllocateRegisterForValue(m3.src(), m3.getNumber());
                int moveDstRegister = this.allocator.getRegisterForValue(m3.dest(), m3.getNumber());
                for (int i = 0; i < defined.requiredRegisters(); ++i) {
                    for (int j = 0; j < m3.outValue().requiredRegisters(); ++j) {
                        if (definedRegister + i != moveDstRegister + j && definedRegister + i != moveSrcRegister + j) continue;
                        return true;
                    }
                }
                return false;
            });
        }
        if (instruction.isMove()) {
            this.activeMoves.add(instruction.asMove());
        }
        return false;
    }
}

