/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeInterface;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeVirtual;

public class NestUtils {
    public static boolean sameNest(DexType type1, DexType type2, DexDefinitionSupplier definitions) {
        if (type1 == type2) {
            return true;
        }
        DexClass clazz1 = definitions.definitionFor(type1);
        if (clazz1 == null) {
            return false;
        }
        if (!clazz1.isInANest()) {
            return false;
        }
        DexClass clazz2 = definitions.definitionFor(type2);
        if (clazz2 == null) {
            return false;
        }
        return clazz1.getNestHost() == clazz2.getNestHost();
    }

    public static void rewriteNestCallsForInlining(IRCode code, ProgramMethod callerContext, AppView<?> appView) {
        InstructionListIterator iterator2 = code.instructionListIterator();
        assert (code.context().getHolder() != callerContext.getHolder());
        while (iterator2.hasNext()) {
            DexEncodedMethod encodedMethod;
            DexClass holder;
            DexMethod method;
            InvokeMethod invoke;
            Instruction instruction = (Instruction)iterator2.next();
            if (instruction.isInvokeDirect()) {
                invoke = instruction.asInvokeDirect();
                method = invoke.getInvokedMethod();
                encodedMethod = method.lookupOnClass(holder = appView.definitionForHolder(method));
                if (encodedMethod == null || encodedMethod.isInstanceInitializer()) continue;
                assert (encodedMethod.isPrivateMethod());
                if (((InvokeDirect)invoke).getInterfaceBit()) {
                    iterator2.replaceCurrentInstruction(new InvokeInterface(method, invoke.outValue(), invoke.arguments()));
                    continue;
                }
                iterator2.replaceCurrentInstruction(new InvokeVirtual(method, invoke.outValue(), invoke.arguments()));
                continue;
            }
            if (!instruction.isInvokeInterface() && !instruction.isInvokeVirtual()) continue;
            invoke = instruction.asInvokeMethod();
            method = invoke.getInvokedMethod();
            if (method.holder != callerContext.getHolderType() || (encodedMethod = method.lookupOnClass(holder = appView.definitionForHolder(method))) == null || !encodedMethod.isPrivateMethod()) continue;
            iterator2.replaceCurrentInstruction(new InvokeDirect(method, invoke.outValue(), invoke.arguments(), callerContext.getHolder().isInterface()));
        }
    }
}

