/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.Load;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Store;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.peepholes.PeepholeHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class PhiOptimizations {
    private static boolean predecessorsHaveNormalFlow(BasicBlock block) {
        for (BasicBlock predecessor : block.getPredecessors()) {
            if (predecessor.exit().isGoto() && predecessor.exit().asGoto().getTarget() == block) continue;
            return false;
        }
        return true;
    }

    private static boolean singleUseOfPhiAndOperands(Phi phi) {
        if (phi.numberOfAllUsers() != 1 || phi.numberOfUsers() != 1) {
            return false;
        }
        for (Value operand : phi.getOperands()) {
            if (operand.numberOfAllUsers() == 1) continue;
            return false;
        }
        return true;
    }

    private static int getRelativeStackHeightForInstruction(BasicBlock block, Instruction instruction) {
        int stackHeight = 0;
        HashSet<BasicBlock> seenBlocks = new HashSet<BasicBlock>();
        while (block != null) {
            seenBlocks.add(block);
            for (Instruction current : block.getInstructions()) {
                if (instruction == current) {
                    return stackHeight;
                }
                if ((stackHeight -= PeepholeHelper.numberOfValuesConsumedFromStack(instruction)) < 0) {
                    return Integer.MIN_VALUE;
                }
                stackHeight += PeepholeHelper.numberOfValuesPutOnStack(instruction);
            }
            if (block.exit().isGoto() && !seenBlocks.contains(block.exit().asGoto().getTarget())) {
                block = block.exit().asGoto().getTarget();
                continue;
            }
            block = null;
        }
        return Integer.MIN_VALUE;
    }

    private static int getStackHeightAtInstructionBackwards(Instruction instruction) {
        Instruction current;
        int stackHeight = 0;
        BasicBlock block = instruction.getBlock();
        InstructionIterator it = block.iterator(block.getInstructions().size() - 1);
        while (it.hasPrevious() && (current = it.previous()) != instruction) {
            if ((stackHeight -= PeepholeHelper.numberOfValuesPutOnStack(instruction)) < 0) {
                return Integer.MIN_VALUE;
            }
            stackHeight += PeepholeHelper.numberOfValuesConsumedFromStack(instruction);
        }
        return stackHeight;
    }

    private static boolean tryMovePhisToStack(IRCode code) {
        boolean hadChange = false;
        for (BasicBlock block : code.blocks) {
            boolean changed = true;
            HashSet<BasicBlock> predecessors = new HashSet<BasicBlock>(block.getPredecessors());
            while (changed) {
                changed = false;
                for (Phi phi : block.getPhis()) {
                    changed |= PhiOptimizations.tryMovePhiToStack(block, phi, predecessors);
                }
                if (!changed) continue;
                hadChange = true;
            }
        }
        return hadChange;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean tryMovePhiToStack(BasicBlock block, Phi phi, Set<BasicBlock> predecessors) {
        void var5_8;
        if (!PhiOptimizations.predecessorsHaveNormalFlow(block) || !PhiOptimizations.singleUseOfPhiAndOperands(phi)) {
            return false;
        }
        Load phiLoad = phi.singleUniqueUser().asLoad();
        if (phiLoad == null || phiLoad.src().hasLocalInfo()) {
            return false;
        }
        if (PhiOptimizations.getRelativeStackHeightForInstruction(block, phiLoad) != 0) {
            return false;
        }
        for (Value value : phi.getOperands()) {
            if (value.definition == null || !value.definition.isStore()) {
                return false;
            }
            if (!predecessors.contains(value.definition.getBlock())) {
                return false;
            }
            if (PhiOptimizations.getStackHeightAtInstructionBackwards(value.definition) == 0) continue;
            return false;
        }
        ArrayList<Store> stores = new ArrayList<Store>();
        for (Value operand : phi.getOperands()) {
            stores.add(operand.definition.asStore());
        }
        boolean bl = false;
        while (var5_8 < stores.size()) {
            Store store = (Store)stores.get((int)var5_8);
            phi.replaceOperandAt((int)var5_8, store.src());
            store.src().removeUser(store);
            store.getBlock().removeInstruction(store);
            ++var5_8;
        }
        phiLoad.outValue().replaceUsers(phi);
        phiLoad.src().removeUser(phiLoad);
        phiLoad.getBlock().removeInstruction(phiLoad);
        phi.setIsStackPhi(true);
        return true;
    }

    public boolean optimize(IRCode code) {
        return PhiOptimizations.tryMovePhisToStack(code);
    }
}

