/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.features.ClassToFeatureSplitMap;
import com.android.tools.r8.graph.AccessControl;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramDefinition;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.InitClass;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.DescriptorUtils;
import java.util.Set;
import java.util.function.BiConsumer;

public class ReflectionOptimizer {
    public static void rewriteGetClassOrForNameToConstClass(AppView<AppInfoWithLiveness> appView, IRCode code) {
        if (!appView.appInfo().canUseConstClassInstructions(appView.options())) {
            return;
        }
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        ProgramMethod context = code.context();
        BasicBlockIterator blockIterator = code.listIterator();
        while (blockIterator.hasNext()) {
            BasicBlock block = blockIterator.next();
            InstructionListIterator it = block.listIterator(code);
            while (it.hasNext()) {
                InvokeMethod invoke = (InvokeMethod)it.nextUntil(x -> x.isInvokeStatic() || x.isInvokeVirtual());
                if (invoke == null) continue;
                if (invoke.isInvokeStatic()) {
                    ReflectionOptimizer.applyTypeForClassForNameTo(appView, context, invoke.asInvokeStatic(), ReflectionOptimizer.rewriteSingleGetClassOrForNameToConstClass(appView, code, blockIterator, it, invoke, affectedValues));
                    continue;
                }
                ReflectionOptimizer.applyTypeForGetClassTo(appView, context, invoke.asInvokeVirtual(), ReflectionOptimizer.rewriteSingleGetClassOrForNameToConstClass(appView, code, blockIterator, it, invoke, affectedValues));
            }
        }
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(appView).narrowing(affectedValues);
        }
        assert (code.isConsistentSSA(appView));
    }

    private static BiConsumer<DexType, DexClass> rewriteSingleGetClassOrForNameToConstClass(AppView<AppInfoWithLiveness> appView, IRCode code, BasicBlockIterator blockIterator, InstructionListIterator instructionIterator, InvokeMethod invoke, Set<Value> affectedValues) {
        return (type, baseClass) -> {
            InitClass initClass = null;
            if (invoke.getInvokedMethod().match(appView.dexItemFactory().classMethods.forName)) {
                if (baseClass.isProgramClass() && !((AppInfoWithLiveness)appView.appInfo()).getMainDexInfo().canRebindReference(code.context(), baseClass.getType(), appView.getSyntheticItems())) {
                    return;
                }
                if (type.isClassType() && baseClass.classInitializationMayHaveSideEffectsInContext(appView, code.context())) {
                    if (!baseClass.isProgramClass() || !appView.canUseInitClass()) {
                        return;
                    }
                    initClass = ((InitClass.Builder)((InitClass.Builder)InitClass.builder().setFreshOutValue(code, TypeElement.getInt())).setType((DexType)type).setPosition(invoke)).build();
                }
            }
            if (!invoke.hasOutValue() || !invoke.outValue().hasAnyUsers()) {
                if (initClass != null) {
                    instructionIterator.replaceCurrentInstruction(initClass);
                } else {
                    instructionIterator.removeOrReplaceByDebugLocalRead();
                }
                return;
            }
            BasicBlock block = invoke.getBlock();
            affectedValues.addAll(invoke.outValue().affectedValues());
            instructionIterator.replaceCurrentInstructionWithConstClass(appView, code, (DexType)type, invoke.getLocalInfo());
            if (initClass != null) {
                if (block.hasCatchHandlers()) {
                    instructionIterator.splitCopyCatchHandlers(code, blockIterator, appView.options()).listIterator(code).add(initClass);
                } else {
                    instructionIterator.add(initClass);
                }
            }
            if (appView.options().isGeneratingClassFiles()) {
                code.method().upgradeClassFileVersion(appView.options().requiredCfVersionForConstClassInstructions());
            }
        };
    }

    private static void applyTypeForGetClassTo(AppView<AppInfoWithLiveness> appView, ProgramMethod context, InvokeVirtual invoke, BiConsumer<DexType, ? super DexClass> consumer) {
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        DexMethod invokedMethod = invoke.getInvokedMethod();
        if (invokedMethod != dexItemFactory.objectMembers.getClass) {
            return;
        }
        Value in = invoke.getReceiver();
        if (in.hasLocalInfo()) {
            return;
        }
        TypeElement inType = in.getType();
        if (!inType.isClassType() && !inType.isArrayType() || inType.isNullable()) {
            return;
        }
        DexType type = inType.isClassType() ? inType.asClassType().getClassType() : inType.asArrayType().toDexType(dexItemFactory);
        DexType baseType = type.toBaseType(dexItemFactory);
        if (!baseType.isClassType()) {
            return;
        }
        DexProgramClass clazz = DexProgramClass.asProgramClassOrNull(appView.definitionFor(baseType));
        if (clazz == null) {
            return;
        }
        if (!(clazz.isEffectivelyFinal(appView) || !in.isPhi() && in.definition.isCreatingInstanceOrArray())) {
            return;
        }
        Inliner.ConstraintWithTarget constraints = Inliner.ConstraintWithTarget.classIsVisible(context, baseType, appView);
        if (constraints == Inliner.ConstraintWithTarget.NEVER) {
            return;
        }
        consumer.accept(type, clazz);
    }

    private static void applyTypeForClassForNameTo(AppView<AppInfoWithLiveness> appView, ProgramMethod context, InvokeStatic invoke, BiConsumer<DexType, ? super DexClass> consumer) {
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        DexMethod invokedMethod = invoke.getInvokedMethod();
        if (invokedMethod != dexItemFactory.classMethods.forName) {
            return;
        }
        assert (invoke.arguments().size() == 1);
        Value in = invoke.getArgument(0).getAliasedValue();
        if (in.hasLocalInfo() || in.isPhi()) {
            return;
        }
        if (invoke.hasOutValue() && invoke.outValue().hasLocalInfo()) {
            return;
        }
        DexType type = null;
        if (in.definition.isDexItemBasedConstString()) {
            if (in.definition.asDexItemBasedConstString().getItem().isDexType()) {
                type = in.definition.asDexItemBasedConstString().getItem().asDexType();
            }
        } else if (in.definition.isConstString()) {
            String name = in.definition.asConstString().getValue().toString();
            String descriptor = DescriptorUtils.javaTypeToDescriptorIfValidJavaType(name);
            if (descriptor == null && name.startsWith("[") && name.endsWith(";")) {
                descriptor = name.replace('.', '/');
            }
            if (descriptor == null || descriptor.indexOf(46) > 0) {
                return;
            }
            type = dexItemFactory.createType(descriptor);
            if (!type.isReferenceType()) {
                return;
            }
        } else {
            return;
        }
        if (type == null) {
            return;
        }
        DexType baseType = type.toBaseType(dexItemFactory);
        DexClass baseClass = appView.appInfo().definitionForWithoutExistenceAssert(baseType);
        if (baseClass == null || !baseClass.isResolvable(appView)) {
            return;
        }
        ClassToFeatureSplitMap classToFeatureSplitMap = appView.appInfo().getClassToFeatureSplitMap();
        if (AccessControl.isClassAccessible(baseClass, context, classToFeatureSplitMap, appView.getSyntheticItems()).isPossiblyFalse()) {
            return;
        }
        assert (!baseClass.isProgramClass() || classToFeatureSplitMap.isInBaseOrSameFeatureAs(baseClass.asProgramClass(), (ProgramDefinition)context, appView.getSyntheticItems()));
        consumer.accept(type, baseClass);
    }
}

