/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.com.google.common.base.Supplier;
import com.android.tools.r8.com.google.common.base.Suppliers;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.AlwaysMaterializingDefinition;
import com.android.tools.r8.ir.code.AlwaysMaterializingNop;
import com.android.tools.r8.ir.code.AlwaysMaterializingUser;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.IntSwitch;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.NumericType;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.CodeRewriter;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntArrayList;
import com.android.tools.r8.utils.InternalOptions;
import java.util.Collections;

public class RuntimeWorkaroundCodeRewriter {
    private static final int SELF_RECURSION_LIMIT = 4;

    public static void workaroundDex2OatInliningIssue(AppView<?> appView, IRCode code) {
        if (!appView.options().canHaveDex2OatInliningIssue() || code.hasCatchHandlers()) {
            return;
        }
        int selfRecursionFanOut = 0;
        Instruction lastSelfRecursiveCall = null;
        for (Instruction i : code.instructions()) {
            if (!i.isInvokeMethod() || i.asInvokeMethod().getInvokedMethod() != code.method().getReference()) continue;
            ++selfRecursionFanOut;
            lastSelfRecursiveCall = i;
        }
        if (selfRecursionFanOut > 4) {
            assert (lastSelfRecursiveCall != null);
            InstructionListIterator splitIterator = lastSelfRecursiveCall.getBlock().listIterator(code, lastSelfRecursiveCall);
            splitIterator.previous();
            BasicBlock newBlock = splitIterator.split(code, 1);
            DexType guard = appView.dexItemFactory().throwableType;
            BasicBlock rethrowBlock = BasicBlock.createRethrowBlock(code, lastSelfRecursiveCall.getPosition(), guard, appView);
            code.blocks.add(rethrowBlock);
            newBlock.appendCatchHandler(rethrowBlock, guard);
        }
    }

    public static void workaroundDex2OatLinkedListBug(IRCode code, InternalOptions options) {
        if (!options.canHaveDex2OatLinkedListBug()) {
            return;
        }
        DexItemFactory factory = options.itemFactory;
        Supplier<DexMethod> javaLangLangSignum = Suppliers.memoize(() -> factory.createMethod(factory.createString("Ljava/lang/Long;"), factory.createString("signum"), factory.intDescriptor, new DexString[]{factory.longDescriptor}));
        for (BasicBlock block : code.blocks) {
            Instruction secondMaterializing;
            InstructionListIterator it = block.listIterator(code);
            Instruction firstMaterializing = (Instruction)it.nextUntil(RuntimeWorkaroundCodeRewriter::isNotPseudoInstruction);
            if (!RuntimeWorkaroundCodeRewriter.isLongMul(firstMaterializing) || !RuntimeWorkaroundCodeRewriter.isLongAddOrSub(secondMaterializing = (Instruction)it.nextUntil(RuntimeWorkaroundCodeRewriter::isNotPseudoInstruction)) || RuntimeWorkaroundCodeRewriter.isFallthoughTarget(block)) continue;
            Value outOfMul = firstMaterializing.outValue();
            for (Value inOfAddOrSub : secondMaterializing.inValues()) {
                if (!RuntimeWorkaroundCodeRewriter.isAliasOf(inOfAddOrSub, outOfMul)) continue;
                it = block.listIterator(code);
                it.nextUntil(i -> i == firstMaterializing);
                Value longValue = firstMaterializing.inValues().get(0);
                InvokeStatic invokeLongSignum = new InvokeStatic((DexMethod)javaLangLangSignum.get(), null, Collections.singletonList(longValue));
                RuntimeWorkaroundCodeRewriter.ensureThrowingInstructionBefore(code, firstMaterializing, it, invokeLongSignum);
                return;
            }
        }
    }

    public static void workaroundExceptionTargetingLoopHeaderBug(IRCode code, InternalOptions options) {
        if (!options.canHaveExceptionTargetingLoopHeaderBug()) {
            return;
        }
        for (BasicBlock block : code.blocks) {
            if (!block.hasCatchHandlers()) continue;
            for (BasicBlock handler : block.getCatchHandlers().getUniqueTargets()) {
                BasicBlock target = handler.endOfGotoChain();
                if (target == null || target.getPredecessors().size() <= 1 || target.getNormalPredecessors().size() <= 1 || target.getNormalSuccessors().size() <= 1) continue;
                AlwaysMaterializingNop fixit = new AlwaysMaterializingNop();
                fixit.setBlock(handler);
                fixit.setPosition(handler.getPosition());
                handler.getInstructions().addFirst(fixit);
            }
        }
    }

    public static void workaroundForwardingInitializerBug(IRCode code, InternalOptions options) {
        if (!options.canHaveForwardingInitInliningBug()) {
            return;
        }
        if (!code.method().isInstanceInitializer()) {
            return;
        }
        DexTypeList paramTypes = ((DexMethod)code.method().getReference()).proto.parameters;
        if (paramTypes.size() != 3 || paramTypes.values[0] != options.itemFactory.doubleType || paramTypes.values[1] != options.itemFactory.doubleType || !paramTypes.values[2].isClassType()) {
            return;
        }
        for (BasicBlock block : code.blocks) {
            InstructionListIterator it = block.listIterator(code);
            Instruction superConstructorCall = (Instruction)it.nextUntil(i -> i.isInvokeDirect() && i.asInvokeDirect().getInvokedMethod().name == options.itemFactory.constructorMethodName && i.asInvokeDirect().arguments().size() == 4 && i.asInvokeDirect().arguments().stream().allMatch(Value::isArgument));
            if (superConstructorCall == null) continue;
            RuntimeWorkaroundCodeRewriter.ensureInstructionBefore(code, superConstructorCall, it);
            break;
        }
    }

    public static void workaroundSwitchMaxIntBug(IRCode code, CodeRewriter codeRewriter, InternalOptions options) {
        if (options.canHaveSwitchMaxIntBug() && code.metadata().mayHaveSwitch()) {
            RuntimeWorkaroundCodeRewriter.rewriteSwitchForMaxIntOnly(code, codeRewriter);
        }
    }

    private static void rewriteSwitchForMaxIntOnly(IRCode code, CodeRewriter codeRewriter) {
        boolean needToSplitCriticalEdges = false;
        BasicBlockIterator blocksIterator = code.listIterator();
        while (blocksIterator.hasNext()) {
            BasicBlock block = (BasicBlock)blocksIterator.next();
            InstructionListIterator iterator2 = block.listIterator(code);
            while (iterator2.hasNext()) {
                IntSwitch intSwitch;
                Instruction instruction = (Instruction)iterator2.next();
                assert (!instruction.isStringSwitch());
                if (!instruction.isIntSwitch() || (intSwitch = instruction.asIntSwitch()).getKey(intSwitch.numberOfKeys() - 1) != Integer.MAX_VALUE) continue;
                if (intSwitch.numberOfKeys() == 1) {
                    codeRewriter.rewriteSingleKeySwitchToIf(code, block, iterator2, intSwitch);
                } else {
                    IntArrayList newSwitchSequences = new IntArrayList(intSwitch.numberOfKeys() - 1);
                    for (int i = 0; i < intSwitch.numberOfKeys() - 1; ++i) {
                        newSwitchSequences.add(intSwitch.getKey(i));
                    }
                    IntArrayList outliers = new IntArrayList(1);
                    outliers.add(Integer.MAX_VALUE);
                    codeRewriter.convertSwitchToSwitchAndIfs(code, blocksIterator, block, iterator2, intSwitch, ImmutableList.of(newSwitchSequences), outliers);
                }
                needToSplitCriticalEdges = true;
            }
        }
        if (needToSplitCriticalEdges) {
            code.splitCriticalEdges();
        }
    }

    public static void workaroundNumberConversionRegisterAllocationBug(IRCode code, InternalOptions options) {
        if (!options.canHaveNumberConversionRegisterAllocationBug()) {
            return;
        }
        DexItemFactory dexItemFactory = options.dexItemFactory();
        BasicBlockIterator blocks = code.listIterator();
        while (blocks.hasNext()) {
            BasicBlock block = (BasicBlock)blocks.next();
            InstructionListIterator it = block.listIterator(code);
            while (it.hasNext()) {
                Instruction instruction = (Instruction)it.next();
                if (!instruction.isArithmeticBinop() && !instruction.isNeg()) continue;
                for (Value value : instruction.inValues()) {
                    BasicBlock blockWithInvokeNaN;
                    if (value.isPhi() || !value.definition.isNumberConversion() || value.definition.asNumberConversion().to != NumericType.DOUBLE) continue;
                    InvokeStatic invokeIsNaN = new InvokeStatic(dexItemFactory.doubleMembers.isNaN, null, ImmutableList.of(value));
                    invokeIsNaN.setPosition(instruction.getPosition());
                    it.previous();
                    BasicBlock basicBlock = blockWithInvokeNaN = block.hasCatchHandlers() ? it.split(code, blocks) : block;
                    if (blockWithInvokeNaN != block) {
                        it = block.listIterator(code, block.getInstructions().size());
                        it.previous();
                        it.add(invokeIsNaN);
                        block = blockWithInvokeNaN;
                        it = block.listIterator(code);
                    } else {
                        it.add(invokeIsNaN);
                    }
                    Instruction temp = (Instruction)it.next();
                    assert (temp == instruction);
                }
            }
        }
    }

    private static void ensureInstructionBefore(IRCode code, Instruction addBefore, InstructionListIterator it) {
        Instruction check = (Instruction)it.previous();
        assert (addBefore == check);
        Value fixitValue = code.createValue(TypeElement.getInt());
        AlwaysMaterializingDefinition fixitDefinition = new AlwaysMaterializingDefinition(fixitValue);
        fixitDefinition.setBlock(addBefore.getBlock());
        fixitDefinition.setPosition(addBefore.getPosition());
        it.add(fixitDefinition);
        AlwaysMaterializingUser fixitUser = new AlwaysMaterializingUser(fixitValue);
        fixitUser.setBlock(addBefore.getBlock());
        fixitUser.setPosition(addBefore.getPosition());
        it.add(fixitUser);
    }

    private static void ensureThrowingInstructionBefore(IRCode code, Instruction addBefore, InstructionListIterator it, Instruction instruction) {
        Instruction check = (Instruction)it.previous();
        assert (addBefore == check);
        BasicBlock block = check.getBlock();
        if (block.hasCatchHandlers()) {
            BasicBlock split = it.split(code);
            assert (split.hasCatchHandlers());
            assert (!block.hasCatchHandlers());
            it = block.listIterator(code, block.getInstructions().size() - 1);
        }
        instruction.setPosition(addBefore.getPosition());
        it.add(instruction);
    }

    private static boolean isNotPseudoInstruction(Instruction instruction) {
        return !instruction.isDebugInstruction() && !instruction.isMove();
    }

    private static boolean isAliasOf(Value usedValue, Value definingValue) {
        while (usedValue != definingValue) {
            Instruction definition = usedValue.definition;
            if (definition == null || !definition.isMove()) {
                return false;
            }
            usedValue = definition.asMove().src();
        }
        return true;
    }

    private static boolean isLongMul(Instruction instruction) {
        return instruction != null && instruction.isMul() && instruction.asBinop().getNumericType() == NumericType.LONG && instruction.outValue() != null;
    }

    private static boolean isLongAddOrSub(Instruction instruction) {
        return instruction != null && (instruction.isAdd() || instruction.isSub()) && instruction.asBinop().getNumericType() == NumericType.LONG;
    }

    private static boolean isFallthoughTarget(BasicBlock block) {
        for (BasicBlock pred : block.getPredecessors()) {
            if (pred.exit().fallthroughBlock() != block) continue;
            return true;
        }
        return false;
    }
}

