/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.androidapi.AndroidApiLevelCompute;
import com.android.tools.r8.com.google.common.collect.ImmutableList;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.ConstClass;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.desugar.ServiceLoaderSourceCode;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.BooleanBox;
import com.android.tools.r8.utils.ListUtils;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;

public class ServiceLoaderRewriter {
    private final AppView<AppInfoWithLiveness> appView;
    private final List<ProgramMethod> serviceLoadMethods = new ArrayList<ProgramMethod>();
    private final AndroidApiLevelCompute apiLevelCompute;

    public ServiceLoaderRewriter(AppView<AppInfoWithLiveness> appView, AndroidApiLevelCompute apiLevelCompute) {
        this.appView = appView;
        this.apiLevelCompute = apiLevelCompute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DexEncodedMethod createSynthesizedMethod(DexType serviceType, List<DexClass> classes, CompilationContext.MethodProcessingContext methodProcessingContext) {
        DexProto proto = this.appView.dexItemFactory().createProto(this.appView.dexItemFactory().iteratorType, new DexType[0]);
        ProgramMethod method = this.appView.getSyntheticItems().createMethod(kinds -> kinds.SERVICE_LOADER, methodProcessingContext.createUniqueContext(), this.appView, builder -> builder.setAccessFlags(MethodAccessFlags.createPublicStaticSynthetic()).setProto(proto).setApiLevelForDefinition(this.appView.computedMinApiLevel()).setApiLevelForCode(this.apiLevelCompute.computeApiLevelForDefinition(ListUtils.map(classes, clazz -> clazz.type), this.apiLevelCompute.getPlatformApiLevelOrUnknown(this.appView))).setCode(m3 -> ServiceLoaderSourceCode.generate(serviceType, classes, this.appView.dexItemFactory())));
        List<ProgramMethod> list = this.serviceLoadMethods;
        synchronized (list) {
            this.serviceLoadMethods.add(method);
        }
        return (DexEncodedMethod)method.getDefinition();
    }

    public List<ProgramMethod> getServiceLoadMethods() {
        return this.serviceLoadMethods;
    }

    public void rewrite(IRCode code, CompilationContext.MethodProcessingContext methodProcessingContext) {
        DexItemFactory factory = this.appView.dexItemFactory();
        InstructionListIterator instructionIterator = code.instructionListIterator();
        IdentityHashMap<DexType, DexEncodedMethod> synthesizedServiceLoaders = new IdentityHashMap<DexType, DexEncodedMethod>();
        while (instructionIterator.hasNext()) {
            boolean isGetClassLoaderOnConstClassOrNull;
            Value argument;
            InvokeStatic serviceLoaderLoad;
            Value serviceLoaderLoadOut;
            Instruction instruction = (Instruction)instructionIterator.next();
            if (!instruction.isInvokeStatic() || instruction.asInvokeStatic().getInvokedMethod() != factory.serviceLoaderMethods.loadWithClassLoader || (serviceLoaderLoadOut = (serviceLoaderLoad = instruction.asInvokeStatic()).outValue()).numberOfAllUsers() != 1 || serviceLoaderLoadOut.hasPhiUsers() || !serviceLoaderLoadOut.singleUniqueUser().isInvokeVirtual() || serviceLoaderLoadOut.singleUniqueUser().asInvokeVirtual().getInvokedMethod() != factory.serviceLoaderMethods.iterator || (argument = serviceLoaderLoad.inValues().get(0).getAliasedValue()).isPhi() || !argument.definition.isConstClass()) continue;
            ConstClass constClass = argument.getConstInstruction().asConstClass();
            if (this.appView.appInfo().isPinned(constClass.getValue()) || !this.appView.appServices().allServiceTypes().contains(constClass.getValue()) || this.appView.appServices().hasServiceImplementationsInFeature(this.appView, constClass.getValue()) || serviceLoaderLoad.inValues().get(1).isPhi()) continue;
            InvokeVirtual classLoaderInvoke = serviceLoaderLoad.inValues().get((int)1).definition.asInvokeVirtual();
            boolean bl = isGetClassLoaderOnConstClassOrNull = serviceLoaderLoad.inValues().get(1).getType().isNullType() || classLoaderInvoke != null && classLoaderInvoke.inValues().size() == 1 && classLoaderInvoke.getReceiver().getAliasedValue().isConstClass() && classLoaderInvoke.getReceiver().getAliasedValue().getConstInstruction().asConstClass().getValue() == constClass.getValue();
            if (!isGetClassLoaderOnConstClassOrNull) continue;
            List<DexType> dexTypes = this.appView.appServices().serviceImplementationsFor(constClass.getValue());
            ArrayList<DexClass> classes = new ArrayList<DexClass>(dexTypes.size());
            boolean seenNull = false;
            for (DexType serviceImpl : dexTypes) {
                DexClass serviceImplClazz = this.appView.definitionFor(serviceImpl);
                if (serviceImplClazz == null) {
                    seenNull = true;
                }
                classes.add(serviceImplClazz);
            }
            if (seenNull) continue;
            DexEncodedMethod synthesizedMethod = synthesizedServiceLoaders.computeIfAbsent(constClass.getValue(), service -> {
                DexEncodedMethod addedMethod = this.createSynthesizedMethod((DexType)service, (List<DexClass>)classes, methodProcessingContext);
                if (this.appView.options().isGeneratingClassFiles()) {
                    addedMethod.upgradeClassFileVersion(((DexEncodedMethod)code.context().getDefinition()).getClassFileVersion());
                }
                return addedMethod;
            });
            new Rewriter(code, instructionIterator, serviceLoaderLoad).perform(classLoaderInvoke, (DexMethod)synthesizedMethod.getReference());
        }
    }

    private static class Rewriter {
        private final IRCode code;
        private final InvokeStatic serviceLoaderLoad;
        private final InstructionListIterator iterator;

        Rewriter(IRCode code, InstructionListIterator iterator2, InvokeStatic serviceLoaderLoad) {
            this.iterator = iterator2;
            this.code = code;
            this.serviceLoaderLoad = serviceLoaderLoad;
        }

        private void clearGetClassLoader(InvokeVirtual classLoaderInvoke) {
            while (this.iterator.hasPrevious()) {
                Instruction instruction = (Instruction)this.iterator.previous();
                if (instruction != classLoaderInvoke) continue;
                this.iterator.replaceCurrentInstruction(this.code.createConstNull());
                break;
            }
        }

        public void perform(InvokeVirtual classLoaderInvoke, DexMethod method) {
            if (classLoaderInvoke != null) {
                BooleanBox allClassLoaderUsersAreServiceLoaders = new BooleanBox(!classLoaderInvoke.outValue().hasPhiUsers());
                classLoaderInvoke.outValue().uniqueUsers().forEach(user -> {
                    assert (!user.isAssume());
                    allClassLoaderUsersAreServiceLoaders.and(user == this.serviceLoaderLoad);
                });
                if (allClassLoaderUsersAreServiceLoaders.get()) {
                    this.clearGetClassLoader(classLoaderInvoke);
                    this.iterator.nextUntil(i -> i == this.serviceLoaderLoad);
                }
            }
            InvokeVirtual serviceLoaderIterator = this.serviceLoaderLoad.outValue().singleUniqueUser().asInvokeVirtual();
            this.iterator.replaceCurrentInstruction(this.code.createConstNull());
            this.iterator.nextUntil(x -> x == serviceLoaderIterator);
            InvokeStatic synthesizedInvoke = new InvokeStatic(method, serviceLoaderIterator.outValue(), ImmutableList.of());
            this.iterator.replaceCurrentInstruction(synthesizedInvoke);
        }
    }
}

