/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize;

import com.android.tools.r8.cf.CfVersion;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.CfCode;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.conversion.MethodProcessor;
import com.android.tools.r8.ir.optimize.templates.CfUtilityMethodsForCodeOptimizations;
import com.android.tools.r8.synthesis.SyntheticItems;
import com.android.tools.r8.utils.InternalOptions;

public class UtilityMethodsForCodeOptimizations {
    public static UtilityMethodForCodeOptimizations synthesizeToStringIfNotNullMethod(AppView<?> appView, CompilationContext.MethodProcessingContext methodProcessingContext) {
        InternalOptions options = appView.options();
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        DexProto proto = dexItemFactory.createProto(dexItemFactory.voidType, dexItemFactory.objectType);
        SyntheticItems syntheticItems = appView.getSyntheticItems();
        ProgramMethod syntheticMethod = syntheticItems.createMethod(kinds -> kinds.TO_STRING_IF_NOT_NULL, methodProcessingContext.createUniqueContext(), appView, builder -> builder.setAccessFlags(MethodAccessFlags.createPublicStaticSynthetic()).setClassFileVersion(CfVersion.V1_8).setApiLevelForDefinition(appView.computedMinApiLevel()).setApiLevelForCode(appView.computedMinApiLevel()).setCode(method -> UtilityMethodsForCodeOptimizations.getToStringIfNotNullCodeTemplate(method, options)).setProto(proto));
        return new UtilityMethodForCodeOptimizations(syntheticMethod);
    }

    private static CfCode getToStringIfNotNullCodeTemplate(DexMethod method, InternalOptions options) {
        return CfUtilityMethodsForCodeOptimizations.CfUtilityMethodsForCodeOptimizationsTemplates_toStringIfNotNull(options, method);
    }

    public static UtilityMethodForCodeOptimizations synthesizeThrowClassCastExceptionIfNotNullMethod(AppView<?> appView, CompilationContext.MethodProcessingContext methodProcessingContext) {
        InternalOptions options = appView.options();
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        DexProto proto = dexItemFactory.createProto(dexItemFactory.voidType, dexItemFactory.objectType);
        SyntheticItems syntheticItems = appView.getSyntheticItems();
        CompilationContext.UniqueContext positionContext = methodProcessingContext.createUniqueContext();
        ProgramMethod syntheticMethod = syntheticItems.createMethod(kinds -> kinds.THROW_CCE_IF_NOT_NULL, positionContext, appView, builder -> builder.setAccessFlags(MethodAccessFlags.createPublicStaticSynthetic()).setClassFileVersion(CfVersion.V1_8).setApiLevelForDefinition(appView.computedMinApiLevel()).setApiLevelForCode(appView.computedMinApiLevel()).setCode(method -> UtilityMethodsForCodeOptimizations.getThrowClassCastExceptionIfNotNullCodeTemplate(method, options)).setProto(proto));
        return new UtilityMethodForCodeOptimizations(syntheticMethod);
    }

    private static CfCode getThrowClassCastExceptionIfNotNullCodeTemplate(DexMethod method, InternalOptions options) {
        return CfUtilityMethodsForCodeOptimizations.CfUtilityMethodsForCodeOptimizationsTemplates_throwClassCastExceptionIfNotNull(options, method);
    }

    public static UtilityMethodForCodeOptimizations synthesizeThrowIllegalAccessErrorMethod(AppView<?> appView, CompilationContext.MethodProcessingContext methodProcessingContext) {
        InternalOptions options = appView.options();
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        DexProto proto = dexItemFactory.createProto(dexItemFactory.illegalAccessErrorType, new DexType[0]);
        SyntheticItems syntheticItems = appView.getSyntheticItems();
        ProgramMethod syntheticMethod = syntheticItems.createMethod(kinds -> kinds.THROW_IAE, methodProcessingContext.createUniqueContext(), appView, builder -> builder.setAccessFlags(MethodAccessFlags.createPublicStaticSynthetic()).setClassFileVersion(CfVersion.V1_8).setApiLevelForDefinition(appView.computedMinApiLevel()).setApiLevelForCode(appView.computedMinApiLevel()).setCode(method -> UtilityMethodsForCodeOptimizations.getThrowIllegalAccessErrorCodeTemplate(method, options)).setProto(proto));
        return new UtilityMethodForCodeOptimizations(syntheticMethod);
    }

    private static CfCode getThrowIllegalAccessErrorCodeTemplate(DexMethod method, InternalOptions options) {
        return CfUtilityMethodsForCodeOptimizations.CfUtilityMethodsForCodeOptimizationsTemplates_throwIllegalAccessError(options, method);
    }

    public static UtilityMethodForCodeOptimizations synthesizeThrowIncompatibleClassChangeErrorMethod(AppView<?> appView, CompilationContext.MethodProcessingContext methodProcessingContext) {
        InternalOptions options = appView.options();
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        DexProto proto = dexItemFactory.createProto(dexItemFactory.icceType, new DexType[0]);
        SyntheticItems syntheticItems = appView.getSyntheticItems();
        ProgramMethod syntheticMethod = syntheticItems.createMethod(kinds -> kinds.THROW_ICCE, methodProcessingContext.createUniqueContext(), appView, builder -> builder.setAccessFlags(MethodAccessFlags.createPublicStaticSynthetic()).setClassFileVersion(CfVersion.V1_8).setApiLevelForDefinition(appView.computedMinApiLevel()).setApiLevelForCode(appView.computedMinApiLevel()).setCode(method -> UtilityMethodsForCodeOptimizations.getThrowIncompatibleClassChangeErrorCodeTemplate(method, options)).setProto(proto));
        return new UtilityMethodForCodeOptimizations(syntheticMethod);
    }

    private static CfCode getThrowIncompatibleClassChangeErrorCodeTemplate(DexMethod method, InternalOptions options) {
        return CfUtilityMethodsForCodeOptimizations.CfUtilityMethodsForCodeOptimizationsTemplates_throwIncompatibleClassChangeError(options, method);
    }

    public static UtilityMethodForCodeOptimizations synthesizeThrowNoSuchMethodErrorMethod(AppView<?> appView, CompilationContext.MethodProcessingContext methodProcessingContext) {
        InternalOptions options = appView.options();
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        DexProto proto = dexItemFactory.createProto(dexItemFactory.noSuchMethodErrorType, new DexType[0]);
        SyntheticItems syntheticItems = appView.getSyntheticItems();
        ProgramMethod syntheticMethod = syntheticItems.createMethod(kinds -> kinds.THROW_NSME, methodProcessingContext.createUniqueContext(), appView, builder -> builder.setAccessFlags(MethodAccessFlags.createPublicStaticSynthetic()).setClassFileVersion(CfVersion.V1_8).setApiLevelForDefinition(appView.computedMinApiLevel()).setApiLevelForCode(appView.computedMinApiLevel()).setCode(method -> UtilityMethodsForCodeOptimizations.getThrowNoSuchMethodErrorCodeTemplate(method, options)).setProto(proto));
        return new UtilityMethodForCodeOptimizations(syntheticMethod);
    }

    private static CfCode getThrowNoSuchMethodErrorCodeTemplate(DexMethod method, InternalOptions options) {
        return CfUtilityMethodsForCodeOptimizations.CfUtilityMethodsForCodeOptimizationsTemplates_throwNoSuchMethodError(options, method);
    }

    public static class UtilityMethodForCodeOptimizations {
        private final ProgramMethod method;
        private boolean optimized;

        private UtilityMethodForCodeOptimizations(ProgramMethod method) {
            this.method = method;
        }

        public ProgramMethod getMethod() {
            assert (this.optimized);
            return this.method;
        }

        public ProgramMethod uncheckedGetMethod() {
            return this.method;
        }

        public void optimize(MethodProcessor methodProcessor) {
            methodProcessor.scheduleDesugaredMethodForProcessing(this.method);
            this.optimized = true;
        }
    }

    public static interface MethodSynthesizerConsumer {
        public UtilityMethodForCodeOptimizations synthesizeMethod(AppView<?> var1, CompilationContext.MethodProcessingContext var2);
    }
}

