/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.classinliner;

import com.android.tools.r8.com.google.common.collect.Lists;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionOrPhi;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.MethodProcessor;
import com.android.tools.r8.ir.optimize.AssumeRemover;
import com.android.tools.r8.ir.optimize.CodeRewriter;
import com.android.tools.r8.ir.optimize.Inliner;
import com.android.tools.r8.ir.optimize.InliningOracle;
import com.android.tools.r8.ir.optimize.classinliner.ClassInlinerCostAnalysis;
import com.android.tools.r8.ir.optimize.classinliner.InlineCandidateProcessor;
import com.android.tools.r8.ir.optimize.enums.EnumValueOptimizer;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.inliner.InliningIRProvider;
import com.android.tools.r8.ir.optimize.string.StringOptimizer;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public final class ClassInliner {
    private final ConcurrentHashMap<DexClass, EligibilityStatus> knownClasses = new ConcurrentHashMap();

    private EligibilityStatus isClassEligible(AppView<AppInfoWithLiveness> appView, DexProgramClass clazz) {
        EligibilityStatus eligible = this.knownClasses.get(clazz);
        if (eligible == null) {
            EligibilityStatus computed = this.computeClassEligible(appView, clazz);
            EligibilityStatus existing = this.knownClasses.putIfAbsent(clazz, computed);
            assert (existing == null || existing == computed);
            eligible = existing == null ? computed : existing;
        }
        return eligible;
    }

    private EligibilityStatus computeClassEligible(AppView<AppInfoWithLiveness> appView, DexProgramClass clazz) {
        if (clazz == null || clazz.isAbstract() || clazz.isInterface() || !appView.appInfo().isClassInliningAllowed(clazz)) {
            return EligibilityStatus.NOT_ELIGIBLE;
        }
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        for (DexEncodedMethod method : clazz.virtualMethods()) {
            if (((DexMethod)method.getReference()).name != dexItemFactory.finalizeMethodName || ((DexMethod)method.getReference()).proto != dexItemFactory.objectMembers.finalize.proto) continue;
            return EligibilityStatus.NOT_ELIGIBLE;
        }
        if (clazz.classInitializationMayHaveSideEffects(appView)) {
            return EligibilityStatus.NOT_ELIGIBLE;
        }
        if (!appView.testing().allowClassInliningOfSynthetics && appView.getSyntheticItems().isSyntheticClass(clazz)) {
            return EligibilityStatus.NOT_ELIGIBLE;
        }
        return EligibilityStatus.ELIGIBLE;
    }

    public final void processMethodCode(AppView<AppInfoWithLiveness> appView, CodeRewriter codeRewriter, StringOptimizer stringOptimizer, EnumValueOptimizer enumValueOptimizer, ProgramMethod method, IRCode code, OptimizationFeedback feedback, MethodProcessor methodProcessor, CompilationContext.MethodProcessingContext methodProcessingContext, Inliner inliner, Supplier<InliningOracle> defaultOracle) {
        boolean repeat;
        ArrayList roots = Lists.newArrayList(code.instructions(insn -> insn.isNewInstance() || insn.isStaticGet()));
        boolean anyInlinedGeneratedMessageLiteBuilders = false;
        boolean anyInlinedMethods = false;
        do {
            repeat = false;
            Iterator rootsIterator = roots.iterator();
            while (rootsIterator.hasNext()) {
                DexType instantiatedType;
                DexProgramClass clazz2;
                Instruction root = (Instruction)rootsIterator.next();
                InlineCandidateProcessor processor = new InlineCandidateProcessor(appView, inliner, clazz -> this.isClassEligible(appView, (DexProgramClass)clazz), methodProcessor, method, root);
                EligibilityStatus status = processor.isInstanceEligible();
                if (status != EligibilityStatus.ELIGIBLE) {
                    rootsIterator.remove();
                    continue;
                }
                status = processor.isClassAndUsageEligible();
                if (status != EligibilityStatus.ELIGIBLE) {
                    rootsIterator.remove();
                    continue;
                }
                InstructionOrPhi ineligibleUser = processor.areInstanceUsersEligible(defaultOracle);
                if (ineligibleUser != null) continue;
                InliningIRProvider inliningIRProvider = new InliningIRProvider(appView, method, code, methodProcessor);
                ClassInlinerCostAnalysis costAnalysis = new ClassInlinerCostAnalysis(appView, inliningIRProvider, processor.getReceivers());
                if (costAnalysis.willExceedInstructionBudget(code, processor.getEligibleClass(), processor.getDirectInlinees(), processor.getIndirectInlinees())) {
                    rootsIterator.remove();
                    continue;
                }
                if (appView.protoShrinker() != null && root.isNewInstance() && (clazz2 = DexProgramClass.asProgramClassOrNull(appView.definitionFor(instantiatedType = root.asNewInstance().clazz))) != null && appView.protoShrinker().references.isGeneratedMessageLiteBuilder(clazz2)) {
                    anyInlinedGeneratedMessageLiteBuilders = true;
                }
                Set<Value> affectedValues = Sets.newIdentityHashSet();
                AssumeRemover assumeRemover = new AssumeRemover(appView, code, affectedValues);
                try {
                    anyInlinedMethods |= processor.processInlining(code, affectedValues, assumeRemover, inliningIRProvider);
                }
                catch (InlineCandidateProcessor.IllegalClassInlinerStateException e) {
                    assert (false);
                    anyInlinedMethods = true;
                }
                assumeRemover.removeMarkedInstructions();
                code.removeAllDeadAndTrivialPhis(affectedValues);
                assumeRemover.finish();
                assert (code.isConsistentSSA(appView));
                rootsIterator.remove();
                repeat = true;
            }
        } while (repeat);
        if (anyInlinedGeneratedMessageLiteBuilders) {
            appView.withGeneratedMessageLiteBuilderShrinker(shrinker -> shrinker.inlineCallsToDynamicMethod(method, code, enumValueOptimizer, feedback, methodProcessor, inliner));
        }
        if (anyInlinedMethods) {
            boolean isDebugMode;
            codeRewriter.removeTrivialCheckCastAndInstanceOfInstructions(code, method, methodProcessor, methodProcessingContext);
            codeRewriter.simplifyControlFlow(code);
            boolean bl = isDebugMode = appView.options().debug || method.getOrComputeReachabilitySensitive(appView);
            if (!isDebugMode) {
                stringOptimizer.computeTrivialOperationsOnConstString(code);
                stringOptimizer.removeTrivialConversions(code);
            }
        }
    }

    static enum EligibilityStatus {
        ELIGIBLE,
        NOT_ELIGIBLE;

    }
}

