/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.classinliner;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.utils.SetUtils;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;

class ClassInlinerReceiverSet {
    private final Value root;
    private final Set<Value> receiverAliases;
    private final Set<Value> illegalReceiverAliases = Sets.newIdentityHashSet();
    private final Map<Value, List<BooleanSupplier>> deferredAliasValidityChecks = new IdentityHashMap<Value, List<BooleanSupplier>>();

    ClassInlinerReceiverSet(Value root) {
        this.receiverAliases = SetUtils.newIdentityHashSet(root);
        this.root = root;
    }

    private boolean isIllegalReceiverAlias(Value value) {
        if (this.illegalReceiverAliases.contains(value)) {
            return true;
        }
        List<BooleanSupplier> deferredValidityChecks = this.deferredAliasValidityChecks.get(value);
        if (deferredValidityChecks != null) {
            for (BooleanSupplier deferredValidityCheck : deferredValidityChecks) {
                if (deferredValidityCheck.getAsBoolean()) continue;
                return true;
            }
        }
        return false;
    }

    boolean addReceiverAlias(Value alias) {
        if (this.isIllegalReceiverAlias(alias)) {
            return false;
        }
        this.deferredAliasValidityChecks.remove(alias);
        boolean changed = this.receiverAliases.add(alias);
        assert (changed) : alias.toString() + " already added as an alias";
        return true;
    }

    boolean addIllegalReceiverAlias(Value value) {
        if (this.isReceiverAlias(value)) {
            return false;
        }
        this.illegalReceiverAliases.add(value);
        this.deferredAliasValidityChecks.remove(value);
        return true;
    }

    void addDeferredAliasValidityCheck(Value value, BooleanSupplier deferredValidityCheck) {
        assert (!this.isReceiverAlias(value));
        if (this.illegalReceiverAliases.contains(value)) {
            assert (!this.deferredAliasValidityChecks.containsKey(value));
        } else {
            this.deferredAliasValidityChecks.computeIfAbsent(value, ignore -> new ArrayList()).add(deferredValidityCheck);
        }
    }

    boolean isReceiverAlias(Value value) {
        return this.isDefiniteReceiverAlias(value);
    }

    boolean isDefiniteReceiverAlias(Value value) {
        return this.receiverAliases.contains(value);
    }

    void reset() {
        this.deferredAliasValidityChecks.clear();
        this.receiverAliases.clear();
        this.receiverAliases.add(this.root);
    }
}

