/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.classinliner.analysis;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.framework.intraprocedural.DataflowAnalysisResult;
import com.android.tools.r8.ir.analysis.framework.intraprocedural.IntraproceduralDataflowAnalysis;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.optimize.classinliner.analysis.ParameterUsages;
import com.android.tools.r8.ir.optimize.classinliner.analysis.TransferFunction;
import com.android.tools.r8.ir.optimize.classinliner.constraint.ClassInlinerMethodConstraint;
import com.android.tools.r8.ir.optimize.classinliner.constraint.ConditionalClassInlinerMethodConstraint;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.Timing;

public class ClassInlinerMethodConstraintAnalysis {
    public static ClassInlinerMethodConstraint analyze(AppView<AppInfoWithLiveness> appView, ProgramMethod method, IRCode code, Timing timing) {
        if (((DexEncodedMethod)method.getDefinition()).isClassInitializer() || ((DexEncodedMethod)method.getDefinition()).getNumberOfArguments() == 0) {
            return ClassInlinerMethodConstraint.alwaysFalse();
        }
        IntraproceduralDataflowAnalysis<ParameterUsages> analysis = new IntraproceduralDataflowAnalysis<ParameterUsages>(ParameterUsages.bottom(), new TransferFunction(appView, method, code));
        DataflowAnalysisResult.SuccessfulDataflowAnalysisResult result = timing.time("Data flow analysis", () -> analysis.run(code.entryBlock(), timing).asSuccessfulAnalysisResult());
        if (result == null) {
            return ClassInlinerMethodConstraint.alwaysFalse();
        }
        ParameterUsages usages = timing.time("Externalize", () -> ((ParameterUsages)result.join()).externalize());
        if (usages.isBottom()) {
            return ClassInlinerMethodConstraint.alwaysTrue();
        }
        if (usages.isTop()) {
            return ClassInlinerMethodConstraint.alwaysFalse();
        }
        return new ConditionalClassInlinerMethodConstraint(usages);
    }
}

