/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.classinliner.analysis;

import com.android.tools.r8.com.google.common.collect.ImmutableMultiset;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Multiset;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.optimize.classinliner.analysis.NonEmptyParameterUsage;
import com.android.tools.r8.ir.optimize.classinliner.analysis.ParameterUsage;
import com.android.tools.r8.utils.BooleanUtils;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public class InternalNonEmptyParameterUsage
extends ParameterUsage {
    private Set<DexType> castsWithParameter;
    private Set<DexField> fieldsReadFromParameter;
    private Set<InvokeMethodWithReceiver> methodCallsWithParameterAsReceiver;
    private boolean isParameterMutated;
    private boolean isParameterReturned;
    private boolean isParameterUsedAsLock;

    InternalNonEmptyParameterUsage(Set<DexType> castsWithParameter, Set<DexField> fieldsReadFromParameter, Set<InvokeMethodWithReceiver> methodCallsWithParameterAsReceiver, boolean isParameterMutated, boolean isParameterReturned, boolean isParameterUsedAsLock) {
        assert (!castsWithParameter.isEmpty() || !fieldsReadFromParameter.isEmpty() || !methodCallsWithParameterAsReceiver.isEmpty() || isParameterMutated || isParameterReturned || isParameterUsedAsLock);
        this.castsWithParameter = castsWithParameter;
        this.fieldsReadFromParameter = fieldsReadFromParameter;
        this.methodCallsWithParameterAsReceiver = methodCallsWithParameterAsReceiver;
        this.isParameterMutated = isParameterMutated;
        this.isParameterReturned = isParameterReturned;
        this.isParameterUsedAsLock = isParameterUsedAsLock;
    }

    static Builder builder() {
        return new Builder();
    }

    Builder builderFromInstance() {
        return new Builder(this);
    }

    @Override
    ParameterUsage addCastWithParameter(DexType castType) {
        ImmutableSet.Builder newCastsWithParameter = ImmutableSet.builder();
        newCastsWithParameter.addAll(this.castsWithParameter);
        newCastsWithParameter.add(castType);
        return new InternalNonEmptyParameterUsage((Set<DexType>)((Object)newCastsWithParameter.build()), this.fieldsReadFromParameter, this.methodCallsWithParameterAsReceiver, this.isParameterMutated, this.isParameterReturned, this.isParameterUsedAsLock);
    }

    @Override
    InternalNonEmptyParameterUsage addFieldReadFromParameter(DexField field) {
        ImmutableSet.Builder newFieldsReadFromParameterBuilder = ImmutableSet.builder();
        newFieldsReadFromParameterBuilder.addAll(this.fieldsReadFromParameter);
        newFieldsReadFromParameterBuilder.add(field);
        return new InternalNonEmptyParameterUsage(this.castsWithParameter, (Set<DexField>)((Object)newFieldsReadFromParameterBuilder.build()), this.methodCallsWithParameterAsReceiver, this.isParameterMutated, this.isParameterReturned, this.isParameterUsedAsLock);
    }

    @Override
    InternalNonEmptyParameterUsage addMethodCallWithParameterAsReceiver(InvokeMethodWithReceiver invoke) {
        ImmutableSet.Builder newMethodCallsWithParameterAsReceiverBuilder = ImmutableSet.builder();
        newMethodCallsWithParameterAsReceiverBuilder.addAll(this.methodCallsWithParameterAsReceiver);
        newMethodCallsWithParameterAsReceiverBuilder.add(invoke);
        return new InternalNonEmptyParameterUsage(this.castsWithParameter, this.fieldsReadFromParameter, (Set<InvokeMethodWithReceiver>)((Object)newMethodCallsWithParameterAsReceiverBuilder.build()), this.isParameterMutated, this.isParameterReturned, this.isParameterUsedAsLock);
    }

    @Override
    public InternalNonEmptyParameterUsage asInternalNonEmpty() {
        return this;
    }

    @Override
    ParameterUsage externalize() {
        ImmutableMultiset.Builder methodCallsWithParameterAsReceiverBuilder = ImmutableMultiset.builder();
        this.methodCallsWithParameterAsReceiver.forEach(invoke -> methodCallsWithParameterAsReceiverBuilder.add(invoke.getInvokedMethod()));
        return new NonEmptyParameterUsage(this.castsWithParameter, this.fieldsReadFromParameter, (Multiset<DexMethod>)((Object)methodCallsWithParameterAsReceiverBuilder.build()), this.isParameterMutated, this.isParameterReturned, this.isParameterUsedAsLock);
    }

    @Override
    public boolean isParameterMutated() {
        return this.isParameterMutated;
    }

    @Override
    public boolean isParameterReturned() {
        return this.isParameterReturned;
    }

    @Override
    public boolean isParameterUsedAsLock() {
        return this.isParameterUsedAsLock;
    }

    InternalNonEmptyParameterUsage join(InternalNonEmptyParameterUsage other) {
        return this.builderFromInstance().addCastsWithParameter(other.castsWithParameter).addFieldsReadFromParameter(other.fieldsReadFromParameter).addMethodCallsWithParameterAsReceiver(other.methodCallsWithParameterAsReceiver).joinIsReceiverMutated(other.isParameterMutated).joinIsReceiverReturned(other.isParameterReturned).joinIsReceiverUsedAsLock(other.isParameterUsedAsLock).build();
    }

    @Override
    InternalNonEmptyParameterUsage setParameterMutated() {
        if (this.isParameterMutated) {
            return this;
        }
        return new InternalNonEmptyParameterUsage(this.castsWithParameter, this.fieldsReadFromParameter, this.methodCallsWithParameterAsReceiver, true, this.isParameterReturned, this.isParameterUsedAsLock);
    }

    @Override
    InternalNonEmptyParameterUsage setParameterReturned() {
        if (this.isParameterReturned) {
            return this;
        }
        return new InternalNonEmptyParameterUsage(this.castsWithParameter, this.fieldsReadFromParameter, this.methodCallsWithParameterAsReceiver, this.isParameterMutated, true, this.isParameterUsedAsLock);
    }

    @Override
    InternalNonEmptyParameterUsage setParameterUsedAsLock() {
        if (this.isParameterUsedAsLock) {
            return this;
        }
        return new InternalNonEmptyParameterUsage(this.castsWithParameter, this.fieldsReadFromParameter, this.methodCallsWithParameterAsReceiver, this.isParameterMutated, this.isParameterReturned, true);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        InternalNonEmptyParameterUsage knownParameterUsage = (InternalNonEmptyParameterUsage)obj;
        return this.isParameterMutated == knownParameterUsage.isParameterMutated && this.isParameterReturned == knownParameterUsage.isParameterReturned && this.isParameterUsedAsLock == knownParameterUsage.isParameterUsedAsLock && this.castsWithParameter.equals(knownParameterUsage.castsWithParameter) && this.fieldsReadFromParameter.equals(knownParameterUsage.fieldsReadFromParameter) && this.methodCallsWithParameterAsReceiver.equals(knownParameterUsage.methodCallsWithParameterAsReceiver);
    }

    public int hashCode() {
        int hash = 31 * (31 * (31 + this.castsWithParameter.hashCode()) + this.fieldsReadFromParameter.hashCode()) + this.methodCallsWithParameterAsReceiver.hashCode();
        assert (hash == Objects.hash(this.castsWithParameter, this.fieldsReadFromParameter, this.methodCallsWithParameterAsReceiver));
        hash = hash << 1 | BooleanUtils.intValue(this.isParameterMutated);
        hash = hash << 1 | BooleanUtils.intValue(this.isParameterReturned);
        hash = hash << 1 | BooleanUtils.intValue(this.isParameterUsedAsLock);
        return hash;
    }

    static class Builder {
        private ImmutableSet.Builder<DexType> castsWithParameterBuilder;
        private ImmutableSet.Builder<DexField> fieldsReadFromParameterBuilder;
        private ImmutableSet.Builder<InvokeMethodWithReceiver> methodCallsWithParameterAsReceiverBuilder;
        private boolean isParameterMutated;
        private boolean isParameterReturned;
        private boolean isParameterUsedAsLock;

        Builder() {
            this.castsWithParameterBuilder = ImmutableSet.builder();
            this.fieldsReadFromParameterBuilder = ImmutableSet.builder();
            this.methodCallsWithParameterAsReceiverBuilder = ImmutableSet.builder();
        }

        Builder(InternalNonEmptyParameterUsage methodBehavior) {
            this.castsWithParameterBuilder = ImmutableSet.builder().addAll((Iterable)methodBehavior.castsWithParameter);
            this.fieldsReadFromParameterBuilder = ImmutableSet.builder().addAll((Iterable)methodBehavior.fieldsReadFromParameter);
            this.methodCallsWithParameterAsReceiverBuilder = ImmutableSet.builder().addAll((Iterable)methodBehavior.methodCallsWithParameterAsReceiver);
            this.isParameterMutated = methodBehavior.isParameterMutated;
            this.isParameterReturned = methodBehavior.isParameterReturned;
            this.isParameterUsedAsLock = methodBehavior.isParameterUsedAsLock;
        }

        Builder addCastWithParameter(DexType castType) {
            this.castsWithParameterBuilder.add((Object)castType);
            return this;
        }

        Builder addCastsWithParameter(Collection<DexType> castTypes) {
            this.castsWithParameterBuilder.addAll(castTypes);
            return this;
        }

        Builder addFieldReadFromParameter(DexField fieldReadFromParameter) {
            this.fieldsReadFromParameterBuilder.add((Object)fieldReadFromParameter);
            return this;
        }

        Builder addFieldsReadFromParameter(Collection<DexField> fieldsReadFromParameter) {
            this.fieldsReadFromParameterBuilder.addAll(fieldsReadFromParameter);
            return this;
        }

        Builder addMethodCallWithParameterAsReceiver(InvokeMethodWithReceiver methodCallWithParameterAsReceiver) {
            this.methodCallsWithParameterAsReceiverBuilder.add((Object)methodCallWithParameterAsReceiver);
            return this;
        }

        Builder addMethodCallsWithParameterAsReceiver(Set<InvokeMethodWithReceiver> methodCallsWithParameterAsReceiver) {
            this.methodCallsWithParameterAsReceiverBuilder.addAll(methodCallsWithParameterAsReceiver);
            return this;
        }

        Builder joinIsReceiverMutated(boolean isParameterMutated) {
            this.isParameterMutated |= isParameterMutated;
            return this;
        }

        Builder joinIsReceiverReturned(boolean isParameterReturned) {
            this.isParameterReturned |= isParameterReturned;
            return this;
        }

        Builder joinIsReceiverUsedAsLock(boolean isParameterUsedAsLock) {
            this.isParameterUsedAsLock |= isParameterUsedAsLock;
            return this;
        }

        Builder setParameterMutated() {
            this.isParameterMutated = true;
            return this;
        }

        Builder setParameterReturned() {
            this.isParameterReturned = true;
            return this;
        }

        Builder setParameterUsedAsLock() {
            this.isParameterUsedAsLock = true;
            return this;
        }

        InternalNonEmptyParameterUsage build() {
            return new InternalNonEmptyParameterUsage((Set<DexType>)((Object)this.castsWithParameterBuilder.build()), (Set<DexField>)((Object)this.fieldsReadFromParameterBuilder.build()), (Set<InvokeMethodWithReceiver>)((Object)this.methodCallsWithParameterAsReceiverBuilder.build()), this.isParameterMutated, this.isParameterReturned, this.isParameterUsedAsLock);
        }
    }
}

