/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.classinliner.analysis;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.ir.optimize.classinliner.analysis.AnalysisContext;
import com.android.tools.r8.ir.optimize.classinliner.analysis.DefaultAnalysisContext;
import com.android.tools.r8.ir.optimize.classinliner.analysis.ParameterUsage;
import com.android.tools.r8.ir.optimize.classinliner.analysis.ParameterUsagePerContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

class NonEmptyParameterUsagePerContext
extends ParameterUsagePerContext {
    private final Map<AnalysisContext, ParameterUsage> backing;

    private NonEmptyParameterUsagePerContext(Map<AnalysisContext, ParameterUsage> backing) {
        assert (!backing.isEmpty());
        this.backing = backing;
    }

    static ParameterUsagePerContext create(Map<AnalysisContext, ParameterUsage> backing) {
        return backing.isEmpty() ? NonEmptyParameterUsagePerContext.bottom() : new NonEmptyParameterUsagePerContext(backing);
    }

    static NonEmptyParameterUsagePerContext createInitial() {
        return new NonEmptyParameterUsagePerContext(ImmutableMap.of(DefaultAnalysisContext.getInstance(), ParameterUsage.bottom()));
    }

    public boolean allMatch(BiPredicate<AnalysisContext, ParameterUsage> predicate) {
        for (Map.Entry<AnalysisContext, ParameterUsage> entry : this.backing.entrySet()) {
            if (predicate.test(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    void forEach(BiConsumer<AnalysisContext, ParameterUsage> consumer) {
        this.backing.forEach(consumer);
    }

    ParameterUsagePerContext join(NonEmptyParameterUsagePerContext parameterUsagePerContext) {
        if (this.isBottom()) {
            return parameterUsagePerContext;
        }
        if (parameterUsagePerContext.isBottom()) {
            return this;
        }
        HashMap<AnalysisContext, ParameterUsage> newBacking = new HashMap<AnalysisContext, ParameterUsage>(this.backing);
        parameterUsagePerContext.forEach((context, parameterUsage) -> newBacking.put((AnalysisContext)context, parameterUsage.join(newBacking.getOrDefault(context, ParameterUsage.bottom()))));
        return NonEmptyParameterUsagePerContext.create(newBacking);
    }

    @Override
    NonEmptyParameterUsagePerContext asKnown() {
        return this;
    }

    @Override
    ParameterUsagePerContext externalize() {
        boolean allBottom = true;
        boolean allTop = true;
        for (ParameterUsage usage2 : this.backing.values()) {
            if (!usage2.isBottom()) {
                allBottom = false;
            }
            if (usage2.isTop()) continue;
            allTop = false;
        }
        if (allBottom) {
            return NonEmptyParameterUsagePerContext.bottom();
        }
        if (allTop) {
            return NonEmptyParameterUsagePerContext.top();
        }
        ParameterUsagePerContext rebuilt = this.rebuild((context, usage) -> usage.isTop() ? null : usage.externalize());
        assert (!rebuilt.isBottom());
        assert (!rebuilt.isTop());
        return rebuilt;
    }

    @Override
    public ParameterUsage get(AnalysisContext context) {
        return this.backing.getOrDefault(context, ParameterUsage.top());
    }

    public int getNumberOfContexts() {
        return this.backing.size();
    }

    @Override
    ParameterUsagePerContext rebuild(BiFunction<AnalysisContext, ParameterUsage, ParameterUsage> transformation) {
        ImmutableMap.Builder<AnalysisContext, ParameterUsage> builder = null;
        for (Map.Entry<AnalysisContext, ParameterUsage> entry : this.backing.entrySet()) {
            ParameterUsage usage;
            AnalysisContext context = entry.getKey();
            ParameterUsage newUsage = transformation.apply(context, usage = entry.getValue());
            if (newUsage == null) continue;
            if (newUsage != usage) {
                if (builder == null) {
                    Map.Entry<AnalysisContext, ParameterUsage> previousEntry;
                    AnalysisContext previousContext;
                    builder = ImmutableMap.builder();
                    Iterator<Map.Entry<AnalysisContext, ParameterUsage>> iterator2 = this.backing.entrySet().iterator();
                    while (iterator2.hasNext() && (previousContext = (previousEntry = iterator2.next()).getKey()) != context) {
                        builder.put(previousContext, previousEntry.getValue());
                    }
                }
                builder.put(context, newUsage);
                continue;
            }
            if (builder == null) continue;
            builder.put(context, newUsage);
        }
        return builder != null ? NonEmptyParameterUsagePerContext.create(builder.build()) : this;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        NonEmptyParameterUsagePerContext knownParameterUsagePerContext = (NonEmptyParameterUsagePerContext)obj;
        return this.backing.equals(knownParameterUsagePerContext.backing);
    }

    public int hashCode() {
        return this.backing.hashCode();
    }
}

