/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.classinliner.analysis;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ClasspathOrLibraryClass;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldResolutionResult;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.framework.intraprocedural.AbstractTransferFunction;
import com.android.tools.r8.ir.analysis.framework.intraprocedural.FailedTransferFunctionResult;
import com.android.tools.r8.ir.analysis.framework.intraprocedural.TransferFunctionResult;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.AliasedValueConfiguration;
import com.android.tools.r8.ir.code.Argument;
import com.android.tools.r8.ir.code.Assume;
import com.android.tools.r8.ir.code.AssumeAndCheckCastAliasedValueConfiguration;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CheckCast;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.InstanceGet;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeInterface;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.Monitor;
import com.android.tools.r8.ir.code.Return;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.classinliner.analysis.NonEmptyParameterUsagePerContext;
import com.android.tools.r8.ir.optimize.classinliner.analysis.NonEmptyParameterUsages;
import com.android.tools.r8.ir.optimize.classinliner.analysis.ParameterUsagePerContext;
import com.android.tools.r8.ir.optimize.classinliner.analysis.ParameterUsages;
import com.android.tools.r8.ir.optimize.info.initializer.InstanceInitializerInfo;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import java.util.Set;

class TransferFunction
implements AbstractTransferFunction<ParameterUsages> {
    private static final AliasedValueConfiguration aliasedValueConfiguration = AssumeAndCheckCastAliasedValueConfiguration.getInstance();
    private final AppView<AppInfoWithLiveness> appView;
    private final DexItemFactory dexItemFactory;
    private final ProgramMethod method;
    private final Argument lastArgument;
    private InvokeDirect constructorInvoke;
    private Set<Value> argumentsOfInterest = Sets.newIdentityHashSet();
    private Set<Instruction> instructionsOfInterest = Sets.newIdentityHashSet();

    TransferFunction(AppView<AppInfoWithLiveness> appView, ProgramMethod method, IRCode code) {
        this.appView = appView;
        this.dexItemFactory = appView.dexItemFactory();
        this.method = method;
        this.lastArgument = code.getLastArgument();
    }

    private ParameterUsages apply(Instruction instruction, NonEmptyParameterUsages state) {
        switch (instruction.opcode()) {
            case 9: {
                return this.analyzeAssume(instruction.asAssume(), state);
            }
            case 10: {
                return this.analyzeCheckCast(instruction.asCheckCast(), state);
            }
            case 25: {
                return this.analyzeIf(instruction.asIf(), state);
            }
            case 28: {
                return this.analyzeInstanceGet(instruction.asInstanceGet(), state);
            }
            case 30: {
                return this.analyzeInstancePut(instruction.asInstancePut(), state);
            }
            case 33: {
                return this.analyzeInvokeDirect(instruction.asInvokeDirect(), state);
            }
            case 34: {
                return this.analyzeInvokeInterface(instruction.asInvokeInterface(), state);
            }
            case 38: {
                return this.analyzeInvokeStatic(instruction.asInvokeStatic(), state);
            }
            case 40: {
                return this.analyzeInvokeVirtual(instruction.asInvokeVirtual(), state);
            }
            case 42: {
                return this.analyzeMonitor(instruction.asMonitor(), state);
            }
            case 56: {
                return this.analyzeReturn(instruction.asReturn(), state);
            }
        }
        return this.fail(instruction, state);
    }

    private ParameterUsages analyzeArgument(Argument argument, ParameterUsages state) {
        Value value = argument.outValue();
        if (!this.isMaybeEligibleForClassInlining(value.getType()) || value.hasPhiUsers()) {
            return state.put(argument.getIndex(), ParameterUsagePerContext.top());
        }
        this.argumentsOfInterest.add(value);
        this.instructionsOfInterest.addAll(value.aliasedUsers(aliasedValueConfiguration));
        return state.put(argument.getIndex(), NonEmptyParameterUsagePerContext.createInitial());
    }

    private ParameterUsages analyzeAssume(Assume assume, NonEmptyParameterUsages state) {
        return assume.outValue().hasPhiUsers() ? this.fail(assume, state) : state;
    }

    private ParameterUsages analyzeCheckCast(CheckCast checkCast, NonEmptyParameterUsages state) {
        if (checkCast.outValue().hasPhiUsers()) {
            return this.fail(checkCast, state);
        }
        return state.rebuildParameter(checkCast.object(), (context, usage) -> usage.addCastWithParameter(checkCast.getType()));
    }

    private ParameterUsages analyzeIf(If theIf, NonEmptyParameterUsages state) {
        if (theIf.isZeroTest()) {
            assert (this.argumentsOfInterest.contains(theIf.lhs().getAliasedValue(aliasedValueConfiguration)));
            return state;
        }
        return this.fail(theIf, state);
    }

    private ParameterUsages analyzeInstanceGet(InstanceGet instanceGet, NonEmptyParameterUsages state) {
        FieldResolutionResult resolutionResult = this.appView.appInfo().resolveField(instanceGet.getField());
        if (resolutionResult.isSingleFieldResolutionResult()) {
            return state.rebuildParameter(instanceGet.object(), (context, usage) -> usage.addFieldReadFromParameter(instanceGet.getField()));
        }
        return this.fail(instanceGet, state);
    }

    private ParameterUsages analyzeInstancePut(InstancePut instancePut, NonEmptyParameterUsages state) {
        Value objectRoot;
        Value valueRoot = instancePut.value().getAliasedValue(aliasedValueConfiguration);
        if (this.isArgumentOfInterest(valueRoot)) {
            state = state.abandonClassInliningInCurrentContexts(valueRoot);
        }
        if (!this.isArgumentOfInterest(objectRoot = instancePut.object().getAliasedValue(aliasedValueConfiguration))) {
            return state;
        }
        FieldResolutionResult resolutionResult = this.appView.appInfo().resolveField(instancePut.getField());
        if (resolutionResult.isSingleFieldResolutionResult()) {
            return state.rebuildParameter(objectRoot, (context, usage) -> usage.setParameterMutated());
        }
        return state.abandonClassInliningInCurrentContexts(objectRoot);
    }

    private ParameterUsages analyzeInvokeDirect(InvokeDirect invoke, NonEmptyParameterUsages state) {
        state = state.abandonClassInliningInCurrentContexts(invoke.getNonReceiverArguments(), this::isArgumentOfInterest);
        Value receiverRoot = invoke.getReceiver().getAliasedValue(aliasedValueConfiguration);
        if (!this.isArgumentOfInterest(receiverRoot)) {
            return state;
        }
        if (!(receiverRoot.isThis() && ((DexEncodedMethod)this.method.getDefinition()).isInstanceInitializer() && invoke.isInvokeConstructor(this.dexItemFactory))) {
            return state.abandonClassInliningInCurrentContexts(receiverRoot);
        }
        MethodResolutionResult.SingleResolutionResult resolutionResult = this.appView.appInfo().resolveMethodOnClass(invoke.getInvokedMethod()).asSingleResolution();
        if (resolutionResult == null) {
            return state.abandonClassInliningInCurrentContexts(receiverRoot);
        }
        InstanceInitializerInfo instanceInitializerInfo = resolutionResult.getResolvedMethod().getOptimizationInfo().getInstanceInitializerInfo(invoke);
        if (instanceInitializerInfo.receiverMayEscapeOutsideConstructorChain()) {
            return state.abandonClassInliningInCurrentContexts(receiverRoot);
        }
        if (this.constructorInvoke != null && this.constructorInvoke != invoke) {
            return state.abandonClassInliningInCurrentContexts(receiverRoot);
        }
        this.constructorInvoke = invoke;
        return state;
    }

    private ParameterUsages analyzeInvokeInterface(InvokeInterface invoke, NonEmptyParameterUsages state) {
        state = state.abandonClassInliningInCurrentContexts(invoke.getNonReceiverArguments(), this::isArgumentOfInterest);
        Value receiverRoot = invoke.getReceiver().getAliasedValue(aliasedValueConfiguration);
        if (!this.isArgumentOfInterest(receiverRoot)) {
            return state;
        }
        MethodResolutionResult.SingleResolutionResult resolutionResult = this.appView.appInfo().resolveMethodOnInterface(invoke.getInvokedMethod()).asSingleResolution();
        if (resolutionResult == null) {
            return state.abandonClassInliningInCurrentContexts(receiverRoot);
        }
        return state.rebuildParameter(receiverRoot, (context, usage) -> usage.addMethodCallWithParameterAsReceiver(invoke));
    }

    private ParameterUsages analyzeInvokeStatic(InvokeStatic invoke, NonEmptyParameterUsages state) {
        MethodResolutionResult.SingleResolutionResult resolutionResult = this.appView.appInfo().unsafeResolveMethodDueToDexFormat(invoke.getInvokedMethod()).asSingleResolution();
        if (resolutionResult != null && resolutionResult.getResolvedMethod().getReference() == this.dexItemFactory.objectsMethods.requireNonNull) {
            return state;
        }
        return this.fail(invoke, state);
    }

    private ParameterUsages analyzeInvokeVirtual(InvokeVirtual invoke, NonEmptyParameterUsages state) {
        state = state.abandonClassInliningInCurrentContexts(invoke.getNonReceiverArguments(), this::isArgumentOfInterest);
        Value receiverRoot = invoke.getReceiver().getAliasedValue(aliasedValueConfiguration);
        if (!this.isArgumentOfInterest(receiverRoot)) {
            return state;
        }
        MethodResolutionResult.SingleResolutionResult resolutionResult = this.appView.appInfo().resolveMethodOnClass(invoke.getInvokedMethod()).asSingleResolution();
        if (resolutionResult == null) {
            return state.abandonClassInliningInCurrentContexts(receiverRoot);
        }
        return state.rebuildParameter(receiverRoot, (context, usage) -> usage.addMethodCallWithParameterAsReceiver(invoke));
    }

    private ParameterUsages analyzeMonitor(Monitor monitor, NonEmptyParameterUsages state) {
        return state.rebuildParameter(monitor.object(), (context, usage) -> usage.setParameterUsedAsLock());
    }

    private ParameterUsages analyzeReturn(Return theReturn, NonEmptyParameterUsages state) {
        return state.rebuildParameter(theReturn.returnValue(), (context, usage) -> usage.setParameterReturned());
    }

    private FailedTransferFunctionResult<ParameterUsages> fail() {
        return new FailedTransferFunctionResult<ParameterUsages>();
    }

    private ParameterUsages fail(Instruction instruction, NonEmptyParameterUsages state) {
        return state.abandonClassInliningInCurrentContexts(instruction.inValues(), this::isArgumentOfInterest);
    }

    private boolean isArgumentOfInterest(Value value) {
        assert (value.getAliasedValue(aliasedValueConfiguration) == value);
        return value.isArgument() && this.argumentsOfInterest.contains(value);
    }

    private boolean isMaybeEligibleForClassInlining(TypeElement type) {
        if (!type.isClassType()) {
            return false;
        }
        DexClass clazz = this.appView.definitionFor(type.asClassType().getClassType());
        if (clazz == null) {
            return false;
        }
        return clazz.isProgramClass() ? this.isMaybeEligibleForClassInlining(clazz.asProgramClass()) : this.isMaybeEligibleForClassInlining(clazz.asClasspathOrLibraryClass());
    }

    private boolean isMaybeEligibleForClassInlining(DexProgramClass clazz) {
        DexType superType = clazz.getSuperType();
        DexClass superClass;
        while ((superClass = this.appView.definitionFor(superType)) != null) {
            if (!superClass.isProgramClass()) {
                return superClass.getType() == this.dexItemFactory.objectType;
            }
            superType = superClass.getSuperType();
        }
        return false;
    }

    private boolean isMaybeEligibleForClassInlining(ClasspathOrLibraryClass clazz) {
        return clazz.getType() == this.dexItemFactory.objectType || clazz.isInterface();
    }

    private TransferFunctionResult<ParameterUsages> widen(ParameterUsages state) {
        int maxNumberOfContexts = 1;
        ParameterUsages widened = state.rebuildParameters((parameter, usagePerContext) -> {
            if (usagePerContext.isBottom() || usagePerContext.isTop()) {
                return usagePerContext;
            }
            NonEmptyParameterUsagePerContext nonEmptyUsagePerContext = usagePerContext.asKnown();
            if (nonEmptyUsagePerContext.getNumberOfContexts() == maxNumberOfContexts && nonEmptyUsagePerContext.allMatch((context, usageInContext) -> usageInContext.isTop())) {
                return ParameterUsagePerContext.top();
            }
            return usagePerContext;
        });
        if (!widened.isBottom() && !widened.isTop() && widened.asNonEmpty().allMatch((parameter, usagePerContext) -> usagePerContext.isTop())) {
            return this.fail();
        }
        return widened;
    }

    @Override
    public TransferFunctionResult<ParameterUsages> apply(Instruction instruction, ParameterUsages state) {
        if (instruction.isArgument()) {
            Argument argument = instruction.asArgument();
            ParameterUsages result = this.analyzeArgument(argument, state);
            if (argument == this.lastArgument && result.asNonEmpty().allMatch((context, usagePerContext) -> usagePerContext.isTop())) {
                return this.fail();
            }
            return result;
        }
        if (!this.instructionsOfInterest.contains(instruction)) {
            return state;
        }
        assert (!state.isBottom());
        assert (!state.isTop());
        ParameterUsages outState = this.apply(instruction, state.asNonEmpty());
        return outState != state ? this.widen(outState) : outState;
    }

    @Override
    public ParameterUsages computeBlockEntryState(BasicBlock block, BasicBlock predecessor, ParameterUsages predecessorExitState) {
        return predecessorExitState;
    }
}

