/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.classinliner.constraint;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.proto.ArgumentInfo;
import com.android.tools.r8.graph.proto.ArgumentInfoCollection;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.SingleConstValue;
import com.android.tools.r8.ir.analysis.value.objectstate.ObjectState;
import com.android.tools.r8.ir.optimize.classinliner.analysis.AnalysisContext;
import com.android.tools.r8.ir.optimize.classinliner.analysis.DefaultAnalysisContext;
import com.android.tools.r8.ir.optimize.classinliner.analysis.NonEmptyParameterUsage;
import com.android.tools.r8.ir.optimize.classinliner.analysis.NonEmptyParameterUsages;
import com.android.tools.r8.ir.optimize.classinliner.analysis.ParameterUsage;
import com.android.tools.r8.ir.optimize.classinliner.analysis.ParameterUsagePerContext;
import com.android.tools.r8.ir.optimize.classinliner.analysis.ParameterUsages;
import com.android.tools.r8.ir.optimize.classinliner.constraint.ClassInlinerMethodConstraint;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import com.android.tools.r8.shaking.AppInfoWithLiveness;

public class ConditionalClassInlinerMethodConstraint
implements ClassInlinerMethodConstraint {
    private final ParameterUsages usages;

    public ConditionalClassInlinerMethodConstraint(ParameterUsages usages) {
        assert (!usages.isTop());
        this.usages = usages;
    }

    private boolean hasUnsafeCast(AppView<AppInfoWithLiveness> appView, DexProgramClass candidateClass, NonEmptyParameterUsage knownUsage) {
        for (DexType castType : knownUsage.getCastsWithParameter()) {
            if (!castType.isClassType()) {
                return true;
            }
            DexClass castClass = appView.definitionFor(castType);
            if (castClass != null && appView.appInfo().isSubtype(candidateClass, castClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ClassInlinerMethodConstraint fixupAfterParametersChanged(AppView<AppInfoWithLiveness> appView, ArgumentInfoCollection changes) {
        if (this.usages.isBottom()) {
            return this;
        }
        Int2ObjectOpenHashMap<ParameterUsagePerContext> backing = new Int2ObjectOpenHashMap<ParameterUsagePerContext>();
        this.usages.asNonEmpty().forEach((argumentIndex, usagePerContext) -> {
            ArgumentInfo argumentInfo = changes.getArgumentInfo(argumentIndex);
            if (argumentInfo.isRemovedArgumentInfo()) {
                return;
            }
            if (argumentInfo.isRewrittenTypeInfo() && argumentInfo.asRewrittenTypeInfo().getNewType().isIntType()) {
                return;
            }
            backing.put(changes.getNewArgumentIndex(argumentIndex), (ParameterUsagePerContext)usagePerContext);
        });
        return new ConditionalClassInlinerMethodConstraint(NonEmptyParameterUsages.create(backing));
    }

    @Override
    public ParameterUsage getParameterUsage(int parameter) {
        DefaultAnalysisContext defaultContext = AnalysisContext.getDefaultContext();
        return this.usages.get(parameter).get(defaultContext);
    }

    @Override
    public boolean isEligibleForNewInstanceClassInlining(AppView<AppInfoWithLiveness> appView, DexProgramClass candidateClass, ProgramMethod method, int parameter) {
        DefaultAnalysisContext defaultContext = AnalysisContext.getDefaultContext();
        ParameterUsage usage = this.usages.get(parameter).get(defaultContext);
        if (usage.isBottom()) {
            return true;
        }
        if (usage.isTop()) {
            return false;
        }
        NonEmptyParameterUsage knownUsage = usage.asNonEmpty();
        return !this.hasUnsafeCast(appView, candidateClass, knownUsage);
    }

    @Override
    public boolean isEligibleForStaticGetClassInlining(AppView<AppInfoWithLiveness> appView, DexProgramClass candidateClass, int parameter, ObjectState objectState, ProgramMethod context) {
        DefaultAnalysisContext defaultContext = AnalysisContext.getDefaultContext();
        ParameterUsage usage = this.usages.get(parameter).get(defaultContext);
        if (usage.isBottom()) {
            return true;
        }
        if (usage.isTop()) {
            return false;
        }
        NonEmptyParameterUsage knownUsage = usage.asNonEmpty();
        if (knownUsage.isParameterMutated()) {
            return false;
        }
        if (knownUsage.isParameterUsedAsLock()) {
            return false;
        }
        if (this.hasUnsafeCast(appView, candidateClass, knownUsage)) {
            return false;
        }
        for (DexField fieldReadFromParameter : knownUsage.getFieldsReadFromParameter()) {
            DexClass holder;
            DexEncodedField definition = fieldReadFromParameter.lookupOnClass(holder = appView.definitionFor(fieldReadFromParameter.getHolderType()));
            if (definition == null) {
                return false;
            }
            AbstractValue abstractValue = objectState.getAbstractFieldValue(definition);
            if (!abstractValue.isSingleConstValue()) {
                return false;
            }
            SingleConstValue singleConstValue = abstractValue.asSingleConstValue();
            if (singleConstValue.isMaterializableInContext(appView, context)) continue;
            return false;
        }
        return true;
    }
}

