/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.enums;

import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.ir.optimize.enums.EnumInstanceFieldData;
import java.util.Set;

public class EnumDataMap {
    private final ImmutableMap<DexType, EnumData> map;

    public static EnumDataMap empty() {
        return new EnumDataMap(ImmutableMap.of());
    }

    public EnumDataMap(ImmutableMap<DexType, EnumData> map) {
        this.map = map;
    }

    public boolean isUnboxedEnum(DexProgramClass clazz) {
        return this.isUnboxedEnum(clazz.getType());
    }

    public boolean isUnboxedEnum(DexType type) {
        return this.map.containsKey(type);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public EnumData get(DexProgramClass enumClass) {
        EnumData enumData = this.map.get(enumClass.getType());
        assert (enumData != null);
        return enumData;
    }

    public Set<DexType> getUnboxedEnums() {
        return this.map.keySet();
    }

    public EnumInstanceFieldData.EnumInstanceFieldKnownData getInstanceFieldData(DexType enumType, DexField enumInstanceField) {
        assert (this.map.containsKey(enumType));
        return this.map.get(enumType).getInstanceFieldData(enumInstanceField);
    }

    public boolean hasUnboxedValueFor(DexField enumStaticField) {
        return this.isUnboxedEnum(enumStaticField.holder) && this.map.get(enumStaticField.holder).hasUnboxedValueFor(enumStaticField);
    }

    public int getUnboxedValue(DexField enumStaticField) {
        assert (this.map.containsKey(enumStaticField.holder));
        return this.map.get(enumStaticField.holder).getUnboxedValue(enumStaticField);
    }

    public int getValuesSize(DexType enumType) {
        assert (this.map.containsKey(enumType));
        return this.map.get(enumType).getValuesSize();
    }

    public int getMaxValuesSize() {
        int maxValuesSize = 0;
        for (EnumData data2 : this.map.values()) {
            if (!data2.hasValues()) continue;
            maxValuesSize = Math.max(maxValuesSize, data2.getValuesSize());
        }
        return maxValuesSize;
    }

    public boolean matchesValuesField(DexField staticField) {
        assert (this.map.containsKey(staticField.holder));
        return this.map.get(staticField.holder).matchesValuesField(staticField);
    }

    public static class EnumData {
        static final int INVALID_VALUES_SIZE = -1;
        final ImmutableMap<DexField, EnumInstanceFieldData.EnumInstanceFieldKnownData> instanceFieldMap;
        final ImmutableMap<DexField, Integer> unboxedValues;
        final ImmutableSet<DexField> valuesFields;
        final int valuesSize;

        public EnumData(ImmutableMap<DexField, EnumInstanceFieldData.EnumInstanceFieldKnownData> instanceFieldMap, ImmutableMap<DexField, Integer> unboxedValues, ImmutableSet<DexField> valuesFields, int valuesSize) {
            this.instanceFieldMap = instanceFieldMap;
            this.unboxedValues = unboxedValues;
            this.valuesFields = valuesFields;
            this.valuesSize = valuesSize;
        }

        public EnumInstanceFieldData.EnumInstanceFieldKnownData getInstanceFieldData(DexField enumInstanceField) {
            assert (this.instanceFieldMap.containsKey(enumInstanceField));
            return this.instanceFieldMap.get(enumInstanceField);
        }

        public int getUnboxedValue(DexField field) {
            assert (this.unboxedValues.containsKey(field));
            return this.unboxedValues.get(field);
        }

        public boolean hasUnboxedValueFor(ProgramField field) {
            return this.hasUnboxedValueFor((DexField)field.getReference());
        }

        public boolean hasUnboxedValueFor(DexField field) {
            return this.unboxedValues.containsKey(field);
        }

        public boolean matchesValuesField(ProgramField field) {
            return this.matchesValuesField((DexField)field.getReference());
        }

        public boolean matchesValuesField(DexField field) {
            return this.valuesFields.contains(field);
        }

        public boolean hasValues() {
            return this.valuesSize != -1;
        }

        public int getValuesSize() {
            assert (this.hasValues());
            return this.valuesSize;
        }
    }
}

