/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.enums;

import com.android.tools.r8.com.google.common.collect.HashMultiset;
import com.android.tools.r8.com.google.common.collect.ImmutableMap;
import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexClassAndField;
import com.android.tools.r8.graph.DexClassAndMethod;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexMethodHandle;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.FieldResolutionResult;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import com.android.tools.r8.ir.analysis.fieldvalueanalysis.StaticFieldValues;
import com.android.tools.r8.ir.analysis.type.ArrayTypeElement;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.objectstate.EnumValuesObjectState;
import com.android.tools.r8.ir.analysis.value.objectstate.ObjectState;
import com.android.tools.r8.ir.code.ArrayGet;
import com.android.tools.r8.ir.code.ArrayLength;
import com.android.tools.r8.ir.code.ArrayPut;
import com.android.tools.r8.ir.code.Assume;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CheckCast;
import com.android.tools.r8.ir.code.ConstClass;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.InitClass;
import com.android.tools.r8.ir.code.InstanceGet;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeCustom;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.Phi;
import com.android.tools.r8.ir.code.Return;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.conversion.MethodProcessor;
import com.android.tools.r8.ir.conversion.PostMethodProcessor;
import com.android.tools.r8.ir.desugar.LambdaDescriptor;
import com.android.tools.r8.ir.optimize.enums.EnumDataMap;
import com.android.tools.r8.ir.optimize.enums.EnumInstanceFieldData;
import com.android.tools.r8.ir.optimize.enums.EnumUnboxer;
import com.android.tools.r8.ir.optimize.enums.EnumUnboxingCandidateAnalysis;
import com.android.tools.r8.ir.optimize.enums.EnumUnboxingCandidateInfoCollection;
import com.android.tools.r8.ir.optimize.enums.EnumUnboxingLens;
import com.android.tools.r8.ir.optimize.enums.EnumUnboxingRewriter;
import com.android.tools.r8.ir.optimize.enums.EnumUnboxingTreeFixer;
import com.android.tools.r8.ir.optimize.enums.EnumUnboxingUtilityClasses;
import com.android.tools.r8.ir.optimize.enums.classification.CheckNotNullEnumUnboxerMethodClassification;
import com.android.tools.r8.ir.optimize.enums.classification.EnumUnboxerMethodClassification;
import com.android.tools.r8.ir.optimize.enums.eligibility.Reason;
import com.android.tools.r8.ir.optimize.info.MutableFieldOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.MutableMethodOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackDelayed;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.shaking.KeepInfoCollection;
import com.android.tools.r8.utils.MapUtils;
import com.android.tools.r8.utils.Reporter;
import com.android.tools.r8.utils.StringDiagnostic;
import com.android.tools.r8.utils.collections.ImmutableInt2ReferenceSortedMap;
import com.android.tools.r8.utils.collections.LongLivedClassSetBuilder;
import com.android.tools.r8.utils.collections.LongLivedProgramMethodMapBuilder;
import com.android.tools.r8.utils.collections.LongLivedProgramMethodSetBuilder;
import com.android.tools.r8.utils.collections.ProgramMethodMap;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;

public class EnumUnboxerImpl
extends EnumUnboxer {
    private final AppView<AppInfoWithLiveness> appView;
    private final DexItemFactory factory;
    private EnumUnboxingCandidateInfoCollection enumUnboxingCandidatesInfo;
    private final Set<DexProgramClass> candidatesToRemoveInWave = Sets.newConcurrentHashSet();
    private final Map<DexType, StaticFieldValues.EnumStaticFieldValues> staticFieldValuesMap = new ConcurrentHashMap<DexType, StaticFieldValues.EnumStaticFieldValues>();
    private LongLivedProgramMethodSetBuilder<ProgramMethodSet> methodsDependingOnLibraryModelisation;
    private LongLivedProgramMethodMapBuilder<LongLivedClassSetBuilder<DexProgramClass>> checkNotNullMethodsBuilder;
    private final DexClassAndField ordinalField;
    private EnumUnboxingRewriter enumUnboxerRewriter;
    private final boolean debugLogEnabled;
    private final Map<DexType, List<Reason>> debugLogs;

    EnumUnboxerImpl(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
        this.factory = appView.dexItemFactory();
        if (appView.options().testing.enableEnumUnboxingDebugLogs) {
            this.debugLogEnabled = true;
            this.debugLogs = new ConcurrentHashMap<DexType, List<Reason>>();
        } else {
            this.debugLogEnabled = false;
            this.debugLogs = null;
        }
        assert (!appView.options().debug);
        this.ordinalField = appView.appInfo().resolveField(this.factory.enumMembers.ordinalField).getResolutionPair();
    }

    public static int ordinalToUnboxedInt(int ordinal) {
        return ordinal + 1;
    }

    private boolean markEnumAsUnboxable(Reason reason, DexProgramClass enumClass) {
        assert (enumClass.isEnum());
        if (!this.reportFailure(enumClass, reason)) {
            this.candidatesToRemoveInWave.add(enumClass);
            return true;
        }
        return false;
    }

    private void markMethodDependsOnLibraryModelisation(ProgramMethod method) {
        this.methodsDependingOnLibraryModelisation.add(method, this.appView.graphLens());
    }

    private DexProgramClass getEnumUnboxingCandidateOrNull(TypeElement lattice) {
        ArrayTypeElement arrayType;
        if (lattice.isClassType()) {
            DexType classType = lattice.asClassType().getClassType();
            return this.getEnumUnboxingCandidateOrNull(classType);
        }
        if (lattice.isArrayType() && (arrayType = lattice.asArrayType()).getBaseType().isClassType()) {
            return this.getEnumUnboxingCandidateOrNull(arrayType.getBaseType());
        }
        return null;
    }

    private DexProgramClass getEnumUnboxingCandidateOrNull(DexType type) {
        if (type.isArrayType()) {
            return this.getEnumUnboxingCandidateOrNull(type.toBaseType(this.appView.dexItemFactory()));
        }
        if (type.isPrimitiveType() || type.isVoidType()) {
            return null;
        }
        assert (type.isClassType());
        return this.enumUnboxingCandidatesInfo.getCandidateClassOrNull(type);
    }

    private void markEnumEligible(DexType type, Set<DexType> eligibleEnums) {
        DexProgramClass enumClass = this.getEnumUnboxingCandidateOrNull(type);
        if (enumClass != null) {
            eligibleEnums.add(enumClass.getType());
        }
    }

    private void invalidateEnum(DexType type) {
        DexProgramClass enumClass = this.getEnumUnboxingCandidateOrNull(type);
        if (enumClass != null) {
            this.markEnumAsUnboxable(Reason.INVALID_INVOKE_CUSTOM, enumClass);
        }
    }

    private void analyzeInvokeCustom(InvokeCustom invoke, Set<DexType> eligibleEnums, ProgramMethod context) {
        invoke.getCallSite().getMethodProto().forEachType(t -> this.markEnumEligible((DexType)t, eligibleEnums));
        LambdaDescriptor lambdaDescriptor = LambdaDescriptor.tryInfer(invoke.getCallSite(), this.appView.appInfo(), context);
        if (lambdaDescriptor == null) {
            this.analyzeInvokeCustomParameters(invoke, this::invalidateEnum);
            return;
        }
        this.analyzeInvokeCustomParameters(invoke, t -> this.markEnumEligible((DexType)t, eligibleEnums));
        lambdaDescriptor.forEachErasedAndEnforcedTypes((erasedType, enforcedType) -> {
            if (erasedType != enforcedType) {
                this.invalidateEnum((DexType)erasedType);
                this.invalidateEnum((DexType)enforcedType);
            }
        });
    }

    private void analyzeInvokeCustomParameters(InvokeCustom invoke, Consumer<DexType> nonHolder) {
        invoke.getCallSite().getBootstrapArgs().forEach(bootstrapArgument -> {
            if (bootstrapArgument.isDexValueMethodHandle()) {
                DexMethodHandle methodHandle = (DexMethodHandle)bootstrapArgument.asDexValueMethodHandle().getValue();
                if (methodHandle.isMethodHandle()) {
                    DexMethod method = methodHandle.asMethod();
                    this.invalidateEnum(method.getHolderType());
                    method.getProto().forEachType(nonHolder);
                } else {
                    assert (methodHandle.isFieldHandle());
                    DexField field = methodHandle.asField();
                    this.invalidateEnum(field.getHolderType());
                    nonHolder.accept(field.type);
                }
            } else if (bootstrapArgument.isDexValueMethodType()) {
                DexProto proto = (DexProto)bootstrapArgument.asDexValueMethodType().getValue();
                proto.forEachType(nonHolder);
            }
        });
    }

    private void analyzeFieldInstruction(FieldInstruction fieldInstruction, Set<DexType> eligibleEnums, ProgramMethod context) {
        DexField field = fieldInstruction.getField();
        DexProgramClass enumClass = this.getEnumUnboxingCandidateOrNull(field.holder);
        if (enumClass != null) {
            FieldResolutionResult resolutionResult = this.appView.appInfo().resolveField(field, context);
            if (resolutionResult.isSingleFieldResolutionResult()) {
                eligibleEnums.add(enumClass.getType());
            } else {
                this.markEnumAsUnboxable(Reason.UNRESOLVABLE_FIELD, enumClass);
            }
        }
    }

    private void analyzeInvokeStatic(InvokeStatic invokeStatic, Set<DexType> eligibleEnums, ProgramMethod context) {
        DexMethod invokedMethod = invokeStatic.getInvokedMethod();
        DexProgramClass enumClass = this.getEnumUnboxingCandidateOrNull(invokedMethod.holder);
        if (enumClass != null) {
            DexClassAndMethod method = invokeStatic.lookupSingleTarget(this.appView, context);
            if (method != null) {
                eligibleEnums.add(enumClass.type);
            } else {
                this.markEnumAsUnboxable(Reason.INVALID_INVOKE, enumClass);
            }
        }
    }

    private void analyzeCheckCast(CheckCast checkCast, Set<DexType> eligibleEnums) {
        if (checkCast.getType().isArrayType()) {
            return;
        }
        DexProgramClass enumClass = this.getEnumUnboxingCandidateOrNull(checkCast.getType().toBaseType(this.factory));
        if (enumClass == null) {
            return;
        }
        if (this.allowCheckCast(checkCast)) {
            eligibleEnums.add(enumClass.type);
            return;
        }
        this.markEnumAsUnboxable(Reason.DOWN_CAST, enumClass);
    }

    private void analyzeInitClass(InitClass initClass, Set<DexType> eligibleEnums) {
        DexProgramClass enumClass = this.getEnumUnboxingCandidateOrNull(initClass.getClassValue());
        if (enumClass != null) {
            eligibleEnums.add(enumClass.getType());
        }
    }

    private boolean allowCheckCast(CheckCast checkCast) {
        TypeElement objectType = checkCast.object().getDynamicUpperBoundType(this.appView);
        return objectType.equalUpToNullability(TypeElement.fromDexType(checkCast.getType(), Nullability.definitelyNotNull(), this.appView));
    }

    private void analyzeConstClass(ConstClass constClass, Set<DexType> eligibleEnums, ProgramMethod context) {
        DexType enumType = constClass.getValue();
        if (!this.enumUnboxingCandidatesInfo.isCandidate(enumType)) {
            return;
        }
        if (constClass.outValue() == null) {
            eligibleEnums.add(enumType);
            return;
        }
        DexProgramClass enumClass = this.appView.definitionFor(enumType).asProgramClass();
        if (constClass.outValue().hasPhiUsers()) {
            this.markEnumAsUnboxable(Reason.CONST_CLASS, enumClass);
            return;
        }
        for (Instruction user : constClass.outValue().aliasedUsers()) {
            if (this.isLegitimateConstClassUser(user, context, enumClass)) continue;
            this.markEnumAsUnboxable(Reason.CONST_CLASS, enumClass);
            return;
        }
        eligibleEnums.add(enumType);
    }

    private boolean isLegitimateConstClassUser(Instruction user, ProgramMethod context, DexProgramClass enumClass) {
        if (user.isAssume()) {
            return !user.outValue().hasPhiUsers();
        }
        if (user.isInvokeStatic()) {
            DexClassAndMethod singleTarget = user.asInvokeStatic().lookupSingleTarget(this.appView, context);
            if (singleTarget == null) {
                return false;
            }
            if (singleTarget.getReference() == this.factory.enumMembers.valueOf) {
                this.addRequiredNameData(enumClass);
                this.markMethodDependsOnLibraryModelisation(context);
                return true;
            }
            if (singleTarget.getReference() == this.factory.javaLangReflectArrayMembers.newInstanceMethodWithDimensions) {
                this.markMethodDependsOnLibraryModelisation(context);
                return true;
            }
        }
        if (user.isInvokeVirtual()) {
            InvokeVirtual invoke = user.asInvokeVirtual();
            DexMethod invokedMethod = invoke.getInvokedMethod();
            if (invokedMethod == this.factory.classMethods.desiredAssertionStatus) {
                return ((DexEncodedMethod)context.getDefinition()).isClassInitializer() && context.getHolder() == enumClass;
            }
            if (this.isUnboxableNameMethod(invokedMethod)) {
                return true;
            }
        }
        return false;
    }

    private void addRequiredNameData(DexProgramClass enumClass) {
        this.enumUnboxingCandidatesInfo.addRequiredEnumInstanceFieldData(enumClass, this.factory.enumMembers.nameField);
    }

    private boolean isUnboxableNameMethod(DexMethod method) {
        return method == this.factory.classMethods.getName || method == this.factory.classMethods.getCanonicalName || method == this.factory.classMethods.getSimpleName;
    }

    private void addNullDependencies(IRCode code, Value nullValue, Set<DexType> eligibleEnums) {
        for (Instruction use : nullValue.uniqueUsers()) {
            DexType returnType;
            if (use.isInvokeMethod()) {
                DexProgramClass enumClass;
                InvokeMethod invokeMethod = use.asInvokeMethod();
                DexMethod invokedMethod = invokeMethod.getInvokedMethod();
                for (DexType paramType : invokedMethod.proto.parameters.values) {
                    if (!this.enumUnboxingCandidatesInfo.isCandidate(paramType)) continue;
                    eligibleEnums.add(paramType);
                }
                if (!invokeMethod.isInvokeMethodWithReceiver() || invokeMethod.asInvokeMethodWithReceiver().getReceiver() != nullValue || (enumClass = this.getEnumUnboxingCandidateOrNull(invokedMethod.holder)) == null) continue;
                this.markEnumAsUnboxable(Reason.ENUM_METHOD_CALLED_WITH_NULL_RECEIVER, enumClass);
                continue;
            }
            if (use.isFieldPut()) {
                DexType type = use.asFieldInstruction().getField().type;
                if (!this.enumUnboxingCandidatesInfo.isCandidate(type)) continue;
                eligibleEnums.add(type);
                continue;
            }
            if (!use.isReturn() || !this.enumUnboxingCandidatesInfo.isCandidate(returnType = ((DexMethod)code.method().getReference()).proto.returnType)) continue;
            eligibleEnums.add(returnType);
        }
    }

    private Reason validateEnumUsages(IRCode code, Value value, DexProgramClass enumClass) {
        Reason result = Reason.ELIGIBLE;
        for (Instruction user : value.uniqueUsers()) {
            Reason reason = this.instructionAllowEnumUnboxing(user, code, enumClass, value);
            if (reason == Reason.ELIGIBLE) continue;
            if (this.markEnumAsUnboxable(reason, enumClass)) {
                return reason;
            }
            result = reason;
        }
        for (Phi phi : value.uniquePhiUsers()) {
            for (Value operand : phi.getOperands()) {
                if (operand.getType().isNullType() || this.getEnumUnboxingCandidateOrNull(operand.getType()) == enumClass) continue;
                this.markEnumAsUnboxable(Reason.INVALID_PHI, enumClass);
                return Reason.INVALID_PHI;
            }
        }
        return result;
    }

    private void initializeCheckNotNullMethods(GraphLens graphLensForPrimaryOptimizationPass) {
        assert (this.checkNotNullMethodsBuilder == null);
        this.checkNotNullMethodsBuilder = LongLivedProgramMethodMapBuilder.createConcurrentBuilderForNonConcurrentMap(graphLensForPrimaryOptimizationPass);
    }

    private void initializeEnumUnboxingCandidates(GraphLens graphLensForPrimaryOptimizationPass) {
        assert (this.enumUnboxingCandidatesInfo == null);
        this.enumUnboxingCandidatesInfo = new EnumUnboxingCandidateAnalysis(this.appView, this).findCandidates(graphLensForPrimaryOptimizationPass);
        this.methodsDependingOnLibraryModelisation = LongLivedProgramMethodSetBuilder.createConcurrentForIdentitySet(graphLensForPrimaryOptimizationPass);
    }

    private void updateOptimizationInfos(ExecutorService executorService, OptimizationFeedbackDelayed feedback, final EnumUnboxingTreeFixer.Result treeFixerResult, GraphLens previousLens) throws ExecutionException {
        final GraphLens.NonIdentityGraphLens graphLens = this.appView.graphLens().asNonIdentityLens();
        assert (graphLens.isEnumUnboxerLens());
        final GraphLens codeLens = graphLens.getPrevious();
        assert (codeLens == previousLens);
        feedback.fixupOptimizationInfos(this.appView, executorService, new OptimizationFeedback.OptimizationInfoFixer(){

            @Override
            public void fixup(DexEncodedField field, MutableFieldOptimizationInfo optimizationInfo) {
                optimizationInfo.fixupClassTypeReferences(EnumUnboxerImpl.this.appView, graphLens).fixupAbstractValue(EnumUnboxerImpl.this.appView, graphLens, codeLens);
            }

            @Override
            public void fixup(DexEncodedMethod method, MutableMethodOptimizationInfo optimizationInfo) {
                optimizationInfo.fixupClassTypeReferences(EnumUnboxerImpl.this.appView, graphLens).fixupAbstractReturnValue(EnumUnboxerImpl.this.appView, graphLens, codeLens).fixupInstanceInitializerInfo(EnumUnboxerImpl.this.appView, graphLens, codeLens, treeFixerResult.getPrunedItems());
                if (!treeFixerResult.getCheckNotNullToCheckNotZeroMapping().containsValue(method.getReference())) {
                    optimizationInfo.unsetEnumUnboxerMethodClassification();
                }
            }
        });
    }

    private void updateKeepInfo(Set<DexType> enumsToUnbox) {
        KeepInfoCollection keepInfo = this.appView.appInfo().getKeepInfo();
        keepInfo.mutate(mutator -> mutator.removeKeepInfoForPrunedItems(PrunedItems.builder().setRemovedClasses(enumsToUnbox).build()));
    }

    private EnumDataMap analyzeEnumInstances() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.enumUnboxingCandidatesInfo.forEachCandidateAndRequiredInstanceFieldData((enumClass, instanceFields) -> {
            EnumDataMap.EnumData data2 = this.buildData((DexProgramClass)enumClass, (Set<DexField>)instanceFields);
            if (data2 == null) {
                this.enumUnboxingCandidatesInfo.removeCandidate((DexProgramClass)enumClass);
                return;
            }
            if (!this.debugLogEnabled || !this.debugLogs.containsKey(enumClass.getType())) {
                builder.put(enumClass.type, data2);
            }
        });
        this.staticFieldValuesMap.clear();
        return new EnumDataMap(builder.build());
    }

    private EnumDataMap.EnumData buildData(DexProgramClass enumClass, Set<DexField> instanceFields) {
        ImmutableMap<DexField, EnumInstanceFieldData.EnumInstanceFieldKnownData> instanceFieldsData;
        if (!enumClass.hasStaticFields()) {
            return new EnumDataMap.EnumData(ImmutableMap.of(), ImmutableMap.of(), ImmutableSet.of(), -1);
        }
        ImmutableMap.Builder<DexField, Integer> unboxedValues = ImmutableMap.builder();
        Int2ReferenceArrayMap<ObjectState> ordinalToObjectState = new Int2ReferenceArrayMap<ObjectState>();
        ImmutableSet.Builder valuesField = ImmutableSet.builder();
        EnumValuesObjectState valuesContents = null;
        StaticFieldValues.EnumStaticFieldValues enumStaticFieldValues = this.staticFieldValuesMap.get(enumClass.type);
        if (enumStaticFieldValues == null) {
            this.reportFailure(enumClass, (Reason)new Reason.MissingEnumStaticFieldValuesReason());
            return null;
        }
        for (DexEncodedField staticField : enumClass.staticFields()) {
            if (this.factory.enumMembers.isEnumField(staticField, enumClass.type)) {
                ObjectState enumState = enumStaticFieldValues.getObjectStateForPossiblyPinnedField((DexField)staticField.getReference());
                if (enumState == null) {
                    if (staticField.getOptimizationInfo().isDead()) continue;
                    this.reportFailure(enumClass, (Reason)new Reason.MissingObjectStateForEnumInstanceReason((DexField)staticField.getReference()));
                    return null;
                }
                OptionalInt optionalOrdinal = this.getOrdinal(enumState);
                if (!optionalOrdinal.isPresent()) {
                    this.reportFailure(enumClass, (Reason)new Reason.MissingInstanceFieldValueForEnumInstanceReason((DexField)staticField.getReference(), this.factory.enumMembers.ordinalField));
                    return null;
                }
                int ordinal = optionalOrdinal.getAsInt();
                unboxedValues.put((DexField)staticField.getReference(), EnumUnboxerImpl.ordinalToUnboxedInt(ordinal));
                ordinalToObjectState.put(ordinal, enumState);
                continue;
            }
            if (!this.factory.enumMembers.isValuesFieldCandidate(staticField, enumClass.type)) continue;
            ObjectState valuesState = enumStaticFieldValues.getObjectStateForPossiblyPinnedField((DexField)staticField.getReference());
            if (valuesState == null) {
                if (staticField.getOptimizationInfo().isDead()) continue;
                this.reportFailure(enumClass, (Reason)new Reason.MissingContentsForEnumValuesArrayReason((DexField)staticField.getReference()));
                return null;
            }
            assert (valuesState.isEnumValuesObjectState());
            assert (valuesContents == null || valuesContents.equals(valuesState.asEnumValuesObjectState()));
            valuesContents = valuesState.asEnumValuesObjectState();
            valuesField.add((DexField)staticField.getReference());
        }
        if (valuesContents != null) {
            for (int ordinal = 0; ordinal < valuesContents.getEnumValuesSize(); ++ordinal) {
                if (ordinalToObjectState.containsKey(ordinal)) continue;
                ObjectState enumState = valuesContents.getObjectStateForOrdinal(ordinal);
                if (enumState.isEmpty()) {
                    return null;
                }
                assert (this.getOrdinal(enumState).isPresent());
                assert (this.getOrdinal(enumState).getAsInt() == ordinal);
                ordinalToObjectState.put(ordinal, enumState);
            }
        }
        if ((instanceFieldsData = this.computeRequiredEnumInstanceFieldsData(enumClass, instanceFields, ordinalToObjectState)) == null) {
            return null;
        }
        return new EnumDataMap.EnumData(instanceFieldsData, unboxedValues.build(), (ImmutableSet<DexField>)valuesField.build(), valuesContents == null ? -1 : valuesContents.getEnumValuesSize());
    }

    private ImmutableMap<DexField, EnumInstanceFieldData.EnumInstanceFieldKnownData> computeRequiredEnumInstanceFieldsData(DexProgramClass enumClass, Set<DexField> instanceFields, Int2ReferenceMap<ObjectState> ordinalToObjectState) {
        ImmutableMap.Builder<DexField, EnumInstanceFieldData.EnumInstanceFieldKnownData> builder = ImmutableMap.builder();
        for (DexField instanceField : instanceFields) {
            EnumInstanceFieldData fieldData = this.computeRequiredEnumInstanceFieldData(instanceField, enumClass, ordinalToObjectState);
            if (fieldData.isUnknown()) {
                if (!this.debugLogEnabled) {
                    return null;
                }
                builder = null;
            }
            if (builder == null) continue;
            builder.put(instanceField, fieldData.asEnumFieldKnownData());
        }
        return builder != null ? builder.build() : null;
    }

    private EnumInstanceFieldData computeRequiredEnumInstanceFieldData(DexField instanceField, DexProgramClass enumClass, Int2ReferenceMap<ObjectState> ordinalToObjectState) {
        DexEncodedField encodedInstanceField = this.appView.appInfo().resolveFieldOn(enumClass, instanceField).getResolvedField();
        assert (encodedInstanceField != null);
        boolean canBeOrdinal = instanceField.type.isIntType();
        ImmutableInt2ReferenceSortedMap.Builder<AbstractValue> data2 = ImmutableInt2ReferenceSortedMap.builder();
        for (Integer ordinal : ordinalToObjectState.keySet()) {
            ObjectState state = ordinalToObjectState.get(ordinal);
            AbstractValue fieldValue = state.getAbstractFieldValue(encodedInstanceField);
            if (!fieldValue.isSingleValue()) {
                this.reportFailure(enumClass, (Reason)new Reason.MissingInstanceFieldValueForEnumInstanceReason(ordinal, instanceField));
                return EnumInstanceFieldData.EnumInstanceFieldUnknownData.getInstance();
            }
            if (!fieldValue.isSingleNumberValue() && !fieldValue.isSingleStringValue()) {
                this.reportFailure(enumClass, (Reason)new Reason.UnsupportedInstanceFieldValueForEnumInstanceReason(ordinal, instanceField));
                return EnumInstanceFieldData.EnumInstanceFieldUnknownData.getInstance();
            }
            data2.put(EnumUnboxerImpl.ordinalToUnboxedInt(ordinal), fieldValue);
            if (!canBeOrdinal) continue;
            assert (fieldValue.isSingleNumberValue());
            int computedValue = fieldValue.asSingleNumberValue().getIntValue();
            if (computedValue == ordinal) continue;
            canBeOrdinal = false;
        }
        if (canBeOrdinal) {
            return new EnumInstanceFieldData.EnumInstanceFieldOrdinalData();
        }
        return new EnumInstanceFieldData.EnumInstanceFieldMappingData(data2.build());
    }

    private OptionalInt getOrdinal(ObjectState state) {
        AbstractValue field = state.getAbstractFieldValue((DexEncodedField)this.getOrdinalField().getDefinition());
        if (field.isSingleNumberValue()) {
            return OptionalInt.of(field.asSingleNumberValue().getIntValue());
        }
        return OptionalInt.empty();
    }

    private void analyzeInitializers() {
        this.enumUnboxingCandidatesInfo.forEachCandidate(enumClass -> {
            DexEncodedMethod directMethod;
            Iterator<DexEncodedMethod> iterator2 = enumClass.directMethods().iterator();
            while (!(!iterator2.hasNext() || (directMethod = iterator2.next()).isInstanceInitializer() && directMethod.getOptimizationInfo().getContextInsensitiveInstanceInitializerInfo().mayHaveOtherSideEffectsThanInstanceFieldAssignments() && this.markEnumAsUnboxable(Reason.INVALID_INIT, (DexProgramClass)enumClass))) {
            }
            if (enumClass.classInitializationMayHaveSideEffects(this.appView)) {
                this.markEnumAsUnboxable(Reason.INVALID_CLINIT, (DexProgramClass)enumClass);
            }
        });
    }

    private Reason instructionAllowEnumUnboxing(Instruction instruction, IRCode code, DexProgramClass enumClass, Value enumValue) {
        ProgramMethod context = code.context();
        switch (instruction.opcode()) {
            case 9: {
                return this.analyzeAssumeUser(instruction.asAssume(), code, context, enumClass, enumValue);
            }
            case 6: {
                return this.analyzeArrayGetUser(instruction.asArrayGet(), code, context, enumClass, enumValue);
            }
            case 7: {
                return this.analyzeArrayLengthUser(instruction.asArrayLength(), code, context, enumClass, enumValue);
            }
            case 8: {
                return this.analyzeArrayPutUser(instruction.asArrayPut(), code, context, enumClass, enumValue);
            }
            case 10: {
                return this.analyzeCheckCastUser(instruction.asCheckCast(), code, context, enumClass, enumValue);
            }
            case 25: {
                return this.analyzeIfUser(instruction.asIf(), code, context, enumClass, enumValue);
            }
            case 28: {
                return this.analyzeInstanceGetUser(instruction.asInstanceGet(), code, context, enumClass, enumValue);
            }
            case 30: {
                return this.analyzeFieldPutUser(instruction.asInstancePut(), code, context, enumClass, enumValue);
            }
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: {
                return this.analyzeInvokeUser(instruction.asInvokeMethod(), code, context, enumClass, enumValue);
            }
            case 56: {
                return this.analyzeReturnUser(instruction.asReturn(), code, context, enumClass, enumValue);
            }
            case 60: {
                return this.analyzeFieldPutUser(instruction.asStaticPut(), code, context, enumClass, enumValue);
            }
        }
        return Reason.OTHER_UNSUPPORTED_INSTRUCTION;
    }

    private Reason analyzeAssumeUser(Assume assume, IRCode code, ProgramMethod context, DexProgramClass enumClass, Value enumValue) {
        return this.validateEnumUsages(code, assume.outValue(), enumClass);
    }

    private Reason analyzeArrayGetUser(ArrayGet arrayGet, IRCode code, ProgramMethod context, DexProgramClass enumClass, Value enumValue) {
        return Reason.ELIGIBLE;
    }

    private Reason analyzeArrayLengthUser(ArrayLength arrayLength, IRCode code, ProgramMethod context, DexProgramClass enumClass, Value enumValue) {
        return Reason.ELIGIBLE;
    }

    private Reason analyzeArrayPutUser(ArrayPut arrayPut, IRCode code, ProgramMethod context, DexProgramClass enumClass, Value enumValue) {
        assert (arrayPut.getMemberType() == MemberType.OBJECT);
        TypeElement arrayType = arrayPut.array().getType();
        assert (arrayType.isArrayType());
        assert (arrayType.asArrayType().getBaseType().isClassType());
        ClassTypeElement arrayBaseType = arrayType.asArrayType().getBaseType().asClassType();
        TypeElement valueBaseType = arrayPut.value().getType();
        if (valueBaseType.isArrayType()) {
            assert (valueBaseType.asArrayType().getBaseType().isClassType());
            assert (valueBaseType.asArrayType().getNesting() == arrayType.asArrayType().getNesting() - 1);
            valueBaseType = valueBaseType.asArrayType().getBaseType();
        }
        if (arrayBaseType.equalUpToNullability(valueBaseType) && arrayBaseType.getClassType() == enumClass.type) {
            return Reason.ELIGIBLE;
        }
        return Reason.INVALID_ARRAY_PUT;
    }

    private Reason analyzeCheckCastUser(CheckCast checkCast, IRCode code, ProgramMethod context, DexProgramClass enumClass, Value enumValue) {
        if (this.allowCheckCast(checkCast)) {
            return Reason.ELIGIBLE;
        }
        return Reason.DOWN_CAST;
    }

    private Reason analyzeFieldPutUser(FieldInstruction fieldPut, IRCode code, ProgramMethod context, DexProgramClass enumClass, Value enumValue) {
        assert (fieldPut.isInstancePut() || fieldPut.isStaticPut());
        DexEncodedField field = this.appView.appInfo().resolveField(fieldPut.getField()).getResolvedField();
        if (field == null) {
            return Reason.INVALID_FIELD_PUT;
        }
        DexProgramClass dexClass = this.appView.programDefinitionFor(field.getHolderType(), code.context());
        if (dexClass == null) {
            return Reason.INVALID_FIELD_PUT;
        }
        if (fieldPut.isInstancePut() && fieldPut.asInstancePut().object() == enumValue) {
            return Reason.ELIGIBLE;
        }
        if (((DexField)field.getReference()).type.toBaseType(this.factory) != enumClass.type) {
            return Reason.TYPE_MISMATCH_FIELD_PUT;
        }
        return Reason.ELIGIBLE;
    }

    private Reason analyzeIfUser(If theIf, IRCode code, ProgramMethod context, DexProgramClass enumClass, Value enumValue) {
        TypeElement rightType;
        assert (theIf.getType() == If.Type.EQ || theIf.getType() == If.Type.NE) : "Comparing a reference with " + theIf.getType().toString();
        if (theIf.isZeroTest()) {
            return Reason.ELIGIBLE;
        }
        TypeElement leftType = theIf.lhs().getType();
        if (leftType.equalUpToNullability(rightType = theIf.rhs().getType())) {
            assert (leftType.isClassType());
            assert (leftType.asClassType().getClassType() == enumClass.type);
            return Reason.ELIGIBLE;
        }
        return Reason.INVALID_IF_TYPES;
    }

    private Reason analyzeInstanceGetUser(InstanceGet instanceGet, IRCode code, ProgramMethod context, DexProgramClass enumClass, Value enumValue) {
        assert (instanceGet.getField().holder == enumClass.type);
        DexField field = instanceGet.getField();
        this.enumUnboxingCandidatesInfo.addRequiredEnumInstanceFieldData(enumClass, field);
        return Reason.ELIGIBLE;
    }

    private Reason analyzeInvokeUser(InvokeMethod invoke, IRCode code, ProgramMethod context, DexProgramClass enumClass, Value enumValue) {
        if (invoke.getInvokedMethod().holder.isArrayType()) {
            if (invoke.getInvokedMethod().name == this.factory.cloneMethodName) {
                return Reason.ELIGIBLE;
            }
            return Reason.INVALID_INVOKE_ON_ARRAY;
        }
        DexClassAndMethod singleTarget = invoke.lookupSingleTarget(this.appView, code.context());
        if (singleTarget == null) {
            return Reason.INVALID_INVOKE;
        }
        DexMethod singleTargetReference = (DexMethod)singleTarget.getReference();
        DexClass targetHolder = singleTarget.getHolder();
        if (targetHolder.isProgramClass()) {
            Value receiver;
            CheckNotNullEnumUnboxerMethodClassification checkNotNullClassification;
            if (targetHolder.isEnum() && ((DexEncodedMethod)singleTarget.getDefinition()).isInstanceInitializer()) {
                if (code.context().getHolder() != targetHolder || !code.method().isInitializer()) {
                    return Reason.INVALID_INIT;
                }
                if (code.method().isInstanceInitializer() && !invoke.getFirstArgument().isThis()) {
                    return Reason.INVALID_INIT;
                }
                return Reason.ELIGIBLE;
            }
            EnumUnboxerMethodClassification classification = singleTarget.getOptimizationInfo().getEnumUnboxerMethodClassification();
            if (classification.isCheckNotNullClassification() && (checkNotNullClassification = classification.asCheckNotNullClassification()).isUseEligibleForUnboxing(invoke.asInvokeStatic(), enumValue)) {
                GraphLens graphLens = this.appView.graphLens();
                this.checkNotNullMethodsBuilder.computeIfAbsent(singleTarget.asProgramMethod(), MapUtils.ignoreKey(() -> LongLivedClassSetBuilder.createConcurrentBuilderForIdentitySet(graphLens)), graphLens).add(enumClass, graphLens);
                return Reason.ELIGIBLE;
            }
            for (int i = 0; i < singleTarget.getParameters().size(); ++i) {
                if (invoke.getArgumentForParameter(i) != enumValue || singleTarget.getParameter(i).toBaseType(this.factory) == enumClass.getType()) continue;
                return new Reason.IllegalInvokeWithImpreciseParameterTypeReason(singleTargetReference);
            }
            if (invoke.isInvokeMethodWithReceiver() && (receiver = invoke.asInvokeMethodWithReceiver().getReceiver()) == enumValue && targetHolder.isInterface()) {
                return Reason.DEFAULT_METHOD_INVOKE;
            }
            return Reason.ELIGIBLE;
        }
        if (targetHolder.isClasspathClass()) {
            return Reason.INVALID_INVOKE_CLASSPATH;
        }
        assert (targetHolder.isLibraryClass());
        Reason reason = this.analyzeLibraryInvoke(invoke, code, context, enumClass, enumValue, singleTargetReference, targetHolder);
        if (reason == Reason.ELIGIBLE) {
            this.markMethodDependsOnLibraryModelisation(context);
        }
        return reason;
    }

    private Reason analyzeLibraryInvoke(InvokeMethod invoke, IRCode code, ProgramMethod context, DexProgramClass enumClass, Value enumValue, DexMethod singleTargetReference, DexClass targetHolder) {
        if (targetHolder.getType() == this.factory.enumType) {
            if (singleTargetReference == this.factory.enumMembers.compareTo || singleTargetReference == this.factory.enumMembers.compareToWithObject) {
                DexProgramClass otherEnumClass = this.getEnumUnboxingCandidateOrNull(invoke.getLastArgument().getType());
                if (otherEnumClass == enumClass || invoke.getLastArgument().getType().isNullType()) {
                    return Reason.ELIGIBLE;
                }
            } else {
                if (singleTargetReference == this.factory.enumMembers.equals) {
                    return Reason.ELIGIBLE;
                }
                if (singleTargetReference == this.factory.enumMembers.nameMethod || singleTargetReference == this.factory.enumMembers.toString) {
                    assert (invoke.asInvokeMethodWithReceiver().getReceiver() == enumValue);
                    this.addRequiredNameData(enumClass);
                    return Reason.ELIGIBLE;
                }
                if (singleTargetReference == this.factory.enumMembers.ordinalMethod) {
                    return Reason.ELIGIBLE;
                }
                if (singleTargetReference == this.factory.enumMembers.hashCode) {
                    return Reason.ELIGIBLE;
                }
                if (singleTargetReference == this.factory.enumMembers.constructor && code.method().isInstanceInitializer() && code.context().getHolder() == enumClass) {
                    return Reason.ELIGIBLE;
                }
            }
            return new Reason.UnsupportedLibraryInvokeReason(singleTargetReference);
        }
        if (targetHolder.getType() == this.factory.objectType) {
            if (singleTargetReference == this.factory.objectMembers.getClass && invoke.hasUnusedOutValue()) {
                return Reason.ELIGIBLE;
            }
            return new Reason.UnsupportedLibraryInvokeReason(singleTargetReference);
        }
        if (targetHolder.getType() == this.factory.objectsType) {
            if (singleTargetReference == this.factory.objectsMethods.requireNonNull || singleTargetReference == this.factory.objectsMethods.requireNonNullWithMessage) {
                return Reason.ELIGIBLE;
            }
            return new Reason.UnsupportedLibraryInvokeReason(singleTargetReference);
        }
        if (targetHolder.getType() == this.factory.stringType) {
            if (singleTargetReference == this.factory.stringMembers.valueOf) {
                this.addRequiredNameData(enumClass);
                return Reason.ELIGIBLE;
            }
            return new Reason.UnsupportedLibraryInvokeReason(singleTargetReference);
        }
        if (targetHolder.getType() == this.factory.stringBuilderType || targetHolder.getType() == this.factory.stringBufferType) {
            if (singleTargetReference == this.factory.stringBuilderMethods.appendObject || singleTargetReference == this.factory.stringBufferMethods.appendObject) {
                this.addRequiredNameData(enumClass);
                return Reason.ELIGIBLE;
            }
            return new Reason.UnsupportedLibraryInvokeReason(singleTargetReference);
        }
        if (targetHolder.getType() == this.factory.javaLangSystemType) {
            if (singleTargetReference == this.factory.javaLangSystemMethods.arraycopy) {
                return Reason.ELIGIBLE;
            }
            if (singleTargetReference == this.factory.javaLangSystemMethods.identityHashCode) {
                return Reason.ELIGIBLE;
            }
            return new Reason.UnsupportedLibraryInvokeReason(singleTargetReference);
        }
        return new Reason.UnsupportedLibraryInvokeReason(singleTargetReference);
    }

    private Reason analyzeReturnUser(Return theReturn, IRCode code, ProgramMethod context, DexProgramClass enumClass, Value enumValue) {
        DexType returnType = context.getReturnType();
        if (returnType != enumClass.type && returnType.toBaseType(this.factory) != enumClass.type) {
            return Reason.IMPLICIT_UP_CAST_IN_RETURN;
        }
        return Reason.ELIGIBLE;
    }

    private void reportEnumsAnalysis() {
        Map.Entry entry;
        List reasons2;
        assert (this.debugLogEnabled);
        Reporter reporter = this.appView.reporter();
        ImmutableSet<DexType> candidates = this.enumUnboxingCandidatesInfo.candidates();
        reporter.info(new StringDiagnostic("Unboxed " + candidates.size() + " enums: " + Arrays.toString(candidates.toArray())));
        StringBuilder sb = new StringBuilder("Unable to unbox ").append(this.debugLogs.size()).append(" enums.").append(System.lineSeparator()).append(System.lineSeparator());
        TreeMap<DexType, List> sortedDebugLogs = new TreeMap<DexType, List>(Comparator.comparingInt(x -> this.debugLogs.get(x).size()).thenComparing(Function.identity()));
        sortedDebugLogs.putAll(this.debugLogs);
        ArrayList<DexType> pinned = new ArrayList<DexType>();
        Iterator sortedDebugLogIterator = sortedDebugLogs.entrySet().iterator();
        while (sortedDebugLogIterator.hasNext() && (reasons2 = (List)(entry = sortedDebugLogIterator.next()).getValue()).size() <= 1) {
            if (reasons2.get(0) != Reason.PINNED) continue;
            pinned.add(entry.getKey());
            sortedDebugLogIterator.remove();
        }
        if (!pinned.isEmpty()) {
            sb.append("Pinned: ").append(Arrays.toString(pinned.toArray()));
        }
        sortedDebugLogs.forEach((type, reasons) -> {
            sb.append(type).append(" (").append(reasons.size()).append(" reasons):");
            HashMultiset.create(reasons).forEachEntry((reason, count) -> sb.append(System.lineSeparator()).append(" - ").append(reason).append(" (").append(count).append(")"));
            sb.append(System.lineSeparator());
        });
        sb.append(System.lineSeparator());
        Object2IntOpenHashMap reasonKindCount = new Object2IntOpenHashMap();
        this.debugLogs.forEach((type, reasons) -> reasons.forEach(reason -> reasonKindCount.put(reason.getKind(), reasonKindCount.getInt(reason) + 1)));
        ArrayList differentReasonKinds = new ArrayList(reasonKindCount.keySet());
        differentReasonKinds.sort((reasonKind, other) -> {
            int freq = reasonKindCount.getInt(reasonKind) - reasonKindCount.getInt(other);
            return freq != 0 ? freq : System.identityHashCode(reasonKind) - System.identityHashCode(other);
        });
        differentReasonKinds.forEach(reasonKind -> sb.append(reasonKind).append(" (").append(reasonKindCount.getInt(reasonKind)).append(")").append(System.lineSeparator()));
        reporter.info(new StringDiagnostic(sb.toString()));
    }

    public DexClassAndField getOrdinalField() {
        return this.ordinalField;
    }

    @Override
    public void updateEnumUnboxingCandidatesInfo() {
        for (DexProgramClass candidate : this.candidatesToRemoveInWave) {
            this.enumUnboxingCandidatesInfo.removeCandidate(candidate);
        }
        this.candidatesToRemoveInWave.clear();
    }

    @Override
    public void analyzeEnums(IRCode code, MethodProcessor methodProcessor) {
        Set<DexType> eligibleEnums = Sets.newIdentityHashSet();
        for (BasicBlock block : code.blocks) {
            for (Instruction instruction : block.getInstructions()) {
                DexProgramClass enumClass;
                Value outValue = instruction.outValue();
                if (outValue != null) {
                    Reason reason;
                    enumClass = this.getEnumUnboxingCandidateOrNull(outValue.getDynamicUpperBoundType(this.appView));
                    if (enumClass != null && (reason = this.validateEnumUsages(code, outValue, enumClass)) == Reason.ELIGIBLE) {
                        eligibleEnums.add(enumClass.type);
                    }
                    if (outValue.getType().isNullType()) {
                        this.addNullDependencies(code, outValue, eligibleEnums);
                    }
                } else if (instruction.isInvokeMethod() && (enumClass = this.getEnumUnboxingCandidateOrNull(instruction.asInvokeMethod().getReturnType())) != null) {
                    eligibleEnums.add(enumClass.type);
                }
                switch (instruction.opcode()) {
                    case 12: {
                        this.analyzeConstClass(instruction.asConstClass(), eligibleEnums, code.context());
                        break;
                    }
                    case 10: {
                        this.analyzeCheckCast(instruction.asCheckCast(), eligibleEnums);
                        break;
                    }
                    case 27: {
                        this.analyzeInitClass(instruction.asInitClass(), eligibleEnums);
                        break;
                    }
                    case 32: {
                        this.analyzeInvokeCustom(instruction.asInvokeCustom(), eligibleEnums, code.context());
                        break;
                    }
                    case 38: {
                        this.analyzeInvokeStatic(instruction.asInvokeStatic(), eligibleEnums, code.context());
                        break;
                    }
                    case 28: 
                    case 30: 
                    case 59: 
                    case 60: {
                        this.analyzeFieldInstruction(instruction.asFieldInstruction(), eligibleEnums, code.context());
                        break;
                    }
                }
            }
            for (Phi phi : block.getPhis()) {
                Reason reason;
                DexProgramClass enumClass = this.getEnumUnboxingCandidateOrNull(phi.getType());
                if (enumClass != null && (reason = this.validateEnumUsages(code, phi, enumClass)) == Reason.ELIGIBLE) {
                    eligibleEnums.add(enumClass.type);
                }
                if (!phi.getType().isNullType()) continue;
                this.addNullDependencies(code, phi, eligibleEnums);
            }
        }
        if (!eligibleEnums.isEmpty()) {
            for (DexType eligibleEnum : eligibleEnums) {
                this.enumUnboxingCandidatesInfo.addMethodDependency(eligibleEnum, code.context());
            }
        }
        if (this.methodsDependingOnLibraryModelisation.contains(code.context(), this.appView.graphLens())) {
            code.mutateConversionOptions(conversionOptions -> conversionOptions.disablePeepholeOptimizations(methodProcessor));
        }
    }

    @Override
    public void prepareForPrimaryOptimizationPass(GraphLens graphLensForPrimaryOptimizationPass) {
        assert (this.appView.graphLens() == graphLensForPrimaryOptimizationPass);
        this.initializeCheckNotNullMethods(graphLensForPrimaryOptimizationPass);
        this.initializeEnumUnboxingCandidates(graphLensForPrimaryOptimizationPass);
    }

    @Override
    public void rewriteWithLens() {
        this.methodsDependingOnLibraryModelisation = this.methodsDependingOnLibraryModelisation.rewrittenWithLens(this.appView.graphLens());
    }

    @Override
    public void unboxEnums(AppView<AppInfoWithLiveness> appView, IRConverter converter, PostMethodProcessor.Builder postMethodProcessorBuilder, ExecutorService executorService, OptimizationFeedbackDelayed feedback) throws ExecutionException {
        assert (feedback.noUpdatesLeft());
        assert (this.candidatesToRemoveInWave.isEmpty());
        EnumDataMap enumDataMap = this.finishAnalysis();
        assert (this.candidatesToRemoveInWave.isEmpty());
        appView.setUnboxedEnums(enumDataMap);
        if (this.enumUnboxingCandidatesInfo.isEmpty()) {
            assert (enumDataMap.isEmpty());
            return;
        }
        GraphLens previousLens = appView.graphLens();
        ImmutableSet<DexType> enumsToUnbox = this.enumUnboxingCandidatesInfo.candidates();
        ImmutableSet<DexProgramClass> enumClassesToUnbox = this.enumUnboxingCandidatesInfo.candidateClasses();
        LongLivedProgramMethodSetBuilder<ProgramMethodSet> dependencies = this.enumUnboxingCandidatesInfo.allMethodDependencies();
        this.enumUnboxingCandidatesInfo.clear();
        this.updateKeepInfo(enumsToUnbox);
        EnumUnboxingUtilityClasses utilityClasses = EnumUnboxingUtilityClasses.builder(appView).synthesizeEnumUnboxingUtilityClasses(enumClassesToUnbox, enumDataMap).build(converter, executorService);
        ProgramMethodMap<Set<DexProgramClass>> checkNotNullMethods = this.checkNotNullMethodsBuilder.rewrittenWithLens(appView, (enumClasses, appliedGraphLens) -> enumClasses).build(appView, builder -> builder.build(appView));
        checkNotNullMethods.removeIf((checkNotNullMethod, ignore) -> !checkNotNullMethod.getOptimizationInfo().getEnumUnboxerMethodClassification().isCheckNotNullClassification());
        EnumUnboxingTreeFixer.Result treeFixerResult = new EnumUnboxingTreeFixer(appView, checkNotNullMethods, enumDataMap, enumClassesToUnbox, utilityClasses).fixupTypeReferences(converter, executorService);
        EnumUnboxingLens enumUnboxingLens = treeFixerResult.getLens();
        postMethodProcessorBuilder.rewrittenWithLens(appView).removeAll(treeFixerResult.getPrunedItems().getRemovedMethods()).merge(dependencies.rewrittenWithLens(appView).removeAll(treeFixerResult.getPrunedItems().getRemovedMethods())).merge(this.methodsDependingOnLibraryModelisation.rewrittenWithLens(appView).removeAll(treeFixerResult.getPrunedItems().getRemovedMethods()));
        this.methodsDependingOnLibraryModelisation.clear();
        this.updateOptimizationInfos(executorService, feedback, treeFixerResult, previousLens);
        this.enumUnboxerRewriter = new EnumUnboxingRewriter(appView, treeFixerResult.getCheckNotNullToCheckNotZeroMapping(), enumUnboxingLens, enumDataMap, utilityClasses);
    }

    public EnumDataMap finishAnalysis() {
        this.analyzeInitializers();
        this.updateEnumUnboxingCandidatesInfo();
        EnumDataMap enumDataMap = this.analyzeEnumInstances();
        if (this.debugLogEnabled) {
            this.debugLogs.keySet().forEach(this.enumUnboxingCandidatesInfo::removeCandidate);
            this.reportEnumsAnalysis();
        }
        assert (enumDataMap.getUnboxedEnums().size() == this.enumUnboxingCandidatesInfo.candidates().size());
        return enumDataMap;
    }

    @Override
    public void recordEnumState(DexProgramClass clazz, StaticFieldValues staticFieldValues) {
        if (staticFieldValues == null || !staticFieldValues.isEnumStaticFieldValues()) {
            return;
        }
        assert (clazz.isEnum());
        StaticFieldValues.EnumStaticFieldValues enumStaticFieldValues = staticFieldValues.asEnumStaticFieldValues();
        if (this.getEnumUnboxingCandidateOrNull(clazz.type) != null) {
            this.staticFieldValuesMap.put(clazz.type, enumStaticFieldValues);
        }
    }

    boolean reportFailure(DexProgramClass enumClass, Reason reason) {
        return this.reportFailure(enumClass.getType(), reason);
    }

    boolean reportFailure(DexType enumType, Reason reason) {
        if (this.debugLogEnabled) {
            this.debugLogs.computeIfAbsent(enumType, ignore -> Collections.synchronizedList(new ArrayList())).add(reason);
            return true;
        }
        return false;
    }

    @Override
    public void onMethodPruned(ProgramMethod method) {
        this.onMethodCodePruned(method);
    }

    @Override
    public void onMethodCodePruned(ProgramMethod method) {
        this.enumUnboxingCandidatesInfo.addPrunedMethod(method);
        this.methodsDependingOnLibraryModelisation.remove((DexMethod)method.getReference(), this.appView.graphLens());
    }

    @Override
    public Set<Phi> rewriteCode(IRCode code, MethodProcessor methodProcessor, RewrittenPrototypeDescription prototypeChanges) {
        if (this.enumUnboxerRewriter != null) {
            return this.enumUnboxerRewriter.rewriteCode(code, methodProcessor, prototypeChanges);
        }
        return Sets.newIdentityHashSet();
    }

    @Override
    public void unsetRewriter() {
        this.enumUnboxerRewriter = null;
    }
}

