/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.enums;

import com.android.tools.r8.com.google.common.collect.ImmutableSet;
import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.collections.LongLivedProgramMethodSetBuilder;
import com.android.tools.r8.utils.collections.ProgramMethodSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class EnumUnboxingCandidateInfoCollection {
    private final Map<DexType, EnumUnboxingCandidateInfo> enumTypeToInfo = new ConcurrentHashMap<DexType, EnumUnboxingCandidateInfo>();
    private final Set<DexMethod> prunedMethods = Sets.newConcurrentHashSet();

    public void addCandidate(AppView<AppInfoWithLiveness> appView, DexProgramClass enumClass, GraphLens graphLensForPrimaryOptimizationPass) {
        assert (!this.enumTypeToInfo.containsKey(enumClass.type));
        this.enumTypeToInfo.put(enumClass.type, new EnumUnboxingCandidateInfo(appView, enumClass, graphLensForPrimaryOptimizationPass));
    }

    public void addPrunedMethod(ProgramMethod method) {
        this.prunedMethods.add((DexMethod)method.getReference());
    }

    public void removeCandidate(DexProgramClass enumClass) {
        this.removeCandidate(enumClass.getType());
    }

    public void removeCandidate(DexType enumType) {
        this.enumTypeToInfo.remove(enumType);
    }

    public boolean isCandidate(DexType enumType) {
        return this.enumTypeToInfo.containsKey(enumType);
    }

    public boolean isEmpty() {
        return this.enumTypeToInfo.isEmpty();
    }

    public ImmutableSet<DexType> candidates() {
        return ImmutableSet.copyOf(this.enumTypeToInfo.keySet());
    }

    public ImmutableSet<DexProgramClass> candidateClasses() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (EnumUnboxingCandidateInfo info : this.enumTypeToInfo.values()) {
            builder.add(info.getEnumClass());
        }
        return builder.build();
    }

    public DexProgramClass getCandidateClassOrNull(DexType enumType) {
        EnumUnboxingCandidateInfo info = this.enumTypeToInfo.get(enumType);
        if (info == null) {
            return null;
        }
        return info.enumClass;
    }

    public LongLivedProgramMethodSetBuilder<ProgramMethodSet> allMethodDependencies() {
        Iterator<EnumUnboxingCandidateInfo> candidateInfoIterator = this.enumTypeToInfo.values().iterator();
        assert (candidateInfoIterator.hasNext());
        LongLivedProgramMethodSetBuilder allMethodDependencies = candidateInfoIterator.next().methodDependencies;
        while (candidateInfoIterator.hasNext()) {
            allMethodDependencies.merge(candidateInfoIterator.next().methodDependencies);
        }
        allMethodDependencies.removeAll(this.prunedMethods);
        return allMethodDependencies;
    }

    public void addMethodDependency(DexType enumType, ProgramMethod programMethod) {
        EnumUnboxingCandidateInfo info = this.enumTypeToInfo.get(enumType);
        if (info == null) {
            return;
        }
        info.addMethodDependency(programMethod);
    }

    public void addRequiredEnumInstanceFieldData(DexProgramClass enumClass, DexField field) {
        EnumUnboxingCandidateInfo info = this.enumTypeToInfo.get(enumClass.getType());
        if (info == null) {
            return;
        }
        info.addRequiredInstanceFieldData(field);
    }

    public void forEachCandidate(Consumer<DexProgramClass> enumClassConsumer) {
        this.enumTypeToInfo.values().forEach(info -> enumClassConsumer.accept(((EnumUnboxingCandidateInfo)info).enumClass));
    }

    public void forEachCandidateAndRequiredInstanceFieldData(BiConsumer<DexProgramClass, Set<DexField>> biConsumer) {
        this.enumTypeToInfo.values().forEach(info -> biConsumer.accept(info.getEnumClass(), info.getRequiredInstanceFieldData()));
    }

    public void clear() {
        this.enumTypeToInfo.clear();
    }

    private static class EnumUnboxingCandidateInfo {
        private final DexProgramClass enumClass;
        private final LongLivedProgramMethodSetBuilder<ProgramMethodSet> methodDependencies;
        private final Set<DexField> requiredInstanceFieldData = Sets.newConcurrentHashSet();

        public EnumUnboxingCandidateInfo(AppView<AppInfoWithLiveness> appView, DexProgramClass enumClass, GraphLens graphLensForPrimaryOptimizationPass) {
            assert (enumClass != null);
            assert (appView.graphLens() == graphLensForPrimaryOptimizationPass);
            this.enumClass = enumClass;
            this.methodDependencies = LongLivedProgramMethodSetBuilder.createConcurrentForIdentitySet(graphLensForPrimaryOptimizationPass);
        }

        public DexProgramClass getEnumClass() {
            return this.enumClass;
        }

        public void addMethodDependency(ProgramMethod method) {
            this.methodDependencies.add(method);
        }

        public void addRequiredInstanceFieldData(DexField field) {
            this.requiredInstanceFieldData.add(field);
        }

        public Set<DexField> getRequiredInstanceFieldData() {
            return this.requiredInstanceFieldData;
        }
    }
}

