/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.enums;

import com.android.tools.r8.com.google.common.collect.BiMap;
import com.android.tools.r8.com.google.common.collect.HashBiMap;
import com.android.tools.r8.contexts.CompilationContext;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ProgramField;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.PrunedItems;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import com.android.tools.r8.ir.analysis.type.ClassTypeElement;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.type.TypeElement;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.BasicBlockIterator;
import com.android.tools.r8.ir.code.ConstClass;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionListIterator;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.NewUnboxedEnumInstance;
import com.android.tools.r8.ir.code.StaticPut;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.ExtraUnusedNullParameter;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.conversion.OneTimeMethodProcessor;
import com.android.tools.r8.ir.optimize.enums.EnumDataMap;
import com.android.tools.r8.ir.optimize.enums.EnumUnboxingLens;
import com.android.tools.r8.ir.optimize.enums.EnumUnboxingUtilityClasses;
import com.android.tools.r8.ir.optimize.enums.LocalEnumUnboxingUtilityClass;
import com.android.tools.r8.ir.optimize.enums.classification.CheckNotNullEnumUnboxerMethodClassification;
import com.android.tools.r8.ir.optimize.enums.code.CheckNotZeroCode;
import com.android.tools.r8.ir.optimize.info.DefaultMethodOptimizationInfo;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedbackIgnore;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldInitializationInfo;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.ImmutableArrayUtils;
import com.android.tools.r8.utils.OptionalBool;
import com.android.tools.r8.utils.SetUtils;
import com.android.tools.r8.utils.ThreadUtils;
import com.android.tools.r8.utils.Timing;
import com.android.tools.r8.utils.collections.ProgramMethodMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;

class EnumUnboxingTreeFixer {
    private final EnumUnboxingLens.Builder lensBuilder;
    private final AppView<AppInfoWithLiveness> appView;
    private final ProgramMethodMap<Set<DexProgramClass>> checkNotNullMethods;
    private final DexItemFactory factory;
    private final EnumDataMap enumDataMap;
    private final Set<DexProgramClass> unboxedEnums;
    private final EnumUnboxingUtilityClasses utilityClasses;

    EnumUnboxingTreeFixer(AppView<AppInfoWithLiveness> appView, ProgramMethodMap<Set<DexProgramClass>> checkNotNullMethods, EnumDataMap enumDataMap, Set<DexProgramClass> unboxedEnums, EnumUnboxingUtilityClasses utilityClasses) {
        this.appView = appView;
        this.checkNotNullMethods = checkNotNullMethods;
        this.enumDataMap = enumDataMap;
        this.factory = appView.dexItemFactory();
        this.lensBuilder = EnumUnboxingLens.enumUnboxingLensBuilder(appView).mapUnboxedEnums(enumDataMap.getUnboxedEnums());
        this.unboxedEnums = unboxedEnums;
        this.utilityClasses = utilityClasses;
    }

    private BiMap<DexMethod, DexMethod> duplicateCheckNotNullMethods(IRConverter converter, ExecutorService executorService) throws ExecutionException {
        HashBiMap<DexMethod, DexMethod> checkNotNullToCheckNotZeroMapping = HashBiMap.create();
        CompilationContext.ProcessorContext processorContext = this.appView.createProcessorContext();
        OneTimeMethodProcessor.Builder methodProcessorBuilder = OneTimeMethodProcessor.builder(processorContext);
        this.checkNotNullMethods.removeIf((checkNotNullMethod, dependentEnums) -> !SetUtils.containsAnyOf(this.unboxedEnums, dependentEnums));
        this.checkNotNullMethods.forEach((checkNotNullMethod, dependentEnums) -> {
            CheckNotNullEnumUnboxerMethodClassification checkNotNullClassification = checkNotNullMethod.getOptimizationInfo().getEnumUnboxerMethodClassification().asCheckNotNullClassification();
            DexProto newProto = this.factory.createProto(this.factory.voidType, ImmutableArrayUtils.set(checkNotNullMethod.getParameters().getBacking(), checkNotNullClassification.getArgumentIndex(), this.factory.intType));
            ProgramMethod checkNotZeroMethod = this.appView.getSyntheticItems().createMethod(kinds -> kinds.ENUM_UNBOXING_CHECK_NOT_ZERO_METHOD, processorContext.createMethodProcessingContext((ProgramMethod)checkNotNullMethod).createUniqueContext(), this.appView, builder -> builder.setAccessFlags(MethodAccessFlags.createPublicStaticSynthetic()).setClassFileVersion(((DexEncodedMethod)checkNotNullMethod.getDefinition()).getClassFileVersionOrElse(null)).setApiLevelForDefinition(this.appView.computedMinApiLevel()).setApiLevelForCode(this.appView.computedMinApiLevel()).setCode(method -> new CheckNotZeroCode((ProgramMethod)checkNotNullMethod)).setOptimizationInfo(DefaultMethodOptimizationInfo.getInstance().toMutableOptimizationInfo().setEnumUnboxerMethodClassification(checkNotNullClassification)).setProto(newProto));
            checkNotNullToCheckNotZeroMapping.put((DexMethod)checkNotNullMethod.getReference(), (DexMethod)checkNotZeroMethod.getReference());
            this.lensBuilder.recordCheckNotZeroMethod((ProgramMethod)checkNotNullMethod, checkNotZeroMethod);
            methodProcessorBuilder.add(checkNotZeroMethod);
        });
        OneTimeMethodProcessor methodProcessor = methodProcessorBuilder.build();
        methodProcessor.forEachWaveWithExtension((method, methodProcessingContext) -> converter.processDesugaredMethod(method, OptimizationFeedback.getSimple(), methodProcessor, methodProcessingContext), executorService);
        return checkNotNullToCheckNotZeroMapping;
    }

    private void fixupEnumClassInitializers(IRConverter converter, ExecutorService executorService) throws ExecutionException {
        DexEncodedField ordinalField = this.appView.appInfo().resolveField(this.appView.dexItemFactory().enumMembers.ordinalField).getResolvedField();
        ThreadUtils.processItems(this.unboxedEnums, unboxedEnum -> this.fixupEnumClassInitializer(converter, (DexProgramClass)unboxedEnum, ordinalField), executorService);
    }

    private void fixupEnumClassInitializer(IRConverter converter, DexProgramClass unboxedEnum, DexEncodedField ordinalField) {
        if (!unboxedEnum.hasClassInitializer()) {
            assert (unboxedEnum.staticFields().isEmpty());
            return;
        }
        ProgramMethod classInitializer = unboxedEnum.getProgramClassInitializer();
        EnumDataMap.EnumData enumData = this.enumDataMap.get(unboxedEnum);
        LocalEnumUnboxingUtilityClass localUtilityClass = this.utilityClasses.getLocalUtilityClass(unboxedEnum);
        IRCode code = classInitializer.buildIR(this.appView);
        BasicBlockIterator blockIterator = code.listIterator();
        IdentityHashMap instructionsToRemove = new IdentityHashMap();
        while (blockIterator.hasNext()) {
            BasicBlock block = (BasicBlock)blockIterator.next();
            InstructionListIterator instructionIterator = block.listIterator(code);
            while (instructionIterator.hasNext()) {
                ProgramField programField;
                Instruction instruction = (Instruction)instructionIterator.next();
                if (instructionsToRemove.containsKey(instruction)) {
                    Optional rewrittenInstruction = (Optional)instructionsToRemove.remove(instruction);
                    if (rewrittenInstruction.isPresent()) {
                        instructionIterator.replaceCurrentInstruction((Instruction)rewrittenInstruction.get());
                        instructionIterator.previous();
                    }
                    instructionIterator.removeOrReplaceByDebugLocalRead();
                    continue;
                }
                if (instruction.isConstClass()) {
                    ConstClass constClass = instruction.asConstClass();
                    if (constClass.getType() != unboxedEnum.getType()) continue;
                    ArrayList<InvokeVirtual> desiredAssertionStatusUsers = new ArrayList<InvokeVirtual>();
                    for (Instruction user : constClass.outValue().aliasedUsers()) {
                        InvokeVirtual invoke;
                        if (!user.isInvokeVirtual() || (invoke = user.asInvokeVirtual()).getInvokedMethod() != this.appView.dexItemFactory().classMethods.desiredAssertionStatus) continue;
                        desiredAssertionStatusUsers.add(invoke);
                    }
                    if (desiredAssertionStatusUsers.isEmpty()) continue;
                    ConstClass newConstClass = ((ConstClass.Builder)((ConstClass.Builder)ConstClass.builder().setType(localUtilityClass.getType()).setFreshOutValue(code, TypeElement.classClassType(this.appView, Nullability.definitelyNotNull()))).setPosition(constClass.getPosition())).build();
                    instructionIterator.add(newConstClass);
                    constClass.outValue().replaceSelectiveInstructionUsers(newConstClass.outValue(), desiredAssertionStatusUsers::contains);
                    continue;
                }
                if (instruction.isNewInstance()) {
                    int ordinal;
                    NewInstance newInstance = instruction.asNewInstance();
                    DexType rewrittenType = this.appView.graphLens().lookupType(newInstance.getType());
                    if (rewrittenType != unboxedEnum.getType()) continue;
                    InvokeDirect constructorInvoke = newInstance.getUniqueConstructorInvoke(this.appView.dexItemFactory());
                    assert (constructorInvoke != null);
                    DexMethod invokedMethod = constructorInvoke.getInvokedMethod();
                    GraphLens.MethodLookupResult lookupResult = this.appView.graphLens().lookupInvokeDirect(invokedMethod, classInitializer);
                    if (lookupResult.getReference() != invokedMethod) {
                        ArrayList<Value> rewrittenArguments = new ArrayList<Value>(constructorInvoke.arguments().size());
                        for (int i = 0; i < constructorInvoke.arguments().size(); ++i) {
                            Value argument = constructorInvoke.getArgument(i);
                            if (lookupResult.getPrototypeChanges().getArgumentInfoCollection().isArgumentRemoved(i)) continue;
                            rewrittenArguments.add(argument);
                        }
                        InvokeDirect originalConstructorInvoke = constructorInvoke;
                        constructorInvoke = ((InvokeDirect.Builder)((InvokeDirect.Builder)InvokeDirect.builder().setArguments(rewrittenArguments)).setMethod((DexMethod)lookupResult.getReference())).build();
                        instructionsToRemove.put(originalConstructorInvoke, Optional.of(constructorInvoke));
                    } else {
                        assert (lookupResult.getPrototypeChanges().isEmpty());
                        instructionsToRemove.put(constructorInvoke, Optional.empty());
                    }
                    ProgramMethod constructor = unboxedEnum.lookupProgramMethod((DexMethod)lookupResult.getReference());
                    assert (constructor != null);
                    InstanceFieldInitializationInfo ordinalInitializationInfo = ((DexEncodedMethod)constructor.getDefinition()).getOptimizationInfo().getInstanceInitializerInfo(constructorInvoke).fieldInitializationInfos().get(ordinalField);
                    if (ordinalInitializationInfo.isArgumentInitializationInfo()) {
                        Value ordinalValue = constructorInvoke.getArgument(ordinalInitializationInfo.asArgumentInitializationInfo().getArgumentIndex()).getAliasedValue();
                        assert (ordinalValue.isDefinedByInstructionSatisfying(Instruction::isConstNumber));
                        ordinal = ordinalValue.getDefinition().asConstNumber().getIntValue();
                    } else {
                        assert (ordinalInitializationInfo.isSingleValue());
                        assert (ordinalInitializationInfo.asSingleValue().isSingleNumberValue());
                        ordinal = ordinalInitializationInfo.asSingleValue().asSingleNumberValue().getIntValue();
                    }
                    instructionIterator.replaceCurrentInstruction(new NewUnboxedEnumInstance(unboxedEnum.getType(), ordinal, code.createValue(ClassTypeElement.create(unboxedEnum.getType(), Nullability.definitelyNotNull(), this.appView))));
                    continue;
                }
                if (!instruction.isStaticPut()) continue;
                StaticPut staticPut = instruction.asStaticPut();
                DexField rewrittenField = this.appView.graphLens().lookupField(staticPut.getField());
                if (rewrittenField.getHolderType() != unboxedEnum.getType() || (programField = this.appView.appInfo().resolveField(rewrittenField).getSingleProgramField()) == null || !this.isPrunedAfterEnumUnboxing(programField, enumData)) continue;
                instructionIterator.removeOrReplaceByDebugLocalRead();
            }
        }
        if (!instructionsToRemove.isEmpty()) {
            InstructionListIterator instructionIterator = code.instructionListIterator();
            while (instructionIterator.hasNext()) {
                Instruction instruction = (Instruction)instructionIterator.next();
                if (!instructionsToRemove.containsKey(instruction)) continue;
                Optional rewrittenInstruction = (Optional)instructionsToRemove.get(instruction);
                if (rewrittenInstruction.isPresent()) {
                    instructionIterator.replaceCurrentInstruction((Instruction)rewrittenInstruction.get());
                    instructionIterator.previous();
                }
                instructionIterator.removeOrReplaceByDebugLocalRead();
            }
        }
        converter.removeDeadCodeAndFinalizeIR(code, OptimizationFeedbackIgnore.getInstance(), Timing.empty());
    }

    private Collection<DexEncodedField> createLocalUtilityFields(DexProgramClass unboxedEnum, LocalEnumUnboxingUtilityClass localUtilityClass, PrunedItems.Builder prunedItemsBuilder) {
        EnumDataMap.EnumData enumData = this.enumDataMap.get(unboxedEnum);
        LinkedHashMap localUtilityFields = new LinkedHashMap(unboxedEnum.staticFields().size());
        assert (localUtilityClass.getDefinition().staticFields().isEmpty());
        unboxedEnum.forEachProgramField(field -> {
            if (this.isPrunedAfterEnumUnboxing((ProgramField)field, enumData)) {
                prunedItemsBuilder.addRemovedField((DexField)field.getReference());
                return;
            }
            DexEncodedField newLocalUtilityField = this.createLocalUtilityField((ProgramField)field, localUtilityClass, newFieldSignature -> !localUtilityFields.containsKey(newFieldSignature));
            assert (!localUtilityFields.containsKey(newLocalUtilityField.getReference()));
            localUtilityFields.put((DexField)newLocalUtilityField.getReference(), newLocalUtilityField);
        });
        return localUtilityFields.values();
    }

    private DexEncodedField createLocalUtilityField(ProgramField field, LocalEnumUnboxingUtilityClass localUtilityClass, Predicate<DexField> availableFieldSignatures) {
        DexField newFieldSignature = this.factory.createFreshFieldNameWithoutHolder(localUtilityClass.getType(), this.fixupType(field.getType()), field.getName().toString(), availableFieldSignatures);
        this.lensBuilder.move((DexField)field.getReference(), newFieldSignature);
        return ((DexEncodedField)field.getDefinition()).toTypeSubstitutedField(this.appView, newFieldSignature, builder -> builder.clearAnnotations().modifyAccessFlags(accessFlags -> {
            assert (accessFlags.isStatic());
            accessFlags.promoteToPublic();
        }));
    }

    private Collection<DexEncodedMethod> createLocalUtilityMethods(DexProgramClass unboxedEnum, LocalEnumUnboxingUtilityClass localUtilityClass, PrunedItems.Builder prunedItemsBuilder) {
        LinkedHashMap localUtilityMethods = new LinkedHashMap(localUtilityClass.getDefinition().getMethodCollection().size() + unboxedEnum.getMethodCollection().size());
        localUtilityClass.getDefinition().forEachMethod(method -> localUtilityMethods.put((DexMethod)method.getReference(), method));
        unboxedEnum.forEachProgramMethod(method -> {
            if (((DexEncodedMethod)method.getDefinition()).isInstanceInitializer()) {
                prunedItemsBuilder.addRemovedMethod((DexMethod)method.getReference());
            } else {
                DexEncodedMethod newLocalUtilityMethod = this.createLocalUtilityMethod((ProgramMethod)method, localUtilityClass, newMethodSignature -> !localUtilityMethods.containsKey(newMethodSignature));
                assert (!localUtilityMethods.containsKey(newLocalUtilityMethod.getReference()));
                localUtilityMethods.put((DexMethod)newLocalUtilityMethod.getReference(), newLocalUtilityMethod);
            }
        });
        return localUtilityMethods.values();
    }

    private DexEncodedMethod createLocalUtilityMethod(ProgramMethod method, LocalEnumUnboxingUtilityClass localUtilityClass, Predicate<DexMethod> availableMethodSignatures) {
        DexMethod methodReference = (DexMethod)method.getReference();
        DexMethod newMethod = ((DexEncodedMethod)method.getDefinition()).isClassInitializer() ? this.factory.createClassInitializer(localUtilityClass.getType()) : this.factory.createFreshMethodNameWithoutHolder("_" + method.getName().toString(), this.fixupProto(method.getAccessFlags().isStatic() ? method.getProto() : this.factory.prependHolderToProto(methodReference)), localUtilityClass.getType(), availableMethodSignatures);
        this.lensBuilder.move(methodReference, newMethod, ((DexEncodedMethod)method.getDefinition()).isStatic(), true);
        return ((DexEncodedMethod)method.getDefinition()).toTypeSubstitutedMethod(newMethod, builder -> builder.clearAllAnnotations().modifyAccessFlags(accessFlags -> {
            if (((DexEncodedMethod)method.getDefinition()).isClassInitializer()) {
                assert (accessFlags.isStatic());
            } else {
                accessFlags.promoteToPublic();
                accessFlags.promoteToStatic();
            }
        }).setCompilationState(((DexEncodedMethod)method.getDefinition()).getCompilationState()).unsetIsLibraryMethodOverride());
    }

    private boolean isPrunedAfterEnumUnboxing(ProgramField field, EnumDataMap.EnumData enumData) {
        return !field.getAccessFlags().isStatic() || (enumData.hasUnboxedValueFor(field) || enumData.matchesValuesField(field)) && !((DexEncodedField)field.getDefinition()).getOptimizationInfo().isDead();
    }

    private DexEncodedMethod fixupEncodedMethod(DexProgramClass holder, DexEncodedMethod method) {
        DexProto oldProto = method.getProto();
        DexProto newProto = this.fixupProto(oldProto);
        if (newProto == method.getProto()) {
            return method;
        }
        assert (!method.isClassInitializer());
        assert (!method.isLibraryMethodOverride().isTrue()) : "Enum unboxing is changing the signature of a library override in a non unboxed class.";
        String newMethodName = method.getName().toString() + (method.isNonPrivateVirtualMethod() ? "$enumunboxing$" : "");
        DexMethod newMethod = this.factory.createMethod(method.getHolderType(), newProto, newMethodName);
        newMethod = this.ensureUniqueMethod(method, newMethod);
        List<ExtraUnusedNullParameter> extraUnusedNullParameters = ExtraUnusedNullParameter.computeExtraUnusedNullParameters((DexMethod)method.getReference(), newMethod);
        boolean isStatic = method.isStatic();
        RewrittenPrototypeDescription prototypeChanges = this.lensBuilder.move((DexMethod)method.getReference(), newMethod, isStatic, isStatic, extraUnusedNullParameters);
        return method.toTypeSubstitutedMethod(newMethod, builder -> builder.fixupOptimizationInfo(this.appView, prototypeChanges.createMethodOptimizationInfoFixer()).setCompilationState(method.getCompilationState()).setIsLibraryMethodOverrideIf(method.isNonPrivateVirtualMethod(), OptionalBool.FALSE));
    }

    private DexMethod ensureUniqueMethod(DexEncodedMethod encodedMethod, DexMethod newMethod) {
        DexClass holder = this.appView.definitionFor(encodedMethod.getHolderType());
        assert (holder != null);
        if (newMethod.isInstanceInitializer(this.appView.dexItemFactory())) {
            newMethod = this.factory.createInstanceInitializerWithFreshProto(newMethod, this.utilityClasses.getSharedUtilityClass().getType(), tryMethod -> holder.lookupMethod((DexMethod)tryMethod) == null);
        } else {
            int index = 0;
            while (holder.lookupMethod(newMethod) != null) {
                newMethod = newMethod.withName(encodedMethod.getName().toString() + "$enumunboxing$" + index++, this.appView.dexItemFactory());
            }
        }
        return newMethod;
    }

    private void fixupFields(List<DexEncodedField> fields, DexClass.FieldSetter setter) {
        if (fields == null) {
            return;
        }
        for (int i = 0; i < fields.size(); ++i) {
            DexEncodedField encodedField = fields.get(i);
            DexField field = (DexField)encodedField.getReference();
            DexType newType = this.fixupType(field.type);
            if (newType == field.type) continue;
            DexField newField = field.withType(newType, this.factory);
            this.lensBuilder.move(field, newField);
            DexEncodedField newEncodedField = encodedField.toTypeSubstitutedField(this.appView, newField, builder -> builder.setAbstractValue(encodedField.getOptimizationInfo().getAbstractValue(), this.appView));
            setter.setField(i, newEncodedField);
            if (!encodedField.isStatic() || !encodedField.hasExplicitStaticValue()) continue;
            assert (encodedField.getStaticValue() == DexValue.DexValueNull.NULL);
            newEncodedField.setStaticValue(DexValue.DexValueInt.DEFAULT);
        }
    }

    private DexProto fixupProto(DexProto proto) {
        DexType returnType = this.fixupType(proto.returnType);
        DexType[] arguments = this.fixupTypes(proto.parameters.values);
        return this.factory.createProto(returnType, arguments);
    }

    private DexType fixupType(DexType type) {
        if (type.isArrayType()) {
            DexType fixed;
            DexType base = type.toBaseType(this.factory);
            if (base == (fixed = this.fixupType(base))) {
                return type;
            }
            return type.replaceBaseType(fixed, this.factory);
        }
        return type.isClassType() && this.enumDataMap.isUnboxedEnum(type) ? this.factory.intType : type;
    }

    private DexType[] fixupTypes(DexType[] types) {
        DexType[] result = new DexType[types.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.fixupType(types[i]);
        }
        return result;
    }

    Result fixupTypeReferences(IRConverter converter, ExecutorService executorService) throws ExecutionException {
        PrunedItems.Builder prunedItemsBuilder = PrunedItems.builder();
        this.fixupEnumClassInitializers(converter, executorService);
        for (DexProgramClass clazz : this.appView.appInfo().classes()) {
            if (this.enumDataMap.isUnboxedEnum(clazz)) {
                LocalEnumUnboxingUtilityClass localUtilityClass = this.utilityClasses.getLocalUtilityClass(clazz);
                Collection<DexEncodedField> localUtilityFields = this.createLocalUtilityFields(clazz, localUtilityClass, prunedItemsBuilder);
                Collection<DexEncodedMethod> localUtilityMethods = this.createLocalUtilityMethods(clazz, localUtilityClass, prunedItemsBuilder);
                clazz.clearInstanceFields();
                clazz.clearStaticFields();
                clazz.getMethodCollection().clearDirectMethods();
                clazz.getMethodCollection().clearVirtualMethods();
                localUtilityClass.getDefinition().setDirectMethods(localUtilityMethods);
                localUtilityClass.getDefinition().setStaticFields(localUtilityFields);
                continue;
            }
            clazz.getMethodCollection().replaceMethods(method -> this.fixupEncodedMethod(clazz, (DexEncodedMethod)method));
            this.fixupFields(clazz.staticFields(), clazz::setStaticField);
            this.fixupFields(clazz.instanceFields(), clazz::setInstanceField);
        }
        EnumUnboxingLens lens = this.lensBuilder.build(this.appView);
        this.appView.rewriteWithLens(lens);
        converter.outliner.rewriteWithLens();
        BiMap<DexMethod, DexMethod> checkNotNullToCheckNotZeroMapping = this.duplicateCheckNotNullMethods(converter, executorService);
        return new Result(checkNotNullToCheckNotZeroMapping, lens, prunedItemsBuilder.build());
    }

    public static class Result {
        private final BiMap<DexMethod, DexMethod> checkNotNullToCheckNotZeroMapping;
        private final EnumUnboxingLens lens;
        private final PrunedItems prunedItems;

        Result(BiMap<DexMethod, DexMethod> checkNotNullToCheckNotZeroMapping, EnumUnboxingLens lens, PrunedItems prunedItems) {
            this.checkNotNullToCheckNotZeroMapping = checkNotNullToCheckNotZeroMapping;
            this.lens = lens;
            this.prunedItems = prunedItems;
        }

        BiMap<DexMethod, DexMethod> getCheckNotNullToCheckNotZeroMapping() {
            return this.checkNotNullToCheckNotZeroMapping;
        }

        EnumUnboxingLens getLens() {
            return this.lens;
        }

        PrunedItems getPrunedItems() {
            return this.prunedItems;
        }
    }
}

