/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.enums;

import com.android.tools.r8.cf.CfVersion;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.value.SingleStringValue;
import com.android.tools.r8.ir.optimize.enums.EnumDataMap;
import com.android.tools.r8.ir.optimize.enums.EnumUnboxingUtilityClass;
import com.android.tools.r8.ir.optimize.enums.EnumUnboxingUtilityClasses;
import com.android.tools.r8.ir.synthetic.EnumUnboxingCfCodeProvider;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.synthesis.SyntheticMethodBuilder;
import com.android.tools.r8.synthesis.SyntheticProgramClassBuilder;
import com.android.tools.r8.utils.ConsumerUtils;

public class LocalEnumUnboxingUtilityClass
extends EnumUnboxingUtilityClass {
    private static final String ENUM_UNBOXING_LOCAL_UTILITY_CLASS_SUFFIX = "$r8$EnumUnboxingLocalUtility";
    private final DexProgramClass localUtilityClass;
    private final EnumDataMap.EnumData data;

    public LocalEnumUnboxingUtilityClass(DexProgramClass localUtilityClass, EnumDataMap.EnumData data2, DexProgramClass synthesizingContext) {
        super(synthesizingContext);
        this.localUtilityClass = localUtilityClass;
        this.data = data2;
    }

    public static Builder builder(AppView<AppInfoWithLiveness> appView, DexProgramClass enumToUnbox, EnumDataMap.EnumData data2) {
        return new Builder(appView, enumToUnbox, data2);
    }

    private ProgramMethod internalEnsureMethod(AppView<AppInfoWithLiveness> appView, DexString methodName, DexProto methodProto, SyntheticMethodBuilder.SyntheticCodeGenerator codeGenerator) {
        return appView.getSyntheticItems().ensureFixedClassMethod(methodName, methodProto, kinds -> kinds.ENUM_UNBOXING_LOCAL_UTILITY_CLASS, this.getSynthesizingContext(), appView, ConsumerUtils.emptyConsumer(), methodBuilder -> methodBuilder.setAccessFlags(MethodAccessFlags.createPublicStaticSynthetic()).setApiLevelForDefinition(appView.computedMinApiLevel()).setApiLevelForCode(appView.computedMinApiLevel()).setCode(codeGenerator).setClassFileVersion(CfVersion.V1_6));
    }

    @Override
    public void ensureMethods(AppView<AppInfoWithLiveness> appView) {
        this.data.instanceFieldMap.forEach((field, fieldData) -> {
            if (fieldData.isMapping()) {
                this.ensureGetInstanceFieldMethod(appView, (DexField)field);
            }
        });
        if (this.data.instanceFieldMap.containsKey(appView.dexItemFactory().enumMembers.nameField)) {
            this.ensureStringValueOfMethod(appView);
            this.ensureValueOfMethod(appView);
        }
    }

    public ProgramMethod ensureGetInstanceFieldMethod(AppView<AppInfoWithLiveness> appView, DexField field) {
        DexString methodName;
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        String fieldName = field.getName().toString();
        if (field.getHolderType() == this.getSynthesizingContext().getType()) {
            methodName = dexItemFactory.createString("get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1));
        } else {
            assert (field == appView.dexItemFactory().enumMembers.nameField || field == appView.dexItemFactory().enumMembers.ordinalField);
            methodName = field.getName();
        }
        return this.internalEnsureMethod(appView, methodName, dexItemFactory.createProto(field.getType(), dexItemFactory.intType), method -> new EnumUnboxingCfCodeProvider.EnumUnboxingInstanceFieldCfCodeProvider(appView, this.getType(), this.data, field).generateCfCode());
    }

    public ProgramMethod ensureStringValueOfMethod(AppView<AppInfoWithLiveness> appView) {
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        SingleStringValue defaultValue = appView.abstractValueFactory().createSingleStringValue(dexItemFactory.createString("null"));
        return this.internalEnsureMethod(appView, dexItemFactory.createString("stringValueOf"), dexItemFactory.createProto(dexItemFactory.stringType, dexItemFactory.intType), method -> new EnumUnboxingCfCodeProvider.EnumUnboxingInstanceFieldCfCodeProvider(appView, this.getType(), this.data, dexItemFactory.enumMembers.nameField, defaultValue).generateCfCode());
    }

    public ProgramMethod ensureValueOfMethod(AppView<AppInfoWithLiveness> appView) {
        DexItemFactory dexItemFactory = appView.dexItemFactory();
        return this.internalEnsureMethod(appView, dexItemFactory.createString("valueOf"), dexItemFactory.createProto(dexItemFactory.intType, dexItemFactory.stringType), method -> new EnumUnboxingCfCodeProvider.EnumUnboxingValueOfCfCodeProvider(appView, this.getType(), this.getSynthesizingContext().getType(), this.data.getInstanceFieldData(dexItemFactory.enumMembers.nameField).asEnumFieldMappingData()).generateCfCode());
    }

    @Override
    public DexProgramClass getDefinition() {
        return this.localUtilityClass;
    }

    public DexType getType() {
        return this.localUtilityClass.getType();
    }

    public static class Builder {
        private final AppView<AppInfoWithLiveness> appView;
        private final EnumDataMap.EnumData data;
        private final DexProgramClass enumToUnbox;
        private final DexType localUtilityClassType;

        private Builder(AppView<AppInfoWithLiveness> appView, DexProgramClass enumToUnbox, EnumDataMap.EnumData data2) {
            this.appView = appView;
            this.data = data2;
            this.enumToUnbox = enumToUnbox;
            this.localUtilityClassType = EnumUnboxingUtilityClasses.Builder.getUtilityClassType(enumToUnbox, LocalEnumUnboxingUtilityClass.ENUM_UNBOXING_LOCAL_UTILITY_CLASS_SUFFIX, appView.dexItemFactory());
            assert (appView.appInfo().definitionForWithoutExistenceAssert(this.localUtilityClassType) == null);
        }

        private DexProgramClass createClass() {
            DexProgramClass clazz = this.appView.getSyntheticItems().createFixedClass(kinds -> kinds.ENUM_UNBOXING_LOCAL_UTILITY_CLASS, this.enumToUnbox, this.appView, builder -> {
                SyntheticProgramClassBuilder cfr_ignored_0 = (SyntheticProgramClassBuilder)builder.setUseSortedMethodBacking(true);
            });
            assert (clazz.getAccessFlags().equals(ClassAccessFlags.createPublicFinalSynthetic()));
            return clazz;
        }

        LocalEnumUnboxingUtilityClass build() {
            DexProgramClass clazz = this.createClass();
            return new LocalEnumUnboxingUtilityClass(clazz, this.data, this.enumToUnbox);
        }
    }
}

