/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.info;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.graph.proto.ArgumentInfoCollection;
import com.android.tools.r8.graph.proto.RewrittenPrototypeDescription;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.analysis.type.DynamicTypeWithUpperBound;
import com.android.tools.r8.ir.analysis.type.Nullability;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.UnknownValue;
import com.android.tools.r8.ir.optimize.info.CallSiteOptimizationInfo;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceArrayMap;
import com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteMonomorphicMethodState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ConcreteParameterState;
import com.android.tools.r8.optimize.argumentpropagation.codescanner.ParameterState;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.MapUtils;
import java.util.Objects;

public class ConcreteCallSiteOptimizationInfo
extends CallSiteOptimizationInfo {
    private final int size;
    private final Int2ReferenceMap<DynamicType> dynamicTypes;
    private final Int2ReferenceMap<AbstractValue> constants;

    private ConcreteCallSiteOptimizationInfo(int size) {
        this(size, new Int2ReferenceArrayMap<DynamicType>(size), new Int2ReferenceArrayMap<AbstractValue>(size));
    }

    private ConcreteCallSiteOptimizationInfo(int size, Int2ReferenceMap<DynamicType> dynamicTypes, Int2ReferenceMap<AbstractValue> constants) {
        assert (size > 0);
        assert (constants.values().stream().noneMatch(AbstractValue::isUnknown));
        assert (dynamicTypes.values().stream().noneMatch(DynamicType::isUnknown));
        this.size = size;
        this.dynamicTypes = Objects.requireNonNull(dynamicTypes);
        this.constants = Objects.requireNonNull(constants);
    }

    private static CallSiteOptimizationInfo create(int size, Int2ReferenceMap<DynamicType> dynamicTypes, Int2ReferenceMap<AbstractValue> constants) {
        return constants.isEmpty() && dynamicTypes.isEmpty() ? ConcreteCallSiteOptimizationInfo.top() : new ConcreteCallSiteOptimizationInfo(size, MapUtils.canonicalizeEmptyMap(dynamicTypes), MapUtils.canonicalizeEmptyMap(constants));
    }

    public static CallSiteOptimizationInfo fromMethodState(AppView<AppInfoWithLiveness> appView, ProgramMethod method, ConcreteMonomorphicMethodState methodState) {
        ConcreteCallSiteOptimizationInfo newCallSiteInfo = new ConcreteCallSiteOptimizationInfo(methodState.size());
        boolean isTop = true;
        for (int argumentIndex = 0; argumentIndex < methodState.size(); ++argumentIndex) {
            DynamicType dynamicType;
            DexType staticType;
            ParameterState parameterState = methodState.getParameterState(argumentIndex);
            if (parameterState.isUnknown()) continue;
            ConcreteParameterState concreteParameterState = parameterState.asConcrete();
            AbstractValue abstractValue = concreteParameterState.getAbstractValue(appView);
            if (abstractValue.isNonTrivial()) {
                newCallSiteInfo.constants.put(argumentIndex, abstractValue);
                isTop = false;
            }
            if (!(staticType = ((DexEncodedMethod)method.getDefinition()).getArgumentType(argumentIndex)).isReferenceType()) continue;
            DynamicTypeWithUpperBound staticTypeElement = staticType.toDynamicType(appView);
            if (staticType.isArrayType()) {
                Nullability nullability = concreteParameterState.asArrayParameter().getNullability();
                if (nullability.isDefinitelyNull()) {
                    newCallSiteInfo.constants.put(argumentIndex, (AbstractValue)appView.abstractValueFactory().createNullValue());
                    isTop = false;
                    continue;
                }
                if (nullability.isDefinitelyNotNull()) {
                    newCallSiteInfo.dynamicTypes.put(argumentIndex, (DynamicType)staticTypeElement.withNullability(Nullability.definitelyNotNull()));
                    isTop = false;
                    continue;
                }
                assert (false);
                continue;
            }
            if (!staticType.isClassType() || (dynamicType = concreteParameterState.asReferenceParameter().getDynamicType()).isUnknown()) continue;
            newCallSiteInfo.dynamicTypes.put(argumentIndex, dynamicType);
            isTop = false;
        }
        return isTop ? CallSiteOptimizationInfo.top() : newCallSiteInfo;
    }

    public CallSiteOptimizationInfo fixupAfterParametersChanged(RewrittenPrototypeDescription prototypeChanges) {
        if (prototypeChanges.isEmpty()) {
            return this;
        }
        ArgumentInfoCollection parameterChanges = prototypeChanges.getArgumentInfoCollection();
        if (parameterChanges.isEmpty()) {
            if (prototypeChanges.hasExtraParameters()) {
                return new ConcreteCallSiteOptimizationInfo(this.size + prototypeChanges.numberOfExtraParameters(), this.dynamicTypes, this.constants);
            }
            return this;
        }
        assert (parameterChanges.getRemovedParameterIndices().stream().allMatch(removedParameterIndex -> removedParameterIndex < this.size));
        int newSizeAfterParameterRemoval = this.size - parameterChanges.numberOfRemovedArguments();
        if (newSizeAfterParameterRemoval == 0) {
            return ConcreteCallSiteOptimizationInfo.top();
        }
        Int2ReferenceArrayMap<AbstractValue> rewrittenConstants = new Int2ReferenceArrayMap<AbstractValue>(newSizeAfterParameterRemoval);
        Int2ReferenceArrayMap<DynamicType> rewrittenDynamicTypes = new Int2ReferenceArrayMap<DynamicType>(newSizeAfterParameterRemoval);
        int rewrittenParameterIndex = 0;
        for (int parameterIndex = 0; parameterIndex < this.size; ++parameterIndex) {
            DynamicType dynamicType;
            if (parameterChanges.isArgumentRemoved(parameterIndex)) continue;
            AbstractValue abstractValue = this.constants.getOrDefault(parameterIndex, AbstractValue.unknown());
            if (!abstractValue.isUnknown()) {
                rewrittenConstants.put(rewrittenParameterIndex, abstractValue);
            }
            if ((dynamicType = (DynamicType)this.dynamicTypes.get(parameterIndex)) != null) {
                rewrittenDynamicTypes.put(rewrittenParameterIndex, dynamicType);
            }
            ++rewrittenParameterIndex;
        }
        return ConcreteCallSiteOptimizationInfo.create(newSizeAfterParameterRemoval + prototypeChanges.numberOfExtraParameters(), rewrittenDynamicTypes, rewrittenConstants);
    }

    @Override
    public DynamicType getDynamicType(int argIndex) {
        assert (0 <= argIndex && argIndex < this.size);
        return this.dynamicTypes.getOrDefault(argIndex, DynamicType.unknown());
    }

    @Override
    public AbstractValue getAbstractArgumentValue(int argIndex) {
        assert (0 <= argIndex && argIndex < this.size);
        return this.constants.getOrDefault(argIndex, UnknownValue.getInstance());
    }

    public Nullability getNullability(int argIndex) {
        return this.getDynamicType(argIndex).getNullability();
    }

    @Override
    public boolean isConcreteCallSiteOptimizationInfo() {
        return true;
    }

    @Override
    public ConcreteCallSiteOptimizationInfo asConcreteCallSiteOptimizationInfo() {
        return this;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ConcreteCallSiteOptimizationInfo)) {
            return false;
        }
        ConcreteCallSiteOptimizationInfo otherInfo = (ConcreteCallSiteOptimizationInfo)other;
        return this.dynamicTypes.equals(otherInfo.dynamicTypes) && this.constants.equals(otherInfo.constants);
    }

    public int hashCode() {
        return System.identityHashCode(this.dynamicTypes) * 7 + System.identityHashCode(this.constants);
    }

    public String toString() {
        return this.dynamicTypes.toString() + (this.constants == null ? "" : System.lineSeparator() + this.constants);
    }
}

