/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.info;

import com.android.tools.r8.com.google.common.collect.Sets;
import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.MethodResolutionResult;
import com.android.tools.r8.graph.ProgramMethod;
import com.android.tools.r8.ir.analysis.DeterminismAnalysis;
import com.android.tools.r8.ir.analysis.InitializedClassesOnNormalExitAnalysis;
import com.android.tools.r8.ir.analysis.inlining.SimpleInliningConstraintAnalysis;
import com.android.tools.r8.ir.analysis.sideeffect.ClassInitializerSideEffectAnalysis;
import com.android.tools.r8.ir.analysis.type.DynamicType;
import com.android.tools.r8.ir.analysis.type.DynamicTypeWithUpperBound;
import com.android.tools.r8.ir.analysis.value.AbstractValue;
import com.android.tools.r8.ir.analysis.value.StatefulObjectValue;
import com.android.tools.r8.ir.analysis.value.objectstate.ObjectState;
import com.android.tools.r8.ir.analysis.value.objectstate.ObjectStateAnalysis;
import com.android.tools.r8.ir.code.AliasedValueConfiguration;
import com.android.tools.r8.ir.code.Argument;
import com.android.tools.r8.ir.code.AssumeAndCheckCastAliasedValueConfiguration;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.DominatorTree;
import com.android.tools.r8.ir.code.FieldInstruction;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.If;
import com.android.tools.r8.ir.code.InstancePut;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InstructionIterator;
import com.android.tools.r8.ir.code.Invoke;
import com.android.tools.r8.ir.code.InvokeDirect;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import com.android.tools.r8.ir.code.InvokeStatic;
import com.android.tools.r8.ir.code.NewInstance;
import com.android.tools.r8.ir.code.Return;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.conversion.IRConverter;
import com.android.tools.r8.ir.conversion.MethodProcessor;
import com.android.tools.r8.ir.optimize.DynamicTypeOptimization;
import com.android.tools.r8.ir.optimize.classinliner.analysis.ClassInlinerMethodConstraintAnalysis;
import com.android.tools.r8.ir.optimize.classinliner.constraint.ClassInlinerMethodConstraint;
import com.android.tools.r8.ir.optimize.enums.classification.EnumUnboxerMethodClassification;
import com.android.tools.r8.ir.optimize.enums.classification.EnumUnboxerMethodClassificationAnalysis;
import com.android.tools.r8.ir.optimize.info.OptimizationFeedback;
import com.android.tools.r8.ir.optimize.info.bridge.BridgeAnalyzer;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldInitializationInfoCollection;
import com.android.tools.r8.ir.optimize.info.initializer.InstanceInitializerInfo;
import com.android.tools.r8.ir.optimize.info.initializer.InstanceInitializerInfoCollection;
import com.android.tools.r8.ir.optimize.info.initializer.NonTrivialInstanceInitializerInfo;
import com.android.tools.r8.ir.optimize.typechecks.CheckCastAndInstanceOfMethodSpecialization;
import com.android.tools.r8.kotlin.Kotlin;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.Timing;
import java.util.ArrayDeque;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;

public class MethodOptimizationInfoCollector {
    private final AppView<AppInfoWithLiveness> appView;
    private final CheckCastAndInstanceOfMethodSpecialization checkCastAndInstanceOfMethodSpecialization;
    private final DexItemFactory dexItemFactory;
    private final InternalOptions options;

    public MethodOptimizationInfoCollector(AppView<AppInfoWithLiveness> appView, IRConverter converter) {
        this.appView = appView;
        this.checkCastAndInstanceOfMethodSpecialization = appView.options().isRelease() ? new CheckCastAndInstanceOfMethodSpecialization(appView, converter) : null;
        this.dexItemFactory = appView.dexItemFactory();
        this.options = appView.options();
    }

    private void identifyBridgeInfo(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback, Timing timing) {
        timing.begin("Identify bridge info");
        feedback.setBridgeInfo(method, BridgeAnalyzer.analyzeMethod(method, code));
        timing.end();
    }

    private void analyzeReturns(IRCode code, OptimizationFeedback feedback, MethodProcessor methodProcessor, Timing timing) {
        timing.begin("Identify returns argument");
        this.analyzeReturns(code, feedback, methodProcessor);
        timing.end();
    }

    private void analyzeReturns(IRCode code, OptimizationFeedback feedback, MethodProcessor methodProcessor) {
        Value aliasedValue;
        ProgramMethod context = code.context();
        DexEncodedMethod method = (DexEncodedMethod)context.getDefinition();
        List<BasicBlock> normalExits = code.computeNormalExitBlocks();
        if (normalExits.isEmpty()) {
            feedback.methodNeverReturnsNormally(context);
            return;
        }
        Return firstExit = normalExits.get(0).exit().asReturn();
        if (firstExit.isReturnVoid()) {
            return;
        }
        Value returnValue = firstExit.returnValue();
        for (int i = 1; i < normalExits.size(); ++i) {
            Return exit = normalExits.get(i).exit().asReturn();
            Value value = exit.returnValue();
            if (value == returnValue) continue;
            returnValue = null;
        }
        if (returnValue != null && !(aliasedValue = returnValue.getAliasedValue()).isPhi()) {
            AbstractValue abstractReturnValue;
            Instruction definition = aliasedValue.definition;
            if (definition.isArgument()) {
                feedback.methodReturnsArgument(method, definition.asArgument().getIndex());
            }
            if ((abstractReturnValue = definition.getAbstractValue(this.appView, context)).isNonTrivial()) {
                feedback.methodReturnsAbstractValue(method, this.appView, abstractReturnValue);
                if (this.checkCastAndInstanceOfMethodSpecialization != null) {
                    this.checkCastAndInstanceOfMethodSpecialization.addCandidateForOptimization(context, abstractReturnValue, methodProcessor);
                }
            } else if (returnValue.getType().isReferenceType()) {
                ObjectState objectState = ObjectStateAnalysis.computeObjectState(aliasedValue, this.appView, context);
                feedback.methodReturnsAbstractValue(method, this.appView, StatefulObjectValue.create(objectState));
            }
        }
    }

    private void computeInstanceInitializerInfo(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback, InstanceFieldInitializationInfoCollection instanceFieldInitializationInfos, Timing timing) {
        timing.begin("Compute instance initializer info");
        this.computeInstanceInitializerInfo(method, code, feedback, instanceFieldInitializationInfos);
        timing.end();
    }

    private void computeInstanceInitializerInfo(DexEncodedMethod method, IRCode code, OptimizationFeedback feedback, InstanceFieldInitializationInfoCollection instanceFieldInitializationInfos) {
        assert (!this.appView.appInfo().isPinned(method.getReference()));
        if (!method.isInstanceInitializer()) {
            return;
        }
        assert (instanceFieldInitializationInfos != null);
        if (method.accessFlags.isNative()) {
            return;
        }
        if (this.appView.appInfo().mayHaveSideEffects.containsKey(method.getReference())) {
            return;
        }
        NonTrivialInstanceInitializerInfo.Builder builder = NonTrivialInstanceInitializerInfo.builder(instanceFieldInitializationInfos);
        InstanceInitializerInfo instanceInitializerInfo = this.analyzeInstanceInitializer(code, builder);
        feedback.setInstanceInitializerInfoCollection(method, InstanceInitializerInfoCollection.of(instanceInitializerInfo));
    }

    private InstanceInitializerInfo analyzeInstanceInitializer(IRCode code, NonTrivialInstanceInitializerInfo.Builder builder) {
        ProgramMethod context = code.context();
        if (context.getHolder().definesFinalizer(this.options.itemFactory)) {
            return null;
        }
        AssumeAndCheckCastAliasedValueConfiguration aliasesThroughAssumeAndCheckCasts = AssumeAndCheckCastAliasedValueConfiguration.getInstance();
        Value receiver = code.getThis();
        boolean hasCatchHandler = false;
        for (BasicBlock block : code.blocks) {
            if (block.hasCatchHandlers()) {
                hasCatchHandler = true;
            }
            block13: for (Instruction instruction : block.getInstructions()) {
                block0 : switch (instruction.opcode()) {
                    case 5: 
                    case 9: 
                    case 15: 
                    case 24: 
                    case 56: {
                        break;
                    }
                    case 25: 
                    case 31: 
                    case 62: {
                        builder.setInstanceFieldInitializationMayDependOnEnvironment();
                        break;
                    }
                    case 0: 
                    case 4: 
                    case 7: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 16: 
                    case 20: 
                    case 21: 
                    case 27: 
                    case 29: 
                    case 45: 
                    case 47: 
                    case 53: 
                    case 55: 
                    case 57: 
                    case 58: 
                    case 63: 
                    case 65: 
                    case 67: 
                    case 68: {
                        if (!instruction.instructionMayHaveSideEffects(this.appView, context)) continue block13;
                        builder.setMayHaveOtherSideEffectsThanInstanceFieldAssignments();
                        break;
                    }
                    case 28: 
                    case 59: {
                        FieldInstruction fieldGet = instruction.asFieldInstruction();
                        DexEncodedField field = this.appView.appInfo().resolveField(fieldGet.getField()).getResolvedField();
                        if (field == null) {
                            return null;
                        }
                        builder.markFieldAsRead(field);
                        if (!fieldGet.instructionMayHaveSideEffects(this.appView, context)) continue block13;
                        builder.setMayHaveOtherSideEffectsThanInstanceFieldAssignments();
                        if (!fieldGet.isStaticGet()) continue block13;
                        builder.markAllFieldsAsRead();
                        break;
                    }
                    case 30: {
                        Value value;
                        InstancePut instancePut = instruction.asInstancePut();
                        DexEncodedField field = this.appView.appInfo().resolveField(instancePut.getField()).getResolvedField();
                        if (field == null) {
                            return null;
                        }
                        Value object = instancePut.object().getAliasedValue(aliasesThroughAssumeAndCheckCasts);
                        if (object != receiver || instancePut.instructionInstanceCanThrow(this.appView, context)) {
                            builder.setMayHaveOtherSideEffectsThanInstanceFieldAssignments();
                        }
                        if (!(value = instancePut.value().getAliasedValue(aliasesThroughAssumeAndCheckCasts)).onlyDependsOnArgument()) {
                            builder.setInstanceFieldInitializationMayDependOnEnvironment();
                        }
                        if (!MethodOptimizationInfoCollector.couldBeReceiverValue(value, receiver, aliasesThroughAssumeAndCheckCasts)) continue block13;
                        builder.setReceiverMayEscapeOutsideConstructorChain();
                        break;
                    }
                    case 33: {
                        Invoke invoke = instruction.asInvokeDirect();
                        DexMethod invokedMethod = ((InvokeMethod)invoke).getInvokedMethod();
                        DexClass holder = this.appView.definitionForHolder(invokedMethod);
                        DexEncodedMethod singleTarget = invokedMethod.lookupOnClass(holder);
                        if (singleTarget == null) {
                            return null;
                        }
                        if (singleTarget.isInstanceInitializer() && ((InvokeMethodWithReceiver)invoke).getReceiver().getAliasedValue() == receiver) {
                            if (builder.hasParent() && builder.getParent() != singleTarget.getReference()) {
                                return null;
                            }
                            if (invokedMethod == this.dexItemFactory.enumMembers.constructor || invokedMethod == this.dexItemFactory.objectMembers.constructor) {
                                builder.setParent(invokedMethod);
                                break;
                            }
                            builder.merge(singleTarget.getOptimizationInfo().getInstanceInitializerInfo((InvokeDirect)invoke));
                            for (int i = 1; i < invoke.arguments().size(); ++i) {
                                Value argument = invoke.arguments().get(i).getAliasedValue(aliasesThroughAssumeAndCheckCasts);
                                if (MethodOptimizationInfoCollector.couldBeReceiverValue(argument, receiver, aliasesThroughAssumeAndCheckCasts)) {
                                    builder.setReceiverMayEscapeOutsideConstructorChain();
                                }
                                if (argument.onlyDependsOnArgument()) continue;
                                builder.setInstanceFieldInitializationMayDependOnEnvironment();
                            }
                            builder.setParent(invokedMethod);
                            break;
                        }
                        builder.markAllFieldsAsRead().setMayHaveOtherSideEffectsThanInstanceFieldAssignments();
                        for (Value inValue : invoke.inValues()) {
                            if (!MethodOptimizationInfoCollector.couldBeReceiverValue(inValue, receiver, aliasesThroughAssumeAndCheckCasts)) continue;
                            builder.setReceiverMayEscapeOutsideConstructorChain();
                            break block0;
                        }
                        continue block13;
                    }
                    case 36: {
                        Invoke invoke = instruction.asInvokeNewArray();
                        if (invoke.instructionMayHaveSideEffects(this.appView, context)) {
                            builder.setMayHaveOtherSideEffectsThanInstanceFieldAssignments();
                        }
                        for (Value argument : invoke.arguments()) {
                            if (!MethodOptimizationInfoCollector.couldBeReceiverValue(argument, receiver, aliasesThroughAssumeAndCheckCasts)) continue;
                            builder.setReceiverMayEscapeOutsideConstructorChain();
                            break block0;
                        }
                        continue block13;
                    }
                    case 34: 
                    case 38: 
                    case 40: {
                        Invoke invoke = instruction.asInvokeMethod();
                        builder.markAllFieldsAsRead().setMayHaveOtherSideEffectsThanInstanceFieldAssignments();
                        for (Value argument : invoke.arguments()) {
                            if (!MethodOptimizationInfoCollector.couldBeReceiverValue(argument, receiver, aliasesThroughAssumeAndCheckCasts)) continue;
                            builder.setReceiverMayEscapeOutsideConstructorChain();
                            break block0;
                        }
                        continue block13;
                    }
                    case 49: {
                        NewInstance newInstance = instruction.asNewInstance();
                        if (!newInstance.instructionMayHaveSideEffects(this.appView, context)) continue block13;
                        builder.markAllFieldsAsRead().setMayHaveOtherSideEffectsThanInstanceFieldAssignments();
                        break;
                    }
                    case 6: {
                        builder.setMayHaveOtherSideEffectsThanInstanceFieldAssignments();
                        break;
                    }
                    default: {
                        builder.markAllFieldsAsRead().setInstanceFieldInitializationMayDependOnEnvironment().setMayHaveOtherSideEffectsThanInstanceFieldAssignments().setReceiverMayEscapeOutsideConstructorChain();
                    }
                }
            }
        }
        if (hasCatchHandler && builder.mayHaveOtherSideEffectsThanInstanceFieldAssignments()) {
            builder.setInstanceFieldInitializationMayDependOnEnvironment();
        }
        return builder.build();
    }

    private static boolean couldBeReceiverValue(Value value, Value receiver, AliasedValueConfiguration aliasing) {
        if (value.isPhi() && receiver.hasPhiUsers()) {
            return true;
        }
        return value.getAliasedValue(aliasing) == receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean alwaysTriggerExpectedEffectBeforeAnythingElse(IRCode code, BiFunction<Instruction, InstructionIterator, InstructionEffect> function) {
        int color = code.reserveMarkingColor();
        try {
            ArrayDeque<BasicBlock> worklist = new ArrayDeque<BasicBlock>();
            BasicBlock entry = code.entryBlock();
            worklist.add(entry);
            entry.mark(color);
            while (!worklist.isEmpty()) {
                Instruction lastInstruction;
                BasicBlock currentBlock = (BasicBlock)worklist.poll();
                assert (currentBlock.isMarked(color));
                InstructionEffect result = InstructionEffect.NO_EFFECT;
                InstructionIterator it = currentBlock.iterator();
                while (result == InstructionEffect.NO_EFFECT && it.hasNext()) {
                    result = function.apply((Instruction)it.next(), it);
                }
                if (result == InstructionEffect.OTHER_EFFECT) {
                    boolean bl = false;
                    return bl;
                }
                if (result == InstructionEffect.DESIRED_EFFECT) continue;
                if (result == InstructionEffect.CONDITIONAL_EFFECT) {
                    assert (!currentBlock.getNormalSuccessors().isEmpty());
                    lastInstruction = currentBlock.getInstructions().getLast();
                    assert (lastInstruction.isIf());
                    BasicBlock targetIfReceiverIsNull = lastInstruction.asIf().targetFromCondition(0);
                    if (targetIfReceiverIsNull.isMarked(color)) continue;
                    worklist.add(targetIfReceiverIsNull);
                    targetIfReceiverIsNull.mark(color);
                    continue;
                }
                assert (result == InstructionEffect.NO_EFFECT);
                if (currentBlock.getNormalSuccessors().isEmpty()) {
                    lastInstruction = currentBlock.getInstructions().getLast();
                    assert (lastInstruction.isReturn() || lastInstruction.isThrow());
                    boolean targetIfReceiverIsNull = false;
                    return targetIfReceiverIsNull;
                }
                for (BasicBlock successor : currentBlock.getSuccessors()) {
                    if (successor.isMarked(color)) continue;
                    worklist.add(successor);
                    successor.mark(color);
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            code.returnMarkingColor(color);
        }
    }

    private boolean checksNullBeforeSideEffect(IRCode code, Value value) {
        return MethodOptimizationInfoCollector.alwaysTriggerExpectedEffectBeforeAnythingElse(code, (instr, it) -> {
            BasicBlock currentBlock = instr.getBlock();
            if (!currentBlock.hasCatchHandlers() && MethodOptimizationInfoCollector.isNullCheck(instr, value)) {
                return InstructionEffect.CONDITIONAL_EFFECT;
            }
            if (instr.isInvokeStatic()) {
                InvokeStatic invoke = instr.asInvokeStatic();
                if (MethodOptimizationInfoCollector.isKotlinCheckParameterIsNotNull(this.appView, invoke, value)) {
                    return InstructionEffect.DESIRED_EFFECT;
                }
                if (MethodOptimizationInfoCollector.isKotlinThrowParameterIsNullException(this.appView, invoke)) {
                    for (BasicBlock predecessor : currentBlock.getPredecessors()) {
                        if (!MethodOptimizationInfoCollector.isNullCheck(predecessor.exit(), value)) continue;
                        return InstructionEffect.DESIRED_EFFECT;
                    }
                    return InstructionEffect.NO_EFFECT;
                }
            }
            if (MethodOptimizationInfoCollector.isInstantiationOfNullPointerException(instr, it, this.appView.dexItemFactory())) {
                it.next();
                return InstructionEffect.NO_EFFECT;
            }
            if (instr.throwsNpeIfValueIsNull(value, this.appView, code.context())) {
                if (!currentBlock.hasCatchHandlers()) {
                    return InstructionEffect.DESIRED_EFFECT;
                }
            } else if (instr.instructionMayHaveSideEffects(this.appView, code.context())) {
                if (instr.isConstString() && !instr.instructionInstanceCanThrow()) {
                    return InstructionEffect.NO_EFFECT;
                }
                return InstructionEffect.OTHER_EFFECT;
            }
            return InstructionEffect.NO_EFFECT;
        });
    }

    private static boolean isKotlinCheckParameterIsNotNull(AppView<?> appView, InvokeStatic invoke, Value value) {
        if (appView.options().kotlinOptimizationOptions().disableKotlinSpecificOptimizations) {
            return false;
        }
        Kotlin.Intrinsics intrinsics = appView.dexItemFactory().kotlin.intrinsics;
        DexMethod originalInvokedMethod = appView.graphLens().getOriginalMethodSignature(invoke.getInvokedMethod());
        boolean isCheckNotNullMethod = originalInvokedMethod.match(intrinsics.checkParameterIsNotNull) || originalInvokedMethod.match(intrinsics.checkNotNullParameter);
        return isCheckNotNullMethod && invoke.getFirstArgument() == value && originalInvokedMethod.getHolderType().getPackageDescriptor().startsWith("kotlin");
    }

    private static boolean isKotlinThrowParameterIsNullException(AppView<?> appView, InvokeStatic invoke) {
        if (appView.options().kotlinOptimizationOptions().disableKotlinSpecificOptimizations) {
            return false;
        }
        Kotlin.Intrinsics intrinsics = appView.dexItemFactory().kotlin.intrinsics;
        DexMethod originalInvokedMethod = appView.graphLens().getOriginalMethodSignature(invoke.getInvokedMethod());
        return (originalInvokedMethod.match(intrinsics.throwParameterIsNullException) || originalInvokedMethod.match(intrinsics.throwParameterIsNullNPE)) && originalInvokedMethod.getHolderType().getPackageDescriptor().startsWith("kotlin");
    }

    private static boolean isNullCheck(Instruction instr, Value value) {
        return instr.isIf() && instr.asIf().isZeroTest() && instr.inValues().get(0).equals(value) && (instr.asIf().getType() == If.Type.EQ || instr.asIf().getType() == If.Type.NE);
    }

    private static boolean isInstantiationOfNullPointerException(Instruction instruction, InstructionIterator it, DexItemFactory dexItemFactory) {
        if (!instruction.isNewInstance() || instruction.asNewInstance().clazz != dexItemFactory.npeType) {
            return false;
        }
        Instruction next = it.peekNext();
        return next != null && next.isInvokeDirect() && next.asInvokeDirect().getInvokedMethod() == dexItemFactory.npeMethods.init;
    }

    private void computeClassInlinerMethodConstraint(ProgramMethod method, IRCode code, OptimizationFeedback feedback, Timing timing) {
        timing.begin("Compute class inlining constraint");
        ClassInlinerMethodConstraint classInlinerMethodConstraint = ClassInlinerMethodConstraintAnalysis.analyze(this.appView, method, code, timing);
        feedback.setClassInlinerMethodConstraint(method, classInlinerMethodConstraint);
        timing.end();
    }

    private void computeEnumUnboxerMethodClassification(ProgramMethod method, IRCode code, OptimizationFeedback feedback, MethodProcessor methodProcessor, Timing timing) {
        timing.begin("Compute enum unboxer method classification");
        this.computeEnumUnboxerMethodClassification(method, code, feedback, methodProcessor);
        timing.end();
    }

    private void computeEnumUnboxerMethodClassification(ProgramMethod method, IRCode code, OptimizationFeedback feedback, MethodProcessor methodProcessor) {
        if (this.appView.hasUnboxedEnums()) {
            if (this.appView.unboxedEnums().isEmpty()) {
                feedback.unsetEnumUnboxerMethodClassification(method);
            } else assert (this.verifyEnumUnboxerMethodClassificationCorrect(method, code, methodProcessor));
        } else {
            EnumUnboxerMethodClassification enumUnboxerMethodClassification = EnumUnboxerMethodClassificationAnalysis.analyze(this.appView, method, code, methodProcessor);
            feedback.setEnumUnboxerMethodClassification(method, enumUnboxerMethodClassification);
        }
    }

    private boolean verifyEnumUnboxerMethodClassificationCorrect(ProgramMethod method, IRCode code, MethodProcessor methodProcessor) {
        EnumUnboxerMethodClassification existingClassification = method.getOptimizationInfo().getEnumUnboxerMethodClassification();
        if (existingClassification.isCheckNotNullClassification()) {
            EnumUnboxerMethodClassification computedClassification = EnumUnboxerMethodClassificationAnalysis.analyze(this.appView, method, code, methodProcessor);
            assert (computedClassification.isCheckNotNullClassification());
            assert (computedClassification.asCheckNotNullClassification().getArgumentIndex() == existingClassification.asCheckNotNullClassification().getArgumentIndex());
        } else assert (existingClassification.isUnknownClassification());
        return true;
    }

    private void computeSimpleInliningConstraint(ProgramMethod method, IRCode code, OptimizationFeedback feedback, Timing timing) {
        if (this.appView.options().enableSimpleInliningConstraints) {
            timing.begin("Compute simple inlining constraint");
            this.computeSimpleInliningConstraint(method, code, feedback);
            timing.end();
        }
    }

    private void computeSimpleInliningConstraint(ProgramMethod method, IRCode code, OptimizationFeedback feedback) {
        feedback.setSimpleInliningConstraint(method, new SimpleInliningConstraintAnalysis(this.appView, method).analyzeCode(code));
    }

    private void computeDynamicReturnType(DynamicTypeOptimization dynamicTypeOptimization, OptimizationFeedback feedback, ProgramMethod method, IRCode code, Timing timing) {
        timing.begin("Compute dynamic return type");
        this.computeDynamicReturnType(dynamicTypeOptimization, feedback, method, code);
        timing.end();
    }

    private void computeDynamicReturnType(DynamicTypeOptimization dynamicTypeOptimization, OptimizationFeedback feedback, ProgramMethod method, IRCode code) {
        if (dynamicTypeOptimization == null) {
            return;
        }
        if (!method.getReturnType().isReferenceType()) {
            return;
        }
        DynamicType dynamicReturnType = dynamicTypeOptimization.computeDynamicReturnType(method, code);
        if (dynamicReturnType.isBottom() || dynamicReturnType.isUnknown()) {
            return;
        }
        if (dynamicReturnType.isNullType()) {
            feedback.methodReturnsAbstractValue((DexEncodedMethod)method.getDefinition(), this.appView, this.appView.abstractValueFactory().createNullValue());
            feedback.setDynamicReturnType(method, this.appView, dynamicReturnType);
            return;
        }
        if (dynamicReturnType.isNotNullType()) {
            feedback.setDynamicReturnType(method, this.appView, dynamicReturnType);
            return;
        }
        DynamicTypeWithUpperBound staticReturnType = method.getReturnType().toDynamicType(this.appView);
        if (dynamicReturnType.asDynamicTypeWithUpperBound().strictlyLessThan(staticReturnType, this.appView)) {
            feedback.setDynamicReturnType(method, this.appView, dynamicReturnType);
        }
    }

    private void computeInitializedClassesOnNormalExit(OptimizationFeedback feedback, DexEncodedMethod method, IRCode code, Timing timing) {
        timing.begin("Compute initialized classes on normal exits");
        this.computeInitializedClassesOnNormalExit(feedback, method, code);
        timing.end();
    }

    private void computeInitializedClassesOnNormalExit(OptimizationFeedback feedback, DexEncodedMethod method, IRCode code) {
        AppView<AppInfoWithLiveness> appViewWithLiveness;
        Set<DexType> initializedClasses;
        if (this.options.enableInitializedClassesAnalysis && this.appView.appInfo().hasLiveness() && (initializedClasses = InitializedClassesOnNormalExitAnalysis.computeInitializedClassesOnNormalExit(appViewWithLiveness = this.appView.withLiveness(), code)) != null && !initializedClasses.isEmpty()) {
            feedback.methodInitializesClassesOnNormalExit(method, initializedClasses);
        }
    }

    private void computeMayHaveSideEffects(OptimizationFeedback feedback, DexEncodedMethod method, IRCode code, Timing timing) {
        timing.begin("Compute may have side effects");
        this.computeMayHaveSideEffects(feedback, method, code);
        timing.end();
    }

    private void computeMayHaveSideEffects(OptimizationFeedback feedback, DexEncodedMethod method, IRCode code) {
        boolean mayHaveSideEffects;
        assert (!method.accessFlags.isNative());
        if (!this.options.enableSideEffectAnalysis) {
            return;
        }
        if (this.appView.appInfo().mayHaveSideEffects.containsKey(method.getReference())) {
            return;
        }
        ProgramMethod context = code.context();
        if (method.isClassInitializer()) {
            ClassInitializerSideEffectAnalysis.ClassInitializerSideEffect classInitializerSideEffect = ClassInitializerSideEffectAnalysis.classInitializerCanBePostponed(this.appView, code);
            if (classInitializerSideEffect.isNone()) {
                feedback.methodMayNotHaveSideEffects(method);
                feedback.classInitializerMayBePostponed(method);
            } else if (classInitializerSideEffect.canBePostponed()) {
                feedback.classInitializerMayBePostponed(method);
            } else assert (this.options.debug || this.appView.getSyntheticItems().verifySyntheticLambdaProperty(context.getHolder(), lambdaClass -> this.appView.appInfo().hasPinnedInstanceInitializer(lambdaClass.getType()), nonLambdaClass -> true)) : "Unexpected observable side effects from lambda `" + context.toSourceString() + "`";
            return;
        }
        if (method.isSynchronized()) {
            mayHaveSideEffects = true;
        } else if (method.isInstanceInitializer() && this.hasNonTrivialFinalizeMethod(context.getHolder())) {
            mayHaveSideEffects = true;
        } else {
            mayHaveSideEffects = false;
            for (Instruction instruction : code.instructions()) {
                if (instruction.isInvokeConstructor(this.appView.dexItemFactory()) && instruction.asInvokeDirect().getReceiver().getAliasedValue().isDefinedByInstructionSatisfying(Instruction::isNewInstance)) {
                    if (!instruction.instructionMayHaveSideEffects(this.appView, context, Instruction.SideEffectAssumption.IGNORE_RECEIVER_FIELD_ASSIGNMENTS)) continue;
                    mayHaveSideEffects = true;
                    break;
                }
                if (!instruction.instructionMayHaveSideEffects(this.appView, context)) continue;
                mayHaveSideEffects = true;
                break;
            }
        }
        if (!mayHaveSideEffects) {
            feedback.methodMayNotHaveSideEffects(method);
        }
    }

    private boolean hasNonTrivialFinalizeMethod(DexProgramClass clazz) {
        if (clazz.isInterface()) {
            return false;
        }
        DexItemFactory dexItemFactory = this.appView.dexItemFactory();
        MethodResolutionResult resolutionResult = this.appView.appInfo().resolveMethodOnClass(this.appView.dexItemFactory().objectMembers.finalize, (DexClass)clazz);
        DexEncodedMethod target = resolutionResult.getSingleTarget();
        return target != null && target.getReference() != dexItemFactory.enumMembers.finalize && target.getReference() != dexItemFactory.objectMembers.finalize;
    }

    private void computeReturnValueOnlyDependsOnArguments(OptimizationFeedback feedback, DexEncodedMethod method, IRCode code, Timing timing) {
        timing.begin("Return value only depends on argument");
        this.computeReturnValueOnlyDependsOnArguments(feedback, method, code);
        timing.end();
    }

    private void computeReturnValueOnlyDependsOnArguments(OptimizationFeedback feedback, DexEncodedMethod method, IRCode code) {
        if (!this.options.enableDeterminismAnalysis) {
            return;
        }
        boolean returnValueOnlyDependsOnArguments = DeterminismAnalysis.returnValueOnlyDependsOnArguments(this.appView.withLiveness(), code);
        if (returnValueOnlyDependsOnArguments) {
            feedback.methodReturnValueOnlyDependsOnArguments(method);
        }
    }

    private BitSet computeNonNullParamOrThrow(OptimizationFeedback feedback, DexEncodedMethod method, IRCode code, Timing timing) {
        timing.begin("Compute non-null-param-or-throw");
        BitSet nonNullParamOrThrow = this.computeNonNullParamOrThrow(feedback, method, code);
        timing.end();
        return nonNullParamOrThrow;
    }

    private BitSet computeNonNullParamOrThrow(OptimizationFeedback feedback, DexEncodedMethod method, IRCode code) {
        if (method.getOptimizationInfo().getNonNullParamOrThrow() != null) {
            return null;
        }
        List<Value> arguments = code.collectArguments();
        BitSet paramsCheckedForNull = new BitSet();
        for (int index = 0; index < arguments.size(); ++index) {
            Value argument = arguments.get(index);
            if (!argument.isUsed() || !this.checksNullBeforeSideEffect(code, argument)) continue;
            paramsCheckedForNull.set(index);
        }
        if (!paramsCheckedForNull.isEmpty()) {
            feedback.setNonNullParamOrThrow(method, paramsCheckedForNull);
            return paramsCheckedForNull;
        }
        return null;
    }

    private void computeNonNullParamOnNormalExits(OptimizationFeedback feedback, IRCode code, BitSet nonNullParamOrThrow, Timing timing) {
        timing.begin("Compute non-null-param-on-normal-exits");
        this.computeNonNullParamOnNormalExits(feedback, code, nonNullParamOrThrow);
        timing.end();
    }

    private void computeNonNullParamOnNormalExits(OptimizationFeedback feedback, IRCode code, BitSet nonNullParamOrThrow) {
        Set<BasicBlock> normalExits = Sets.newIdentityHashSet();
        normalExits.addAll(code.computeNormalExitBlocks());
        DominatorTree dominatorTree = new DominatorTree(code, DominatorTree.Assumption.MAY_HAVE_UNREACHABLE_BLOCKS);
        List<Value> arguments = code.collectArguments();
        BitSet facts = new BitSet();
        if (nonNullParamOrThrow != null) {
            facts.or(nonNullParamOrThrow);
        }
        for (int index = 0; index < arguments.size(); ++index) {
            Value argument;
            if (facts.get(index) || !(argument = arguments.get(index)).getType().isReferenceType() || !this.isNonNullOnNormalExit(code, argument, dominatorTree, normalExits)) continue;
            facts.set(index);
        }
        if (!facts.isEmpty()) {
            feedback.setNonNullParamOnNormalExits(code.method(), facts);
        }
    }

    private boolean isNonNullOnNormalExit(IRCode code, Value value, DominatorTree dominatorTree, Set<BasicBlock> normalExits) {
        assert (value.getType().isReferenceType());
        if (value.isThis()) {
            return true;
        }
        Set<BasicBlock> nullCheckedBlocks = Sets.newIdentityHashSet();
        for (Instruction user : value.aliasedUsers()) {
            if (user.isAssumeWithNonNullAssumption()) {
                assert (!user.getBlock().hasCatchHandlers() || user.getBlock().getInstructions().stream().filter(instruction -> instruction == user || instruction.instructionTypeCanThrow()).findFirst().get() == user);
                nullCheckedBlocks.add(user.getBlock());
                continue;
            }
            if (user.throwsNpeIfValueIsNull(value, this.appView, code.context())) {
                if (user.getBlock().hasCatchHandlers()) {
                    nullCheckedBlocks.addAll(user.getBlock().getNormalSuccessors());
                    continue;
                }
                nullCheckedBlocks.add(user.getBlock());
                continue;
            }
            if (!user.isIf() || !user.asIf().isZeroTest() || user.asIf().getType() != If.Type.EQ && user.asIf().getType() != If.Type.NE) continue;
            nullCheckedBlocks.add(user.asIf().targetFromNonNullObject());
        }
        if (nullCheckedBlocks.isEmpty()) {
            return false;
        }
        for (BasicBlock normalExit : normalExits) {
            if (this.isNormalExitDominated(normalExit, code, dominatorTree, nullCheckedBlocks)) continue;
            return false;
        }
        return true;
    }

    private boolean isNormalExitDominated(BasicBlock normalExit, IRCode code, DominatorTree dominatorTree, Set<BasicBlock> nullCheckedBlocks) {
        for (BasicBlock nullCheckedBlock : nullCheckedBlocks) {
            if (!dominatorTree.dominatedBy(normalExit, nullCheckedBlock)) continue;
            return true;
        }
        Set<BasicBlock> visited = Sets.newIdentityHashSet();
        ArrayDeque<BasicBlock> uncoveredPaths = new ArrayDeque<BasicBlock>(normalExit.getPredecessors());
        while (!uncoveredPaths.isEmpty()) {
            BasicBlock uncoveredPath = (BasicBlock)uncoveredPaths.poll();
            if (uncoveredPath == code.entryBlock()) {
                return false;
            }
            if (!visited.add(uncoveredPath)) {
                if (!uncoveredPaths.isEmpty()) continue;
                return false;
            }
            boolean pathCovered = false;
            for (BasicBlock nullCheckedBlock : nullCheckedBlocks) {
                if (!dominatorTree.dominatedBy(uncoveredPath, nullCheckedBlock)) continue;
                pathCovered = true;
                break;
            }
            if (pathCovered) continue;
            uncoveredPaths.addAll(uncoveredPath.getPredecessors());
        }
        assert (uncoveredPaths.isEmpty());
        return true;
    }

    private void computeUnusedArguments(ProgramMethod method, IRCode code, OptimizationFeedback feedback, Timing timing) {
        timing.begin("Compute unused arguments");
        this.computeUnusedArguments(method, code, feedback);
        timing.end();
    }

    private void computeUnusedArguments(ProgramMethod method, IRCode code, OptimizationFeedback feedback) {
        BitSet unusedArguments = new BitSet(((DexEncodedMethod)method.getDefinition()).getNumberOfArguments());
        InstructionIterator instructionIterator = code.entryBlock().iterator();
        Argument argument = ((Instruction)instructionIterator.next()).asArgument();
        while (argument != null) {
            if (!argument.outValue().hasAnyUsers()) {
                unusedArguments.set(argument.getIndex());
            }
            argument = ((Instruction)instructionIterator.next()).asArgument();
        }
        feedback.setUnusedArguments(method, unusedArguments);
    }

    public void collectMethodOptimizationInfo(ProgramMethod method, IRCode code, OptimizationFeedback feedback, DynamicTypeOptimization dynamicTypeOptimization, InstanceFieldInitializationInfoCollection instanceFieldInitializationInfos, MethodProcessor methodProcessor, Timing timing) {
        DexEncodedMethod definition = (DexEncodedMethod)method.getDefinition();
        this.identifyBridgeInfo(definition, code, feedback, timing);
        this.analyzeReturns(code, feedback, methodProcessor, timing);
        if (this.options.enableClassInlining) {
            this.computeClassInlinerMethodConstraint(method, code, feedback, timing);
        }
        this.computeEnumUnboxerMethodClassification(method, code, feedback, methodProcessor, timing);
        this.computeSimpleInliningConstraint(method, code, feedback, timing);
        this.computeDynamicReturnType(dynamicTypeOptimization, feedback, method, code, timing);
        if (this.options.enableInitializedClassesAnalysis) {
            this.computeInitializedClassesOnNormalExit(feedback, definition, code, timing);
        }
        this.computeInstanceInitializerInfo(definition, code, feedback, instanceFieldInitializationInfos, timing);
        this.computeMayHaveSideEffects(feedback, definition, code, timing);
        this.computeReturnValueOnlyDependsOnArguments(feedback, definition, code, timing);
        BitSet nonNullParamOrThrow = this.computeNonNullParamOrThrow(feedback, definition, code, timing);
        this.computeNonNullParamOnNormalExits(feedback, code, nonNullParamOrThrow, timing);
        this.computeUnusedArguments(method, code, feedback, timing);
    }

    private static enum InstructionEffect {
        DESIRED_EFFECT,
        CONDITIONAL_EFFECT,
        OTHER_EFFECT,
        NO_EFFECT;

    }
}

