/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.info.bridge;

import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.ir.code.CheckCast;
import com.android.tools.r8.ir.code.IRCode;
import com.android.tools.r8.ir.code.Instruction;
import com.android.tools.r8.ir.code.InvokeMethod;
import com.android.tools.r8.ir.code.InvokeVirtual;
import com.android.tools.r8.ir.code.Return;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.optimize.info.bridge.BridgeInfo;
import com.android.tools.r8.ir.optimize.info.bridge.VirtualBridgeInfo;
import com.android.tools.r8.utils.BooleanUtils;

public class BridgeAnalyzer {
    public static BridgeInfo analyzeMethod(DexEncodedMethod method, IRCode code) {
        if (!method.isBridge() || code.blocks.size() > 1) {
            return BridgeAnalyzer.failure();
        }
        InvokeMethod uniqueInvoke = null;
        CheckCast uniqueReturnCast = null;
        block7: for (Instruction instruction : code.entryBlock().getInstructions()) {
            switch (instruction.opcode()) {
                case 5: {
                    continue block7;
                }
                case 9: {
                    continue block7;
                }
                case 10: {
                    CheckCast checkCast = instruction.asCheckCast();
                    if (!BridgeAnalyzer.analyzeCheckCast(method, checkCast, uniqueInvoke)) {
                        return BridgeAnalyzer.failure();
                    }
                    if (uniqueInvoke == null) continue block7;
                    if (uniqueReturnCast != null) {
                        return BridgeAnalyzer.failure();
                    }
                    uniqueReturnCast = checkCast;
                    continue block7;
                }
                case 40: {
                    if (uniqueInvoke != null) {
                        return BridgeAnalyzer.failure();
                    }
                    InvokeVirtual invoke = instruction.asInvokeVirtual();
                    if (!BridgeAnalyzer.analyzeInvokeVirtual(invoke)) {
                        return BridgeAnalyzer.failure();
                    }
                    uniqueInvoke = invoke;
                    continue block7;
                }
                case 56: {
                    if (BridgeAnalyzer.analyzeReturn(instruction.asReturn(), uniqueInvoke, uniqueReturnCast)) continue block7;
                    return BridgeAnalyzer.failure();
                }
            }
            return BridgeAnalyzer.failure();
        }
        assert (uniqueInvoke != null);
        return new VirtualBridgeInfo(uniqueInvoke.getInvokedMethod());
    }

    private static boolean analyzeCheckCast(DexEncodedMethod method, CheckCast checkCast, InvokeMethod invoke) {
        return invoke == null ? BridgeAnalyzer.analyzeCheckCastBeforeInvoke(checkCast) : BridgeAnalyzer.analyzeCheckCastAfterInvoke(method, checkCast, invoke);
    }

    private static boolean analyzeCheckCastBeforeInvoke(CheckCast checkCast) {
        Value object = checkCast.object().getAliasedValue();
        if (!object.isArgument()) {
            return false;
        }
        int argumentIndex = object.definition.asArgument().getIndex();
        Value castValue = checkCast.outValue();
        assert (!castValue.hasPhiUsers());
        if (castValue.hasDebugUsers() || !castValue.hasSingleUniqueUser()) {
            return false;
        }
        InvokeMethod invoke = castValue.singleUniqueUser().asInvokeMethod();
        if (invoke == null) {
            return false;
        }
        if (invoke.arguments().size() <= argumentIndex) {
            return false;
        }
        int parameterIndex = argumentIndex - BooleanUtils.intValue(invoke.isInvokeMethodWithReceiver());
        if (parameterIndex == -1) {
            return false;
        }
        if (checkCast.getType() != invoke.getInvokedMethod().proto.getParameter(parameterIndex)) {
            return false;
        }
        Value argument = invoke.getArgument(argumentIndex);
        return argument == castValue;
    }

    private static boolean analyzeCheckCastAfterInvoke(DexEncodedMethod method, CheckCast checkCast, InvokeMethod invoke) {
        Value returnValue = invoke.outValue();
        Value uncastValue = checkCast.object().getAliasedValue();
        Value castValue = checkCast.outValue();
        assert (!castValue.hasPhiUsers());
        return uncastValue == returnValue && checkCast.getType() == method.returnType() && !castValue.hasDebugUsers() && castValue.hasSingleUniqueUser() && castValue.singleUniqueUser().isReturn();
    }

    private static boolean analyzeInvokeVirtual(InvokeVirtual invoke) {
        for (int argumentIndex = 0; argumentIndex < invoke.arguments().size(); ++argumentIndex) {
            Value argument = invoke.getArgument(argumentIndex);
            if (!argument.isArgument() || argumentIndex == argument.definition.asArgument().getIndex()) continue;
            return false;
        }
        return true;
    }

    private static boolean analyzeReturn(Return ret, InvokeMethod invoke, CheckCast returnCast) {
        if (invoke == null) {
            return false;
        }
        return ret.isReturnVoid() || ret.returnValue().getAliasedValue() == (returnCast != null ? returnCast : invoke).outValue();
    }

    private static BridgeInfo failure() {
        return null;
    }
}

