/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.optimize.info.field;

import com.android.tools.r8.graph.AppView;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexDefinitionSupplier;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.GraphLens;
import com.android.tools.r8.graph.proto.ArgumentInfoCollection;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldInitializationInfo;
import com.android.tools.r8.ir.optimize.info.field.InstanceFieldInitializationInfoCollection;
import com.android.tools.r8.ir.optimize.info.field.UnknownInstanceFieldInitializationInfo;
import com.android.tools.r8.shaking.AppInfoWithLiveness;
import com.android.tools.r8.utils.StringUtils;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.function.BiConsumer;

public class NonTrivialInstanceFieldInitializationInfoCollection
extends InstanceFieldInitializationInfoCollection {
    private final TreeMap<DexField, InstanceFieldInitializationInfo> infos;

    NonTrivialInstanceFieldInitializationInfoCollection(TreeMap<DexField, InstanceFieldInitializationInfo> infos) {
        assert (!infos.isEmpty());
        assert (infos.values().stream().noneMatch(InstanceFieldInitializationInfo::isUnknown));
        this.infos = infos;
    }

    @Override
    public void forEach(DexDefinitionSupplier definitions, BiConsumer<DexEncodedField, InstanceFieldInitializationInfo> consumer) {
        this.infos.forEach((field, info) -> {
            DexClass holder = definitions.definitionForHolder(field);
            DexEncodedField definition = field.lookupOnClass(holder);
            if (definition != null) {
                consumer.accept(definition, (InstanceFieldInitializationInfo)info);
            } else assert (false);
        });
    }

    @Override
    public void forEachWithDeterministicOrder(DexDefinitionSupplier definitions, BiConsumer<DexEncodedField, InstanceFieldInitializationInfo> consumer) {
        this.forEach(definitions, consumer);
    }

    @Override
    public InstanceFieldInitializationInfo get(DexEncodedField field) {
        return this.infos.getOrDefault(field.getReference(), UnknownInstanceFieldInitializationInfo.getInstance());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public InstanceFieldInitializationInfoCollection fixupAfterParametersChanged(ArgumentInfoCollection argumentInfoCollection) {
        InstanceFieldInitializationInfoCollection.Builder builder = InstanceFieldInitializationInfoCollection.builder();
        this.infos.forEach((field, info) -> builder.recordInitializationInfo((DexField)field, info.fixupAfterParametersChanged(argumentInfoCollection)));
        return builder.build();
    }

    @Override
    public InstanceFieldInitializationInfoCollection rewrittenWithLens(AppView<AppInfoWithLiveness> appView, GraphLens lens, GraphLens codeLens) {
        InstanceFieldInitializationInfoCollection.Builder builder = InstanceFieldInitializationInfoCollection.builder();
        this.infos.forEach((field, info) -> builder.recordInitializationInfo(lens.lookupField((DexField)field, codeLens), info.rewrittenWithLens(appView, lens, codeLens)));
        return builder.build();
    }

    public String toString() {
        ArrayList strings = new ArrayList();
        this.infos.forEach((field, info) -> strings.add(field.toSourceString() + " -> " + info));
        return "NonTrivialInstanceFieldInitializationInfoCollection(" + StringUtils.join("; ", strings) + ")";
    }
}

